/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphmarker.SubGraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSystemMarkerEntry;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSystemQueueEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pcollections.PSet;

@NeedsEvaluatorArgument
public class Slice
extends Function {
    private Graph graph;
    private List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker;
    private GraphMarker<Set<State>> stateMarker;

    public Slice() {
        super(1000L, 1L, 1.0);
    }

    @Description(params={"internal", "v", "dfa"}, description="Returns a SubGraphMarker, starting at the given root vertex and  being structured according to the given path description.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public SubGraphMarker evaluate(InternalGreqlEvaluator internalGreqlEvaluator, Vertex vertex, DFA dFA) {
        return this.evaluate(internalGreqlEvaluator, JGraLab.set().plus(vertex), dFA);
    }

    @Description(params={"internal", "roots", "dfa"}, description="Returns a SubGraphMarker, starting at the given root vertices and  being structured according to the given path description.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public SubGraphMarker evaluate(InternalGreqlEvaluator internalGreqlEvaluator, PSet<Vertex> pSet, DFA dFA) {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        this.graph = null;
        for (Vertex vertex : pSet) {
            if (this.graph == null) {
                this.graph = vertex.getGraph();
            }
            assert (vertex.getGraph() == this.graph) : "Roots from different graphs?!?";
            hashSet.add(vertex);
        }
        assert (internalGreqlEvaluator.getGraph() == this.graph) : "Roots from different graph than we're querying!?!";
        this.marker = new ArrayList<GraphMarker<Map<Edge, PathSystemMarkerEntry>>>(dFA.stateList.size());
        for (int i = 0; i < dFA.stateList.size(); ++i) {
            this.marker.add(new GraphMarker(this.graph));
        }
        List<Vertex> list = this.markVerticesOfSlice(internalGreqlEvaluator, hashSet, dFA);
        return this.createSliceFromMarkings(this.graph, hashSet, list);
    }

    protected boolean markVertex(Vertex vertex, State state, Vertex vertex2, Edge edge, State state2, int n) {
        PathSystemMarkerEntry pathSystemMarkerEntry;
        PathSystemMarkerEntry pathSystemMarkerEntry2 = new PathSystemMarkerEntry(vertex, vertex2, edge, state, state2, n);
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = this.marker.get(state.number);
        HashMap<Edge, PathSystemMarkerEntry> hashMap = (HashMap<Edge, PathSystemMarkerEntry>)graphMarker.getMark(vertex);
        if (hashMap == null) {
            hashMap = new HashMap<Edge, PathSystemMarkerEntry>();
            graphMarker.mark(vertex, hashMap);
        }
        if ((pathSystemMarkerEntry = (PathSystemMarkerEntry)hashMap.get(edge)) == null) {
            hashMap.put(edge, pathSystemMarkerEntry2);
            return true;
        }
        return false;
    }

    protected boolean isMarked(Vertex vertex, State state, Edge edge) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = this.marker.get(state.number);
        Map map = (Map)graphMarker.getMark(vertex);
        if (map != null) {
            return map.containsKey(edge);
        }
        return false;
    }

    protected boolean isMarked(Vertex vertex, State state) {
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = this.marker.get(state.number);
        Map map = (Map)graphMarker.getMark(vertex);
        return map != null;
    }

    private List<Vertex> markVerticesOfSlice(InternalGreqlEvaluator internalGreqlEvaluator, Set<Vertex> set, DFA dFA) {
        PathSystemQueueEntry pathSystemQueueEntry;
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        LinkedList<PathSystemQueueEntry> linkedList = new LinkedList<PathSystemQueueEntry>();
        for (Vertex graphElement : set) {
            pathSystemQueueEntry = new PathSystemQueueEntry(graphElement, dFA.initialState, null, null, 0);
            linkedList.offer(pathSystemQueueEntry);
            this.markVertex(graphElement, dFA.initialState, null, null, null, 0);
        }
        while (!linkedList.isEmpty()) {
            pathSystemQueueEntry = (PathSystemQueueEntry)linkedList.poll();
            if (pathSystemQueueEntry.state.isFinal) {
                arrayList.add(pathSystemQueueEntry.vertex);
            }
            for (Edge edge : pathSystemQueueEntry.vertex.incidences()) {
                for (Transition transition : pathSystemQueueEntry.state.outTransitions) {
                    Edge edge2;
                    Vertex vertex = transition.getNextVertex(pathSystemQueueEntry.vertex, edge);
                    if (this.isMarked(vertex, transition.endState, edge) || !transition.accepts(pathSystemQueueEntry.vertex, edge, internalGreqlEvaluator)) continue;
                    Edge edge3 = edge2 = transition.consumesEdge() ? edge : null;
                    if (!this.isMarked(vertex, transition.endState)) {
                        linkedList.add(new PathSystemQueueEntry(vertex, transition.endState, edge2, pathSystemQueueEntry.state, 0));
                    }
                    this.markVertex(vertex, transition.endState, pathSystemQueueEntry.vertex, edge2, pathSystemQueueEntry.state, 0);
                }
            }
        }
        return arrayList;
    }

    private SubGraphMarker createSliceFromMarkings(Graph graph, Set<Vertex> set, List<Vertex> list) {
        SubGraphMarker subGraphMarker = new SubGraphMarker(graph);
        for (Vertex vertex2 : set) {
            subGraphMarker.mark(vertex2);
        }
        LinkedList linkedList = new LinkedList();
        this.stateMarker = new GraphMarker(graph);
        GraphMarker<State> graphMarker = new GraphMarker<State>(graph);
        for (Vertex vertex : list) {
            for (GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker2 : this.marker) {
                if (graphMarker2.getMark(vertex) == null) continue;
                for (PathSystemMarkerEntry pathSystemMarkerEntry : ((Map)graphMarker2.getMark(vertex)).values()) {
                    if (!pathSystemMarkerEntry.state.isFinal || this.isVertexMarkedWithState(vertex, pathSystemMarkerEntry.state)) continue;
                    this.markVertexWithState(vertex, pathSystemMarkerEntry.state);
                    graphMarker.mark(vertex, pathSystemMarkerEntry.state);
                    linkedList.add(vertex);
                    while (!linkedList.isEmpty()) {
                        Vertex vertex2;
                        vertex2 = (Vertex)linkedList.poll();
                        for (PathSystemMarkerEntry pathSystemMarkerEntry2 : this.getMarkersWithState(vertex2, (State)graphMarker.getMark(vertex2)).values()) {
                            Vertex vertex3;
                            State state = pathSystemMarkerEntry2.parentState;
                            subGraphMarker.mark(vertex2);
                            if (pathSystemMarkerEntry2.edgeToParentVertex != null) {
                                subGraphMarker.mark(pathSystemMarkerEntry2.edgeToParentVertex);
                            }
                            if ((vertex3 = pathSystemMarkerEntry2.parentVertex) == null || this.isVertexMarkedWithState(vertex3, state)) continue;
                            this.markVertexWithState(vertex3, state);
                            graphMarker.mark(vertex3, state);
                            linkedList.add(vertex3);
                        }
                    }
                }
            }
        }
        return subGraphMarker;
    }

    private void markVertexWithState(Vertex vertex, State state) {
        if (this.stateMarker.getMark(vertex) == null) {
            this.stateMarker.mark(vertex, new HashSet());
        }
        ((Set)this.stateMarker.getMark(vertex)).add(state);
    }

    private boolean isVertexMarkedWithState(Vertex vertex, State state) {
        if (this.stateMarker.getMark(vertex) == null) {
            return false;
        }
        return ((Set)this.stateMarker.getMark(vertex)).contains(state);
    }

    private Map<Edge, PathSystemMarkerEntry> getMarkersWithState(Vertex vertex, State state) {
        if (vertex == null) {
            return null;
        }
        GraphMarker<Map<Edge, PathSystemMarkerEntry>> graphMarker = this.marker.get(state.number);
        return (Map)graphMarker.getMark(vertex);
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return 1000L;
    }

    @Override
    public double getSelectivity() {
        return 0.001f;
    }

    @Override
    public long getEstimatedCardinality(int n) {
        return 1L;
    }
}

