/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.SetMultipleAttributes;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import org.pcollections.PMap;
import org.pcollections.PSequence;

public class CreateAttributes
extends Transformation<Attribute[]> {
    private CreateAttribute.AttributeSpec[] attrSpecs;
    private String semanticExpression;
    private PMap<Object, PSequence<Object>> archetype2ValueListMap;

    protected CreateAttributes(Context context, CreateAttribute.AttributeSpec ... attributeSpecArray) {
        super(context);
        this.attrSpecs = attributeSpecArray;
    }

    public CreateAttributes(Context context, PMap<Object, PSequence<Object>> pMap, CreateAttribute.AttributeSpec ... attributeSpecArray) {
        this(context, attributeSpecArray);
        this.archetype2ValueListMap = pMap;
    }

    public CreateAttributes(Context context, String string, CreateAttribute.AttributeSpec ... attributeSpecArray) {
        this(context, attributeSpecArray);
        this.semanticExpression = string;
    }

    public static CreateAttributes parseAndCreate(ExecuteTransformation executeTransformation) {
        CreateAttribute.AttributeSpec[] attributeSpecArray = executeTransformation.matchAttributeSpecArray();
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new CreateAttributes(executeTransformation.context, string, attributeSpecArray);
    }

    @Override
    protected Attribute[] transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                int n = 0;
                Attribute[] attributeArray = new Attribute[this.attrSpecs.length];
                for (CreateAttribute.AttributeSpec attributeSpec : this.attrSpecs) {
                    attributeArray[n++] = (Attribute)new CreateAttribute(this.context, attributeSpec, (String)null).execute();
                }
                return attributeArray;
            }
            case GRAPH: {
                Attribute[] attributeArray = new Attribute[this.attrSpecs.length];
                int n = 0;
                for (CreateAttribute.AttributeSpec attributeSpec : this.attrSpecs) {
                    attributeArray[n++] = attributeSpec.aec.getAttribute(attributeSpec.name);
                }
                if (this.archetype2ValueListMap != null) {
                    new SetMultipleAttributes(this.context, this.archetype2ValueListMap, attributeArray).execute();
                } else {
                    new SetMultipleAttributes(this.context, this.semanticExpression, attributeArray).execute();
                }
                return attributeArray;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }
}

