/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateVertices;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.PSet;

public class CreateVertexClass
extends Transformation<VertexClass> {
    protected String qualifiedName = null;
    private PSet<? extends Object> archetypes = null;
    private String semanticExpression = null;

    protected CreateVertexClass(Context context, String string) {
        super(context);
        this.qualifiedName = string;
    }

    public CreateVertexClass(Context context, String string, PSet<? extends Object> pSet) {
        this(context, string);
        this.archetypes = pSet;
    }

    public CreateVertexClass(Context context, String string, String string2) {
        this(context, string);
        this.semanticExpression = string2;
    }

    public static CreateVertexClass parseAndCreate(ExecuteTransformation executeTransformation) {
        String string = executeTransformation.matchQualifiedName();
        executeTransformation.matchTransformationArrow();
        String string2 = executeTransformation.matchSemanticExpression();
        return new CreateVertexClass(executeTransformation.context, string, string2);
    }

    @Override
    protected VertexClass transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                VertexClass vertexClass = this.context.targetSchema.getGraphClass().createVertexClass(this.qualifiedName);
                this.context.ensureMappings(vertexClass);
                return vertexClass;
            }
            case GRAPH: {
                VertexClass vertexClass = this.context.targetGraph.getGraphClass().getVertexClass(this.qualifiedName);
                assert (vertexClass != null) : "Couldn't get VertexClass '" + this.qualifiedName + "'.";
                if (this.archetypes != null) {
                    new CreateVertices(this.context, vertexClass, this.archetypes).execute();
                } else {
                    new CreateVertices(this.context, vertexClass, this.semanticExpression).execute();
                }
                return vertexClass;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }
}

