/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.gretl.AddMappings;
import de.uni_koblenz.jgralab.gretl.AddSourceGraph;
import de.uni_koblenz.jgralab.gretl.AddSubClass;
import de.uni_koblenz.jgralab.gretl.AddSubClasses;
import de.uni_koblenz.jgralab.gretl.AddSuperClass;
import de.uni_koblenz.jgralab.gretl.AddSuperClasses;
import de.uni_koblenz.jgralab.gretl.Assert;
import de.uni_koblenz.jgralab.gretl.Call;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CopyDomain;
import de.uni_koblenz.jgralab.gretl.CopyEdgeClass;
import de.uni_koblenz.jgralab.gretl.CopyVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateAbstractEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateAbstractVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.CreateAttributes;
import de.uni_koblenz.jgralab.gretl.CreateEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateEdges;
import de.uni_koblenz.jgralab.gretl.CreateEnumDomain;
import de.uni_koblenz.jgralab.gretl.CreateListDomain;
import de.uni_koblenz.jgralab.gretl.CreateMapDomain;
import de.uni_koblenz.jgralab.gretl.CreateRecordDomain;
import de.uni_koblenz.jgralab.gretl.CreateSetDomain;
import de.uni_koblenz.jgralab.gretl.CreateSubgraph;
import de.uni_koblenz.jgralab.gretl.CreateVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateVertexClassDisjoint;
import de.uni_koblenz.jgralab.gretl.CreateVertices;
import de.uni_koblenz.jgralab.gretl.Delete;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Iteratively;
import de.uni_koblenz.jgralab.gretl.MatchReplace;
import de.uni_koblenz.jgralab.gretl.MergeVertices;
import de.uni_koblenz.jgralab.gretl.NTimes;
import de.uni_koblenz.jgralab.gretl.PrintGraph;
import de.uni_koblenz.jgralab.gretl.SetAttributes;
import de.uni_koblenz.jgralab.gretl.SetMultipleAttributes;
import de.uni_koblenz.jgralab.gretl.SysErr;
import de.uni_koblenz.jgralab.gretl.SysOut;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.parser.GReTLLexer;
import de.uni_koblenz.jgralab.gretl.parser.GReTLParsingException;
import de.uni_koblenz.jgralab.gretl.parser.Token;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ExecuteTransformation
extends Transformation<Graph> {
    static String FACTORY_METHOD_NAME = "parseAndCreate";
    private static final HashMap<String, Method> knownTransformationClasses = new HashMap();
    private static Logger logger = JGraLab.getLogger(ExecuteTransformation.class);
    private final HashMap<String, Transformation<?>> definedTransformations = new HashMap();
    private File file = null;
    private String name = null;
    private final List<Token> tokens;
    private int current;

    public static void registerTransformation(Class<? extends Transformation<?>> clazz) {
        Method method;
        String string = clazz.getSimpleName();
        String string2 = FACTORY_METHOD_NAME;
        try {
            method = clazz.getMethod(string2, ExecuteTransformation.class);
        }
        catch (SecurityException securityException) {
            throw new GReTLException(securityException.getMessage(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new GReTLException("The transformation class " + string + " has no " + string2 + "(ExecuteTransformation) method.", noSuchMethodException);
        }
        knownTransformationClasses.put(string, method);
        logger.finer("Registered transformation " + string + ".");
    }

    public ExecuteTransformation(Context context, File file) {
        super(context);
        this.file = file;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new GReTLParsingException(this.context, "Error while reading transformation...", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException("Cannot close reader of " + file, iOException);
                }
            }
        }
        this.tokens = GReTLLexer.scan(stringBuilder.toString());
        this.current = 0;
        this.match(TokenTypes.TRANSFORMATION);
        this.setName(this.match((TokenTypes)TokenTypes.IDENT).value);
        this.match(TokenTypes.SEMICOLON);
    }

    public static ExecuteTransformation parseAndCreate(ExecuteTransformation executeTransformation) {
        File file = new File(executeTransformation.match((TokenTypes)TokenTypes.STRING).value);
        if (!file.isAbsolute()) {
            file = new File(executeTransformation.file.getParent() + File.separator + file);
        }
        System.out.println(file.getAbsolutePath());
        return new ExecuteTransformation(executeTransformation.context, file);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    protected Graph transform() {
        switch (this.context.getPhase()) {
            case SCHEMA: 
            case GRAPH: {
                this.interpretFile();
                break;
            }
            default: {
                throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.getPhase()) + "!");
            }
        }
        return this.context.getTargetGraph();
    }

    private void interpretFile() {
        this.current = 3;
        while (!this.tryMatch(TokenTypes.EOF)) {
            if (this.tryMatch(TokenTypes.GREQL_IMPORT)) {
                this.match(TokenTypes.GREQL_IMPORT);
                this.addGReQLImport(this.match((TokenTypes)TokenTypes.IDENT).value);
                this.match(TokenTypes.SEMICOLON);
                continue;
            }
            this.matchAndExecute();
        }
        this.match(TokenTypes.EOF);
    }

    private void matchAndExecute() {
        if (this.tryMatchTransformationDefinition()) {
            this.matchTransformationDefinition();
            return;
        }
        if (this.tryMatchTransformationCall()) {
            Transformation<?> transformation = this.matchTransformationCall();
            transformation.execute();
            return;
        }
        if (this.tryMatchHelperDefinition()) {
            Transformation<?> transformation = this.matchHelperDefinition();
            transformation.execute();
            return;
        }
        if (this.tryMatchVariableAssignment()) {
            Transformation<?> transformation = this.matchVariableAssignment();
            transformation.execute();
            return;
        }
        throw new GReTLParsingException(this.context, "Don't know how to parse " + this.tokens.get(this.current));
    }

    private Transformation<?> matchHelperDefinition() {
        final String string = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.PAREN_OPEN);
        this.match(TokenTypes.PAREN_CLOSE);
        this.match(TokenTypes.DEFINES);
        final String string2 = this.match((TokenTypes)TokenTypes.GREQL).value;
        this.match(TokenTypes.SEMICOLON);
        return new Transformation<Void>(this.context){

            @Override
            protected Void transform() {
                this.setGReQLHelper(string, string2);
                return null;
            }
        };
    }

    private Transformation<?> matchVariableAssignment() {
        final String string = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.DEFINES);
        final String string2 = this.match((TokenTypes)TokenTypes.GREQL).value;
        this.match(TokenTypes.SEMICOLON);
        return new Transformation<Void>(this.context){

            @Override
            protected Void transform() {
                this.setGReQLVariable(string, string2);
                return null;
            }
        };
    }

    public boolean tryMatchTransformationCall() {
        Token token = this.lookAhead(0);
        return token.type == TokenTypes.IDENT && knownTransformationClasses.containsKey(token.value);
    }

    private boolean tryMatchTransformationDefinition() {
        Token token = this.lookAhead(0);
        Token token2 = this.lookAhead(1);
        Token token3 = this.lookAhead(2);
        return token.type == TokenTypes.IDENT && token2.type == TokenTypes.DEFINES_TRANSFORMATION && token3.type == TokenTypes.IDENT && knownTransformationClasses.containsKey(token3.value);
    }

    private void matchTransformationDefinition() {
        String string = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.DEFINES_TRANSFORMATION);
        Transformation<?> transformation = this.matchTransformationCall();
        this.definedTransformations.put(string, transformation);
    }

    private boolean tryMatchHelperDefinition() {
        return this.lookAhead(3) != null && this.lookAhead((int)0).type == TokenTypes.IDENT && this.lookAhead((int)1).type == TokenTypes.PAREN_OPEN && this.lookAhead((int)2).type == TokenTypes.PAREN_CLOSE && this.lookAhead((int)3).type == TokenTypes.DEFINES;
    }

    private boolean tryMatchVariableAssignment() {
        return this.lookAhead((int)0).type == TokenTypes.IDENT && this.lookAhead((int)1).type == TokenTypes.DEFINES;
    }

    public Transformation<?> matchTransformationCall() {
        String string = this.match((TokenTypes)TokenTypes.IDENT).value;
        Method method = knownTransformationClasses.get(string);
        if (method == null) {
            throw new GReTLParsingException(this.context, "Unknown transformation class '" + string + "'.");
        }
        try {
            Transformation transformation = (Transformation)method.invoke(null, this);
            this.match(TokenTypes.SEMICOLON);
            return transformation;
        }
        catch (Exception exception) {
            throw new GReTLParsingException(this.context, "Could not match " + string + " at position " + this.lookAhead((int)0).start, exception);
        }
    }

    public Domain matchDomain() {
        StringBuilder stringBuilder = new StringBuilder(this.match((TokenTypes)TokenTypes.IDENT).value);
        while (this.getParenBalance(stringBuilder.toString(), '<', '>') != 0) {
            if (this.tryMatch(TokenTypes.COMMA)) {
                stringBuilder.append(this.match((TokenTypes)TokenTypes.COMMA).value);
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.match((TokenTypes)TokenTypes.IDENT).value);
        }
        return this.domain(stringBuilder.toString());
    }

    public String matchGraphAlias() {
        String string = this.match((TokenTypes)TokenTypes.IDENT).value;
        if (string.startsWith("#") && string.endsWith("#")) {
            return string.substring(1, string.length() - 1);
        }
        throw new GReTLParsingException(this.context, "'" + string + "' is no valid graph alias.");
    }

    public boolean tryMatchGraphAlias() {
        Token token = this.lookAhead(0);
        return token != null && token.type == TokenTypes.IDENT && token.value != null && token.value.startsWith("#") && token.value.endsWith("#");
    }

    private int getParenBalance(String string, char c, char c2) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == c) {
                ++n;
                continue;
            }
            if (c3 != c2) continue;
            --n;
        }
        return n;
    }

    public Attribute matchAttribute() {
        return this.attr(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public Attribute[] matchAttributeArray() {
        LinkedList<Attribute> linkedList = new LinkedList<Attribute>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            linkedList.add(this.matchAttribute());
            if (!this.tryMatch(TokenTypes.COMMA)) continue;
            this.match(TokenTypes.COMMA);
            if (this.tryMatch(TokenTypes.IDENT)) continue;
            this.match(TokenTypes.IDENT);
        }
        return linkedList.toArray(new Attribute[linkedList.size()]);
    }

    public GraphElementClass<?, ?> matchGraphElementClass() {
        return this.gec(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public VertexClass matchVertexClass() {
        return this.vc(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public EdgeClass matchEdgeClass() {
        return this.ec(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public VertexClass[] matchVertexClassArray() {
        LinkedList<VertexClass> linkedList = new LinkedList<VertexClass>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            linkedList.add(this.vc(this.match((TokenTypes)TokenTypes.IDENT).value));
        }
        return linkedList.toArray(new VertexClass[linkedList.size()]);
    }

    public EdgeClass[] matchEdgeClassArray() {
        LinkedList<EdgeClass> linkedList = new LinkedList<EdgeClass>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            linkedList.add(this.ec(this.match((TokenTypes)TokenTypes.IDENT).value));
        }
        return linkedList.toArray(new EdgeClass[linkedList.size()]);
    }

    public RecordDomain.RecordComponent[] matchRecordComponentArray() {
        LinkedList<RecordDomain.RecordComponent> linkedList = new LinkedList<RecordDomain.RecordComponent>();
        this.match(TokenTypes.PAREN_OPEN);
        while (this.tryMatch(TokenTypes.IDENT)) {
            String string = this.match((TokenTypes)TokenTypes.IDENT).value;
            this.match(TokenTypes.COLON);
            String string2 = this.match((TokenTypes)TokenTypes.IDENT).value;
            linkedList.add(new RecordDomain.RecordComponent(string, this.domain(string2)));
            if (this.tryMatch(TokenTypes.COMMA)) {
                this.match(TokenTypes.COMMA);
                if (this.tryMatch(TokenTypes.IDENT)) continue;
                this.match(TokenTypes.IDENT);
                continue;
            }
            if (this.tryMatch(TokenTypes.PAREN_CLOSE)) continue;
            this.match(TokenTypes.PAREN_CLOSE);
        }
        this.match(TokenTypes.PAREN_CLOSE);
        return linkedList.toArray(new RecordDomain.RecordComponent[linkedList.size()]);
    }

    public String[] matchIdentifierArray() {
        this.match(TokenTypes.PAREN_OPEN);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            linkedList.add(this.match((TokenTypes)TokenTypes.IDENT).value);
            if (this.tryMatch(TokenTypes.COMMA)) {
                this.match(TokenTypes.COMMA);
                if (this.tryMatch(TokenTypes.IDENT)) continue;
                this.match(TokenTypes.IDENT);
                continue;
            }
            if (this.tryMatch(TokenTypes.PAREN_CLOSE)) continue;
            this.match(TokenTypes.PAREN_CLOSE);
        }
        this.match(TokenTypes.PAREN_CLOSE);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public CreateEdgeClass.IncidenceClassSpec matchIncidenceClassSpec() {
        Object object;
        if (this.tryMatch(TokenTypes.FROM)) {
            this.match();
        } else {
            this.match(TokenTypes.TO);
        }
        VertexClass vertexClass = this.vc(this.match((TokenTypes)TokenTypes.IDENT).value);
        int n = -1;
        int n2 = -1;
        String string = "";
        AggregationKind aggregationKind = AggregationKind.NONE;
        if (this.tryMatch(TokenTypes.PAREN_OPEN)) {
            this.match();
            n = Integer.parseInt(this.match((TokenTypes)TokenTypes.IDENT).value);
            this.match(TokenTypes.COMMA);
            object = this.match((TokenTypes)TokenTypes.IDENT).value;
            n2 = ((String)object).equals("*") ? Integer.MAX_VALUE : Integer.parseInt((String)object);
            this.match(TokenTypes.PAREN_CLOSE);
        }
        if (this.tryMatch(TokenTypes.ROLE)) {
            this.match();
            string = this.match((TokenTypes)TokenTypes.IDENT).value;
        }
        if (this.tryMatch(TokenTypes.AGGREGATION)) {
            this.match();
            aggregationKind = AggregationKind.valueOf(this.match((TokenTypes)TokenTypes.IDENT).value.toUpperCase());
        }
        try {
            object = CreateEdgeClass.IncidenceClassSpec.class.getConstructor(VertexClass.class, Integer.TYPE, Integer.TYPE, String.class, AggregationKind.class);
            return (CreateEdgeClass.IncidenceClassSpec)((Constructor)object).newInstance(new Object[]{vertexClass, n, n2, string, aggregationKind});
        }
        catch (Exception exception) {
            throw new GReTLParsingException(this.context, "Exception while instantiating an IncidenceClassSpec.", exception);
        }
    }

    public String matchQualifiedName() {
        return this.match((TokenTypes)TokenTypes.IDENT).value;
    }

    public void matchTransformationArrow() {
        this.match(TokenTypes.TRANSFORM_ARROW);
    }

    public String matchSemanticExpression() {
        return this.match((TokenTypes)TokenTypes.GREQL).value;
    }

    public CreateAttribute.AttributeSpec matchAttributeSpec() {
        String string = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.COLON);
        String string2 = this.matchDomain().getQualifiedName();
        String string3 = null;
        if (this.tryMatch(TokenTypes.ASSIGN)) {
            this.match(TokenTypes.ASSIGN);
            string3 = this.match((TokenTypes)TokenTypes.STRING).value;
        }
        try {
            Constructor constructor = CreateAttribute.AttributeSpec.class.getConstructor(AttributedElementClass.class, String.class, Domain.class, String.class);
            int n = string.lastIndexOf(46);
            String string4 = string.substring(0, n);
            AttributedElementClass<?, ?> attributedElementClass = this.aec(string4);
            if (attributedElementClass == null) {
                throw new GReTLParsingException(this.context, "There's no AttributedElementClass '" + string4 + "'.");
            }
            String string5 = string.substring(n + 1);
            return (CreateAttribute.AttributeSpec)constructor.newInstance(attributedElementClass, string5, this.domain(string2), string3);
        }
        catch (Exception exception) {
            throw new GReTLParsingException(this.context, "Exception while instantiating an IncidenceClassSpec.", exception);
        }
    }

    public CreateAttribute.AttributeSpec[] matchAttributeSpecArray() {
        LinkedList<CreateAttribute.AttributeSpec> linkedList = new LinkedList<CreateAttribute.AttributeSpec>();
        boolean bl = true;
        do {
            if (bl) {
                bl = false;
            } else {
                this.match(TokenTypes.COMMA);
            }
            linkedList.add(this.matchAttributeSpec());
        } while (this.tryMatch(TokenTypes.COMMA));
        return linkedList.toArray(new CreateAttribute.AttributeSpec[linkedList.size()]);
    }

    public final Token match(TokenTypes tokenTypes) {
        if (this.lookAhead((int)0).type == tokenTypes) {
            return this.match();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = -5; i < 6; ++i) {
            Token token = this.lookAhead(i);
            if (token == null) continue;
            if (i == 0) {
                stringBuilder.append("\u00bb");
                stringBuilder.append(token.value);
                stringBuilder.append("\u00ab");
            } else {
                stringBuilder.append(token.value);
            }
            stringBuilder.append(" ");
        }
        throw new GReTLParsingException(this.context, "Expected " + (Object)((Object)tokenTypes) + " but got " + (Object)((Object)this.tokens.get((int)this.current).type) + " while parsing: " + stringBuilder.toString());
    }

    public final Token match() {
        return this.tokens.get(this.current++);
    }

    public final boolean tryMatch(TokenTypes tokenTypes) {
        return this.lookAhead((int)0).type == tokenTypes;
    }

    public final Token lookAhead(int n) {
        int n2 = this.current + n;
        if (n2 >= 0 && n2 < this.tokens.size()) {
            return this.tokens.get(n2);
        }
        return null;
    }

    public Transformation<?> getDefinedTransformation(String string) {
        Transformation<?> transformation = this.definedTransformations.get(string);
        if (transformation == null) {
            throw new GReTLParsingException(this.context, "No '" + string + "' Transformation defined!");
        }
        return transformation;
    }

    static {
        ExecuteTransformation.registerTransformation(AddMappings.class);
        ExecuteTransformation.registerTransformation(AddSourceGraph.class);
        ExecuteTransformation.registerTransformation(AddSubClass.class);
        ExecuteTransformation.registerTransformation(AddSubClasses.class);
        ExecuteTransformation.registerTransformation(AddSuperClass.class);
        ExecuteTransformation.registerTransformation(AddSuperClasses.class);
        ExecuteTransformation.registerTransformation(Assert.class);
        ExecuteTransformation.registerTransformation(ExecuteTransformation.class);
        ExecuteTransformation.registerTransformation(Call.class);
        ExecuteTransformation.registerTransformation(CopyDomain.class);
        ExecuteTransformation.registerTransformation(CopyEdgeClass.class);
        ExecuteTransformation.registerTransformation(CopyVertexClass.class);
        ExecuteTransformation.registerTransformation(CreateAbstractEdgeClass.class);
        ExecuteTransformation.registerTransformation(CreateAbstractVertexClass.class);
        ExecuteTransformation.registerTransformation(CreateAttribute.class);
        ExecuteTransformation.registerTransformation(CreateAttributes.class);
        ExecuteTransformation.registerTransformation(CreateEdgeClass.class);
        ExecuteTransformation.registerTransformation(CreateEdges.class);
        ExecuteTransformation.registerTransformation(CreateEnumDomain.class);
        ExecuteTransformation.registerTransformation(CreateListDomain.class);
        ExecuteTransformation.registerTransformation(CreateMapDomain.class);
        ExecuteTransformation.registerTransformation(CreateVertexClassDisjoint.class);
        ExecuteTransformation.registerTransformation(CreateRecordDomain.class);
        ExecuteTransformation.registerTransformation(CreateSetDomain.class);
        ExecuteTransformation.registerTransformation(CreateSubgraph.class);
        ExecuteTransformation.registerTransformation(CreateVertexClass.class);
        ExecuteTransformation.registerTransformation(CreateVertices.class);
        ExecuteTransformation.registerTransformation(Delete.class);
        ExecuteTransformation.registerTransformation(Iteratively.class);
        ExecuteTransformation.registerTransformation(MatchReplace.class);
        ExecuteTransformation.registerTransformation(MergeVertices.class);
        ExecuteTransformation.registerTransformation(NTimes.class);
        ExecuteTransformation.registerTransformation(PrintGraph.class);
        ExecuteTransformation.registerTransformation(SetAttributes.class);
        ExecuteTransformation.registerTransformation(SetMultipleAttributes.class);
        ExecuteTransformation.registerTransformation(SysErr.class);
        ExecuteTransformation.registerTransformation(SysOut.class);
    }
}

