/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.InPlaceTransformation;
import java.util.Map;
import org.pcollections.PMap;
import org.pcollections.PSet;

public class MergeVertices
extends InPlaceTransformation {
    private final String semanticExpression;
    private PMap<Vertex, PSet<Vertex>> matches;

    public MergeVertices(Context context, String string) {
        super(context);
        this.semanticExpression = string;
    }

    public MergeVertices(Context context, PMap<Vertex, PSet<Vertex>> pMap) {
        this(context, (String)null);
        this.matches = pMap;
    }

    public static MergeVertices parseAndCreate(ExecuteTransformation executeTransformation) {
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new MergeVertices(executeTransformation.context, string);
    }

    @Override
    protected Integer transform() {
        if (this.context.getPhase() == Context.TransformationPhase.SCHEMA) {
            throw new GReTLException("SCHEMA phase in InPlaceTransformatio?!?");
        }
        if (this.matches == null) {
            this.matches = (PMap)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        int n = 0;
        for (Map.Entry entry : this.matches.entrySet()) {
            Vertex vertex = (Vertex)entry.getKey();
            if (!vertex.isValid()) continue;
            PSet pSet = (PSet)entry.getValue();
            if (pSet.size() > 0) {
                ++n;
            }
            for (Vertex vertex2 : pSet) {
                if (vertex2 == vertex) {
                    throw new GReTLException(this.context, vertex + " should be both kept and deleted!");
                }
                this.relinkIncidences(vertex2, vertex);
                vertex2.delete();
            }
        }
        this.matches = null;
        return n;
    }
}

