/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.greql.types.Undefined;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import org.pcollections.Empty;
import org.pcollections.PMap;

public class SetAttributes
extends Transformation<PMap<AttributedElement<?, ?>, Object>> {
    private Attribute attribute = null;
    private PMap<? extends Object, ? extends Object> archetype2valueMap = null;
    private String semanticExpression = null;

    public SetAttributes(Context context, Attribute attribute, PMap<? extends Object, ? extends Object> pMap) {
        super(context);
        this.attribute = attribute;
        this.archetype2valueMap = pMap;
    }

    public SetAttributes(Context context, Attribute attribute, String string) {
        super(context);
        this.attribute = attribute;
        this.semanticExpression = string;
    }

    public static SetAttributes parseAndCreate(ExecuteTransformation executeTransformation) {
        Attribute attribute = executeTransformation.matchAttribute();
        executeTransformation.matchTransformationArrow();
        String string = executeTransformation.matchSemanticExpression();
        return new SetAttributes(executeTransformation.context, attribute, string);
    }

    @Override
    protected PMap<AttributedElement<?, ?>, Object> transform() {
        if (this.context.phase != Context.TransformationPhase.GRAPH) {
            return null;
        }
        if (this.archetype2valueMap == null) {
            this.archetype2valueMap = (PMap)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        PMap<AttributedElement<Object, Object>, Object> pMap = Empty.orderedMap();
        for (Object k : this.archetype2valueMap.keySet()) {
            String string;
            AttributedElement attributedElement = (AttributedElement)this.context.getImg(this.attribute.getAttributedElementClass()).get(k);
            if (attributedElement == null) {
                string = this.attribute.getAttributedElementClass().getQualifiedName();
                throw new GReTLException(this.context, "The source graph element '" + k + "' has no image in " + Context.toGReTLVarNotation(string, Context.GReTLVariableType.IMG) + " yet, so no attribute '" + this.attribute.getName() + "' can be created!");
            }
            string = this.archetype2valueMap.get(k);
            pMap = pMap.plus(attributedElement, string);
            if (string == Undefined.UNDEFINED) continue;
            Object object = this.convertToAttributeValue(string);
            attributedElement.setAttribute(this.attribute.getName(), object);
        }
        return pMap;
    }

    private Object convertToAttributeValue(Object object) {
        Object object2 = object;
        Domain domain = this.attribute.getDomain();
        if (domain instanceof RecordDomain) {
            return this.context.getTargetGraph().createRecord((RecordDomain)domain, ((Record)object).toPMap());
        }
        return object2;
    }
}

