/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl.templategraphparser;

import de.uni_koblenz.jgralab.gretl.templategraphparser.ComplexToken;
import de.uni_koblenz.jgralab.gretl.templategraphparser.SimpleToken;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParserException;
import de.uni_koblenz.jgralab.gretl.templategraphparser.Token;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TokenType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateGraphLexer {
    protected static Map<TokenType, String> fixedTokens = new HashMap<TokenType, String>();
    private String text;
    private int position = 0;

    public TemplateGraphLexer(String string) {
        this.text = string;
    }

    public static List<Token> scan(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        TemplateGraphLexer templateGraphLexer = new TemplateGraphLexer(string);
        while (templateGraphLexer.hasNextToken()) {
            Token token = templateGraphLexer.getNextToken();
            arrayList.add(token);
        }
        return arrayList;
    }

    private Token getNextToken() {
        Object object;
        TokenType tokenType = null;
        this.skipWhitespaces();
        for (Map.Entry<TokenType, String> entry : fixedTokens.entrySet()) {
            int n;
            object = entry.getValue();
            if (!this.text.regionMatches(this.position, (String)object, 0, n = ((String)object).length())) continue;
            tokenType = entry.getKey();
            SimpleToken simpleToken = new SimpleToken(tokenType, this.position, n);
            this.position += n;
            return simpleToken;
        }
        if (this.text.charAt(this.position) == '\'') {
            Map.Entry<TokenType, String> entry;
            tokenType = TokenType.STRING;
            ++this.position;
            int n = this.position;
            entry = new StringBuilder();
            while (this.position < this.text.length() && this.text.charAt(this.position) != '\'') {
                if (this.text.charAt(this.position) == '\\') {
                    if (this.position == this.text.length()) {
                        throw new TemplateGraphParserException("String started at position " + n + " but is not closed in query: '" + this.text.substring(n, this.position) + "'.");
                    }
                    if (this.text.charAt(this.position + 1) == '\'' || this.text.charAt(this.position + 1) == '\\') {
                        ++this.position;
                    }
                }
                ((StringBuilder)((Object)entry)).append(this.text.charAt(this.position));
                ++this.position;
            }
            if (this.position >= this.text.length() || this.text.charAt(this.position) != '\'') {
                throw new TemplateGraphParserException("String started at position " + n + " but is not closed in query: '" + ((StringBuilder)((Object)entry)).toString() + "'.");
            }
            object = new ComplexToken(tokenType, n, this.position, ((StringBuilder)((Object)entry)).toString());
            ++this.position;
            return object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.position;
        while (this.text.length() > this.position && !this.isSeparator(this.text.charAt(this.position))) {
            stringBuilder.append(this.text.charAt(this.position++));
        }
        if (n == this.position) {
            throw new TemplateGraphParserException("Zero-length IDENTIFIER at position " + this.position + ".");
        }
        object = new ComplexToken(TokenType.IDENT, n, this.position - n, stringBuilder.toString());
        return object;
    }

    private boolean isSeparator(char c) {
        return fixedTokens.values().contains(String.valueOf(c)) || TemplateGraphLexer.isWhitespace(c) || c == '-' || c == '<' || c == ';';
    }

    private boolean hasNextToken() {
        this.skipWhitespaces();
        return this.position < this.text.length();
    }

    private static final boolean isWhitespace(int n) {
        return n == 32 || n == 10 || n == 9 || n == 13;
    }

    private void skipWhitespaces() {
        while (this.position < this.text.length() && TemplateGraphLexer.isWhitespace(this.text.charAt(this.position))) {
            ++this.position;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(TemplateGraphLexer.scan("v1(foo.bar.Bar 'tup(\"x\", $[1])' | x='\"foo\"', y= '$[0].y')-->{edge.Bar '$[17]'|e = '$[18].name'} v2(Baz '$[11]')"));
        System.out.println(TemplateGraphLexer.scan("v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1"));
        System.out.println(TemplateGraphLexer.scan("v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1<--{a.E2 '$[3]'} v3(a.B '$[4]'),v4('$[6]') <--{a.F '1'| e3='17'} v1"));
        System.out.println(TemplateGraphLexer.scan("v1(,'\"a.A\" ++ Foo' 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1', ...) "));
    }

    static {
        fixedTokens.put(TokenType.L_CURLY, "{");
        fixedTokens.put(TokenType.R_CURLY, "}");
        fixedTokens.put(TokenType.PIPE, "|");
        fixedTokens.put(TokenType.ASSIGN, "=");
        fixedTokens.put(TokenType.L_ARROW, "<--");
        fixedTokens.put(TokenType.R_ARROW, "-->");
        fixedTokens.put(TokenType.L_PAREN, "(");
        fixedTokens.put(TokenType.R_PAREN, ")");
        fixedTokens.put(TokenType.COMMA, ",");
        fixedTokens.put(TokenType.TRIPLE_DOT, "...");
        fixedTokens.put(TokenType.HASH, "#");
    }
}

