/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl.templategraphparser;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.gretl.template.CreateEdge;
import de.uni_koblenz.jgralab.gretl.template.CreateVertex;
import de.uni_koblenz.jgralab.gretl.template.TemplateGraph;
import de.uni_koblenz.jgralab.gretl.template.TemplateSchema;
import de.uni_koblenz.jgralab.gretl.templategraphparser.ComplexToken;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphLexer;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TemplateGraphParserException;
import de.uni_koblenz.jgralab.gretl.templategraphparser.Token;
import de.uni_koblenz.jgralab.gretl.templategraphparser.TokenType;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pcollections.PMap;

public class TemplateGraphParser {
    private List<Token> tokens;
    private TemplateGraph graph;
    private Map<String, CreateVertex> ident2VertexMap = new HashMap<String, CreateVertex>();

    public TemplateGraphParser(List<Token> list) {
        this.tokens = list;
    }

    private TemplateGraph parse() {
        this.graph = TemplateSchema.instance().createTemplateGraph(ImplementationType.STANDARD);
        while (!this.tokens.isEmpty()) {
            this.matchVertexOrSubgraph();
        }
        return this.graph;
    }

    private void matchVertexOrSubgraph() {
        CreateVertex createVertex = this.matchVertex();
        while (!this.tryMatch(TokenType.COMMA) && !this.tokens.isEmpty()) {
            createVertex = this.matchEdgeAndNextVertex(createVertex);
        }
        if (this.tryMatch(TokenType.COMMA)) {
            this.match(TokenType.COMMA);
        }
    }

    private CreateVertex matchEdgeAndNextVertex(CreateVertex createVertex) {
        TokenType tokenType = null;
        String string = null;
        boolean bl = false;
        String string2 = null;
        PMap<String, String> pMap = null;
        boolean bl2 = false;
        tokenType = this.tryMatch(TokenType.L_ARROW) ? this.match((TokenType)TokenType.L_ARROW).type : this.match((TokenType)TokenType.R_ARROW).type;
        this.match(TokenType.L_CURLY);
        if (this.tryMatch(TokenType.IDENT)) {
            string = this.matchComplexToken((TokenType)TokenType.IDENT).value;
        } else if (this.tryMatch(TokenType.HASH)) {
            this.match(TokenType.HASH);
            bl = true;
            string = this.matchComplexToken((TokenType)TokenType.STRING).value;
        }
        if (this.tryMatch(TokenType.STRING)) {
            string2 = this.matchComplexToken((TokenType)TokenType.STRING).value;
        }
        if (this.tryMatch(TokenType.PIPE)) {
            this.match(TokenType.PIPE);
            pMap = this.matchAttributes();
            if (this.tryMatch(TokenType.TRIPLE_DOT)) {
                this.match(TokenType.TRIPLE_DOT);
                bl2 = true;
            }
        }
        this.match(TokenType.R_CURLY);
        CreateVertex createVertex2 = this.matchVertex();
        CreateEdge createEdge = null;
        createEdge = tokenType == TokenType.R_ARROW ? this.graph.createCreateEdge(createVertex, createVertex2) : this.graph.createCreateEdge(createVertex2, createVertex);
        createEdge.set_typeName(string);
        createEdge.set_typeNameIsQuery(bl);
        createEdge.set_archetype(string2);
        createEdge.set_attributes(pMap);
        createEdge.set_copyAttributeValues(bl2);
        return createVertex2;
    }

    private CreateVertex matchVertex() {
        CreateVertex createVertex = null;
        String string = null;
        if (this.tryMatch(TokenType.IDENT)) {
            string = this.matchComplexToken((TokenType)TokenType.IDENT).value;
            createVertex = this.ident2VertexMap.get(string);
        }
        if (createVertex == null) {
            this.match(TokenType.L_PAREN);
            createVertex = this.graph.createCreateVertex();
            if (this.tryMatch(TokenType.IDENT)) {
                String string2 = this.matchComplexToken((TokenType)TokenType.IDENT).value;
                createVertex.set_typeNameIsQuery(false);
                createVertex.set_typeName(string2);
            } else if (this.tryMatch(TokenType.HASH)) {
                this.match(TokenType.HASH);
                String string3 = this.matchComplexToken((TokenType)TokenType.STRING).value;
                createVertex.set_typeNameIsQuery(true);
                createVertex.set_typeName(string3);
            }
            if (this.tryMatch(TokenType.STRING)) {
                createVertex.set_archetype(this.matchComplexToken((TokenType)TokenType.STRING).value);
            }
            if (this.tryMatch(TokenType.PIPE)) {
                this.match(TokenType.PIPE);
                createVertex.set_attributes(this.matchAttributes());
                if (this.tryMatch(TokenType.TRIPLE_DOT)) {
                    this.match(TokenType.TRIPLE_DOT);
                    createVertex.set_copyAttributeValues(true);
                }
            }
            this.match(TokenType.R_PAREN);
            if (string != null) {
                this.ident2VertexMap.put(string, createVertex);
            }
        }
        return createVertex;
    }

    private PMap<String, String> matchAttributes() {
        PMap<String, String> pMap = JGraLab.map();
        do {
            if (this.tryMatch(TokenType.TRIPLE_DOT)) {
                return pMap;
            }
            String string = this.matchComplexToken((TokenType)TokenType.IDENT).value;
            this.match(TokenType.ASSIGN);
            String string2 = this.matchComplexToken((TokenType)TokenType.STRING).value;
            pMap = pMap.plus(string, string2);
        } while (this.tryMatch(TokenType.COMMA) && this.match(TokenType.COMMA) != null);
        return pMap;
    }

    private boolean tryMatch(TokenType tokenType) {
        return !this.tokens.isEmpty() && this.tokens.get((int)0).type == tokenType;
    }

    private ComplexToken matchComplexToken(TokenType tokenType) {
        return (ComplexToken)this.match(tokenType);
    }

    private Token match(TokenType tokenType) {
        if (this.tokens.isEmpty()) {
            throw new TemplateGraphParserException("Expected " + (Object)((Object)tokenType) + " but no Tokens were left over.");
        }
        Token token = this.tokens.get(0);
        if (token.type == tokenType) {
            return this.tokens.remove(0);
        }
        throw new TemplateGraphParserException("Expected " + (Object)((Object)tokenType) + " but got " + token + ".");
    }

    public static TemplateGraph parse(String string) {
        TemplateGraphParser templateGraphParser = new TemplateGraphParser(TemplateGraphLexer.scan(string));
        return templateGraphParser.parse();
    }

    public static void main(String[] stringArray) throws GraphIOException, IOException {
        String[] stringArray2 = new String[]{"v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1", "v1(a.A 'tup($[1], \"aArch\")' | a1 = '\"A\"', a2='$[2] + 1') -->{a.E 'tup($[1], $[2])' | e1 = '$[17]'} v1<--{a.E2 '$[3]'} v3(a.B '$[4]'), v4('$[6]') <--{a.F '1'| e3='17'} v1", "('$' | name = '$.name')"};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("Trying txts[" + i + "]...");
            TemplateGraph templateGraph = TemplateGraphParser.parse(stringArray2[i]);
            Tg2Dot.convertGraph((Graph)templateGraph, "/tmp/g" + i + ".dot", false);
        }
        System.out.println("Fini.");
    }
}

