/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.impl.EdgeBaseImpl;
import de.uni_koblenz.jgralab.impl.IncidenceImpl;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.EdgeClass;

public abstract class ReversedEdgeBaseImpl
extends IncidenceImpl
implements InternalEdge {
    protected final EdgeBaseImpl normalEdge;

    public ReversedEdgeBaseImpl(EdgeBaseImpl edgeBaseImpl, Graph graph) {
        super(graph);
        assert (edgeBaseImpl != null);
        this.normalEdge = edgeBaseImpl;
    }

    @Override
    public Class<? extends Edge> getSchemaClass() {
        return this.normalEdge.getSchemaClass();
    }

    @Override
    public int compareTo(AttributedElement<EdgeClass, Edge> attributedElement) {
        assert (this.isValid());
        assert (attributedElement instanceof Edge);
        Edge edge = (Edge)attributedElement;
        assert (edge.isValid());
        assert (this.getGraph() == edge.getGraph());
        if (edge == this.getNormalEdge()) {
            return 1;
        }
        return Math.abs(this.getId()) - Math.abs(edge.getId());
    }

    @Override
    public void delete() {
        this.normalEdge.delete();
    }

    @Override
    public Vertex getAlpha() {
        return this.normalEdge.getIncidentVertex();
    }

    @Override
    public <T> T getAttribute(String string) {
        return this.normalEdge.getAttribute(string);
    }

    @Override
    public <T> void setAttribute(String string, T t) {
        this.normalEdge.setAttribute(string, t);
    }

    @Override
    public int getId() {
        return -this.normalEdge.getId();
    }

    @Override
    public Edge getNextEdge() {
        return this.normalEdge.getNextEdge();
    }

    @Override
    public InternalEdge getNextEdgeInESeq() {
        return this.normalEdge.getNextEdgeInESeq();
    }

    @Override
    public Edge getPrevEdge() {
        return this.normalEdge.getPrevEdge();
    }

    @Override
    public InternalEdge getPrevEdgeInESeq() {
        return this.normalEdge.getPrevEdgeInESeq();
    }

    @Override
    public Edge getNextEdge(EdgeClass edgeClass) {
        return this.normalEdge.getNextEdge(edgeClass);
    }

    @Override
    public Edge getNormalEdge() {
        return this.normalEdge;
    }

    @Override
    public Vertex getOmega() {
        assert (this.isValid());
        return this.getIncidentVertex();
    }

    @Override
    public Edge getReversedEdge() {
        return this.normalEdge;
    }

    @Override
    public Vertex getThat() {
        return this.getAlpha();
    }

    @Override
    public String getThatRole() {
        return this.normalEdge.getThisRole();
    }

    @Override
    public Vertex getThis() {
        return this.getOmega();
    }

    @Override
    public String getThisRole() {
        return this.normalEdge.getThatRole();
    }

    @Override
    public void graphModified() {
        assert (this.isValid());
        this.graph.graphModified();
    }

    @Override
    public boolean isAfterEdge(Edge edge) {
        return this.normalEdge.isAfterEdge(edge);
    }

    @Override
    public boolean isBeforeEdge(Edge edge) {
        return this.normalEdge.isBeforeEdge(edge);
    }

    @Override
    public boolean isNormal() {
        return false;
    }

    @Override
    public void putAfterEdge(Edge edge) {
        this.normalEdge.putAfterEdge(edge);
    }

    @Override
    public void putBeforeEdge(Edge edge) {
        this.normalEdge.putBeforeEdge(edge);
    }

    @Override
    public void setAlpha(Vertex vertex) {
        this.normalEdge.setAlpha(vertex);
    }

    @Override
    public void setOmega(Vertex vertex) {
        this.normalEdge.setOmega(vertex);
    }

    @Override
    public void setThat(Vertex vertex) {
        this.normalEdge.setAlpha(vertex);
    }

    @Override
    public void setThis(Vertex vertex) {
        this.normalEdge.setOmega(vertex);
    }

    public String toString() {
        return "-e" + this.normalEdge.getId() + ": " + this.getAttributedElementClass().getQualifiedName();
    }

    @Override
    public boolean isValid() {
        return this.graph.eSeqContainsEdge(this);
    }

    @Override
    public void setId(int n) {
        this.normalEdge.setId(n);
    }

    @Override
    public AggregationKind getAggregationKind() {
        return this.normalEdge.getAggregationKind();
    }

    @Override
    public AggregationKind getAlphaAggregationKind() {
        return this.normalEdge.getAlphaAggregationKind();
    }

    @Override
    public AggregationKind getOmegaAggregationKind() {
        return this.normalEdge.getOmegaAggregationKind();
    }

    @Override
    public AggregationKind getThisAggregationKind() {
        return this.normalEdge.getOmegaAggregationKind();
    }

    @Override
    public AggregationKind getThatAggregationKind() {
        return this.normalEdge.getAlphaAggregationKind();
    }

    @Override
    public void setNextEdgeInGraph(Edge edge) {
        this.normalEdge.setNextEdgeInGraph(edge);
    }

    @Override
    public void setPrevEdgeInGraph(Edge edge) {
        this.normalEdge.setPrevEdgeInGraph(edge);
    }
}

