/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.generic;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.impl.generic.InternalAttributesArrayAccess;
import de.uni_koblenz.jgralab.impl.std.GraphImpl;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.BasicDomain;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;
import java.util.Map;

public class GenericGraphImpl
extends GraphImpl
implements InternalAttributesArrayAccess {
    private GraphClass type;
    private Object[] attributes;

    protected GenericGraphImpl(GraphClass graphClass, String string, int n, int n2) {
        super(string, graphClass, n, n2);
        this.type = graphClass;
        if (graphClass.hasAttributes()) {
            this.attributes = new Object[graphClass.getAttributeCount()];
            if (!this.isLoading()) {
                GenericGraphImpl.initializeGenericAttributeValues(this);
            }
        }
    }

    @Override
    public <T extends Vertex> T createVertex(VertexClass vertexClass) {
        return (T)this.graphFactory.createVertex(vertexClass, 0, this);
    }

    @Override
    public <T extends Edge> T createEdge(EdgeClass edgeClass, Vertex vertex, Vertex vertex2) {
        return (T)this.graphFactory.createEdge(edgeClass, 0, this, vertex, vertex2);
    }

    @Override
    public GraphClass getAttributedElementClass() {
        return this.type;
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException, NoSuchAttributeException {
        int n = this.type.getAttributeIndex(string);
        this.attributes[n] = this.type.getAttribute(string).getDomain().parseGenericAttribute(GraphIO.createStringReader(string2, this.getSchema()));
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        for (Attribute attribute : this.type.getAttributeList()) {
            this.attributes[this.type.getAttributeIndex((String)attribute.getName())] = attribute.getDomain().parseGenericAttribute(graphIO);
        }
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException, NoSuchAttributeException {
        GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
        this.type.getAttribute(string).getDomain().serializeGenericAttribute(graphIO, this.getAttribute(string));
        return graphIO.getStringWriterResult();
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws IOException, GraphIOException {
        for (Attribute attribute : this.type.getAttributeList()) {
            attribute.getDomain().serializeGenericAttribute(graphIO, this.getAttribute(attribute.getName()));
        }
    }

    @Override
    public <T> T getAttribute(String string) {
        int n = this.getAttributedElementClass().getAttributeIndex(string);
        return (T)this.attributes[n];
    }

    @Override
    public <T> void setAttribute(String string, T t) {
        int n = this.getAttributedElementClass().getAttributeIndex(string);
        if (!this.type.getAttribute(string).getDomain().isConformValue(t)) {
            Domain domain = this.type.getAttribute(string).getDomain();
            throw new ClassCastException("Expected " + (domain instanceof RecordDomain ? RecordImpl.class.getName() : domain.getJavaAttributeImplementationTypeName(domain.getPackageName())) + " object, but received " + (t != null ? t.getClass().getName() + " object instead" : "null") + " instead");
        }
        T t2 = this.getAttribute(string);
        this.fireBeforeChangeAttribute(this, string, t2, t);
        this.attributes[n] = t;
        this.fireAfterChangeAttribute(this, string, t2, t);
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        GenericGraphImpl.initializeGenericAttributeValues(this);
    }

    public static Object genericAttributeDefaultValue(Domain domain) {
        if (domain instanceof BasicDomain) {
            if (domain instanceof BooleanDomain) {
                return false;
            }
            if (domain instanceof IntegerDomain) {
                return 0;
            }
            if (domain instanceof LongDomain) {
                return 0L;
            }
            if (domain instanceof DoubleDomain) {
                return 0.0;
            }
            return null;
        }
        return null;
    }

    static void initializeGenericAttributeValues(AttributedElement<?, ?> attributedElement) {
        for (Attribute attribute : attributedElement.getAttributedElementClass().getAttributeList()) {
            if (attribute.getDefaultValueAsString() != null && !attribute.getDefaultValueAsString().isEmpty()) {
                try {
                    attribute.setDefaultValue(attributedElement);
                }
                catch (GraphIOException graphIOException) {
                    graphIOException.printStackTrace();
                }
                continue;
            }
            attributedElement.setAttribute(attribute.getName(), GenericGraphImpl.genericAttributeDefaultValue(attribute.getDomain()));
        }
    }

    @Override
    public boolean isInstanceOf(GraphClass graphClass) {
        return this.type.equals(graphClass);
    }

    @Override
    public Object getEnumConstant(EnumDomain enumDomain, String string) {
        for (String string2 : enumDomain.getConsts()) {
            if (!string2.equals(string)) continue;
            return string2;
        }
        throw new GraphException("No such enum constant '" + string + "' in EnumDomain " + enumDomain);
    }

    @Override
    public Record createRecord(RecordDomain recordDomain, Map<String, Object> map) {
        RecordImpl recordImpl = RecordImpl.empty();
        for (RecordDomain.RecordComponent recordComponent : recordDomain.getComponents()) {
            if (!map.containsKey(recordComponent.getName())) {
                throw new GraphException("The provided Map misses a " + recordComponent.getName() + " key!");
            }
            recordImpl = recordImpl.plus(recordComponent.getName(), map.get(recordComponent.getName()));
        }
        return recordImpl;
    }

    @Override
    public Class<? extends Graph> getSchemaClass() {
        throw new UnsupportedOperationException("This method is not supported by the generic implementation");
    }

    @Override
    public void invokeOnAttributesArray(InternalAttributesArrayAccess.OnAttributesFunction onAttributesFunction) {
        this.attributes = onAttributesFunction.invoke(this, this.attributes);
    }
}

