/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl.generic;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphException;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import de.uni_koblenz.jgralab.impl.RecordImpl;
import de.uni_koblenz.jgralab.impl.generic.GenericGraphImpl;
import de.uni_koblenz.jgralab.impl.generic.InternalAttributesArrayAccess;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.IOException;

public class GenericVertexImpl
extends VertexImpl
implements InternalAttributesArrayAccess {
    private final VertexClass type;
    private Object[] attributes;

    protected GenericVertexImpl(VertexClass vertexClass, int n, Graph graph) {
        super(n, graph);
        if (vertexClass.isAbstract()) {
            graph.deleteVertex(this);
            throw new GraphException("Cannot create instances of abstract type " + vertexClass);
        }
        this.type = vertexClass;
        if (vertexClass.hasAttributes()) {
            this.attributes = new Object[vertexClass.getAttributeCount()];
            if (!((InternalGraph)graph).isLoading()) {
                GenericGraphImpl.initializeGenericAttributeValues(this);
            }
        }
    }

    @Override
    public VertexClass getAttributedElementClass() {
        return this.type;
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException, NoSuchAttributeException {
        int n = this.type.getAttributeIndex(string);
        this.attributes[n] = this.type.getAttribute(string).getDomain().parseGenericAttribute(GraphIO.createStringReader(string2, this.getSchema()));
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        for (Attribute attribute : this.type.getAttributeList()) {
            this.attributes[this.type.getAttributeIndex((String)attribute.getName())] = attribute.getDomain().parseGenericAttribute(graphIO);
        }
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException, NoSuchAttributeException {
        GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
        this.type.getAttribute(string).getDomain().serializeGenericAttribute(graphIO, this.getAttribute(string));
        return graphIO.getStringWriterResult();
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws IOException, GraphIOException {
        for (Attribute attribute : this.type.getAttributeList()) {
            attribute.getDomain().serializeGenericAttribute(graphIO, this.getAttribute(attribute.getName()));
        }
    }

    @Override
    public <T> T getAttribute(String string) {
        int n = this.type.getAttributeIndex(string);
        return (T)this.attributes[n];
    }

    @Override
    public <T> void setAttribute(String string, T t) {
        int n = this.type.getAttributeIndex(string);
        if (!this.getAttributedElementClass().getAttribute(string).getDomain().isConformValue(t)) {
            Domain domain = this.type.getAttribute(string).getDomain();
            throw new ClassCastException("Expected " + (domain instanceof RecordDomain ? RecordImpl.class.getName() : domain.getJavaAttributeImplementationTypeName(domain.getPackageName())) + " object, but received " + (t != null ? t.getClass().getName() + " object instead" : "null") + " instead");
        }
        T t2 = this.getAttribute(string);
        this.graph.fireBeforeChangeAttribute(this, string, t2, t);
        this.attributes[n] = t;
        this.graph.fireAfterChangeAttribute(this, string, t2, t);
    }

    @Override
    public void initializeAttributesWithDefaultValues() {
        GenericGraphImpl.initializeGenericAttributeValues(this);
    }

    @Override
    public boolean isInstanceOf(VertexClass vertexClass) {
        return this.type == vertexClass || this.type.isSubClassOf(vertexClass);
    }

    @Override
    public void invokeOnAttributesArray(InternalAttributesArrayAccess.OnAttributesFunction onAttributesFunction) {
        this.attributes = onAttributesFunction.invoke(this, this.attributes);
    }

    @Override
    public Class<? extends Vertex> getSchemaClass() {
        throw new UnsupportedOperationException("This method is not supported by the generic implementation");
    }
}

