/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.AttributedElementCodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import java.util.List;
import java.util.TreeSet;

public class ReversedEdgeCodeGenerator
extends AttributedElementCodeGenerator<EdgeClass, Edge> {
    public ReversedEdgeCodeGenerator(EdgeClass edgeClass, String string, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(edgeClass, string, codeGeneratorConfiguration);
        this.rootBlock.setVariable("graphElementClass", "ReversedEdge");
        this.rootBlock.setVariable("schemaElementClass", "EdgeClass");
        this.rootBlock.setVariable("isImplementationClassOnly", "true");
        this.rootBlock.setVariable("className", "Reversed" + edgeClass.getSimpleName());
        this.rootBlock.setVariable("simpleClassName", "Reversed" + edgeClass.getSimpleName());
        this.rootBlock.setVariable("simpleImplClassName", "Reversed" + edgeClass.getSimpleName() + "Impl");
        this.rootBlock.setVariable("normalQualifiedClassName", this.schemaRootPackageName + "." + edgeClass.getQualifiedName());
        for (EdgeClass edgeClass2 : edgeClass.getDirectSuperClasses().plus(edgeClass.getGraphClass().getDefaultEdgeClass())) {
            this.interfaces.add(edgeClass2.getQualifiedName());
        }
    }

    @Override
    protected String getSchemaTypeName() {
        return "EdgeClass";
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = (CodeList)super.createBody();
        if (this.currentCycle.isStdImpl()) {
            this.rootBlock.setVariable("baseClassName", "ReversedEdgeImpl");
            if (this.currentCycle.isStdImpl()) {
                this.addImports("#jgImplStdPackage#.#baseClassName#");
            }
            if (this.config.hasTypeSpecificMethodsSupport()) {
                codeList.add(this.createNextEdgeMethods());
                codeList.add(this.createNextIncidenceMethods());
            }
            codeList.add(this.createGetAlphaOmegaOverrides());
        }
        return codeList;
    }

    private CodeBlock createGetAlphaOmegaOverrides() {
        CodeSnippet codeSnippet = new CodeSnippet();
        EdgeClass edgeClass = (EdgeClass)this.aec;
        VertexClass vertexClass = edgeClass.getFrom().getVertexClass();
        VertexClass vertexClass2 = edgeClass.getTo().getVertexClass();
        codeSnippet.setVariable("fromVertexClass", vertexClass.getSimpleName());
        codeSnippet.setVariable("toVertexClass", vertexClass2.getSimpleName());
        this.addImports(this.schemaRootPackageName + "." + vertexClass.getQualifiedName());
        this.addImports(this.schemaRootPackageName + "." + vertexClass2.getQualifiedName());
        if (!this.currentCycle.isAbstract()) {
            codeSnippet.add("public #fromVertexClass# getAlpha() {");
            codeSnippet.add("\treturn (#fromVertexClass#) super.getAlpha();");
            codeSnippet.add("}");
            codeSnippet.add("public #toVertexClass# getOmega() {");
            codeSnippet.add("\treturn (#toVertexClass#) super.getOmega();");
            codeSnippet.add("}");
        }
        return codeSnippet;
    }

    @Override
    protected CodeBlock createConstructor() {
        if (this.currentCycle.isStdImpl()) {
            this.addImports("#jgImplStdPackage#.EdgeImpl", "#jgPackage#.Graph");
        }
        return new CodeSnippet(true, "#className#Impl(EdgeImpl e, Graph g) {", "\tsuper(e, g);", "}");
    }

    @Override
    protected CodeBlock createGetter(Attribute attribute) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("name", attribute.getName());
        codeSnippet.setVariable("type", attribute.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        codeSnippet.setVariable("isOrGet", attribute.getDomain().isBoolean() ? "is" : "get");
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("public #type# #isOrGet#_#name#() {", "\treturn ((#normalQualifiedClassName#)normalEdge).#isOrGet#_#name#();", "}");
        }
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("public #type# #isOrGet#_#name#();");
        }
        return codeSnippet;
    }

    @Override
    protected CodeBlock createSetter(Attribute attribute) {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        codeSnippet.setVariable("name", attribute.getName());
        codeSnippet.setVariable("type", attribute.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
        if (this.currentCycle.isStdImpl()) {
            codeSnippet.add("public void set_#name#(#type# _#name#) {", "\t((#normalQualifiedClassName#)normalEdge).set_#name#(_#name#);", "}");
        }
        if (this.currentCycle.isAbstract()) {
            codeSnippet.add("public void set_#name#(#type# _#name#);");
        }
        return codeSnippet;
    }

    @Override
    protected CodeBlock createGenericGetter(List<Attribute> list) {
        return null;
    }

    @Override
    protected CodeBlock createGenericSetter(List<Attribute> list) {
        return null;
    }

    private CodeBlock createNextEdgeMethods() {
        CodeList codeList = new CodeList();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        treeSet.add(this.aec);
        for (GraphElementClass graphElementClass : treeSet) {
            EdgeClass edgeClass = (EdgeClass)graphElementClass;
            codeList.addNoIndent(this.createNextEdgeMethod(edgeClass));
        }
        return codeList;
    }

    private CodeBlock createNextEdgeMethod(EdgeClass edgeClass) {
        CodeSnippet codeSnippet = new CodeSnippet(true, "public #ecName# getNext#ecCamelName#InGraph(#formalParams#) {", "\treturn ((#ecName#)normalEdge).getNext#ecCamelName#InGraph(#actualParams#);", "}");
        codeSnippet.setVariable("ecName", this.schemaRootPackageName + "." + edgeClass.getQualifiedName());
        codeSnippet.setVariable("ecCamelName", ReversedEdgeCodeGenerator.camelCase(edgeClass.getUniqueName()));
        codeSnippet.setVariable("formalParams", "");
        codeSnippet.setVariable("actualParams", "");
        return codeSnippet;
    }

    private CodeBlock createNextIncidenceMethods() {
        CodeList codeList = new CodeList();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(((EdgeClass)this.aec).getAllSuperClasses());
        treeSet.add(this.aec);
        for (GraphElementClass graphElementClass : treeSet) {
            this.addImports("#jgPackage#.EdgeDirection");
            EdgeClass edgeClass = (EdgeClass)graphElementClass;
            codeList.addNoIndent(this.createNextIncidenceMethod(edgeClass, false));
            codeList.addNoIndent(this.createNextIncidenceMethod(edgeClass, true));
        }
        return codeList;
    }

    private CodeBlock createNextIncidenceMethod(EdgeClass edgeClass, boolean bl) {
        CodeSnippet codeSnippet = new CodeSnippet(true, "public #ecName# getNext#ecCamelName#Incidence(#formalParams#) {", "\treturn (#ecName#)getNextIncidence(#ecName#.EC#actualParams#);", "}");
        codeSnippet.setVariable("ecName", this.schemaRootPackageName + "." + edgeClass.getQualifiedName());
        codeSnippet.setVariable("ecCamelName", ReversedEdgeCodeGenerator.camelCase(edgeClass.getUniqueName()));
        codeSnippet.setVariable("formalParams", bl ? "EdgeDirection orientation" : "");
        codeSnippet.setVariable("actualParams", bl ? ", orientation" : "");
        return codeSnippet;
    }

    @Override
    protected CodeBlock createStaticImplementationClassField() {
        return null;
    }

    @Override
    protected CodeBlock createFields(List<Attribute> list) {
        return null;
    }

    @Override
    protected CodeBlock createGetSchemaClassMethod() {
        return null;
    }

    @Override
    protected CodeBlock createReadAttributesFromStringMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        codeList.addNoIndent(new CodeSnippet(true, "public void readAttributeValueFromString(String attributeName, String value) throws GraphIOException {"));
        codeList.add(new CodeSnippet("throw new GraphIOException(\"Can not call readAttributeValuesFromString for reversed Edges.\");"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    @Override
    protected CodeBlock createWriteAttributeToStringMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        codeList.addNoIndent(new CodeSnippet(true, "public String writeAttributeValueToString(String _attributeName) throws IOException, GraphIOException {"));
        codeList.add(new CodeSnippet("throw new GraphIOException(\"Can not call writeAttributeValueToString for reversed Edges.\");"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    @Override
    protected CodeBlock createReadAttributesMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        codeList.addNoIndent(new CodeSnippet(true, "public void readAttributeValues(GraphIO io) throws GraphIOException {"));
        codeList.add(new CodeSnippet("throw new GraphIOException(\"Can not call readAttributeValues for reversed Edges.\");"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    @Override
    protected CodeBlock createWriteAttributesMethod(List<Attribute> list) {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "java.io.IOException");
        codeList.addNoIndent(new CodeSnippet(true, "public void writeAttributeValues(GraphIO io) throws GraphIOException, IOException {"));
        codeList.add(new CodeSnippet("throw new GraphIOException(\"Can not call writeAttributeValues for reversed Edges.\");"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    @Override
    protected CodeBlock createAttributedElementClassConstant() {
        return null;
    }

    @Override
    protected CodeBlock createGetAttributedElementClassMethod() {
        return new CodeSnippet(true, "@Override", "public final #jgSchemaPackage#.#schemaElementClass# getAttributedElementClass() {", "\treturn getNormalEdge().getAttributedElementClass();", "}");
    }
}

