/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.AttributeImpl;
import de.uni_koblenz.jgralab.schema.impl.AttributedElementClassImpl;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import de.uni_koblenz.jgralab.schema.impl.EdgeClassImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.TemporaryEdgeClassImpl;
import de.uni_koblenz.jgralab.schema.impl.TemporaryVertexClassImpl;
import de.uni_koblenz.jgralab.schema.impl.VertexClassImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pcollections.PVector;

public final class GraphClassImpl
extends AttributedElementClassImpl<GraphClass, Graph>
implements GraphClass {
    Map<String, VertexClass> vertexClasses = new HashMap<String, VertexClass>();
    DirectedAcyclicGraph<VertexClass> vertexClassDag = new DirectedAcyclicGraph(true);
    Map<String, EdgeClass> edgeClasses = new HashMap<String, EdgeClass>();
    DirectedAcyclicGraph<EdgeClass> edgeClassDag = new DirectedAcyclicGraph(true);
    PVector<VertexClass> userDefinedVertexClasses;
    PVector<EdgeClass> userDefinedEdgeClasses;
    PVector<GraphElementClass<?, ?>> userDefinedGraphElementClasses;
    private VertexClassImpl defaultVertexClass;
    private EdgeClassImpl defaultEdgeClass;
    private TemporaryVertexClassImpl tempVertexClass;
    private TemporaryEdgeClassImpl tempEdgeClass;

    GraphClassImpl(String string, SchemaImpl schemaImpl) {
        super(string, (PackageImpl)schemaImpl.getDefaultPackage(), schemaImpl);
        schemaImpl.setGraphClass(this);
    }

    @Override
    public final VertexClass getDefaultVertexClass() {
        return this.defaultVertexClass;
    }

    final void initializeDefaultVertexClass() {
        VertexClassImpl vertexClassImpl = new VertexClassImpl("Vertex", (PackageImpl)this.schema.getDefaultPackage(), this);
        vertexClassImpl.setAbstract(true);
        this.defaultVertexClass = vertexClassImpl;
    }

    final void initializeDefaultEdgeClass() {
        assert (this.getDefaultVertexClass() != null) : "Default VertexClass has not yet been created!";
        assert (this.getDefaultEdgeClass() == null) : "Default EdgeClass already created!";
        EdgeClassImpl edgeClassImpl = new EdgeClassImpl("Edge", (PackageImpl)this.schema.getDefaultPackage(), this, this.defaultVertexClass, 0, Integer.MAX_VALUE, "", AggregationKind.NONE, this.defaultVertexClass, 0, Integer.MAX_VALUE, "", AggregationKind.NONE);
        edgeClassImpl.setAbstract(true);
        this.defaultEdgeClass = edgeClassImpl;
    }

    @Override
    public final VertexClass getTemporaryVertexClass() {
        return this.tempVertexClass;
    }

    final void initializeTemporaryVertexClass() {
        assert (this.getTemporaryVertexClass() == null) : "TemporaryVertexClass already created!";
        this.tempVertexClass = new TemporaryVertexClassImpl(this);
    }

    final void initializeTemporaryEdgeClass() {
        assert (this.getDefaultVertexClass() != null) : "Default VertexClass has not yet been created!";
        assert (this.getTemporaryEdgeClass() == null) : "TemporaryEdgeClass already created!";
        this.tempEdgeClass = new TemporaryEdgeClassImpl(this);
    }

    @Override
    public final EdgeClass getTemporaryEdgeClass() {
        return this.tempEdgeClass;
    }

    @Override
    public final EdgeClass getDefaultEdgeClass() {
        return this.defaultEdgeClass;
    }

    void addEdgeClass(EdgeClass edgeClass) {
        if (this.edgeClasses.containsKey(edgeClass.getQualifiedName())) {
            throw new SchemaException("Duplicate edge class name '" + edgeClass.getQualifiedName() + "'");
        }
        if (!edgeClass.getQualifiedName().equals("Edge") && !edgeClass.getQualifiedName().equals("TemporaryEdgeClass")) {
            this.edgeClasses.put(edgeClass.getQualifiedName(), edgeClass);
        }
    }

    void addVertexClass(VertexClass vertexClass) {
        if (this.vertexClasses.containsKey(vertexClass.getQualifiedName())) {
            throw new SchemaException("Duplicate vertex class name '" + vertexClass.getQualifiedName() + "'");
        }
        if (!vertexClass.getQualifiedName().equals("Vertex") && !vertexClass.getQualifiedName().equals("TemporaryVertexClass")) {
            this.vertexClasses.put(vertexClass.getQualifiedName(), vertexClass);
        }
    }

    @Override
    public final EdgeClass createEdgeClass(String string, VertexClass vertexClass, int n, int n2, String string2, AggregationKind aggregationKind, VertexClass vertexClass2, int n3, int n4, String string3, AggregationKind aggregationKind2) {
        this.assertNotFinished();
        if (vertexClass.isDefaultGraphElementClass() || vertexClass2.isDefaultGraphElementClass()) {
            throw new SchemaException("EdgeClasses starting or ending at the default VertexClass Vertex are forbidden.");
        }
        if (aggregationKind != AggregationKind.NONE && aggregationKind2 != AggregationKind.NONE) {
            throw new SchemaException("At least one end of each class must be of AggregationKind NONE at EdgeClass " + string);
        }
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        PackageImpl packageImpl = this.schema.createPackageWithParents(stringArray[0]);
        EdgeClassImpl edgeClassImpl = new EdgeClassImpl(stringArray[1], packageImpl, this, vertexClass, n, n2, string2, aggregationKind, vertexClass2, n3, n4, string3, aggregationKind2);
        if (this.defaultEdgeClass != null) {
            edgeClassImpl.addSuperClass(this.defaultEdgeClass);
        }
        return edgeClassImpl;
    }

    @Override
    public final VertexClass createVertexClass(String string) {
        this.assertNotFinished();
        String[] stringArray = SchemaImpl.splitQualifiedName(string);
        PackageImpl packageImpl = ((SchemaImpl)this.getSchema()).createPackageWithParents(stringArray[0]);
        VertexClassImpl vertexClassImpl = new VertexClassImpl(stringArray[1], packageImpl, this);
        if (this.defaultVertexClass != null) {
            vertexClassImpl.addSuperClass(this.defaultVertexClass);
        }
        return vertexClassImpl;
    }

    @Override
    public final GraphElementClass<?, ?> getGraphElementClass(String string) {
        GraphElementClass graphElementClass = this.vertexClasses.get(string);
        if (graphElementClass != null) {
            return graphElementClass;
        }
        return this.edgeClasses.get(string);
    }

    @Override
    public final List<GraphElementClass<?, ?>> getGraphElementClasses() {
        if (this.finished) {
            return this.userDefinedGraphElementClasses;
        }
        PVector pVector = JGraLab.vector();
        return pVector.plusAll(this.getVertexClasses()).plusAll(this.getEdgeClasses());
    }

    @Override
    public final List<EdgeClass> getEdgeClasses() {
        if (this.finished) {
            return this.userDefinedEdgeClasses;
        }
        PVector<EdgeClass> pVector = this.edgeClassDag.getNodesInTopologicalOrder();
        assert (pVector.get(0) == this.defaultEdgeClass);
        assert (pVector.get(1) == this.tempEdgeClass);
        return pVector.subList(2, pVector.size());
    }

    @Override
    public final List<VertexClass> getVertexClasses() {
        if (this.finished) {
            return this.userDefinedVertexClasses;
        }
        PVector<VertexClass> pVector = this.vertexClassDag.getNodesInTopologicalOrder();
        assert (pVector.get(0) == this.defaultVertexClass);
        assert (pVector.get(1) == this.tempVertexClass);
        return pVector.subList(2, pVector.size());
    }

    @Override
    public final VertexClass getVertexClass(String string) {
        return this.vertexClasses.get(string);
    }

    @Override
    public final EdgeClass getEdgeClass(String string) {
        return this.edgeClasses.get(string);
    }

    @Override
    public final int getEdgeClassCount() {
        return this.edgeClasses.size();
    }

    @Override
    public final int getVertexClassCount() {
        return this.vertexClasses.size();
    }

    @Override
    protected final void finish() {
        this.assertNotFinished();
        this.vertexClassDag.finish();
        this.edgeClassDag.finish();
        for (VertexClass graphElementClass : this.vertexClassDag.getNodesInTopologicalOrder()) {
            ((VertexClassImpl)graphElementClass).finish();
        }
        for (EdgeClass edgeClass : this.edgeClassDag.getNodesInTopologicalOrder()) {
            ((EdgeClassImpl)edgeClass).finish();
        }
        this.userDefinedVertexClasses = this.vertexClassDag.getNodesInTopologicalOrder();
        assert (this.userDefinedVertexClasses.get(0) == this.defaultVertexClass);
        assert (this.userDefinedVertexClasses.get(1) == this.tempVertexClass);
        this.userDefinedVertexClasses = this.userDefinedVertexClasses.subList(2, this.userDefinedVertexClasses.size());
        this.userDefinedEdgeClasses = this.edgeClassDag.getNodesInTopologicalOrder();
        assert (this.userDefinedEdgeClasses.get(0) == this.defaultEdgeClass);
        assert (this.userDefinedEdgeClasses.get(1) == this.tempEdgeClass);
        this.userDefinedEdgeClasses = this.userDefinedEdgeClasses.subList(2, this.userDefinedEdgeClasses.size());
        this.userDefinedGraphElementClasses = JGraLab.vector();
        this.userDefinedGraphElementClasses = this.userDefinedGraphElementClasses.plusAll(this.userDefinedVertexClasses).plusAll(this.userDefinedEdgeClasses);
        super.finish();
    }

    @Override
    public final boolean hasOwnAttributes() {
        return this.hasAttributes();
    }

    @Override
    public final Attribute getOwnAttribute(String string) {
        return this.getAttribute(string);
    }

    @Override
    public final int getOwnAttributeCount() {
        return this.getAttributeCount();
    }

    @Override
    public final List<Attribute> getOwnAttributeList() {
        return this.getAttributeList();
    }

    @Override
    public void setQualifiedName(String string) {
        if (this.qualifiedName.equals(string)) {
            return;
        }
        if (this.schema.knows(string)) {
            throw new SchemaException(string + " is already known to the schema.");
        }
        if (string.contains(".")) {
            throw new SchemaException("The GraphClass must be in the default package. You tried to move it to '" + string + "'.");
        }
        this.unregister();
        this.qualifiedName = string;
        this.simpleName = string;
        this.register();
    }

    @Override
    protected final void reopen() {
        for (VertexClass graphElementClass : this.vertexClassDag.getNodesInTopologicalOrder()) {
            ((VertexClassImpl)graphElementClass).reopen();
        }
        for (EdgeClass edgeClass : this.edgeClassDag.getNodesInTopologicalOrder()) {
            ((EdgeClassImpl)edgeClass).reopen();
        }
        this.vertexClassDag.reopen();
        this.edgeClassDag.reopen();
        super.reopen();
    }

    @Override
    protected void deleteAttribute(AttributeImpl attributeImpl) {
        this.allAttributes = this.allAttributes.minus(attributeImpl);
    }
}

