/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.rsa2tg;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.ist.utilities.xml.XmlProcessor;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.graphvalidator.ConstraintViolation;
import de.uni_koblenz.jgralab.graphvalidator.GraphValidator;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.StringDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.AggregationKind;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.ComesFrom;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.ContainsGraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.EndsAt;
import de.uni_koblenz.jgralab.grumlschema.structure.GoesTo;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.utilities.rsa2tg.ProcessingException;
import de.uni_koblenz.jgralab.utilities.rsa2tg.SchemaGraph2Tg;
import de.uni_koblenz.jgralab.utilities.tg2dot.Tg2Dot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.pcollections.PVector;

public class Rsa2Tg
extends XmlProcessor {
    private static final String OPTION_FILENAME_VALIDATION = "r";
    private static final String OPTION_FILENAME_SCHEMA_GRAPH = "s";
    private static final String OPTION_FILENAME_DOT = "e";
    private static final String OPTION_FILENAME_SCHEMA = "o";
    private static final String OPTION_USE_NAVIGABILITY = "n";
    private static final String OPTION_REMOVE_UNUSED_DOMAINS = "u";
    private static final String OPTION_KEEP_EMPTY_PACKAGES = "k";
    private static final String OPTION_USE_ROLE_NAME = "f";
    private static final String OPTION_REMOVE_COMMENTS = "c";
    private Stack<String> xmiIdStack;
    private SchemaGraph sg;
    private Schema schema;
    private GraphClass graphClass;
    private Stack<Package> packageStack;
    private Map<String, Vertex> idMap;
    private String currentClassId;
    private AttributedElementClass currentClass;
    private RecordDomain currentRecordDomain;
    private HasRecordDomainComponent currentRecordDomainComponent;
    private de.uni_koblenz.jgralab.grumlschema.structure.Attribute currentAttribute;
    private GraphMarker<Set<String>> generalizations;
    private Map<String, Set<String>> realizations;
    private GraphMarker<String> attributeType;
    private GraphMarker<String> recordComponentType;
    private Map<String, Domain> domainMap;
    private Set<Vertex> preliminaryVertices;
    private IncidenceClass currentAssociationEnd;
    private Set<IncidenceClass> ownedEnds;
    private boolean inConstraint;
    private String constrainedElementId;
    private Map<String, List<String>> constraints;
    private Map<String, List<String>> comments;
    private boolean useFromRole;
    private boolean removeUnusedDomains;
    private boolean removeComments;
    private boolean keepEmptyPackages;
    private boolean useNavigability;
    private boolean suppressOutput;
    private String filenameSchema;
    private String filenameSchemaGraph;
    private String filenameDot;
    private String filenameValidation;
    private String annotatedElementId;
    private boolean inComment;
    private boolean inOwnedAttribute;
    private GreqlQuery edgeClassAcyclicQuery;
    private GreqlQuery vertexClassAcyclicQuery;
    private boolean inDefaultValue;
    private int modelRootElementNestingDepth;
    private Set<Package> ignoredPackages;
    private boolean inSpecification;
    private Set<GraphElementClass> derivedGraphElementClasses;
    private static final Pattern GENNAME_PATTERN = Pattern.compile("(.*)\\$\\p{Digit}+(:(\\w+))?\\$$");

    public static void main(String[] stringArray) throws IOException {
        boolean bl;
        System.out.println("RSA to TG");
        System.out.println("=========");
        JGraLab.setLogLevel(Level.OFF);
        CommandLine commandLine = Rsa2Tg.processCommandLineOptions(stringArray);
        assert (commandLine != null) : "No CommandLine object has been generated!";
        File file = new File(commandLine.getOptionValue('i'));
        Rsa2Tg rsa2Tg = new Rsa2Tg();
        rsa2Tg.setUseFromRole(commandLine.hasOption(OPTION_USE_ROLE_NAME));
        rsa2Tg.setRemoveUnusedDomains(commandLine.hasOption(OPTION_REMOVE_UNUSED_DOMAINS));
        rsa2Tg.setKeepEmptyPackages(commandLine.hasOption(OPTION_KEEP_EMPTY_PACKAGES));
        rsa2Tg.setUseNavigability(commandLine.hasOption(OPTION_USE_NAVIGABILITY));
        rsa2Tg.setRemoveComments(commandLine.hasOption(OPTION_REMOVE_COMMENTS));
        rsa2Tg.setFilenameSchema(commandLine.getOptionValue(OPTION_FILENAME_SCHEMA));
        rsa2Tg.setFilenameSchemaGraph(commandLine.getOptionValue(OPTION_FILENAME_SCHEMA_GRAPH));
        rsa2Tg.setFilenameDot(commandLine.getOptionValue(OPTION_FILENAME_DOT));
        rsa2Tg.setFilenameValidation(commandLine.getOptionValue(OPTION_FILENAME_VALIDATION));
        boolean bl2 = bl = !commandLine.hasOption(OPTION_FILENAME_SCHEMA) && !commandLine.hasOption(OPTION_FILENAME_SCHEMA_GRAPH) && !commandLine.hasOption(OPTION_FILENAME_DOT) && !commandLine.hasOption(OPTION_FILENAME_VALIDATION);
        if (bl) {
            System.out.println("No output option has been selected. A TG-file for the Schema will be written.");
            rsa2Tg.setFilenameSchema(Rsa2Tg.createFilename(file));
        }
        try {
            System.out.println("processing: " + file.getPath() + "\n");
            rsa2Tg.process(file.getPath());
        }
        catch (Exception exception) {
            System.err.println("An Exception occured while processing " + file + ".");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        System.out.println("Fini.");
    }

    public void setRemoveComments(boolean bl) {
        this.removeComments = bl;
    }

    public static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + Rsa2Tg.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option(OPTION_FILENAME_VALIDATION, "report", true, "(optional): writes a validation report to the given filename. Free naming, but should look like this: '<filename>.html'");
        option.setRequired(false);
        option.setArgName("filename");
        optionHandler.addOption(option);
        Option option2 = new Option(OPTION_FILENAME_DOT, "export", true, "(optional): writes a GraphViz DOT file to the given filename. Free naming, but should look like this: '<filename>.dot'");
        option2.setRequired(false);
        option2.setArgName("filename");
        optionHandler.addOption(option2);
        Option option3 = new Option(OPTION_FILENAME_SCHEMA_GRAPH, "schemaGraph", true, "(optional): writes a TG-file of the Schema as graph instance to the given filename. Free naming, but should look like this:  '<filename>.tg'");
        option3.setRequired(false);
        option3.setArgName("filename");
        optionHandler.addOption(option3);
        Option option4 = new Option("i", "input", true, "(required): UML 2.1-XMI exchange model file of the Schema.");
        option4.setRequired(true);
        option4.setArgName("filename");
        optionHandler.addOption(option4);
        Option option5 = new Option(OPTION_FILENAME_SCHEMA, "output", true, "(optional): writes a TG-file of the Schema to the given filename. Free naming, but should look like this: '<filename>.rsa.tg.'");
        option5.setRequired(false);
        option5.setArgName("filename");
        optionHandler.addOption(option5);
        Option option6 = new Option(OPTION_USE_ROLE_NAME, "useFromRole", false, "(optional): if this flag is set, the name of from roles will be used for creating undefined EdgeClass names.");
        option6.setRequired(false);
        optionHandler.addOption(option6);
        Option option7 = new Option(OPTION_REMOVE_UNUSED_DOMAINS, "removeUnusedDomains", false, "(optional): if this flag is set, all unused domains be deleted.");
        option7.setRequired(false);
        optionHandler.addOption(option7);
        Option option8 = new Option(OPTION_REMOVE_COMMENTS, "removeComments", false, "(optional): if this flag is set, all comments are removed.");
        option8.setRequired(false);
        optionHandler.addOption(option8);
        Option option9 = new Option(OPTION_KEEP_EMPTY_PACKAGES, "keepEmptyPackages", false, "(optional): if this flag is set, empty packages will be retained.");
        option9.setRequired(false);
        optionHandler.addOption(option9);
        Option option10 = new Option(OPTION_USE_NAVIGABILITY, "useNavigability", false, "(optional): if this flag is set, navigability information will be interpreted as reading direction.");
        option10.setRequired(false);
        optionHandler.addOption(option10);
        return optionHandler.parse(stringArray);
    }

    public static String createFilename(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file.getParent());
        stringBuilder.append(File.separatorChar);
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        stringBuilder.append(string);
        stringBuilder.append(".rsa.tg");
        return stringBuilder.toString();
    }

    public Rsa2Tg() {
        this.addIgnoredElements("profileApplication", "packageImport", "Ecore:EReference");
    }

    @Override
    public void startDocument() {
        this.sg = GrumlSchema.instance().createSchemaGraph(ImplementationType.STANDARD);
        this.xmiIdStack = new Stack();
        this.idMap = new HashMap<String, Vertex>();
        this.packageStack = new Stack();
        this.generalizations = new GraphMarker(this.sg);
        this.realizations = new HashMap<String, Set<String>>();
        this.attributeType = new GraphMarker(this.sg);
        this.recordComponentType = new GraphMarker(this.sg);
        this.domainMap = new HashMap<String, Domain>();
        this.preliminaryVertices = new HashSet<Vertex>();
        this.ownedEnds = new HashSet<IncidenceClass>();
        this.constraints = new HashMap<String, List<String>>();
        this.comments = new HashMap<String, List<String>>();
        this.ignoredPackages = new HashSet<Package>();
        this.modelRootElementNestingDepth = 1;
        this.derivedGraphElementClasses = new HashSet<GraphElementClass>();
    }

    @Override
    protected void startElement(String string) throws XMLStreamException {
        if (this.getNestingDepth() == 1 && string.equals("xmi:XMI")) {
            this.modelRootElementNestingDepth = 2;
            return;
        }
        String string2 = this.getAttribute("xmi", "id");
        this.xmiIdStack.push(string2);
        Vertex vertex = null;
        vertex = this.getNestingDepth() == this.modelRootElementNestingDepth ? this.createDefaultElements(string) : this.processXMIElements(string, string2);
        if (string2 != null && vertex != null) {
            this.idMap.put(string2, vertex);
        }
    }

    private Vertex createDefaultElements(String string) throws XMLStreamException {
        if (!string.equals("uml:Model") && !string.equals("uml:Package")) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "Root element must be uml:Model or uml:Package, buf was " + string);
        }
        this.setSchemaQualifiedName();
        this.createGraphClass();
        this.createDefaultPackage();
        return this.schema;
    }

    private void setSchemaQualifiedName() throws XMLStreamException {
        String string = this.getAttribute("name");
        int n = string.lastIndexOf(46);
        this.schema = this.sg.createSchema();
        if (n == -1) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "A Schema must have a package prefix!\nProcessed qualified name: " + string);
        }
        this.schema.set_packagePrefix(string.substring(0, n));
        this.schema.set_name(string.substring(n + 1));
    }

    private void createGraphClass() {
        this.graphClass = this.sg.createGraphClass();
        this.sg.createDefinesGraphClass(this.schema, this.graphClass);
    }

    private void createDefaultPackage() {
        Package package_ = this.sg.createPackage();
        package_.set_qualifiedName("");
        this.sg.createContainsDefaultPackage(this.schema, package_);
        this.packageStack.push(package_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vertex processXMIElements(String string, String string2) throws XMLStreamException {
        String string3 = this.getAttribute("xmi", "type");
        Vertex vertex = null;
        if (string.equals("packagedElement")) {
            if (string3.equals("uml:Package")) {
                return this.handlePackage();
            }
            if (string3.equals("uml:Class")) {
                return this.handleClass(string2);
            }
            if (string3.equals("uml:Association")) return this.handleAssociation(string2);
            if (string3.equals("uml:AssociationClass")) {
                return this.handleAssociation(string2);
            }
            if (string3.equals("uml:Enumeration")) {
                return this.handleEnumeration();
            }
            if (string3.equals("uml:PrimitiveType")) {
                return this.handlePrimitiveType(string2);
            }
            if (!string3.equals("uml:Realization")) throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, string3));
            this.handleRealization();
            return vertex;
        } else if (string.equals("ownedRule")) {
            this.inConstraint = true;
            this.constrainedElementId = this.getAttribute("constrainedElement");
            if (this.constrainedElementId == null) return vertex;
            int n = this.constrainedElementId.indexOf(32);
            if (n < 0) return vertex;
            this.constrainedElementId = null;
            return vertex;
        } else {
            if (string.equals("body")) {
                if (this.inConstraint) return vertex;
                if (this.inComment) return vertex;
                if (this.inDefaultValue) return vertex;
                if (this.inSpecification) return vertex;
                throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, null));
            }
            if (string.equals("specification")) {
                this.inSpecification = true;
                return vertex;
            } else {
                if (string.equals("language")) {
                    if (this.inConstraint) return vertex;
                    throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, null));
                }
                if (string.equals("ownedEnd")) {
                    if (!string3.equals("uml:Property")) throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, string3));
                    if (!(this.currentClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)) throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, string3));
                    this.handleAssociationEnd(string2);
                    return vertex;
                } else if (string.equals("ownedAttribute")) {
                    this.inOwnedAttribute = true;
                    if (!string3.equals("uml:Property")) throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, string3));
                    this.handleOwnedAttribute(string2);
                    return vertex;
                } else if (string.equals("type")) {
                    if (this.inDefaultValue) return vertex;
                    if (!string3.equals("uml:PrimitiveType")) throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, string3));
                    this.handleNestedTypeElement(string2);
                    return vertex;
                } else if (string.equals("ownedLiteral")) {
                    if (!string3.equals("uml:EnumerationLiteral")) throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, string3));
                    this.handleEnumerationLiteral();
                    return vertex;
                } else {
                    if (string.equals("xmi:Extension") || string.equals("eAnnotations")) return vertex;
                    if (string.equals("generalization")) {
                        this.handleGeneralization();
                        return vertex;
                    } else if (string.equals("details")) {
                        this.handleStereotype();
                        return vertex;
                    } else if (string.equals("lowerValue")) {
                        this.handleLowerValue();
                        return vertex;
                    } else if (string.equals("upperValue")) {
                        this.handleUpperValue();
                        return vertex;
                    } else if (string.equals("ownedComment")) {
                        this.annotatedElementId = this.getAttribute("annotatedElement");
                        this.inComment = true;
                        return vertex;
                    } else {
                        if (!string.equals("defaultValue")) throw new ProcessingException(this.getParser(), this.getFilename(), this.createUnexpectedElementMessage(string, string3));
                        String string4 = this.getAttribute("xmi", "type");
                        if (this.isPrimitiveDefaultValue(string4)) {
                            this.handlePrimitiveDefaultValue(string2, string4);
                        } else if (!string4.equals("uml:OpaqueExpression")) {
                            System.out.println("Warning: Unexpected default value type '" + string4 + "' for attribute '" + this.currentAttribute.get_name() + "' of " + this.currentClass.getSchemaClass().getSimpleName() + " '" + this.currentClass.get_qualifiedName() + "' in file '" + this.getFilename() + "' at line " + this.getParser().getLocation().getLineNumber());
                        }
                        this.inDefaultValue = true;
                    }
                }
            }
        }
        return vertex;
    }

    private boolean isPrimitiveDefaultValue(String string) {
        return string.equals("uml:LiteralString") || string.equals("uml:LiteralInteger") || string.equals("uml:LiteralBoolean") || string.equals("uml:InstanceValue");
    }

    private void handlePrimitiveDefaultValue(String string, String string2) throws XMLStreamException {
        if (string2.equals("uml:InstanceValue")) {
            String string3 = this.getAttribute("name");
            this.handleDefaultValue(string, string3);
            return;
        }
        String string4 = this.getAttribute("value");
        if (string2.equals("uml:LiteralBoolean")) {
            if (string4 == null) {
                string4 = OPTION_USE_ROLE_NAME;
            } else {
                assert (string4.equals("true") || string4.equals("false"));
                string4 = string4.substring(0, 1);
            }
            this.handleDefaultValue(string, string4);
            return;
        }
        if (string2.equals("uml:LiteralInteger")) {
            if (string4 == null) {
                string4 = "0";
            }
            this.handleDefaultValue(string, string4);
            return;
        }
        if (string4 == null) {
            System.out.println("Warning: Undefined default value for attribute '" + this.currentAttribute.get_name() + "' of " + this.currentClass.getSchemaClass().getSimpleName() + " '" + this.currentClass.get_qualifiedName() + "' in file '" + this.getFilename() + "' at line " + this.getParser().getLocation().getLineNumber());
            return;
        }
        if (string2.equals("uml:LiteralString")) {
            string4 = "\"" + string4 + "\"";
            this.handleDefaultValue(string, string4);
        } else {
            System.out.println("Warning: Undefined default value type '" + string2 + "' for attribute '" + this.currentAttribute.get_name() + "' of " + this.currentClass.getSchemaClass().getSimpleName() + " '" + this.currentClass.get_qualifiedName() + "' in file '" + this.getFilename() + "' at line " + this.getParser().getLocation().getLineNumber());
        }
    }

    private void handleDefaultValue(String string, String string2) {
        if (this.currentAttribute == null) {
            throw new ProcessingException(this.getFilename(), "Found a <defaultValue> tag (XMI id " + string + ") outside an attribute definition (e.g. in a <<record>> class)");
        }
        this.currentAttribute.set_defaultValue(string2);
    }

    @Override
    protected void endElement(String string, StringBuilder stringBuilder) throws XMLStreamException {
        AttributedElement attributedElement;
        if (this.getNestingDepth() < this.modelRootElementNestingDepth) {
            return;
        }
        String string2 = this.xmiIdStack.pop();
        if (string.equals("body")) {
            if (this.inConstraint) {
                assert (!this.inComment && !this.inDefaultValue);
                this.handleConstraint(stringBuilder.toString().trim().replace("\\s+", " "));
            } else if (this.inComment) {
                assert (!this.inDefaultValue);
                this.handleComment(stringBuilder.toString());
            } else if (this.inDefaultValue) {
                this.handleDefaultValue(string2, stringBuilder.toString().trim());
            }
        }
        if ((attributedElement = (AttributedElement)this.idMap.get(string2)) != null) {
            if (attributedElement instanceof Package) {
                if (this.packageStack.size() <= 1) {
                    throw new ProcessingException(this.getParser(), this.getFilename(), "XMI file is malformed. There is probably one end element to much.");
                }
                this.packageStack.pop();
            } else if (attributedElement instanceof AttributedElementClass) {
                this.currentClassId = null;
                this.currentClass = null;
                this.currentAttribute = null;
            } else if (attributedElement instanceof RecordDomain) {
                this.currentRecordDomain = null;
                this.currentAttribute = null;
            } else if (attributedElement instanceof de.uni_koblenz.jgralab.grumlschema.structure.Attribute) {
                this.currentAttribute = null;
            }
        }
        if (string.equals("uml:Package")) {
            this.packageStack.pop();
            if (this.packageStack.size() != 0) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "XMI file is malformed. There is probably one end element to much.");
            }
        } else if (string.equals("ownedAttribute")) {
            this.currentRecordDomainComponent = null;
            if (this.currentAssociationEnd != null) {
                this.checkMultiplicities(this.currentAssociationEnd);
                this.currentAssociationEnd = null;
            }
            this.inOwnedAttribute = false;
        } else if (string.equals("ownedEnd")) {
            this.checkMultiplicities(this.currentAssociationEnd);
            this.currentAssociationEnd = null;
        } else if (string.equals("ownedRule")) {
            this.inConstraint = false;
            this.constrainedElementId = null;
        } else if (string.equals("ownedComment")) {
            this.inComment = false;
            this.annotatedElementId = null;
        } else if (string.equals("defaultValue")) {
            this.inDefaultValue = false;
        } else if (string.equals("specification")) {
            this.inSpecification = false;
        }
    }

    private void checkMultiplicities(IncidenceClass incidenceClass) {
        int n = incidenceClass.get_min();
        int n2 = incidenceClass.get_max();
        assert (n >= 0);
        assert (n2 > 0);
        if (n == Integer.MAX_VALUE) {
            throw new ProcessingException(this.getFilename(), "Error in multiplicities: lower bound must not be * at association end " + incidenceClass);
        }
        if (n > n2) {
            throw new ProcessingException(this.getFilename(), "Error in multiplicities: lower bound (" + n + ") must be <= upper bound (" + n2 + ") at association end " + incidenceClass);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleComment(String string) {
        void var4_7;
        string = string.replaceAll("\\s+", " ");
        string = string.replace("<p>", " ");
        string = string.replace("</p>", "\n");
        String[] stringArray = string.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if ((string2 = string2.replaceAll("\\s+", " ").trim()).length() <= 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() == 0) {
            return;
        }
        List<String> list = this.comments.get(this.annotatedElementId);
        if (list == null) {
            LinkedList linkedList = new LinkedList();
            this.comments.put(this.annotatedElementId, linkedList);
        }
        var4_7.add(stringBuilder.toString());
    }

    @Override
    public void endDocument() throws XMLStreamException {
        assert (this.schema != null);
        assert (this.graphClass != null);
        if (this.graphClass.get_qualifiedName() == null) {
            throw new ProcessingException(this.getFilename(), "No <<graphclass>> defined in schema '" + this.schema.get_packagePrefix() + "." + this.schema.get_name() + "'");
        }
        this.checkEnumDomains();
        this.linkGeneralizations();
        this.linkRecordDomainComponents();
        this.linkAttributeDomains();
        this.removeIgnoredPackages();
        if (this.isUseNavigability()) {
            this.correctEdgeDirection();
        }
        this.attachConstraints();
        this.checkSubsettingOfAllIncidenceClasses();
        for (GraphElementClass vertex : this.derivedGraphElementClasses) {
            assert (vertex.isValid());
            Edge edge = vertex.getFirstIncidence();
            while (edge != null) {
                Vertex vertex2;
                Edge edge2 = edge.getNextIncidence();
                if (edge.isInstanceOf(Annotates.EC) && (vertex2 = edge2.getThat()).getDegree() == 1) {
                    vertex2.delete();
                }
                edge = edge2;
            }
            vertex.delete();
        }
        this.createEdgeClassNames();
        this.checkAttributes();
        if (this.isRemoveUnusedDomains()) {
            this.removeUnusedDomains();
        }
        if (!this.isRemoveComments()) {
            this.attachComments();
        }
        if (!this.isKeepEmptyPackages()) {
            this.removeEmptyPackages();
        }
        if (!this.preliminaryVertices.isEmpty()) {
            System.err.println("Remaining preliminary vertices (" + this.preliminaryVertices.size() + "):");
            for (Vertex vertex : this.preliminaryVertices) {
                System.err.println(this.attributedElement2String(vertex));
            }
            throw new ProcessingException(this.getFilename(), "There are still vertices left over. ");
        }
        if (!this.suppressOutput) {
            try {
                this.writeOutput();
            }
            catch (GraphIOException graphIOException) {
                throw new XMLStreamException(graphIOException);
            }
        }
    }

    private boolean isRemoveComments() {
        return this.removeComments;
    }

    private void checkAttributes() {
        GraphClass graphClass = this.sg.getFirstGraphClass();
        HashMap<String, AttributedElementClass> hashMap = new HashMap<String, AttributedElementClass>();
        for (de.uni_koblenz.jgralab.grumlschema.structure.Attribute vertex : graphClass.get_attributes()) {
            if (hashMap.containsKey(vertex.get_name())) {
                throw new RuntimeException("Attribute " + vertex.get_name() + " at " + graphClass.get_qualifiedName() + " is duplicate.");
            }
            hashMap.put(vertex.get_name(), graphClass);
        }
        for (GraphElementClass graphElementClass : this.sg.getGraphElementClassVertices()) {
            boolean bl = graphElementClass.isInstanceOf(VertexClass.VC);
            hashMap = new HashMap();
            BooleanGraphMarker booleanGraphMarker = new BooleanGraphMarker(this.sg);
            LinkedList<AttributedElementClass> linkedList = new LinkedList<AttributedElementClass>();
            linkedList.add(graphElementClass);
            while (!linkedList.isEmpty()) {
                AttributedElementClass attributedElementClass;
                GraphElementClass graphElementClass2 = (GraphElementClass)linkedList.poll();
                if (booleanGraphMarker.isMarked(graphElementClass2)) continue;
                for (de.uni_koblenz.jgralab.grumlschema.structure.Attribute attribute : graphElementClass2.get_attributes()) {
                    if (hashMap.containsKey(attribute.get_name())) {
                        attributedElementClass = (AttributedElementClass)hashMap.get(attribute.get_name());
                        throw new RuntimeException("The name of the " + (attributedElementClass == graphElementClass && graphElementClass2 != graphElementClass ? "" : "inherited ") + "attribute " + attribute.get_name() + " of " + (bl ? "VertexClass" : "EdgeClass") + " " + attributedElementClass.get_qualifiedName() + (graphElementClass2 == graphElementClass ? " is duplicate" : " is the same name as the inherited attribute of " + (bl ? "VertexClass" : "EdgeClass") + " " + graphElementClass2.get_qualifiedName()) + ".");
                    }
                    hashMap.put(attribute.get_name(), graphElementClass2);
                }
                booleanGraphMarker.mark(graphElementClass2);
                for (Edge edge : graphElementClass2.incidences(bl ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT)) {
                    attributedElementClass = (GraphElementClass)edge.getThat();
                    if (booleanGraphMarker.isMarked(attributedElementClass)) continue;
                    linkedList.add(attributedElementClass);
                }
            }
        }
    }

    private void removeIgnoredPackages() {
        System.out.println("Removing ignored packages...");
        int n = 0;
        for (Package package_ : this.ignoredPackages) {
            n += this.removePackage(package_);
        }
        System.out.println("\tRemoved " + n + " package" + (n == 1 ? "" : OPTION_FILENAME_SCHEMA_GRAPH) + ".");
    }

    private int removePackage(Package package_) {
        if (!package_.isValid()) {
            return 0;
        }
        int n = 0;
        ArrayList<Package> arrayList = new ArrayList<Package>();
        for (Package namedElement : package_.get_subpackages()) {
            arrayList.add(namedElement);
        }
        for (Package package_2 : arrayList) {
            n += this.removePackage(package_2);
        }
        Object object = package_.getFirstContainsGraphElementClassIncidence(EdgeDirection.OUT);
        while (object != null) {
            GraphElementClass graphElementClass;
            GraphElementClass graphElementClass2 = (GraphElementClass)object.getThat();
            if (graphElementClass2 instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) {
                graphElementClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)graphElementClass2;
                graphElementClass.get_to().delete();
                graphElementClass.get_from().delete();
            } else if (graphElementClass2 instanceof VertexClass) {
                graphElementClass = (VertexClass)graphElementClass2;
                EndsAt endsAt = graphElementClass.getFirstEndsAtIncidence(EdgeDirection.IN);
                while (endsAt != null) {
                    de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass;
                    ComesFrom comesFrom = ((IncidenceClass)endsAt.getThat()).getFirstComesFromIncidence();
                    if (comesFrom == null) {
                        GoesTo goesTo = ((IncidenceClass)endsAt.getThat()).getFirstGoesToIncidence();
                        edgeClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)goesTo.getThat();
                    } else {
                        edgeClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)comesFrom.getThat();
                    }
                    edgeClass.get_to().delete();
                    edgeClass.get_from().delete();
                    this.removeAttributes(edgeClass);
                    edgeClass.delete();
                    endsAt = graphElementClass.getFirstEndsAtIncidence(EdgeDirection.IN);
                }
            }
            this.removeAttributes(graphElementClass2);
            graphElementClass2.delete();
            object = package_.getFirstContainsGraphElementClassIncidence(EdgeDirection.OUT);
        }
        if (package_.getDegree() == 1) {
            ++n;
            System.out.println("\t- removing " + package_.get_qualifiedName());
            package_.delete();
        }
        return n;
    }

    private void removeAttributes(AttributedElementClass attributedElementClass) {
        HasAttribute hasAttribute = attributedElementClass.getFirstHasAttributeIncidence(EdgeDirection.OUT);
        while (hasAttribute != null) {
            hasAttribute.getThat().delete();
            hasAttribute = attributedElementClass.getFirstHasAttributeIncidence(EdgeDirection.OUT);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkEnumDomains() {
        System.out.println("Checking enumeration domains...");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EnumDomain object : this.sg.getEnumDomainVertices()) {
            if (object.get_enumConstants().size() >= 1) continue;
            arrayList.add(object.get_qualifiedName());
        }
        if (arrayList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The following enumeration domain").append(arrayList.size() == 1 ? " has" : "s have").append(" no literals");
            String string = ": ";
            for (String string2 : arrayList) {
                void var3_5;
                stringBuilder.append((String)var3_5).append(string2);
                String string3 = ", ";
            }
            throw new ProcessingException(this.getFilename(), stringBuilder.toString());
        }
    }

    private void attachComments() {
        System.out.println("Attaching comments to annotated elements...");
        for (String string : this.comments.keySet()) {
            Object object;
            NamedElement namedElement = null;
            if (this.domainMap.containsKey(string)) {
                namedElement = this.domainMap.get(string);
            } else if (this.idMap.containsKey(string)) {
                object = this.idMap.get(string);
                namedElement = (NamedElement)object;
            }
            if (namedElement == null) {
                System.out.println("\t- Couldn't find annotated element for XMI id " + string + "\n\t  => attaching to GraphClass (Comment starts with '" + this.comments.get(string).get(0) + "'");
                namedElement = this.graphClass;
            }
            assert (namedElement != null);
            if (!namedElement.isValid()) continue;
            object = this.comments.get(string);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Comment comment = this.sg.createComment();
                comment.set_text(string2);
                this.sg.createAnnotates(comment, namedElement);
            }
        }
    }

    private void checkSubsettingOfAllIncidenceClasses() {
        System.out.println("Checking subsets relationships...");
        for (SpecializesEdgeClass specializesEdgeClass = this.sg.getFirstSpecializesEdgeClass(); specializesEdgeClass != null; specializesEdgeClass = specializesEdgeClass.getNextSpecializesEdgeClassInGraph()) {
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass = specializesEdgeClass.getAlpha();
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass2 = specializesEdgeClass.getOmega();
            assert (edgeClass.getFirstComesFromIncidence() != null);
            assert (edgeClass2.getFirstComesFromIncidence() != null);
            this.checkSubsettingOfIncidences(edgeClass, edgeClass2, (IncidenceClass)edgeClass.getFirstComesFromIncidence().getThat(), (IncidenceClass)edgeClass2.getFirstComesFromIncidence().getThat());
            assert (edgeClass.getFirstGoesToIncidence() != null);
            assert (edgeClass2.getFirstGoesToIncidence() != null);
            this.checkSubsettingOfIncidences(edgeClass, edgeClass2, (IncidenceClass)edgeClass.getFirstGoesToIncidence().getThat(), (IncidenceClass)edgeClass2.getFirstGoesToIncidence().getThat());
        }
    }

    private void checkSubsettingOfIncidences(de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass, de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass2, IncidenceClass incidenceClass, IncidenceClass incidenceClass2) {
        assert (this.getDirection(incidenceClass) != null);
        assert (this.getDirection(incidenceClass2) != null);
        if (this.getDirection(incidenceClass) != this.getDirection(incidenceClass2)) {
            throw new ProcessingException(this.getFilename(), "Incompatible incidence direction in specialisation " + edgeClass + " --> " + edgeClass2);
        }
        if (incidenceClass.get_max() > incidenceClass2.get_max()) {
            throw new ProcessingException(this.getFilename(), "Subclass has higher upper bound (" + incidenceClass.get_max() + ") than superclass (" + incidenceClass2.get_max() + ") in specialisation " + edgeClass.get_qualifiedName() + " --> " + edgeClass2.get_qualifiedName());
        }
        AggregationKind aggregationKind = incidenceClass.get_aggregation();
        AggregationKind aggregationKind2 = incidenceClass2.get_aggregation();
        if (aggregationKind == AggregationKind.SHARED && aggregationKind2 == AggregationKind.COMPOSITE || aggregationKind == AggregationKind.NONE && aggregationKind2 != AggregationKind.NONE) {
            throw new ProcessingException(this.getFilename(), "Incompatible aggregation kinds (" + (Object)((Object)aggregationKind) + " specialises " + (Object)((Object)aggregationKind2) + ") in generalisation " + edgeClass.get_qualifiedName() + " --> " + edgeClass2.get_qualifiedName());
        }
    }

    private EdgeDirection getDirection(IncidenceClass incidenceClass) {
        assert (incidenceClass.getFirstComesFromIncidence() == null || incidenceClass.getFirstGoesToIncidence() == null);
        if (incidenceClass.getFirstComesFromIncidence() != null) {
            return EdgeDirection.OUT;
        }
        if (incidenceClass.getFirstGoesToIncidence() != null) {
            return EdgeDirection.IN;
        }
        return null;
    }

    public void writeOutput() throws XMLStreamException, GraphIOException {
        boolean bl = false;
        if (this.filenameDot != null) {
            try {
                this.printTypeAndFilename("GraphvViz DOT file", this.filenameDot);
                this.writeDotFile(this.filenameDot);
                bl = true;
            }
            catch (IOException iOException) {
                System.out.println("Could not create DOT file.");
                System.out.println("Exception was " + iOException);
            }
        }
        if (this.filenameSchemaGraph != null) {
            this.printTypeAndFilename("schemagraph", this.filenameSchemaGraph);
            this.writeSchemaGraph(this.filenameSchemaGraph);
            bl = true;
        }
        System.out.println("Validating schema graph...");
        this.validateGraph(this.filenameValidation);
        if (this.filenameValidation != null) {
            bl = true;
        }
        if (this.filenameSchema != null) {
            this.printTypeAndFilename("schema", this.filenameSchema);
            this.writeSchema(this.filenameSchema);
            bl = true;
        }
        if (!bl) {
            System.out.println("No files have been created.");
        }
    }

    private void printTypeAndFilename(String string, String string2) {
        System.out.println("Writing " + string + " to: " + string2);
    }

    private void validateGraph(String string) {
        if (string != null) {
            this.printTypeAndFilename("validation report", string);
        }
        try {
            GraphValidator graphValidator = new GraphValidator(this.sg);
            SortedSet<ConstraintViolation> sortedSet = string != null ? graphValidator.createValidationReport(string) : graphValidator.validate();
            if (!sortedSet.isEmpty()) {
                System.err.println("The schema graph is not valid:");
                for (ConstraintViolation constraintViolation : sortedSet) {
                    System.err.println(constraintViolation);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String createUnexpectedElementMessage(String string, String string2) {
        String string3 = string2 != null ? " of type " + string2 : "";
        return "Unexpected element <" + string + ">" + string3 + ".";
    }

    private Vertex handlePackage() throws XMLStreamException {
        Package package_ = this.sg.createPackage();
        package_.set_qualifiedName(this.getQualifiedName(this.getAttribute("name")));
        this.sg.createContainsSubPackage(this.packageStack.peek(), package_);
        this.packageStack.push(package_);
        return package_;
    }

    private Vertex handleClass(String string) throws XMLStreamException {
        boolean bl;
        AttributedElement attributedElement = this.idMap.get(string);
        VertexClass vertexClass = null;
        if (attributedElement != null) {
            if (!(attributedElement instanceof VertexClass)) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "The element with ID '" + string + "' is not a class. (VertexClass)");
            }
            assert (this.preliminaryVertices.contains(attributedElement));
            this.preliminaryVertices.remove(attributedElement);
            vertexClass = (VertexClass)attributedElement;
        } else {
            vertexClass = this.sg.createVertexClass();
        }
        this.currentClassId = string;
        this.currentClass = vertexClass;
        String string2 = this.getAttribute("isAbstract");
        vertexClass.set_abstract(string2 != null && string2.equals("true"));
        vertexClass.set_qualifiedName(this.getQualifiedName(this.getAttribute("name")));
        this.sg.createContainsGraphElementClass(this.packageStack.peek(), vertexClass);
        String string3 = this.getAttribute("isDerived");
        boolean bl2 = bl = string3 != null && string3.equals("true");
        if (bl) {
            this.derivedGraphElementClasses.add(vertexClass);
        }
        return vertexClass;
    }

    private Vertex handleAssociation(String string) throws XMLStreamException {
        boolean bl;
        Object object;
        AttributedElement attributedElement = this.idMap.get(string);
        de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass = null;
        if (attributedElement != null) {
            if (!(attributedElement instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "The XMI id " + string + " must denonte an EdgeClass, but is " + attributedElement.getAttributedElementClass().getQualifiedName());
            }
            assert (this.preliminaryVertices.contains(attributedElement));
            this.preliminaryVertices.remove(attributedElement);
            edgeClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)attributedElement;
        } else {
            edgeClass = this.sg.createEdgeClass();
        }
        this.currentClassId = string;
        this.currentClass = edgeClass;
        String string2 = this.getAttribute("isAbstract");
        edgeClass.set_abstract(string2 != null && string2.equals("true"));
        String string3 = this.getAttribute("name");
        String string4 = string3 = string3 == null ? "" : string3.trim();
        if (string3.length() > 0) {
            string3 = Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
        }
        edgeClass.set_qualifiedName(this.getQualifiedName(string3));
        this.sg.createContainsGraphElementClass(this.packageStack.peek(), edgeClass);
        String string5 = this.getAttribute("memberEnd");
        if (string5 == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "The association with ID '" + string + "' has no end member. (EdgeClass)");
        }
        string5 = string5.trim().replaceAll("\\s+", " ");
        int n = string5.indexOf(32);
        String string6 = string5.substring(0, n);
        String string7 = string5.substring(n + 1);
        IncidenceClass incidenceClass = (IncidenceClass)this.idMap.get(string7);
        if (incidenceClass == null) {
            object = this.sg.createVertexClass();
            this.preliminaryVertices.add((Vertex)object);
            object.set_qualifiedName("preliminary for source end " + string7);
            incidenceClass = this.sg.createIncidenceClass();
            incidenceClass.set_aggregation(AggregationKind.NONE);
            incidenceClass.set_min(1);
            incidenceClass.set_max(1);
            this.sg.createComesFrom(edgeClass, incidenceClass);
            this.sg.createEndsAt(incidenceClass, (VertexClass)object);
            this.idMap.put(string7, incidenceClass);
        }
        if ((incidenceClass = (IncidenceClass)this.idMap.get(string6)) != null) {
            assert (incidenceClass.isValid());
            assert (this.getDirection(incidenceClass) == EdgeDirection.OUT);
            object = this.sg.createIncidenceClass();
            IncidenceClass incidenceClass2 = incidenceClass;
            this.sg.createGoesTo(edgeClass, (IncidenceClass)object);
            this.sg.createEndsAt((IncidenceClass)object, (VertexClass)incidenceClass2.getFirstEndsAtIncidence().getThat());
            object.set_aggregation(incidenceClass2.get_aggregation());
            object.set_max(incidenceClass2.get_max());
            object.set_min(incidenceClass2.get_min());
            object.set_roleName(incidenceClass2.get_roleName());
            if (this.ownedEnds.contains(incidenceClass2)) {
                this.ownedEnds.remove(incidenceClass2);
                this.ownedEnds.add((IncidenceClass)object);
            }
            incidenceClass.delete();
            this.idMap.put(string6, (Vertex)object);
        } else {
            object = this.sg.createVertexClass();
            this.preliminaryVertices.add((Vertex)object);
            object.set_qualifiedName("preliminary for target end " + string6);
            incidenceClass = this.sg.createIncidenceClass();
            incidenceClass.set_aggregation(AggregationKind.NONE);
            incidenceClass.set_min(1);
            incidenceClass.set_max(1);
            this.sg.createGoesTo(edgeClass, incidenceClass);
            this.sg.createEndsAt(incidenceClass, (VertexClass)object);
            this.idMap.put(string6, incidenceClass);
        }
        object = this.getAttribute("isDerived");
        boolean bl2 = bl = object != null && ((String)object).equals("true");
        if (bl) {
            this.derivedGraphElementClasses.add(edgeClass);
        }
        return edgeClass;
    }

    private Vertex handleEnumeration() throws XMLStreamException {
        EnumDomain enumDomain = this.sg.createEnumDomain();
        Package package_ = this.packageStack.peek();
        enumDomain.set_qualifiedName(this.getQualifiedName(this.getAttribute("name")));
        this.sg.createContainsDomain(package_, enumDomain);
        PVector<String> pVector = JGraLab.vector();
        enumDomain.set_enumConstants(pVector);
        Domain domain = this.domainMap.get(enumDomain.get_qualifiedName());
        if (domain != null) {
            assert (this.preliminaryVertices.contains(domain));
            this.reconnectEdges(domain, enumDomain);
            domain.delete();
            this.preliminaryVertices.remove(domain);
        }
        this.domainMap.put(enumDomain.get_qualifiedName(), enumDomain);
        return enumDomain;
    }

    private Vertex handlePrimitiveType(String string) throws XMLStreamException {
        String string2 = this.getAttribute("name");
        if (string2 == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "No type name in primitive type. XMI ID: " + string);
        }
        if ((string2 = string2.replaceAll("\\s", "")).length() == 0) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "Type name in primitive type is empty. XMI ID: " + string);
        }
        Domain domain = this.createDomain(string2);
        assert (domain != null);
        return domain;
    }

    private void handleRealization() throws XMLStreamException {
        String string = this.getAttribute("supplier");
        String string2 = this.getAttribute("client");
        Set<String> set = this.realizations.get(string2);
        if (set == null) {
            set = new TreeSet<String>();
            this.realizations.put(string2, set);
        }
        set.add(string);
    }

    private String attributedElement2String(AttributedElement<?, ?> attributedElement) {
        StringBuilder stringBuilder = new StringBuilder();
        Object obj = attributedElement.getAttributedElementClass();
        stringBuilder.append(attributedElement);
        stringBuilder.append(" { ");
        for (Attribute attribute : obj.getAttributeList()) {
            stringBuilder.append(attribute.getName());
            stringBuilder.append(" = ");
            stringBuilder.append(attributedElement.getAttribute(attribute.getName()));
            stringBuilder.append("; ");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    private void handleEnumerationLiteral() throws XMLStreamException {
        String string = this.getAttribute("name");
        if (string == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "No Literal declared.");
        }
        if ((string = string.trim()).length() <= 0) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "Literal is empty.");
        }
        String string2 = this.getAttribute("classifier");
        if (string2 == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "No Enumeration found for Literal '" + string + "'.");
        }
        EnumDomain enumDomain = (EnumDomain)this.idMap.get(string2);
        if (!string.equals(string.toUpperCase())) {
            System.out.println("Warning: Enumeration literal '" + string + "' in enumeration + '" + enumDomain.get_qualifiedName() + "' should be all uppercase letters.");
        }
        enumDomain.set_enumConstants(enumDomain.get_enumConstants().plus(string));
    }

    private void writeSchema(String string) {
        try {
            SchemaGraph2Tg schemaGraph2Tg = new SchemaGraph2Tg(this.sg, string);
            schemaGraph2Tg.process();
        }
        catch (IOException iOException) {
            throw new RuntimeException("SchemaGraph2Tg failed with an IOException!", iOException);
        }
    }

    private void correctEdgeDirection() {
        if (!this.isUseNavigability()) {
            return;
        }
        System.out.println("Correcting edge directions according to navigability...");
        for (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass : this.sg.getEdgeClassVertices()) {
            boolean bl;
            ComesFrom comesFrom = edgeClass.getFirstComesFromIncidence();
            if (comesFrom == null) {
                throw new ProcessingException(this.getFilename(), "EdgeClass " + edgeClass.get_qualifiedName() + " has no ComesFrom incidence");
            }
            GoesTo goesTo = edgeClass.getFirstGoesToIncidence();
            if (goesTo == null) {
                throw new ProcessingException(this.getFilename(), "EdgeClass " + edgeClass.get_qualifiedName() + " has no GoesTo incidence");
            }
            IncidenceClass incidenceClass = (IncidenceClass)comesFrom.getThat();
            IncidenceClass incidenceClass2 = (IncidenceClass)goesTo.getThat();
            boolean bl2 = !this.ownedEnds.contains(incidenceClass);
            if (bl2 == (bl = !this.ownedEnds.contains(incidenceClass2)) || bl) continue;
            assert (this.getDirection(incidenceClass2) == EdgeDirection.IN);
            assert (this.getDirection(incidenceClass) == EdgeDirection.OUT);
            IncidenceClass incidenceClass3 = (IncidenceClass)comesFrom.getThat();
            comesFrom.setThat(goesTo.getThat());
            goesTo.setThat(incidenceClass3);
        }
    }

    private void attachConstraints() throws XMLStreamException {
        System.out.println("Attaching constraints...");
        for (String string : this.constraints.keySet()) {
            List<String> list = this.constraints.get(string);
            if (list.size() == 0) continue;
            Vertex vertex = this.idMap.get(string);
            if (vertex == null) {
                vertex = this.graphClass;
            }
            if (!vertex.isValid()) continue;
            if (!(vertex instanceof AttributedElementClass) && !(vertex instanceof IncidenceClass)) {
                throw new ProcessingException(this.getFilename(), "Constraint can only be attached to GraphClass, VertexClass, EdgeClass or association ends. Offending element is " + vertex + " (XMI id " + string + ")");
            }
            if (vertex instanceof AttributedElementClass) {
                if (!((AttributedElementClass)vertex).isValid()) continue;
                for (String string2 : list) {
                    this.addGreqlConstraint((AttributedElementClass)vertex, string2);
                }
                continue;
            }
            throw new ProcessingException(this.getFilename(), "Don't know what to do with constraint(s) at element " + vertex + " (XMI id " + string + ")");
        }
    }

    private void createEdgeClassNames() {
        System.out.println("Creating missing edge class names...");
        for (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass : this.sg.getEdgeClassVertices()) {
            String string = edgeClass.get_qualifiedName().trim();
            String string2 = null;
            Matcher matcher = GENNAME_PATTERN.matcher(string);
            if (matcher.matches()) {
                string = matcher.group(1);
                string2 = matcher.group(matcher.groupCount());
            }
            if (!string.equals("") && !string.endsWith(".")) continue;
            IncidenceClass incidenceClass = (IncidenceClass)edgeClass.getFirstGoesToIncidence().getThat();
            IncidenceClass incidenceClass2 = (IncidenceClass)edgeClass.getFirstComesFromIncidence().getThat();
            String string3 = incidenceClass.get_roleName();
            if (string3 == null || string3.equals("")) {
                string3 = ((VertexClass)incidenceClass.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                int n = string3.lastIndexOf(46);
                if (n >= 0) {
                    string3 = string3.substring(n + 1);
                }
            } else {
                string3 = Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
            }
            if (string3 == null || string3.length() <= 0) {
                throw new ProcessingException(this.getFilename(), "There is no role name 'to' for the edge '" + string + "' defined.");
            }
            string2 = string2 == null ? (incidenceClass2.get_aggregation() != AggregationKind.NONE || incidenceClass.get_aggregation() != AggregationKind.NONE ? (incidenceClass.get_aggregation() != AggregationKind.NONE ? "Contains" + string3 : "IsPartOf" + string3) : "LinksTo" + string3) : string2 + string3;
            if (this.isUseFromRole()) {
                String string4 = incidenceClass2.get_roleName();
                if (string4 == null || string4.equals("")) {
                    string4 = ((VertexClass)incidenceClass2.getFirstEndsAtIncidence().getThat()).get_qualifiedName();
                    int n = string4.lastIndexOf(46);
                    if (n >= 0) {
                        string4 = string4.substring(n + 1);
                    }
                } else {
                    string4 = Character.toUpperCase(string4.charAt(0)) + string4.substring(1);
                }
                if (string4 == null || string4.length() <= 0) {
                    throw new ProcessingException(this.getFilename(), "There is no role name of 'from' for the edge '" + string + "' defined.");
                }
                string = string + string4;
            }
            assert (string2 != null && string2.length() > 0);
            edgeClass.set_qualifiedName(string + string2);
        }
    }

    private void removeUnusedDomains() {
        System.out.println("Removing unused domains...");
        Domain domain = this.sg.getFirstDomain();
        while (domain != null) {
            Domain domain2 = domain.getNextDomain();
            if (domain.getDegree(EdgeDirection.IN) - domain.getDegree(Annotates.EC, EdgeDirection.IN) <= 1) {
                List<? extends Comment> list = domain.remove_comments();
                for (Comment comment : list) {
                    comment.delete();
                }
                domain.delete();
                domain = this.sg.getFirstDomain();
                continue;
            }
            domain = domain2;
        }
    }

    private void linkRecordDomainComponents() {
        for (HasRecordDomainComponent hasRecordDomainComponent : this.sg.getHasRecordDomainComponentEdges()) {
            String string = (String)this.recordComponentType.getMark(hasRecordDomainComponent);
            if (string == null) {
                this.recordComponentType.removeMark(hasRecordDomainComponent);
                continue;
            }
            Domain domain = (Domain)this.idMap.get(string);
            if (domain != null) {
                Domain domain2 = hasRecordDomainComponent.getOmega();
                assert (domain2 instanceof StringDomain && domain2.get_qualifiedName().equals(string) && this.preliminaryVertices.contains(domain2));
                hasRecordDomainComponent.setOmega(domain);
                domain2.delete();
                this.preliminaryVertices.remove(domain2);
                this.recordComponentType.removeMark(hasRecordDomainComponent);
                continue;
            }
            throw new ProcessingException(this.getFilename(), "Undefined Domain with ID '" + string + "' found.");
        }
        if (!this.recordComponentType.isEmpty()) {
            throw new ProcessingException(this.getFilename(), "Some RecordDomains have unresolved component types.");
        }
    }

    private void linkAttributeDomains() {
        for (de.uni_koblenz.jgralab.grumlschema.structure.Attribute attribute : this.sg.getAttributeVertices()) {
            String string = (String)this.attributeType.getMark(attribute);
            if (string == null) {
                assert (attribute.getDegree(HasDomain.EC, EdgeDirection.OUT) == 1) : "Attribute '" + attribute.get_name() + "' of " + attribute.getFirstHasAttributeIncidence().getThat().getSchemaClass().getSimpleName() + " '" + ((AttributedElementClass)attribute.getFirstHasAttributeIncidence().getThat()).get_qualifiedName() + "' has " + attribute.getDegree(HasDomain.EC, EdgeDirection.OUT) + " domain(s)";
                continue;
            }
            Domain domain = (Domain)this.idMap.get(string);
            if (domain == null) {
                throw new ProcessingException(this.getFilename(), "Undefined Domain with ID '" + string + "' found.");
            }
            this.sg.createHasDomain(attribute, domain);
            this.attributeType.removeMark(attribute);
            assert (attribute.getDegree(HasDomain.EC, EdgeDirection.OUT) == 1);
        }
        if (!this.attributeType.isEmpty()) {
            throw new ProcessingException(this.getFilename(), "There are some Attribute objects, whos domains are not resolved.");
        }
    }

    private void writeDotFile(String string) throws IOException {
        Tg2Dot tg2Dot = new Tg2Dot();
        tg2Dot.setGraph(this.sg);
        tg2Dot.setPrintEdgeAttributes(true);
        tg2Dot.setOutputFile(string);
        tg2Dot.convert();
    }

    private void writeSchemaGraph(String string) throws GraphIOException {
        this.sg.save(string);
    }

    private void linkGeneralizations() {
        Set set;
        Object object;
        Object object2;
        for (String object3 : this.realizations.keySet()) {
            object2 = this.realizations.get(object3);
            object = (AttributedElementClass)this.idMap.get(object3);
            if (object2.size() <= 0) continue;
            set = (Set)this.generalizations.getMark(object);
            if (set == null) {
                set = new TreeSet();
                this.generalizations.mark(object, set);
            }
            set.addAll(object2);
        }
        for (AttributedElement attributedElement : this.generalizations.getMarkedElements()) {
            object2 = (AttributedElementClass)attributedElement;
            object = (Set)this.generalizations.getMark(object2);
            set = object.iterator();
            while (set.hasNext()) {
                String string = (String)set.next();
                AttributedElementClass attributedElementClass = (AttributedElementClass)this.idMap.get(string);
                if (attributedElementClass == null) {
                    throw new ProcessingException(this.getFilename(), "The superclass with XMI id '" + string + "' could not be found.");
                }
                if (attributedElementClass instanceof VertexClass) {
                    if (!(object2 instanceof VertexClass)) {
                        throw new ProcessingException(this.getFilename(), "Different types in generalization: " + object2.getSchemaClass().getSimpleName() + " '" + object2.get_qualifiedName() + "' can not be subclass of " + object2.getSchemaClass().getSimpleName() + " '" + attributedElementClass.get_qualifiedName() + "'");
                    }
                    this.sg.createSpecializesVertexClass((VertexClass)attributedElement, (VertexClass)attributedElementClass);
                    if (this.vertexClassHierarchyIsAcyclic()) continue;
                    throw new ProcessingException(this.getFilename(), "Cycle in vertex class hierarchy. Involved classes are '" + object2.get_qualifiedName() + "' and '" + attributedElementClass.get_qualifiedName() + "'");
                }
                if (attributedElementClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) {
                    if (!(object2 instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)) {
                        throw new ProcessingException(this.getFilename(), "Different types in generalization: " + object2.getSchemaClass().getSimpleName() + " '" + object2.get_qualifiedName() + "' can not be subclass of " + object2.getSchemaClass().getSimpleName() + " '" + attributedElementClass.get_qualifiedName() + "'");
                    }
                    this.sg.createSpecializesEdgeClass((de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)attributedElement, (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)attributedElementClass);
                    if (this.edgeClassHierarchyIsAcyclic()) continue;
                    throw new ProcessingException(this.getFilename(), "Cycle in edge class hierarchy. Involved classes are '" + object2.get_qualifiedName() + "' and '" + attributedElementClass.get_qualifiedName() + "'");
                }
                throw new RuntimeException("FIXME: Unexpected super class type. Super class must be VertexClass or EdgeClass!");
            }
        }
        this.generalizations.clear();
    }

    private boolean edgeClassHierarchyIsAcyclic() {
        if (this.edgeClassAcyclicQuery == null) {
            this.edgeClassAcyclicQuery = GreqlQuery.createQuery("on edgeTypeSubgraph{structure.SpecializesEdgeClass}(): isAcyclic()");
        }
        return (Boolean)this.edgeClassAcyclicQuery.evaluate(this.sg);
    }

    private boolean vertexClassHierarchyIsAcyclic() {
        if (this.vertexClassAcyclicQuery == null) {
            this.vertexClassAcyclicQuery = GreqlQuery.createQuery("on edgeTypeSubgraph{structure.SpecializesVertexClass}(): isAcyclic()");
        }
        return (Boolean)this.vertexClassAcyclicQuery.evaluate(this.sg);
    }

    private void removeEmptyPackages() {
        System.out.println("Removing empty packages...");
        Package package_ = this.sg.getFirstPackage();
        int n = 0;
        while (package_ != null) {
            Package package_2 = package_.getNextPackage();
            int n2 = package_.getDegree(Annotates.EC);
            if (package_.getDegree() - n2 == 1 && package_.get_qualifiedName().length() > 0) {
                System.out.println("\t- empty package '" + package_.get_qualifiedName() + "' removed" + (n2 > 0 ? (n2 == 1 ? " including 1 comment" : " including " + n2 + " comments") : ""));
                if (n2 > 0) {
                    Annotates annotates = package_.getFirstAnnotatesIncidence();
                    while (annotates != null) {
                        annotates.getThat().delete();
                        annotates = package_.getFirstAnnotatesIncidence();
                    }
                }
                package_.delete();
                ++n;
                package_ = this.sg.getFirstPackage();
                continue;
            }
            package_ = package_2;
        }
        System.out.println("\tRemoved " + n + " package" + (n == 1 ? "" : OPTION_FILENAME_SCHEMA_GRAPH) + ".");
    }

    private void handleConstraint(String string) throws XMLStreamException {
        if (string.startsWith("\"")) {
            List<String> list = this.constraints.get(this.constrainedElementId);
            if (list == null) {
                list = new LinkedList<String>();
                this.constraints.put(this.constrainedElementId, list);
            }
            list.add(string);
        } else if (string.startsWith("subsets")) {
            System.err.println("warning: {subsets ...} constraint at element " + this.constrainedElementId + " ignored (don't forget to model generalizations between associations)");
        } else if (string.startsWith("union")) {
            System.err.println("warning: {union} constraint at element " + this.constrainedElementId + " ignored (don't forget to add an <<abstract>> stereotype to the association)");
        } else if (string.startsWith("ordered")) {
            System.err.println("warning: {ordered} constraint at element " + this.constrainedElementId + " ignored (TGraphs are ordered by default)");
        } else {
            throw new ProcessingException(this.getFilename(), this.getParser().getLocation().getLineNumber(), "Illegal constraint format: " + string);
        }
    }

    private void addGreqlConstraint(AttributedElementClass attributedElementClass, String string) throws XMLStreamException {
        assert (attributedElementClass != null);
        Constraint constraint = this.sg.createConstraint();
        this.sg.createHasConstraint(attributedElementClass, constraint);
        int n = 0;
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (bl) {
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (!bl2 && c == '\"') {
                    ++n;
                    String string2 = string.substring(n2 + 1, i).trim().replaceAll("\\\\(.)", "$1");
                    if (string2.isEmpty()) {
                        string2 = null;
                    }
                    switch (n) {
                        case 1: {
                            constraint.set_message(string2);
                            break;
                        }
                        case 2: {
                            constraint.set_predicateQuery(string2);
                            break;
                        }
                        case 3: {
                            constraint.set_offendingElementsQuery(string2);
                            break;
                        }
                        default: {
                            throw new ProcessingException(this.getFilename(), "Illegal constraint format. The constraint text was '" + string + "'.");
                        }
                    }
                    bl = false;
                    continue;
                }
                if (!bl2 || c != '\"') continue;
                bl2 = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == '\"') {
                bl = true;
                n2 = i;
                continue;
            }
            throw new ProcessingException(this.getFilename(), "Illegal constraint format. The constraint text was '" + string + "'.  Expected '\"' but got '" + c + "'.  (position = " + i + ").");
        }
        if (bl || bl2 || n < 2 || n > 3) {
            throw new ProcessingException(this.getFilename(), "Illegal constraint format.  The constraint text was '" + string + "'.");
        }
    }

    private void handleUpperValue() throws XMLStreamException {
        assert (this.currentAssociationEnd != null || this.inOwnedAttribute);
        int n = this.getValue();
        if (this.currentAssociationEnd == null && this.inOwnedAttribute) {
            if (n != 1) {
                throw new ProcessingException(this.getFilename(), "grUML does not support attribute multiplicities other than 1..1");
            }
        } else {
            assert (this.currentAssociationEnd != null);
            assert (n >= 1);
            this.currentAssociationEnd.set_max(n);
        }
    }

    private int getValue() throws XMLStreamException {
        String string = this.getAttribute("value");
        return string == null ? 0 : (string.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(string));
    }

    private void handleLowerValue() throws XMLStreamException {
        assert (this.currentAssociationEnd != null || this.inOwnedAttribute);
        int n = this.getValue();
        if (this.currentAssociationEnd == null && this.inOwnedAttribute) {
            if (n != 1) {
                throw new ProcessingException(this.getFilename(), "grUML does not support attribute multiplicities other than 1..1");
            }
        } else {
            assert (this.currentAssociationEnd != null);
            assert (n >= 0);
            this.currentAssociationEnd.set_min(n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleStereotype() throws XMLStreamException {
        String string = this.getAttribute("key");
        if (this.currentClass == null && this.currentClassId == null && this.currentAssociationEnd == null && this.currentAttribute == null && this.currentRecordDomain == null && this.currentRecordDomainComponent == null) {
            if (!string.equals("rsa2tg_ignore")) throw new ProcessingException(this.getParser(), this.getFilename(), "Unexpected stereotype <<" + string + ">>");
            this.ignoredPackages.add(this.packageStack.peek());
            return;
        }
        if (this.currentClass == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "Unexpected stereotype <<" + string + ">>");
        }
        if (string.equals("graphclass")) {
            if (!(this.currentClass instanceof VertexClass)) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "The stereotype '<<graphclass>>' is only valid for a UML class.");
            }
            AttributedElementClass attributedElementClass = (AttributedElementClass)this.idMap.get(this.currentClassId);
            assert (this.graphClass != null);
            this.graphClass.set_qualifiedName(attributedElementClass.get_qualifiedName());
            Edge edge = attributedElementClass.getFirstIncidence();
            while (edge != null) {
                Edge edge2 = edge.getNextIncidence();
                if (edge instanceof ContainsGraphElementClass) {
                    edge.delete();
                } else {
                    edge.setThis(this.graphClass);
                }
                edge = edge2;
            }
            attributedElementClass.delete();
            this.idMap.put(this.currentClassId, this.graphClass);
            this.currentClass = this.graphClass;
            return;
        } else if (string.equals("record")) {
            if (!(this.currentClass instanceof VertexClass)) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "The stereotype '<<record>>' is only allow for UML-classes.");
            }
            RecordDomain recordDomain = this.sg.createRecordDomain();
            recordDomain.set_qualifiedName(this.currentClass.get_qualifiedName());
            Edge edge = this.currentClass.getFirstIncidence();
            while (edge != null) {
                Edge edge3 = edge.getNextIncidence();
                if (edge instanceof ContainsGraphElementClass) {
                    this.sg.createContainsDomain((Package)edge.getThat(), recordDomain);
                    edge.delete();
                } else if (edge instanceof HasAttribute) {
                    GraphElement<EdgeClass, Edge> graphElement;
                    Object object;
                    de.uni_koblenz.jgralab.grumlschema.structure.Attribute attribute = (de.uni_koblenz.jgralab.grumlschema.structure.Attribute)edge.getThat();
                    HasDomain hasDomain = attribute.getFirstHasDomainIncidence();
                    if (hasDomain != null) {
                        object = (Domain)edge.getThat();
                        graphElement = this.sg.createHasRecordDomainComponent(recordDomain, (Domain)object);
                        graphElement.set_name(attribute.get_name());
                    } else {
                        object = (String)this.attributeType.getMark(attribute);
                        if (object == null) {
                            throw new ProcessingException(this.getParser(), this.getFilename(), "No type id has been defined.");
                        }
                        graphElement = this.sg.createStringDomain();
                        graphElement.set_qualifiedName((String)object);
                        this.preliminaryVertices.add((Vertex)graphElement);
                        HasRecordDomainComponent hasRecordDomainComponent = this.sg.createHasRecordDomainComponent(recordDomain, (Domain)graphElement);
                        this.recordComponentType.mark(hasRecordDomainComponent, (String)object);
                        this.attributeType.removeMark(attribute);
                    }
                    attribute.delete();
                }
                edge = edge3;
            }
            if (this.currentClass.getDegree() != 0) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "The <<record>> class '" + this.currentClass.get_qualifiedName() + "' must not have any association.");
            }
            this.domainMap.put(recordDomain.get_qualifiedName(), recordDomain);
            this.idMap.put(this.currentClassId, recordDomain);
            this.currentRecordDomain = recordDomain;
            this.currentClass.delete();
            this.currentClass = null;
            this.currentClassId = null;
            return;
        } else {
            if (!string.equals("abstract")) throw new ProcessingException(this.getParser(), this.getFilename(), "Unexpected stereotype '<<" + string + ">>'.");
            if (!(this.currentClass instanceof GraphElementClass)) throw new ProcessingException(this.getParser(), this.getFilename(), "The stereotype <<abstract>> can only be specified for vertex and edge classes, but not for class '" + this.currentClass.get_qualifiedName() + "'");
            GraphElementClass graphElementClass = (GraphElementClass)this.currentClass;
            graphElementClass.set_abstract(true);
        }
    }

    private void handleGeneralization() throws XMLStreamException {
        String string = this.getAttribute("general");
        TreeSet<String> treeSet = (TreeSet<String>)this.generalizations.getMark(this.currentClass);
        if (treeSet == null) {
            treeSet = new TreeSet<String>();
            this.generalizations.mark(this.currentClass, treeSet);
        }
        treeSet.add(string);
    }

    private void handleNestedTypeElement(String string) throws XMLStreamException {
        if (this.currentAttribute == null && this.currentRecordDomain == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "unexpected primitive type in element (XMI id " + string + ")");
        }
        String string2 = this.getAttribute("href");
        if (string2 == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "No type name specified in primitive type href of attribute (XMI id " + string + ")");
        }
        Domain domain = null;
        if (string2.endsWith("#String")) {
            domain = this.createDomain("String");
        } else if (string2.endsWith("#Integer")) {
            domain = this.createDomain("Integer");
        } else if (string2.endsWith("#Boolean")) {
            domain = this.createDomain("Boolean");
        } else if (string2.endsWith("#double")) {
            domain = this.createDomain("Double");
        } else {
            throw new ProcessingException(this.getParser(), this.getFilename(), "Unknown primitive type with href '" + string2 + "' in attribute (XMI id " + string + ")");
        }
        assert (domain != null);
        if (this.currentRecordDomain != null) {
            assert (this.currentRecordDomainComponent != null);
            Domain domain2 = this.currentRecordDomainComponent.getOmega();
            assert (domain2 instanceof StringDomain && domain2.get_qualifiedName() == null && this.preliminaryVertices.contains(domain2));
            this.currentRecordDomainComponent.setOmega(domain);
            domain2.delete();
            this.preliminaryVertices.remove(domain2);
            this.recordComponentType.removeMark(this.currentRecordDomainComponent);
        } else {
            assert (this.currentAttribute != null);
            this.sg.createHasDomain(this.currentAttribute, domain);
            this.attributeType.removeMark(this.currentAttribute);
        }
    }

    private void handleOwnedAttribute(String string) throws XMLStreamException {
        String string2 = this.getAttribute("association");
        if (string2 == null) {
            boolean bl;
            String string3 = this.getAttribute("name");
            if (this.currentClass == null && this.currentRecordDomain == null) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "Found an attribute '" + string3 + "' (XMI id " + string + ") outside a class!");
            }
            if (string3 == null) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "No attribute name in ownedAttribute (XMI id " + string + ")");
            }
            if ((string3 = string3.trim()).length() == 0) {
                throw new ProcessingException(this.getParser(), this.getFilename(), "Empty attribute name in ownedAttribute (XMI id " + string + ")");
            }
            String string4 = this.getAttribute("isDerived");
            boolean bl2 = bl = string4 != null && string4.equals("true");
            if (bl) {
                return;
            }
            String string5 = this.getAttribute("type");
            if (this.currentClass != null) {
                de.uni_koblenz.jgralab.grumlschema.structure.Attribute attribute;
                this.currentAttribute = attribute = this.sg.createAttribute();
                attribute.set_name(string3);
                this.sg.createHasAttribute(this.currentClass, attribute);
                if (string5 != null) {
                    this.attributeType.mark(attribute, string5);
                }
            } else {
                assert (this.currentRecordDomain != null);
                this.currentAttribute = null;
                this.currentRecordDomainComponent = null;
                if (string5 != null) {
                    Vertex vertex = this.idMap.get(string5);
                    if (vertex != null) {
                        assert (vertex instanceof Domain) : "typeID says " + string5 + " which is no Domain!";
                        this.currentRecordDomainComponent = this.sg.createHasRecordDomainComponent(this.currentRecordDomain, (Domain)vertex);
                    } else {
                        StringDomain stringDomain = this.sg.createStringDomain();
                        stringDomain.set_qualifiedName(string5);
                        this.preliminaryVertices.add(stringDomain);
                        this.currentRecordDomainComponent = this.sg.createHasRecordDomainComponent(this.currentRecordDomain, stringDomain);
                        this.recordComponentType.mark(this.currentRecordDomainComponent, string5);
                    }
                } else {
                    StringDomain stringDomain = this.sg.createStringDomain();
                    this.preliminaryVertices.add(stringDomain);
                    this.currentRecordDomainComponent = this.sg.createHasRecordDomainComponent(this.currentRecordDomain, stringDomain);
                }
                this.currentRecordDomainComponent.set_name(string3);
            }
        } else {
            this.handleAssociationEnd(string);
        }
    }

    private void handleAssociationEnd(String string) throws XMLStreamException {
        String string2 = this.getAttribute("name");
        if (this.currentClass == null || this.currentRecordDomain != null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "Found an association end '" + string2 + "' (XMI id " + string + ") outside a class or in a record domain");
        }
        String string3 = this.getAttribute("aggregation");
        boolean bl = string3 != null && string3.equals("shared");
        boolean bl2 = string3 != null && string3.equals("composite");
        String string4 = this.getAttribute("type");
        if (string4 == null) {
            throw new ProcessingException(this.getParser(), this.getFilename(), "No type attribute in association end (XMI id" + string + ")");
        }
        IncidenceClass incidenceClass = (IncidenceClass)this.idMap.get(string);
        if (incidenceClass == null) {
            VertexClass vertexClass = null;
            AttributedElement attributedElement = this.idMap.get(string4);
            if (attributedElement != null) {
                if (!(attributedElement instanceof VertexClass)) {
                    throw new ProcessingException(this.getParser(), this.getFilename(), "Type attribute of association end (XMI id " + string + ") must denote a VertexClass, but is " + attributedElement.getAttributedElementClass().getQualifiedName());
                }
                vertexClass = (VertexClass)attributedElement;
            } else {
                vertexClass = this.sg.createVertexClass();
                vertexClass.set_qualifiedName(string4);
                this.preliminaryVertices.add(vertexClass);
                this.idMap.put(string4, vertexClass);
            }
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass = null;
            if (this.currentClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) {
                edgeClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)this.currentClass;
                this.idMap.put(this.currentClassId, this.currentClass);
            } else {
                String string5 = this.getAttribute("association");
                if (string5 == null) {
                    throw new ProcessingException(this.getParser(), this.getFilename(), "No assiocation attribute in association end (XMI id " + string + ")");
                }
                attributedElement = this.idMap.get(string5);
                if (attributedElement != null) {
                    if (!(attributedElement instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)) {
                        throw new ProcessingException(this.getParser(), this.getFilename(), "Assiocation attribute of association end (XMI id " + string + ") must denote an EdgeClass, but is " + attributedElement.getAttributedElementClass().getQualifiedName());
                    }
                    edgeClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)attributedElement;
                } else {
                    edgeClass = this.sg.createEdgeClass();
                }
                this.preliminaryVertices.add(edgeClass);
                this.idMap.put(string5, edgeClass);
            }
            assert (vertexClass != null && edgeClass != null);
            incidenceClass = this.sg.createIncidenceClass();
            incidenceClass.set_min(1);
            incidenceClass.set_max(1);
            this.sg.createComesFrom(edgeClass, incidenceClass);
            this.sg.createEndsAt(incidenceClass, vertexClass);
        } else {
            de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass edgeClass = (de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass)(incidenceClass.getFirstComesFromIncidence() != null ? incidenceClass.getFirstComesFromIncidence() : incidenceClass.getFirstGoesToIncidence()).getThat();
            String string6 = null;
            for (Map.Entry<String, Vertex> object : this.idMap.entrySet()) {
                if (object.getValue() != edgeClass) continue;
                string6 = object.getKey();
                break;
            }
            assert (string6 != null);
            this.idMap.put(string6, edgeClass);
            VertexClass vertexClass = (VertexClass)incidenceClass.getFirstEndsAtIncidence().getThat();
            if (this.preliminaryVertices.contains(vertexClass)) {
                AttributedElement attributedElement = this.idMap.get(string4);
                if (attributedElement != null && !vertexClass.equals(attributedElement)) {
                    if (!(attributedElement instanceof VertexClass)) {
                        throw new ProcessingException(this.getParser(), this.getFilename(), "Type attribute of association end (XMI id " + string + ") must denote a VertexClass, but is " + attributedElement.getAttributedElementClass().getQualifiedName());
                    }
                    incidenceClass.getFirstEndsAtIncidence().setOmega((VertexClass)attributedElement);
                    Set set = (Set)this.generalizations.getMark(vertexClass);
                    if (set != null) {
                        this.generalizations.removeMark(vertexClass);
                        this.generalizations.mark(attributedElement, set);
                    }
                    vertexClass.delete();
                    this.preliminaryVertices.remove(vertexClass);
                } else if (attributedElement == null) {
                    this.idMap.put(string4, vertexClass);
                } else {
                    throw new RuntimeException("FIXME: Unexpected type. You should not get here!");
                }
            }
        }
        assert (incidenceClass != null);
        this.currentAssociationEnd = incidenceClass;
        if (this.currentClass instanceof de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass) {
            this.ownedEnds.add(incidenceClass);
        }
        incidenceClass.set_aggregation(bl ? AggregationKind.SHARED : (bl2 ? AggregationKind.COMPOSITE : AggregationKind.NONE));
        this.idMap.put(string, incidenceClass);
        incidenceClass.set_roleName(string2);
    }

    private void reconnectEdges(Vertex vertex, Vertex vertex2) {
        Edge edge = vertex.getFirstIncidence();
        while (edge != null) {
            Edge edge2 = edge.getNextIncidence();
            edge.setThis(vertex2);
            edge = edge2;
        }
    }

    private Domain createDomain(String string) {
        Domain domain = this.domainMap.get(string);
        if (domain != null) {
            return domain;
        }
        if (string.equals("String")) {
            domain = this.sg.createStringDomain();
        } else if (string.equals("Integer")) {
            domain = this.sg.createIntegerDomain();
        } else if (string.equals("Double")) {
            domain = this.sg.createDoubleDomain();
        } else if (string.equals("Long")) {
            domain = this.sg.createLongDomain();
        } else if (string.equals("Boolean")) {
            domain = this.sg.createBooleanDomain();
        } else if (string.startsWith("Map<") && string.endsWith(">")) {
            domain = this.sg.createMapDomain();
            String string2 = string.substring(4, string.length() - 1);
            char[] cArray = string2.toCharArray();
            int n = 0;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == ',' && n == 0) {
                    n = i;
                    break;
                }
                if (cArray[i] == '<') {
                    ++n;
                } else if (cArray[i] == '>') {
                    --n;
                }
                if (n >= 0) continue;
                throw new ProcessingException(this.getFilename(), "Error in primitive type name: '" + string + "'");
            }
            if (n <= 0 || n >= cArray.length - 1) {
                throw new ProcessingException(this.getFilename(), "Error in primitive type name: '" + string + "'");
            }
            String string3 = string2.substring(0, n);
            Domain domain2 = this.createDomain(string3);
            assert (domain2 != null);
            String string4 = string2.substring(n + 1);
            Domain domain3 = this.createDomain(string4);
            assert (domain3 != null);
            this.sg.createHasKeyDomain((MapDomain)domain, domain2);
            this.sg.createHasValueDomain((MapDomain)domain, domain3);
            string = "Map<" + string3 + ", " + string4 + '>';
        } else if (string.startsWith("List<") && string.endsWith(">")) {
            domain = this.sg.createListDomain();
            String string5 = string.substring(5, string.length() - 1);
            Domain domain4 = this.createDomain(string5);
            assert (domain4 != null);
            this.sg.createHasBaseDomain((CollectionDomain)domain, domain4);
        } else if (string.startsWith("Set<") && string.endsWith(">")) {
            domain = this.sg.createSetDomain();
            String string6 = string.substring(4, string.length() - 1);
            Domain domain5 = this.createDomain(string6);
            assert (domain5 != null);
            this.sg.createHasBaseDomain((CollectionDomain)domain, domain5);
        }
        if (domain != null) {
            this.sg.createContainsDomain((Package)this.packageStack.get(0), domain);
        } else {
            domain = this.sg.createStringDomain();
            this.preliminaryVertices.add(domain);
        }
        assert (domain != null);
        domain.set_qualifiedName(string);
        this.domainMap.put(string, domain);
        return domain;
    }

    private String getQualifiedName(String string) {
        assert (string != null);
        string = string.trim();
        Package package_ = this.packageStack.peek();
        assert (package_ != null);
        if (package_.get_qualifiedName().equals("")) {
            return string;
        }
        return package_.get_qualifiedName() + "." + string;
    }

    public void setUseFromRole(boolean bl) {
        this.useFromRole = bl;
    }

    public boolean isUseFromRole() {
        return this.useFromRole;
    }

    public void setRemoveUnusedDomains(boolean bl) {
        this.removeUnusedDomains = bl;
    }

    public boolean isRemoveUnusedDomains() {
        return this.removeUnusedDomains;
    }

    public void setUseNavigability(boolean bl) {
        this.useNavigability = bl;
    }

    public boolean isUseNavigability() {
        return this.useNavigability;
    }

    public SchemaGraph getSchemaGraph() {
        return this.sg;
    }

    public void setSuppressOutput(boolean bl) {
        this.suppressOutput = bl;
    }

    public String getFilenameSchema() {
        return this.filenameSchema;
    }

    public void setFilenameSchema(String string) {
        this.filenameSchema = string;
    }

    public String getFilenameSchemaGraph() {
        return this.filenameSchemaGraph;
    }

    public void setFilenameSchemaGraph(String string) {
        this.filenameSchemaGraph = string;
    }

    public String getFilenameDot() {
        return this.filenameDot;
    }

    public void setFilenameDot(String string) {
        this.filenameDot = string;
    }

    public String getFilenameValidation() {
        return this.filenameValidation;
    }

    public void setFilenameValidation(String string) {
        this.filenameValidation = string;
    }

    public boolean isKeepEmptyPackages() {
        return this.keepEmptyPackages;
    }

    public void setKeepEmptyPackages(boolean bl) {
        this.keepEmptyPackages = bl;
    }
}

