/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.schemacompare;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.WorkInProgress;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.NamedElement;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

@WorkInProgress(responsibleDevelopers="horn")
public class SchemaCompare {
    private Schema s;
    private Schema t;
    private int diffCount = 0;
    private boolean reverseRun = false;
    Set<Object> marked = new HashSet<Object>();

    public SchemaCompare(Schema schema, Schema schema2) {
        this.s = schema;
        this.t = schema2;
    }

    public int compareSchemas() {
        System.out.println("Comparing Schemas:\nForward run...\n");
        this.compareGraphClass(this.s.getGraphClass(), this.t.getGraphClass());
        for (RecordDomain domain : this.s.getRecordDomains()) {
            this.compareRecordDomain(domain, this.t.getDomain(domain.getQualifiedName()));
        }
        for (EnumDomain enumDomain : this.s.getEnumDomains()) {
            this.compareEnumDomain(enumDomain, this.t.getDomain(enumDomain.getQualifiedName()));
        }
        System.out.println("\nReverse run...\n");
        this.reverseRun = true;
        this.compareGraphClass(this.t.getGraphClass(), this.s.getGraphClass());
        for (RecordDomain recordDomain : this.t.getRecordDomains()) {
            this.compareRecordDomain(recordDomain, this.s.getDomain(recordDomain.getQualifiedName()));
        }
        for (EnumDomain enumDomain : this.t.getEnumDomains()) {
            this.compareEnumDomain(enumDomain, this.s.getDomain(enumDomain.getQualifiedName()));
        }
        if (this.diffCount > 0) {
            System.out.println("\nFound " + this.diffCount + " differences!");
        } else {
            System.out.println("Schemas are equivalent.");
        }
        return this.diffCount;
    }

    private boolean areMarked(Object object, Object object2) {
        return this.marked.contains(object) && this.marked.contains(object2);
    }

    private void compareRecordDomain(RecordDomain recordDomain, Domain domain) {
        if (domain == null) {
            this.reportDiff("RecordDomain " + recordDomain.getQualifiedName(), "null");
            return;
        }
        if (this.areMarked(recordDomain, domain)) {
            return;
        }
        if (!(domain instanceof RecordDomain)) {
            this.reportDiff("RecordDomain " + recordDomain.getQualifiedName(), "no RecordDomain");
            return;
        }
        RecordDomain recordDomain2 = (RecordDomain)domain;
        for (RecordDomain.RecordComponent recordComponent : recordDomain.getComponents()) {
            boolean bl = false;
            for (RecordDomain.RecordComponent recordComponent2 : recordDomain2.getComponents()) {
                if (!recordComponent.getName().equals(recordComponent2.getName()) || !recordComponent.getDomain().getQualifiedName().equals(recordComponent2.getDomain().getQualifiedName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.reportDiff("RecordDomain " + recordDomain.getQualifiedName() + ", Component: " + recordComponent.getName() + " : " + recordComponent.getDomain().getQualifiedName(), "RecordDomain " + recordDomain2.getQualifiedName() + " has no such component.");
        }
        this.marked.add(recordDomain);
        this.marked.add(recordDomain2);
    }

    private void compareEnumDomain(EnumDomain enumDomain, Domain domain) {
        if (domain == null) {
            this.reportDiff("EnumDomain " + enumDomain.getQualifiedName(), "null");
            return;
        }
        if (this.areMarked(enumDomain, domain)) {
            return;
        }
        if (!(domain instanceof EnumDomain)) {
            this.reportDiff("EnumDomain " + enumDomain.getQualifiedName(), "no EnumDomain");
            return;
        }
        EnumDomain enumDomain2 = (EnumDomain)domain;
        if (!new HashSet<String>(enumDomain.getConsts()).equals(new HashSet<String>(enumDomain2.getConsts()))) {
            this.reportDiff("EnumDomain " + enumDomain.getQualifiedName() + ": " + enumDomain.getConsts(), "EnumDomain " + enumDomain2.getQualifiedName() + ": " + enumDomain2.getConsts());
        }
        this.marked.add(enumDomain);
        this.marked.add(enumDomain2);
    }

    private void reportDiff(String string, String string2) {
        System.out.println("---");
        if (!this.reverseRun) {
            System.out.println("Schema 1: " + string);
            System.out.println("Schema 2: " + string2);
        } else {
            System.out.println("Schema 2: " + string);
            System.out.println("Schema 1: " + string2);
        }
        ++this.diffCount;
    }

    private void compareGraphClass(GraphClass graphClass, GraphClass graphClass2) {
        if (!graphClass.getQualifiedName().equals(graphClass2.getQualifiedName())) {
            this.reportDiff("GraphClass: " + graphClass.getQualifiedName(), "GraphClass: " + graphClass2.getQualifiedName());
            return;
        }
        if (this.areMarked(graphClass, graphClass2)) {
            return;
        }
        for (GraphElementClass<?, ?> graphElementClass : graphClass.getGraphElementClasses()) {
            this.compareGraphElementClass(graphElementClass, graphClass2.getGraphElementClass(graphElementClass.getQualifiedName()));
        }
        this.marked.add(graphClass);
        this.marked.add(graphClass2);
    }

    private void compareGraphElementClass(GraphElementClass<?, ?> graphElementClass, GraphElementClass<?, ?> graphElementClass2) {
        if (graphElementClass2 == null) {
            this.reportDiff("GraphElementClass: " + graphElementClass.getQualifiedName(), "null");
            return;
        }
        if (this.areMarked(graphElementClass, graphElementClass2)) {
            return;
        }
        this.compareHierarchy(graphElementClass, graphElementClass2);
        this.compareAbstractness(graphElementClass, graphElementClass2);
        for (Attribute attribute : graphElementClass.getOwnAttributeList()) {
            this.compareAttribute(graphElementClass, attribute, graphElementClass2, graphElementClass2.getAttribute(attribute.getName()));
        }
        this.marked.add(graphElementClass);
        this.marked.add(graphElementClass2);
    }

    private void compareAbstractness(GraphElementClass<?, ?> graphElementClass, GraphElementClass<?, ?> graphElementClass2) {
        if (graphElementClass.isAbstract() ^ graphElementClass2.isAbstract()) {
            this.reportDiff(graphElementClass.getQualifiedName() + (graphElementClass.isAbstract() ? " is" : " is not") + " abstract", graphElementClass2.getQualifiedName() + (graphElementClass2.isAbstract() ? " is" : " is not") + " abstract");
        }
    }

    private void compareAttribute(GraphElementClass<?, ?> graphElementClass, Attribute attribute, GraphElementClass<?, ?> graphElementClass2, Attribute attribute2) {
        if (attribute2 == null) {
            this.reportDiff(graphElementClass.getQualifiedName() + "." + attribute.getName(), graphElementClass2.getQualifiedName() + " doesn't have such an Atrribute");
            return;
        }
        if (this.areMarked(graphElementClass, graphElementClass2)) {
            return;
        }
        if (!attribute.getDomain().getQualifiedName().equals(attribute2.getDomain().getQualifiedName())) {
            this.reportDiff(graphElementClass.getQualifiedName() + "." + attribute.getName() + " : " + attribute.getDomain().getQualifiedName(), graphElementClass2.getQualifiedName() + "." + attribute2.getName() + " : " + attribute2.getDomain().getQualifiedName());
        }
        this.marked.add(graphElementClass);
        this.marked.add(graphElementClass2);
    }

    private void compareHierarchy(GraphElementClass<?, ?> graphElementClass, GraphElementClass<?, ?> graphElementClass2) {
        Set<String> set;
        Set<String> set2;
        Set<String> set3;
        Set<String> set4 = this.getQNameSet(graphElementClass.getDirectSuperClasses());
        if (!set4.equals(set3 = this.getQNameSet(graphElementClass2.getDirectSuperClasses()))) {
            this.reportDiff(graphElementClass.getQualifiedName() + " superclasses: " + set4, graphElementClass2.getQualifiedName() + " superclasses: " + set3);
        }
        if (!(set2 = this.getQNameSet(graphElementClass.getAllSubClasses())).equals(set = this.getQNameSet(graphElementClass2.getAllSubClasses()))) {
            this.reportDiff(graphElementClass.getQualifiedName() + " subclasses: " + set2, graphElementClass2.getQualifiedName() + " subclasses: " + set);
        }
    }

    private Set<String> getQNameSet(Set<? extends NamedElement> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (NamedElement namedElement : set) {
            treeSet.add(namedElement.getQualifiedName());
        }
        return treeSet;
    }

    public static void main(String[] stringArray) throws GraphIOException {
        CommandLine commandLine = SchemaCompare.processCommandLineOptions(stringArray);
        assert (commandLine != null);
        SchemaCompare schemaCompare = new SchemaCompare(GraphIO.loadSchemaFromFile(commandLine.getOptionValue("s1")), GraphIO.loadSchemaFromFile(commandLine.getOptionValue("s2")));
        schemaCompare.compareSchemas();
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + SchemaCompare.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("s1", "schema1", true, "(required): the first schema which is compared with the second");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("s2", "schema2", true, "(required): the second schema which is compared with the first");
        option2.setRequired(true);
        option2.setArgName("file");
        optionHandler.addOption(option2);
        return optionHandler.parse(stringArray);
    }
}

