/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgmerge;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.graphmarker.AbstractGraphMarker;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class TGMerge {
    private List<Graph> additionalGraphs = new LinkedList<Graph>();
    private List<AbstractGraphMarker<?>> additionalGraphMarkers = new LinkedList();
    private Graph targetGraph;
    private Map<Vertex, Vertex> old2NewVertices = new HashMap<Vertex, Vertex>();
    private Map<Vertex, Vertex> new2OldVertices = new HashMap<Vertex, Vertex>();
    private Map<Edge, Edge> new2OldEdges = new HashMap<Edge, Edge>();
    private Map<GraphElement<?, ?>, Integer> copiedGraphPositions = new HashMap();
    private Map<GraphElement<?, ?>, Integer> targetGraphPositions = new HashMap();
    private static Logger logger = JGraLab.getLogger(TGMerge.class);

    public TGMerge(List<Graph> list) {
        this(list.toArray(new Graph[list.size()]));
    }

    public TGMerge(Graph graph, AbstractGraphMarker<?> ... abstractGraphMarkerArray) {
        if (abstractGraphMarkerArray.length == 0) {
            throw new RuntimeException("No marker given!");
        }
        this.targetGraph = graph;
        for (AbstractGraphMarker<?> abstractGraphMarker : abstractGraphMarkerArray) {
            this.additionalGraphMarkers.add(abstractGraphMarker);
        }
    }

    public TGMerge(Graph ... graphArray) {
        if (graphArray.length < 2) {
            throw new RuntimeException("Merging makes no sense with less than 2 Graphs.");
        }
        Schema schema = graphArray[0].getSchema();
        for (Graph graph : graphArray) {
            if (graph.getSchema() == schema) continue;
            throw new RuntimeException("It's only possible to merge additionalGraphs conforming to one schema.");
        }
        this.targetGraph = graphArray[0];
        this.additionalGraphs = new LinkedList<Graph>();
        for (int i = 1; i < graphArray.length; ++i) {
            this.additionalGraphs.add(graphArray[i]);
        }
    }

    public static void main(String[] stringArray) throws GraphIOException {
        CommandLine commandLine = TGMerge.processCommandLineOptions(stringArray);
        String string = commandLine.getOptionValue('o').trim();
        LinkedList<Graph> linkedList = new LinkedList<Graph>();
        for (String string2 : commandLine.getArgs()) {
            linkedList.add(GraphIO.loadGraphFromFile(string2, new ConsoleProgressFunction("Loading")));
        }
        TGMerge tGMerge = new TGMerge(linkedList);
        Graph graph = tGMerge.merge();
        GraphIO.saveGraphToFile(graph, string, (ProgressFunction)new ConsoleProgressFunction("Saving"));
    }

    public Graph merge() {
        logger.fine("TargetGraph is '" + this.targetGraph.getId() + "'.");
        for (Graph object : this.additionalGraphs) {
            logger.fine("Merging graph '" + object.getId() + "'...");
            this.rememberTargetGraphPositions();
            this.rememberCopiedGraphPositions(object);
            for (Vertex vertex : object.vertices()) {
                this.copyVertex(vertex);
            }
            for (Edge edge : object.edges()) {
                this.copyEdge(edge);
            }
            this.sortVertices();
            this.sortEdges();
            this.sortIncidences();
            this.resetMaps();
        }
        for (AbstractGraphMarker abstractGraphMarker : this.additionalGraphMarkers) {
            logger.fine("Merging GraphMarker '" + abstractGraphMarker + "'...");
            this.rememberTargetGraphPositions();
            this.rememberCopiedGraphPositions(abstractGraphMarker.getGraph());
            for (AttributedElement attributedElement : abstractGraphMarker.getMarkedElements()) {
                if (!(attributedElement instanceof Vertex)) continue;
                this.copyVertex((Vertex)attributedElement);
            }
            for (AttributedElement attributedElement : abstractGraphMarker.getMarkedElements()) {
                if (!(attributedElement instanceof Edge)) continue;
                this.copyEdge((Edge)attributedElement);
            }
            this.sortVertices();
            this.sortEdges();
            this.sortIncidences();
            this.resetMaps();
        }
        return this.targetGraph;
    }

    private void resetMaps() {
        this.old2NewVertices.clear();
        this.new2OldVertices.clear();
        this.new2OldEdges.clear();
        this.copiedGraphPositions.clear();
        this.targetGraphPositions.clear();
    }

    private void rememberCopiedGraphPositions(Graph graph) {
        int n = 0;
        for (Vertex graphElement : graph.vertices()) {
            this.copiedGraphPositions.put(graphElement, ++n);
        }
        n = 0;
        for (Edge edge : graph.edges()) {
            this.copiedGraphPositions.put(edge, ++n);
        }
    }

    private void rememberTargetGraphPositions() {
        int n = 0;
        for (Vertex graphElement : this.targetGraph.vertices()) {
            this.targetGraphPositions.put(graphElement, ++n);
        }
        n = 0;
        for (Edge edge : this.targetGraph.edges()) {
            this.targetGraphPositions.put(edge, ++n);
        }
    }

    private void sortVertices() {
        logger.fine("Sorting " + this.targetGraph.getVCount() + " vertices...");
        VertexComparator vertexComparator = new VertexComparator();
        this.targetGraph.sortVertices(vertexComparator);
        logger.fine(vertexComparator.compareCount + " comparisons were needed to sort " + this.targetGraph.getVCount() + " vertices.");
    }

    private void sortEdges() {
        logger.fine("Sorting " + this.targetGraph.getECount() + " edges...");
        EdgeComparator edgeComparator = new EdgeComparator();
        this.targetGraph.sortEdges(edgeComparator);
        logger.fine(edgeComparator.compareCount + " comparisons were needed to sort " + this.targetGraph.getECount() + " edges.");
    }

    private void sortIncidences() {
        logger.fine("Sorting incidences...");
        for (Vertex vertex : this.old2NewVertices.values()) {
            vertex.sortIncidences(new Comparator<Edge>(){

                @Override
                public int compare(Edge edge, Edge edge2) {
                    Edge edge3;
                    Edge edge4 = (Edge)TGMerge.this.new2OldEdges.get(edge);
                    if (edge4.isBeforeIncidence(edge3 = (Edge)TGMerge.this.new2OldEdges.get(edge2))) {
                        return -1;
                    }
                    if (edge3.isBeforeIncidence(edge4)) {
                        return 1;
                    }
                    throw new RuntimeException("Exception while sorting incidences.");
                }
            });
        }
    }

    private void copyEdge(Edge edge) {
        Vertex vertex = this.old2NewVertices.get(edge.getAlpha());
        Vertex vertex2 = this.old2NewVertices.get(edge.getOmega());
        Object t = this.targetGraph.createEdge(edge.getAttributedElementClass(), vertex, vertex2);
        this.copyAttributes(edge, (AttributedElement<?, ?>)t);
        this.new2OldEdges.put((Edge)t, edge);
        this.new2OldEdges.put(t.getReversedEdge(), edge.getReversedEdge());
    }

    private void copyVertex(Vertex vertex) {
        Object t = this.targetGraph.createVertex(vertex.getAttributedElementClass());
        this.copyAttributes(vertex, (AttributedElement<?, ?>)t);
        this.old2NewVertices.put(vertex, (Vertex)t);
        this.new2OldVertices.put((Vertex)t, vertex);
    }

    private void copyAttributes(AttributedElement<?, ?> attributedElement, AttributedElement<?, ?> attributedElement2) {
        for (Attribute attribute : attributedElement.getAttributedElementClass().getAttributeList()) {
            attributedElement2.setAttribute(attribute.getName(), attributedElement.getAttribute(attribute.getName()));
        }
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + TGMerge.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("o", "outTG", true, "(required): output TG file");
        option.setRequired(true);
        option.setArgName("outputTG");
        optionHandler.addOption(option);
        optionHandler.setArgumentCount(-2);
        optionHandler.setArgumentName("inputTG");
        optionHandler.setOptionalArgument(false);
        return optionHandler.parse(stringArray);
    }

    private class EdgeComparator
    implements Comparator<Edge> {
        long compareCount = 0L;

        private EdgeComparator() {
        }

        @Override
        public int compare(Edge edge, Edge edge2) {
            ++this.compareCount;
            if (TGMerge.this.new2OldEdges.containsKey(edge) && TGMerge.this.new2OldEdges.containsKey(edge2)) {
                Edge edge3 = (Edge)TGMerge.this.new2OldEdges.get(edge);
                Edge edge4 = (Edge)TGMerge.this.new2OldEdges.get(edge2);
                return (Integer)TGMerge.this.copiedGraphPositions.get(edge3) - (Integer)TGMerge.this.copiedGraphPositions.get(edge4);
            }
            if (TGMerge.this.new2OldEdges.containsKey(edge) && !TGMerge.this.new2OldEdges.containsKey(edge2)) {
                return 1;
            }
            if (!TGMerge.this.new2OldEdges.containsKey(edge) && TGMerge.this.new2OldEdges.containsKey(edge2)) {
                return -1;
            }
            if (!TGMerge.this.new2OldEdges.containsKey(edge) && !TGMerge.this.new2OldEdges.containsKey(edge2)) {
                return (Integer)TGMerge.this.targetGraphPositions.get(edge) - (Integer)TGMerge.this.targetGraphPositions.get(edge2);
            }
            throw new RuntimeException("Exception while sorting edges.");
        }
    }

    private class VertexComparator
    implements Comparator<Vertex> {
        long compareCount = 0L;

        private VertexComparator() {
        }

        @Override
        public int compare(Vertex vertex, Vertex vertex2) {
            ++this.compareCount;
            if (TGMerge.this.new2OldVertices.containsKey(vertex) && TGMerge.this.new2OldVertices.containsKey(vertex2)) {
                Vertex vertex3 = (Vertex)TGMerge.this.new2OldVertices.get(vertex);
                Vertex vertex4 = (Vertex)TGMerge.this.new2OldVertices.get(vertex2);
                return (Integer)TGMerge.this.copiedGraphPositions.get(vertex3) - (Integer)TGMerge.this.copiedGraphPositions.get(vertex4);
            }
            if (TGMerge.this.new2OldVertices.containsKey(vertex) && !TGMerge.this.new2OldVertices.containsKey(vertex2)) {
                return 1;
            }
            if (!TGMerge.this.new2OldVertices.containsKey(vertex) && TGMerge.this.new2OldVertices.containsKey(vertex2)) {
                return -1;
            }
            if (!TGMerge.this.new2OldVertices.containsKey(vertex) && !TGMerge.this.new2OldVertices.containsKey(vertex2)) {
                return (Integer)TGMerge.this.targetGraphPositions.get(vertex) - (Integer)TGMerge.this.targetGraphPositions.get(vertex2);
            }
            throw new RuntimeException("Exception while sorting vertices.");
        }
    }
}

