/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgschema2java;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.utilities.tgschema2java.SchemaJarGenerator;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class TgSchema2Java {
    int i = 0;
    private String tgFilename;
    private String commitPath = ".";
    private String classpath;
    private boolean compile = false;
    private boolean createJar = false;
    private boolean overwrite = true;
    private String jarFileName = null;
    private Schema schema;
    private CodeGeneratorConfiguration config = new CodeGeneratorConfiguration();

    public static void main(String[] stringArray) {
        TgSchema2Java tgSchema2Java = new TgSchema2Java();
        String string = null;
        try {
            CommandLine commandLine = TgSchema2Java.processCommandLineOptions(stringArray);
            assert (commandLine != null);
            if (commandLine.hasOption("p")) {
                tgSchema2Java.setCommitPath(commandLine.getOptionValue("p"));
            }
            tgSchema2Java.setCompile(commandLine.hasOption("c"));
            if (commandLine.hasOption("j")) {
                tgSchema2Java.setCreateJar(true);
                tgSchema2Java.setJarFileName(commandLine.getOptionValue("j"));
            }
            if (commandLine.hasOption('w')) {
                tgSchema2Java.setTypeSpecificMethodSupport(false);
            } else {
                tgSchema2Java.setTypeSpecificMethodSupport(true);
            }
            string = commandLine.getOptionValue("s");
            tgSchema2Java.loadSchema(string);
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
            System.err.println("Couldn't read schema in file '" + string + "': " + graphIOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        tgSchema2Java.execute();
    }

    public void loadSchema(String string) throws GraphIOException {
        this.schema = GraphIO.loadSchemaFromFile(string);
    }

    public void setTypeSpecificMethodSupport(boolean bl) {
        this.config.setTypeSpecificMethodsSupport(bl);
    }

    private boolean deleteFolder(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        for (String string2 : file.list()) {
            File file2 = new File(string + File.separator + string2);
            if (file2.isDirectory()) {
                this.deleteFolder(file2.getPath());
                continue;
            }
            file2.delete();
        }
        file.delete();
        return true;
    }

    private Set<String> getGeneratedFilePaths(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        JavaFileFilter javaFileFilter = new JavaFileFilter();
        File file = new File(string);
        if (!file.exists()) {
            return hashSet;
        }
        for (File file2 : file.listFiles(javaFileFilter)) {
            if (file2.isDirectory()) {
                hashSet.addAll(this.getGeneratedFilePaths(file2.getAbsolutePath()));
                continue;
            }
            hashSet.add(file2.getAbsolutePath());
        }
        return hashSet;
    }

    private boolean isExistingSchema(Schema schema) {
        String string;
        String string2 = schema.getPathName();
        Set<String> set = this.getGeneratedFilePaths(this.commitPath + File.separator + string2);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.commitPath + File.separator + schema.getFileName() + ".java");
        hashSet.add(this.commitPath + File.separator + schema.getPathName() + File.separator + "impl" + File.separator + schema.getName() + "Factory.java");
        for (Domain object : schema.getDomains()) {
            string = object.getPathName();
            if (!string.isEmpty()) {
                string = string.concat(File.separator);
            }
            if (!object.toString().startsWith("Enum") && !object.toString().startsWith("Record")) continue;
            hashSet.add(this.commitPath + File.separator + string2 + File.separator + string + object.getSimpleName() + ".java");
        }
        GraphClass graphClass = schema.getGraphClass();
        hashSet.add(this.commitPath + File.separator + string2 + File.separator + graphClass.getFileName() + ".java");
        if (!graphClass.isAbstract()) {
            string = graphClass.getPathName();
            if (!string.isEmpty()) {
                string = string.concat(File.separator);
            }
            hashSet.add(this.commitPath + File.separator + string2 + File.separator + "impl" + File.separator + string + graphClass.getSimpleName() + "Impl.java");
        }
        for (VertexClass vertexClass : schema.getGraphClass().getVertexClasses()) {
            hashSet.add(this.commitPath + File.separator + string2 + File.separator + vertexClass.getFileName() + ".java");
            if (vertexClass.isAbstract()) continue;
            string = vertexClass.getPathName();
            if (!string.isEmpty()) {
                string = string.concat(File.separator);
            }
            hashSet.add(this.commitPath + File.separator + string2 + File.separator + "impl" + File.separator + string + vertexClass.getSimpleName() + "Impl.java");
        }
        for (EdgeClass edgeClass : schema.getGraphClass().getEdgeClasses()) {
            hashSet.add(this.commitPath + File.separator + string2 + File.separator + edgeClass.getFileName() + ".java");
            if (edgeClass.isAbstract()) continue;
            string = edgeClass.getPathName();
            if (!string.isEmpty()) {
                string = string.concat(File.separator);
            }
            hashSet.add(this.commitPath + File.separator + string2 + File.separator + "impl" + File.separator + string + edgeClass.getSimpleName() + "Impl.java");
            hashSet.add(this.commitPath + File.separator + string2 + File.separator + "impl" + File.separator + string + "Reversed" + edgeClass.getSimpleName() + "Impl.java");
        }
        return set.containsAll(hashSet) && hashSet.containsAll(set);
    }

    public void compile() throws Exception {
        String string = this.schema.getPathName();
        File file = new File(this.commitPath + File.separator + string);
        List<File> list = this.findFilesInDirectory(file);
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(list);
        Vector<String> vector = new Vector<String>();
        if (this.classpath != null) {
            vector.add("-cp");
            vector.add(this.classpath);
        }
        System.out.print("Starting compilation....");
        javaCompiler.getTask(null, standardJavaFileManager, null, null, null, iterable).call();
        System.out.println("finished");
    }

    private List<File> findFilesInDirectory(File file) throws Exception {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isFile() && file2.getName().endsWith(".java")) {
                arrayList.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            arrayList.addAll(this.findFilesInDirectory(file2));
        }
        return arrayList;
    }

    public void execute() {
        try {
            if (this.isExistingSchema(this.schema)) {
                System.out.println("Schema already exists in " + this.commitPath);
                System.out.print("Overwrite existing files (y|n)? ");
                int n = System.in.read();
                switch (n) {
                    case 121: {
                        break;
                    }
                    case 110: {
                        this.overwrite = false;
                    }
                }
            }
            if (this.overwrite) {
                this.deleteFolder(this.commitPath + File.separator + this.schema.getPathName());
                System.out.println("Committing schema " + this.schema.getQualifiedName());
                this.schema.commit(this.commitPath, this.config);
                System.out.println("Schema " + this.schema.getQualifiedName() + " committed successfully");
            }
            if (this.compile) {
                System.out.println("Compiling...");
                this.compile();
                System.out.println("Compiling successful");
            }
            if (this.createJar) {
                System.out.println("Creating .jar-file");
                this.generateJarFile();
                System.out.println(".jar-file created successfully");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void generateJarFile() {
        SchemaJarGenerator schemaJarGenerator = new SchemaJarGenerator(this.commitPath, this.schema.getFileName(), this.jarFileName);
        try {
            schemaJarGenerator.createJar();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + TgSchema2Java.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("s", "schema", true, "(required): specifies the .tg-file of the schema to be converted");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("c", "compile", false, "(optional): if specified, the .java are compiled");
        option2.setRequired(false);
        optionHandler.addOption(option2);
        Option option3 = new Option("j", "jar", true, "(optional): specifies the name of the .jar-file; if omitted, no jar will be created");
        option3.setRequired(false);
        option3.setArgName("file");
        optionHandler.addOption(option3);
        Option option4 = new Option("w", "without-types", false, "(optional): Don't create typespecific methods in classes");
        option4.setRequired(false);
        optionHandler.addOption(option4);
        Option option5 = new Option("p", "path", true, "specifies the path to where the created files are stored; default is current folder (\".\")");
        option5.setRequired(true);
        option5.setArgName("path");
        optionHandler.addOption(option5);
        return optionHandler.parse(stringArray);
    }

    public String getTgFilename() {
        return this.tgFilename;
    }

    public void setTgFilename(String string) {
        this.tgFilename = string;
    }

    public String getCommitPath() {
        return this.commitPath;
    }

    public void setCommitPath(String string) {
        string = string.replace("/", File.separator);
        this.commitPath = string = string.replace("\\", File.separator);
    }

    public boolean isCompile() {
        return this.compile;
    }

    public void setCompile(boolean bl) {
        this.compile = bl;
    }

    public boolean isCreateJar() {
        return this.createJar;
    }

    public void setCreateJar(boolean bl) {
        this.createJar = bl;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    public void setJarFileName(String string) {
        this.jarFileName = string;
    }

    public Schema getSchema() {
        return this.schema;
    }

    static class JavaFileFilter
    implements FileFilter {
        JavaFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".java");
        }
    }
}

