/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.tgtree;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.utilities.tgtree.EdgeTreeNode;
import de.uni_koblenz.jgralab.utilities.tgtree.GraphElementTreeNode;
import java.util.ArrayList;

class VertexTreeNode
extends GraphElementTreeNode {
    private Vertex v;

    public VertexTreeNode(Vertex vertex, EdgeTreeNode edgeTreeNode) {
        super(edgeTreeNode);
        this.v = vertex;
    }

    @Override
    protected void init() {
        if (this.incs != null) {
            return;
        }
        this.incs = new ArrayList();
        for (Edge edge : this.v.incidences()) {
            this.incs.add(new EdgeTreeNode(edge, this));
        }
    }

    @Override
    public String getClipboardText() {
        return this.v.getAttributedElementClass().getQualifiedName();
    }

    public String toString() {
        return this.v.toString();
    }

    @Override
    public String getToolTipText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(this.getAttributeString());
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    @Override
    protected GraphElement<?, ?> get() {
        return this.v;
    }
}

