/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Attribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.References;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Text;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import java.util.Iterator;

public class XmlGraphUtilities {
    private XMLGraph xg;

    public XmlGraphUtilities(XMLGraph xMLGraph) {
        this.xg = xMLGraph;
    }

    public Iterable<Element> elementsWithName(final String string) {
        return this.xg.getElementVertices(new VertexFilter<Element>(){

            @Override
            public boolean accepts(Element element) {
                return element.get_name().equals(string);
            }
        });
    }

    public Iterable<Element> childrenWithName(Element element, final String string) {
        return element.get_children(new VertexFilter<Element>(){

            @Override
            public boolean accepts(Element element) {
                return element.get_name().equals(string);
            }
        });
    }

    public Element firstChildWithName(Element element, String string) {
        Iterator<Element> iterator = this.childrenWithName(element, string).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public Element getRootElement() {
        for (Element element : this.xg.getElementVertices()) {
            if (element.getFirstHasChildIncidence(EdgeDirection.IN) != null) continue;
            return element;
        }
        return null;
    }

    public String getAttributeValue(Element element, String string) {
        for (Attribute attribute : element.get_attributes()) {
            if (!attribute.get_name().equals(string)) continue;
            return attribute.get_value();
        }
        throw new NoSuchAttributeException("Element " + element + " has no attribute '" + string + "'");
    }

    public String getAttributeValue(Element element, String string, boolean bl) {
        String string2 = this.getAttributeValue(element, string);
        if (bl && (string2 = string2.trim()).length() > 0) {
            string2 = Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
        }
        return string2;
    }

    public Element getReferencedElement(Element element, String string) {
        for (Attribute attribute : element.get_attributes()) {
            if (!attribute.get_name().equals(string)) continue;
            References references = attribute.getFirstReferencesIncidence();
            return references == null ? null : (Element)references.getThat();
        }
        throw new NoSuchAttributeException("Element " + element + " has no attribute '" + string + "'");
    }

    public Iterable<Element> getReferencedElements(Element element, String string) {
        for (Attribute attribute : element.get_attributes()) {
            if (!attribute.get_name().equals(string)) continue;
            return attribute.get_refs();
        }
        throw new NoSuchAttributeException("Element " + element + " has no attribute '" + string + "'");
    }

    public boolean hasAttribute(Element element, String string) {
        for (Attribute attribute : element.get_attributes()) {
            if (!attribute.get_name().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getText(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Text text : element.get_texts()) {
            stringBuilder.append(text.get_content());
        }
        return stringBuilder.toString();
    }
}

