/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.xml2tg.schema.impl.std;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.VertexFilter;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.exception.NoSuchAttributeException;
import de.uni_koblenz.jgralab.impl.IncidenceIterable;
import de.uni_koblenz.jgralab.impl.NeighbourIterable;
import de.uni_koblenz.jgralab.impl.std.VertexImpl;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Attribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.Element;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.HasAttribute;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.References;
import de.uni_koblenz.jgralab.utilities.xml2tg.schema.XMLGraph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AttributeImpl
extends VertexImpl
implements Attribute,
Vertex {
    protected String _name;
    protected String _value;

    public AttributeImpl(int n, Graph graph) {
        super(n, graph);
    }

    @Override
    public final VertexClass getAttributedElementClass() {
        return Attribute.VC;
    }

    @Override
    public final Class<? extends Vertex> getSchemaClass() {
        return Attribute.class;
    }

    @Override
    public <T> T getAttribute(String string) {
        if (string.equals("name")) {
            return (T)this.get_name();
        }
        if (string.equals("value")) {
            return (T)this.get_value();
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + string);
    }

    @Override
    public <T> void setAttribute(String string, T t) {
        if (string.equals("name")) {
            this.set_name((String)t);
            return;
        }
        if (string.equals("value")) {
            this.set_value((String)t);
            return;
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + string);
    }

    @Override
    public String get_name() {
        return this._name;
    }

    @Override
    public void set_name(String string) {
        this.graph.fireBeforeChangeAttribute(this, "name", this._name, string);
        String string2 = this._name;
        this._name = string;
        this.graphModified();
        this.graph.fireAfterChangeAttribute(this, "name", string2, string);
    }

    @Override
    public String get_value() {
        return this._value;
    }

    @Override
    public void set_value(String string) {
        this.graph.fireBeforeChangeAttribute(this, "value", this._value, string);
        String string2 = this._value;
        this._value = string;
        this.graphModified();
        this.graph.fireAfterChangeAttribute(this, "value", string2, string);
    }

    @Override
    public void readAttributeValues(GraphIO graphIO) throws GraphIOException {
        this._name = graphIO.matchUtfString();
        this.set_name(this._name);
        this._value = graphIO.matchUtfString();
        this.set_value(this._value);
    }

    @Override
    public void readAttributeValueFromString(String string, String string2) throws GraphIOException {
        if (string.equals("name")) {
            GraphIO graphIO = GraphIO.createStringReader(string2, this.getSchema());
            this._name = graphIO.matchUtfString();
            this.set_name(this._name);
            return;
        }
        if (string.equals("value")) {
            GraphIO graphIO = GraphIO.createStringReader(string2, this.getSchema());
            this._value = graphIO.matchUtfString();
            this.set_value(this._value);
            return;
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + string);
    }

    @Override
    public void writeAttributeValues(GraphIO graphIO) throws GraphIOException, IOException {
        graphIO.writeUtfString(this._name);
        graphIO.writeUtfString(this._value);
    }

    @Override
    public String writeAttributeValueToString(String string) throws IOException, GraphIOException {
        if (string.equals("name")) {
            GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
            graphIO.writeUtfString(this._name);
            return graphIO.getStringWriterResult();
        }
        if (string.equals("value")) {
            GraphIO graphIO = GraphIO.createStringWriter(this.getSchema());
            graphIO.writeUtfString(this._value);
            return graphIO.getStringWriterResult();
        }
        throw new NoSuchAttributeException("Attribute doesn't contain an attribute " + string);
    }

    @Override
    public Attribute getNextAttribute() {
        return (Attribute)this.getNextVertex(Attribute.VC);
    }

    @Override
    public References getFirstReferencesIncidence() {
        return (References)this.getFirstIncidence(References.EC);
    }

    @Override
    public References getFirstReferencesIncidence(EdgeDirection edgeDirection) {
        return (References)this.getFirstIncidence(References.EC, edgeDirection);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence() {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC);
    }

    @Override
    public HasAttribute getFirstHasAttributeIncidence(EdgeDirection edgeDirection) {
        return (HasAttribute)this.getFirstIncidence(HasAttribute.EC, edgeDirection);
    }

    @Override
    public HasAttribute add_element(Element element) {
        return (HasAttribute)((XMLGraph)this.getGraph()).createEdge(HasAttribute.EC, element, this);
    }

    @Override
    public List<? extends Element> remove_element() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        HasAttribute hasAttribute = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (hasAttribute != null) {
            HasAttribute hasAttribute2 = (HasAttribute)hasAttribute.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            arrayList.add((Element)hasAttribute.getThat());
            hasAttribute.delete();
            hasAttribute = hasAttribute2;
        }
        return arrayList;
    }

    @Override
    public boolean remove_element(Element element) {
        boolean bl = false;
        HasAttribute hasAttribute = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        while (hasAttribute != null) {
            HasAttribute hasAttribute2 = (HasAttribute)hasAttribute.getNextIncidence(HasAttribute.EC, EdgeDirection.IN);
            if (hasAttribute.getThat().equals(element)) {
                hasAttribute.delete();
                bl = true;
            }
            hasAttribute = hasAttribute2;
        }
        return bl;
    }

    @Override
    public Element get_element() {
        HasAttribute hasAttribute = (HasAttribute)this.getFirstIncidence(HasAttribute.EC, EdgeDirection.IN);
        if (hasAttribute != null) {
            return (Element)hasAttribute.getThat();
        }
        return null;
    }

    @Override
    public References add_refs(Element element) {
        return (References)((XMLGraph)this.getGraph()).createEdge(References.EC, this, element);
    }

    @Override
    public List<? extends Element> remove_refs() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        References references = (References)this.getFirstIncidence(References.EC, EdgeDirection.OUT);
        while (references != null) {
            References references2 = (References)references.getNextIncidence(References.EC, EdgeDirection.OUT);
            arrayList.add((Element)references.getThat());
            references.delete();
            references = references2;
        }
        return arrayList;
    }

    @Override
    public boolean remove_refs(Element element) {
        boolean bl = false;
        References references = (References)this.getFirstIncidence(References.EC, EdgeDirection.OUT);
        while (references != null) {
            References references2 = (References)references.getNextIncidence(References.EC, EdgeDirection.OUT);
            if (references.getThat().equals(element)) {
                references.delete();
                bl = true;
            }
            references = references2;
        }
        return bl;
    }

    @Override
    public <V extends Element> Iterable<V> get_refs() {
        return new NeighbourIterable(this, References.EC, EdgeDirection.OUT, null);
    }

    @Override
    public <V extends Element> Iterable<V> get_refs(VertexFilter<V> vertexFilter) {
        return new NeighbourIterable(this, References.EC, EdgeDirection.OUT, vertexFilter);
    }

    @Override
    public Iterable<References> getReferencesIncidences() {
        return new IncidenceIterable<References>((Vertex)this, References.EC);
    }

    @Override
    public Iterable<References> getReferencesIncidences(EdgeDirection edgeDirection) {
        return new IncidenceIterable<References>(this, References.EC, edgeDirection);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences() {
        return new IncidenceIterable<HasAttribute>((Vertex)this, HasAttribute.EC);
    }

    @Override
    public Iterable<HasAttribute> getHasAttributeIncidences(EdgeDirection edgeDirection) {
        return new IncidenceIterable<HasAttribute>(this, HasAttribute.EC, edgeDirection);
    }
}

