/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.Iterator;
import java.util.Map;
import org.pcollections.ConsPStack;
import org.pcollections.PStack;
import org.pcollections.SimpleImmutableEntry;

class IntTree<V> {
    static final IntTree<Object> EMPTYNODE = new IntTree();
    private final long key;
    private final V value;
    private final IntTree<V> left;
    private final IntTree<V> right;
    private final int size;
    private static final int OMEGA = 5;
    private static final int ALPHA = 2;

    private IntTree() {
        if (EMPTYNODE != null) {
            throw new RuntimeException("empty constructor should only be used once");
        }
        this.size = 0;
        this.key = 0L;
        this.value = null;
        this.left = null;
        this.right = null;
    }

    private IntTree(long l, V v, IntTree<V> intTree, IntTree<V> intTree2) {
        this.key = l;
        this.value = v;
        this.left = intTree;
        this.right = intTree2;
        this.size = 1 + intTree.size + intTree2.size;
    }

    private IntTree<V> withKey(long l) {
        if (this.size == 0 || l == this.key) {
            return this;
        }
        return new IntTree<V>(l, this.value, this.left, this.right);
    }

    Iterator<Map.Entry<Integer, V>> iterator() {
        return new EntryIterator(this);
    }

    int size() {
        return this.size;
    }

    boolean containsKey(long l) {
        if (this.size == 0) {
            return false;
        }
        if (l < this.key) {
            return this.left.containsKey(l - this.key);
        }
        if (l > this.key) {
            return this.right.containsKey(l - this.key);
        }
        return true;
    }

    V get(long l) {
        if (this.size == 0) {
            return null;
        }
        if (l < this.key) {
            return this.left.get(l - this.key);
        }
        if (l > this.key) {
            return this.right.get(l - this.key);
        }
        return this.value;
    }

    IntTree<V> plus(long l, V v) {
        if (this.size == 0) {
            return new IntTree<V>(l, v, this, this);
        }
        if (l < this.key) {
            return this.rebalanced(this.left.plus(l - this.key, v), this.right);
        }
        if (l > this.key) {
            return this.rebalanced(this.left, this.right.plus(l - this.key, v));
        }
        if (v == this.value) {
            return this;
        }
        return new IntTree<V>(l, v, this.left, this.right);
    }

    IntTree<V> minus(long l) {
        if (this.size == 0) {
            return this;
        }
        if (l < this.key) {
            return this.rebalanced(this.left.minus(l - this.key), this.right);
        }
        if (l > this.key) {
            return this.rebalanced(this.left, this.right.minus(l - this.key));
        }
        if (this.left.size == 0) {
            return super.withKey(this.right.key + this.key);
        }
        if (this.right.size == 0) {
            return super.withKey(this.left.key + this.key);
        }
        long l2 = super.minKey() + this.key;
        V v = this.right.get(l2 - this.key);
        IntTree<V> intTree = this.right.minus(l2 - this.key);
        intTree = super.withKey(intTree.key + this.key - l2);
        IntTree<V> intTree2 = super.withKey(this.left.key + this.key - l2);
        return IntTree.rebalanced(l2, v, intTree2, intTree);
    }

    IntTree<V> changeKeysAbove(long l, int n) {
        if (this.size == 0 || n == 0) {
            return this;
        }
        if (this.key >= l) {
            return new IntTree<V>(this.key + (long)n, this.value, this.left.changeKeysBelow(l - this.key, -n), this.right);
        }
        IntTree<V> intTree = this.right.changeKeysAbove(l - this.key, n);
        if (intTree == this.right) {
            return this;
        }
        return new IntTree<V>(this.key, this.value, this.left, intTree);
    }

    IntTree<V> changeKeysBelow(long l, int n) {
        if (this.size == 0 || n == 0) {
            return this;
        }
        if (this.key < l) {
            return new IntTree<V>(this.key + (long)n, this.value, this.left, this.right.changeKeysAbove(l - this.key, -n));
        }
        IntTree<V> intTree = this.left.changeKeysBelow(l - this.key, n);
        if (intTree == this.left) {
            return this;
        }
        return new IntTree<V>(this.key, this.value, intTree, this.right);
    }

    private long minKey() {
        if (this.left.size == 0) {
            return this.key;
        }
        return super.minKey() + this.key;
    }

    private IntTree<V> rebalanced(IntTree<V> intTree, IntTree<V> intTree2) {
        if (intTree == this.left && intTree2 == this.right) {
            return this;
        }
        return IntTree.rebalanced(this.key, this.value, intTree, intTree2);
    }

    private static <V> IntTree<V> rebalanced(long l, V v, IntTree<V> intTree, IntTree<V> intTree2) {
        if (intTree.size + intTree2.size > 1) {
            if (intTree.size >= 5 * intTree2.size) {
                IntTree<V> intTree3 = intTree.left;
                IntTree<V> intTree4 = intTree.right;
                if (intTree4.size < 2 * intTree3.size) {
                    return new IntTree<V>(intTree.key + l, intTree.value, intTree3, new IntTree<V>(-intTree.key, v, super.withKey(intTree4.key + intTree.key), intTree2));
                }
                IntTree<V> intTree5 = intTree4.left;
                IntTree<V> intTree6 = intTree4.right;
                return new IntTree<V>(intTree4.key + intTree.key + l, intTree4.value, new IntTree<V>(-intTree4.key, intTree.value, intTree3, super.withKey(intTree5.key + intTree4.key)), new IntTree<V>(-intTree.key - intTree4.key, v, super.withKey(intTree6.key + intTree4.key + intTree.key), intTree2));
            }
            if (intTree2.size >= 5 * intTree.size) {
                IntTree<V> intTree7 = intTree2.left;
                IntTree<V> intTree8 = intTree2.right;
                if (intTree7.size < 2 * intTree8.size) {
                    return new IntTree<V>(intTree2.key + l, intTree2.value, new IntTree<V>(-intTree2.key, v, intTree, super.withKey(intTree7.key + intTree2.key)), intTree8);
                }
                IntTree<V> intTree9 = intTree7.left;
                IntTree<V> intTree10 = intTree7.right;
                return new IntTree<V>(intTree7.key + intTree2.key + l, intTree7.value, new IntTree<V>(-intTree2.key - intTree7.key, v, intTree, super.withKey(intTree9.key + intTree7.key + intTree2.key)), new IntTree<V>(-intTree7.key, intTree2.value, super.withKey(intTree10.key + intTree7.key), intTree8));
            }
        }
        return new IntTree<V>(l, v, intTree, intTree2);
    }

    private static final class EntryIterator<V>
    implements Iterator<Map.Entry<Integer, V>> {
        private PStack<IntTree<V>> stack = ConsPStack.empty();
        private int key = 0;

        EntryIterator(IntTree<V> intTree) {
            this.gotoMinOf(intTree);
        }

        @Override
        public boolean hasNext() {
            return this.stack.size() > 0;
        }

        @Override
        public Map.Entry<Integer, V> next() {
            IntTree intTree = (IntTree)this.stack.get(0);
            SimpleImmutableEntry<Integer, Object> simpleImmutableEntry = new SimpleImmutableEntry<Integer, Object>(this.key, intTree.value);
            if (intTree.right.size > 0) {
                this.gotoMinOf(intTree.right);
            } else {
                while (true) {
                    this.key = (int)((long)this.key - intTree.key);
                    this.stack = this.stack.subList(1);
                    if (intTree.key < 0L || this.stack.size() == 0) break;
                    intTree = (IntTree)this.stack.get(0);
                }
            }
            return simpleImmutableEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void gotoMinOf(IntTree<V> intTree) {
            while (intTree.size > 0) {
                this.stack = this.stack.plus(intTree);
                this.key = (int)((long)this.key + intTree.key);
                intTree = intTree.left;
            }
        }
    }
}

