/*
 * Decompiled with CFR 0.152.
 */
package org.pcollections;

import java.util.Collection;
import java.util.Iterator;
import org.pcollections.Empty;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class OrderedPSet<E>
implements POrderedSet<E> {
    private static final OrderedPSet<Object> EMPTY = new OrderedPSet(Empty.set(), Empty.vector());
    private PSet<E> contents;
    private PVector<E> order;
    private int hashCode = 0;

    public static <E> OrderedPSet<E> empty() {
        return EMPTY;
    }

    public static <E> PSet<E> from(Collection<? extends E> collection) {
        if (collection instanceof OrderedPSet) {
            return (OrderedPSet)collection;
        }
        return OrderedPSet.empty().plusAll((Collection)collection);
    }

    public static <E> PSet<E> singleton(E e) {
        return OrderedPSet.empty().plus((Object)e);
    }

    private OrderedPSet(PSet<E> pSet, PVector<E> pVector) {
        this.contents = pSet;
        this.order = pVector;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0 && this.size() > 0) {
            for (Object e : this.order) {
                this.hashCode += e.hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        return this.contents.equals(object);
    }

    @Override
    public POrderedSet<E> plus(E e) {
        if (this.contents.contains(e)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.plus(e), this.order.plus(e));
    }

    @Override
    public POrderedSet<E> plusAll(Collection<? extends E> collection) {
        POrderedSet<E> pOrderedSet = this;
        for (E e : collection) {
            pOrderedSet = pOrderedSet.plus(e);
        }
        return pOrderedSet;
    }

    @Override
    public POrderedSet<E> minus(Object object) {
        if (!this.contents.contains(object)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.minus(object), this.order.minus(object));
    }

    @Override
    public POrderedSet<E> minusAll(Collection<?> collection) {
        POrderedSet<E> pOrderedSet = this;
        for (Object obj : collection) {
            pOrderedSet = pOrderedSet.minus(obj);
        }
        return pOrderedSet;
    }

    @Override
    public Iterator<E> iterator() {
        return this.order.iterator();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public E get(int n) {
        return this.order.get(n);
    }

    @Override
    public int indexOf(Object object) {
        if (!this.contents.contains(object)) {
            return -1;
        }
        return this.order.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    @Override
    public Object[] toArray() {
        return this.order.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.order.toArray(TArray);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.contents.containsAll(collection);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl = true;
        for (Object e : this.order) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(e);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

