/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DrawingPanel
extends JComponent {
    private static final long serialVersionUID = 1L;
    private transient RenderingHints antialiasOn;
    private BoundedRangeModel zoomLevelModel;
    private Rectangle2D boundingBox;
    private Dimension preferredSize;
    private double scale;
    private double pixelPerUnit;
    public static final int ZOOM_MAX = 160;
    public static final int ZOOM_INIT = 80;
    public static final int ZOOM_MIN = 0;
    public static final int CONTINUOUS_DRAG_DELAY = 20;
    private boolean positiveYAxis;
    private boolean centerDrawing;

    public BoundedRangeModel getZoomLevelModel() {
        return this.zoomLevelModel;
    }

    public DrawingPanel(boolean bl, boolean bl2) {
        this.centerDrawing = bl;
        this.positiveYAxis = bl2;
        this.pixelPerUnit = 1.0;
        this.antialiasOn = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.antialiasOn.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.zoomLevelModel = new DefaultBoundedRangeModel(80, 0, 0, 160);
        this.scale = 1.0;
        this.zoomLevelModel.setValue(80);
        this.zoomLevelModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DrawingPanel.this.setScale(DrawingPanel.this.zoomToScale(DrawingPanel.this.zoomLevelModel.getValue()));
            }
        });
        this.setBackground(UIManager.getColor("Panel.background"));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        graphics2D.setColor(this.getBackground());
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        graphics2D.translate(insets.left, insets.top);
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        Rectangle rectangle2 = graphics2D.getClipBounds();
        graphics2D.setClip(rectangle2 != null ? rectangle.intersection(rectangle2) : rectangle);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (this.centerDrawing) {
            graphics2D.translate((double)dimension.width / 2.0, (double)dimension.height / 2.0);
        } else {
            graphics2D.translate(0, this.positiveYAxis ? 0 : dimension.height);
        }
        graphics2D.scale(this.scale * this.pixelPerUnit, (this.positiveYAxis ? this.scale : -this.scale) * this.pixelPerUnit);
        if (this.centerDrawing) {
            graphics2D.translate(-this.boundingBox.getWidth() / 2.0, -this.boundingBox.getHeight() / 2.0);
        }
        graphics2D.setRenderingHints(this.antialiasOn);
        this.paintContent(graphics2D);
    }

    public Point screenToModel(Point point) {
        double d = point.x;
        double d2 = point.y;
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        d -= (double)insets.top;
        d2 -= (double)insets.top;
        if (this.centerDrawing) {
            d -= (double)dimension.width / 2.0;
            d2 -= (double)dimension.height / 2.0;
        } else {
            d2 -= this.positiveYAxis ? 0.0 : (double)dimension.height;
        }
        d /= this.scale * this.pixelPerUnit;
        d2 /= (this.positiveYAxis ? this.scale : -this.scale) * this.pixelPerUnit;
        if (this.centerDrawing) {
            d -= -this.boundingBox.getWidth() / 2.0;
            d2 -= -this.boundingBox.getHeight() / 2.0;
        }
        return new Point((int)d, (int)d2);
    }

    protected void paintContent(Graphics2D graphics2D) {
    }

    public double getPixelPerUnit() {
        return this.pixelPerUnit;
    }

    public void setPixelPerUnit(double d) {
        this.pixelPerUnit = d;
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(Rectangle2D rectangle2D) {
        this.boundingBox = rectangle2D;
        this.calculatePreferredSize();
    }

    private void calculatePreferredSize() {
        if (this.boundingBox == null) {
            throw new IllegalStateException("Bounding box has not been set");
        }
        this.preferredSize = new Dimension((int)Math.round(this.boundingBox.getWidth() * this.scale), (int)Math.round(this.boundingBox.getHeight() * this.scale));
        if (this.isVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.boundingBox == null) {
            throw new IllegalStateException("Bounding box has not been set");
        }
        assert (this.preferredSize != null);
        return this.preferredSize;
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        throw new UnsupportedOperationException("Preferred size is computed from boundingbox and scale");
    }

    public void zoomToFit(Dimension dimension) {
        if (this.boundingBox == null) {
            return;
        }
        Insets insets = this.getInsets();
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        double d = Math.min((double)n / this.boundingBox.getWidth(), (double)n2 / this.boundingBox.getHeight());
        this.zoomLevelModel.setValue(this.scaleToZoom(d));
    }

    private double zoomToScale(int n) {
        return Math.pow(10.0, (double)n / 40.0) / 100.0;
    }

    private void setScale(double d) {
        this.scale = d;
        this.calculatePreferredSize();
    }

    private int scaleToZoom(double d) {
        return Math.max(0, Math.min(160, (int)Math.floor(Math.log10(d * 100.0) * 40.0)));
    }

    public void zoomIn() {
        this.zoomLevelModel.setValue(this.zoomLevelModel.getValue() + 10);
    }

    public void zoomOut() {
        this.zoomLevelModel.setValue(this.zoomLevelModel.getValue() - 10);
    }
}

