/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.ist.utilities.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class XmlProcessor {
    private XMLStreamReader parser;
    private Stack<String> elementNameStack;
    private Stack<StringBuilder> elementContentStack;
    private final Set<String> ignoredElements = new TreeSet<String>();
    private int ignoreCounter;
    private String fileName;

    public void process(String string) throws FileNotFoundException, XMLStreamException {
        this.fileName = string;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        this.parser = xMLInputFactory.createXMLStreamReader(bufferedInputStream, "UTF-8");
        int n = this.parser.getEventType();
        while (n != 8) {
            switch (n) {
                case 7: {
                    this.startDocumentEvent();
                    break;
                }
                case 1: {
                    this.startElementEvent();
                    break;
                }
                case 2: {
                    this.endElementEvent();
                    break;
                }
                case 4: {
                    if (this.ignoreCounter != 0) break;
                    String string2 = this.parser.getText();
                    this.characters(string2);
                    this.elementContentStack.peek().append(string2);
                    break;
                }
            }
            n = this.parser.next();
        }
        this.endDocumentEvent();
    }

    private void startDocumentEvent() throws XMLStreamException {
        this.elementNameStack = new Stack();
        this.elementContentStack = new Stack();
        this.ignoreCounter = 0;
        this.startDocument();
    }

    private void endDocumentEvent() throws XMLStreamException {
        if (!this.elementNameStack.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Missing end tags for");
            String string = ": ";
            for (String string2 : this.elementNameStack) {
                stringBuilder.append(string).append(string2);
                string = ", ";
            }
            throw new XMLStreamException(stringBuilder.toString());
        }
        assert (this.ignoreCounter == 0);
        this.endDocument();
    }

    private void startElementEvent() throws XMLStreamException {
        QName qName = this.parser.getName();
        String string = qName.getPrefix() == null || qName.getPrefix().isEmpty() ? qName.getLocalPart() : qName.getPrefix() + ":" + qName.getLocalPart();
        this.elementNameStack.push(string);
        this.elementContentStack.push(new StringBuilder());
        if (this.ignoredElements.contains(string)) {
            ++this.ignoreCounter;
        }
        if (this.ignoreCounter == 0) {
            this.startElement(string);
        }
    }

    private void endElementEvent() throws XMLStreamException {
        QName qName = this.parser.getName();
        String string = qName.getPrefix() == null || qName.getPrefix().isEmpty() ? qName.getLocalPart() : qName.getPrefix() + ":" + qName.getLocalPart();
        if (this.elementNameStack.isEmpty()) {
            throw new XMLStreamException("Unexpected end element </" + string + "> in line " + this.parser.getLocation().getLineNumber());
        }
        String string2 = this.elementNameStack.peek();
        if (!string2.equals(string)) {
            throw new XMLStreamException("Element <" + string2 + "> is terminated by </" + string + "> in line " + this.parser.getLocation().getLineNumber());
        }
        if (this.ignoreCounter == 0) {
            this.endElement(string, this.elementContentStack.peek());
        }
        if (this.ignoredElements.contains(string)) {
            assert (this.ignoreCounter > 0);
            --this.ignoreCounter;
        }
        this.elementNameStack.pop();
        this.elementContentStack.pop();
    }

    protected void characters(String string) {
    }

    protected abstract void startElement(String var1) throws XMLStreamException;

    protected abstract void endElement(String var1, StringBuilder var2) throws XMLStreamException;

    protected abstract void startDocument() throws XMLStreamException;

    protected abstract void endDocument() throws XMLStreamException;

    protected String getAttribute(String string, String string2) throws XMLStreamException {
        return this.parser.getAttributeValue(this.parser.getNamespaceURI(string), string2);
    }

    protected Set<String> getAttributeNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = this.parser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.parser.getAttributePrefix(i);
            String string2 = this.parser.getAttributeLocalName(i);
            linkedHashSet.add(string == null || string.isEmpty() ? string2 : string + ":" + string2);
        }
        return linkedHashSet;
    }

    protected String getAttribute(String string) throws XMLStreamException {
        int n = string.indexOf(":");
        if (n >= 0) {
            if (n > 0) {
                return this.getAttribute(string.substring(0, n - 1), string.substring(n + 1));
            }
            string = string.substring(n + 1);
        }
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            if (this.parser.getAttributeNamespace(i) != null && !"".equals(this.parser.getAttributeNamespace(i)) || !string.equals(this.parser.getAttributeLocalName(i))) continue;
            return this.parser.getAttributeValue(i);
        }
        return null;
    }

    protected void addIgnoredElements(String ... stringArray) {
        for (String string : stringArray) {
            if (string == null || (string = string.trim()).length() <= 0) continue;
            this.ignoredElements.add(string);
        }
    }

    public int getNestingDepth() {
        return this.elementNameStack.size();
    }

    public String getFilename() {
        return this.fileName;
    }

    public Stack<String> getElementNameStack() {
        return this.elementNameStack;
    }

    public XMLStreamReader getParser() {
        return this.parser;
    }
}

