/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.algorithms.strong_components;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.algolib.algorithms.AlgorithmTerminatedException;
import de.uni_koblenz.jgralab.algolib.algorithms.GraphAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.StructureOrientedAlgorithm;
import de.uni_koblenz.jgralab.algolib.algorithms.search.DepthFirstSearch;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.DFSVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.search.visitors.DFSVisitorAdapter;
import de.uni_koblenz.jgralab.algolib.algorithms.strong_components.visitors.ReducedGraphVisitor;
import de.uni_koblenz.jgralab.algolib.algorithms.strong_components.visitors.ReducedGraphVisitorList;
import de.uni_koblenz.jgralab.algolib.functions.BooleanFunction;
import de.uni_koblenz.jgralab.algolib.functions.Function;
import de.uni_koblenz.jgralab.algolib.functions.IntFunction;
import de.uni_koblenz.jgralab.algolib.problems.StrongComponentsSolver;
import de.uni_koblenz.jgralab.algolib.visitors.Visitor;
import de.uni_koblenz.jgralab.graphmarker.ArrayVertexMarker;
import de.uni_koblenz.jgralab.graphmarker.IntegerVertexMarker;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class StrongComponentsWithDFS
extends StructureOrientedAlgorithm
implements StrongComponentsSolver {
    private DepthFirstSearch dfs;
    private Stack<Vertex> vertexStack;
    private DFSVisitor lowlinkVisitor;
    private IntFunction<Vertex> lowlink;
    private Function<Vertex, Vertex> strongComponents;
    private Function<Vertex, Set<Vertex>> inverseResult;
    private ReducedGraphVisitorList visitors;

    public StrongComponentsWithDFS(Graph graph, DepthFirstSearch depthFirstSearch) {
        this(graph, depthFirstSearch, null);
    }

    public StrongComponentsWithDFS(Graph graph, DepthFirstSearch depthFirstSearch, BooleanFunction<Edge> booleanFunction) {
        super(graph, booleanFunction);
        this.dfs = depthFirstSearch;
    }

    @Override
    public void addVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof ReducedGraphVisitor) {
            visitor.setAlgorithm(this);
            this.visitors.addVisitor(visitor);
        } else {
            this.dfs.addVisitor(visitor);
        }
    }

    @Override
    public void disableOptionalResults() {
        this.checkStateForSettingParameters();
        this.inverseResult = null;
    }

    @Override
    protected void done() {
        this.state = this.dfs.getState();
    }

    @Override
    public StrongComponentsWithDFS normal() {
        super.normal();
        return this;
    }

    @Override
    public StructureOrientedAlgorithm reversed() {
        super.reversed();
        return this;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public boolean isHybrid() {
        return false;
    }

    public StrongComponentsWithDFS withInverseResult() {
        this.checkStateForSettingParameters();
        this.inverseResult = new ArrayVertexMarker<Set<Vertex>>(this.graph);
        return this;
    }

    public StrongComponentsWithDFS withoutInverseResult() {
        this.checkStateForSettingParameters();
        this.inverseResult = null;
        return this;
    }

    @Override
    public void removeVisitor(Visitor visitor) {
        this.checkStateForSettingVisitors();
        if (visitor instanceof ReducedGraphVisitor) {
            this.visitors.removeVisitor(visitor);
        } else {
            this.dfs.removeVisitor(visitor);
        }
    }

    @Override
    public Function<Vertex, Vertex> getStrongComponents() {
        this.checkStateForResult();
        return this.strongComponents;
    }

    public Function<Vertex, Set<Vertex>> getInverseResult() {
        this.checkStateForResult();
        return this.inverseResult;
    }

    public IntFunction<Vertex> getLowlink() {
        this.checkStateForResult();
        return this.lowlink;
    }

    @Override
    public void resetParameters() {
        super.resetParameters();
        this.vertexStack = new Stack();
        this.visitors = new ReducedGraphVisitorList();
        this.inverseResult = null;
        this.lowlinkVisitor = new DFSVisitorAdapter(){
            private IntFunction<Vertex> number;

            @Override
            public void setAlgorithm(GraphAlgorithm graphAlgorithm) {
                super.setAlgorithm(graphAlgorithm);
                this.number = this.dfsAlgorithm.getInternalNumber();
            }

            @Override
            public void visitVertex(Vertex vertex) {
                StrongComponentsWithDFS.this.vertexStack.push(vertex);
                StrongComponentsWithDFS.this.lowlink.set(vertex, this.number.get(vertex));
            }

            public void maybeVisitReducedEdge(Edge edge) {
                if (StrongComponentsWithDFS.this.strongComponents.isDefined(edge.getThat())) {
                    StrongComponentsWithDFS.this.visitors.visitReducedEdge(edge);
                }
            }

            @Override
            public void leaveTreeEdge(Edge edge) {
                Vertex vertex = edge.getThis();
                Vertex vertex2 = edge.getThat();
                StrongComponentsWithDFS.this.lowlink.set(vertex, Math.min(StrongComponentsWithDFS.this.lowlink.get(vertex), StrongComponentsWithDFS.this.lowlink.get(vertex2)));
                this.maybeVisitReducedEdge(edge);
            }

            @Override
            public void visitForwardArc(Edge edge) {
                this.maybeVisitReducedEdge(edge);
            }

            @Override
            public void visitBackwardArc(Edge edge) {
                Vertex vertex = edge.getThis();
                Vertex vertex2 = edge.getThat();
                StrongComponentsWithDFS.this.lowlink.set(vertex, Math.min(StrongComponentsWithDFS.this.lowlink.get(vertex), this.number.get(vertex2)));
            }

            @Override
            public void visitCrosslink(Edge edge) {
                Vertex vertex = edge.getThis();
                Vertex vertex2 = edge.getThat();
                if (StrongComponentsWithDFS.this.vertexStack.contains(vertex2)) {
                    StrongComponentsWithDFS.this.lowlink.set(vertex, Math.min(StrongComponentsWithDFS.this.lowlink.get(vertex), this.number.get(vertex2)));
                }
                this.maybeVisitReducedEdge(edge);
            }

            @Override
            public void leaveVertex(Vertex vertex) {
                if (StrongComponentsWithDFS.this.lowlink.get(vertex) == this.number.get(vertex)) {
                    Vertex vertex2;
                    HashSet<Vertex> hashSet = null;
                    if (StrongComponentsWithDFS.this.inverseResult != null) {
                        assert (StrongComponentsWithDFS.this.inverseResult.get(vertex) == null);
                        hashSet = new HashSet<Vertex>();
                        StrongComponentsWithDFS.this.inverseResult.set(vertex, hashSet);
                    }
                    do {
                        vertex2 = (Vertex)StrongComponentsWithDFS.this.vertexStack.pop();
                        StrongComponentsWithDFS.this.strongComponents.set(vertex2, vertex);
                        if (hashSet == null) continue;
                        hashSet.add(vertex2);
                    } while (vertex2 != vertex);
                    StrongComponentsWithDFS.this.visitors.visitRepresentativeVertex(vertex);
                }
            }
        };
    }

    @Override
    public void reset() {
        super.reset();
        this.lowlink = new IntegerVertexMarker(this.graph);
        this.strongComponents = new ArrayVertexMarker<Vertex>(this.graph);
        this.inverseResult = this.inverseResult == null ? null : new ArrayVertexMarker(this.graph);
        this.vertexStack.clear();
    }

    @Override
    public StrongComponentsSolver execute() throws AlgorithmTerminatedException {
        this.dfs.reset();
        this.dfs.setGraph(this.graph);
        this.dfs.setNavigable(this.navigable);
        this.dfs.setTraversalDirection(this.traversalDirection);
        this.dfs.addVisitor(this.lowlinkVisitor);
        try {
            this.startRunning();
            this.dfs.execute();
        }
        catch (AlgorithmTerminatedException algorithmTerminatedException) {
            // empty catch block
        }
        this.done();
        this.dfs.removeVisitor(this.lowlinkVisitor);
        return this;
    }

    public IntFunction<Vertex> getInternalLowlink() {
        return this.lowlink;
    }

    public Function<Vertex, Vertex> getInternalStrongComponents() {
        return this.strongComponents;
    }

    public Function<Vertex, Set<Vertex>> getInternalInverseResult() {
        return this.inverseResult;
    }

    public Stack<Vertex> getVertexStack() {
        return this.vertexStack;
    }
}

