/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.algolib.util;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class PriorityQueue<T> {
    private Queue<ValuePair<T>> queue;
    private Comparator<ValuePair<T>> comparator = new Comparator<ValuePair<T>>(){

        @Override
        public int compare(ValuePair<T> valuePair, ValuePair<T> valuePair2) {
            return Double.compare(valuePair.value, valuePair2.value);
        }
    };

    public PriorityQueue() {
        this.queue = new java.util.PriorityQueue<ValuePair<T>>(31, this.comparator);
    }

    public T getNext() {
        ValuePair<T> valuePair = this.queue.poll();
        if (valuePair == null) {
            throw new NoSuchElementException("Priority queue is empty.");
        }
        return valuePair.element;
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void put(T t, double d) {
        ValuePair<T> valuePair = new ValuePair<T>(t, d);
        this.queue.add(valuePair);
    }

    public int size() {
        return this.queue.size();
    }

    public PriorityQueue<T> clear() {
        this.queue.clear();
        return this;
    }

    private static class ValuePair<T> {
        public T element;
        public double value;

        public ValuePair(T t, double d) {
            this.set(t, d);
        }

        public ValuePair<T> set(T t, double d) {
            this.element = t;
            this.value = d;
            return this;
        }
    }
}

