/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.AbstractBooleanGraphMarker;
import de.uni_koblenz.jgralab.impl.ReversedEdgeBaseImpl;
import java.util.HashSet;

public class BooleanGraphMarker
extends AbstractBooleanGraphMarker {
    private final HashSet<GraphElement<?, ?>> markedElements = new HashSet();

    public BooleanGraphMarker(Graph graph) {
        super(graph);
    }

    @Override
    public final boolean isMarked(GraphElement<?, ?> edge) {
        assert (edge.getGraph() == this.graph);
        if (edge instanceof ReversedEdgeBaseImpl) {
            edge = ((ReversedEdgeBaseImpl)edge).getNormalEdge();
        }
        return this.markedElements.contains(edge);
    }

    @Override
    public final boolean mark(GraphElement<?, ?> edge) {
        assert (edge.getGraph() == this.graph);
        if (edge instanceof ReversedEdgeBaseImpl) {
            edge = ((ReversedEdgeBaseImpl)edge).getNormalEdge();
        }
        return this.markedElements.add(edge);
    }

    @Override
    public final boolean removeMark(GraphElement<?, ?> edge) {
        assert (edge.getGraph() == this.graph);
        if (edge instanceof ReversedEdgeBaseImpl) {
            edge = ((ReversedEdgeBaseImpl)edge).getNormalEdge();
        }
        return this.markedElements.remove(edge);
    }

    @Override
    public Iterable<GraphElement<?, ?>> getMarkedElements() {
        return this.markedElements;
    }

    @Override
    public int size() {
        return this.markedElements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.markedElements.isEmpty();
    }

    @Override
    public void clear() {
        this.markedElements.clear();
    }

    @Override
    public void edgeDeleted(Edge edge) {
        this.markedElements.remove(edge);
    }

    @Override
    public void vertexDeleted(Vertex vertex) {
        this.markedElements.remove(vertex);
    }
}

