/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.graphmarker;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.ArrayGraphMarkerIterator;
import de.uni_koblenz.jgralab.graphmarker.LongGraphMarker;
import de.uni_koblenz.jgralab.impl.InternalGraph;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongEdgeMarker
extends LongGraphMarker<Edge> {
    public LongEdgeMarker(Graph graph) {
        super(graph, ((InternalGraph)graph).getMaxECount() + 1);
    }

    @Override
    public void edgeDeleted(Edge edge) {
        this.removeMark(edge.getNormalEdge());
    }

    @Override
    public void maxEdgeCountIncreased(int n) {
        if (++n > this.temporaryAttributes.length) {
            this.expand(n);
        }
    }

    @Override
    public void maxVertexCountIncreased(int n) {
    }

    @Override
    public void vertexDeleted(Vertex vertex) {
    }

    @Override
    public long mark(Edge edge, long l) {
        return super.mark(edge.getNormalEdge(), l);
    }

    @Override
    public boolean isMarked(Edge edge) {
        return super.isMarked(edge.getNormalEdge());
    }

    @Override
    public long getMark(Edge edge) {
        return super.getMark(edge.getNormalEdge());
    }

    @Override
    public Iterable<Edge> getMarkedElements() {
        return new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return new ArrayGraphMarkerIterator<Edge>(LongEdgeMarker.this.version){

                    @Override
                    public boolean hasNext() {
                        return this.index < LongEdgeMarker.this.temporaryAttributes.length;
                    }

                    @Override
                    protected void moveIndex() {
                        int n = LongEdgeMarker.this.temporaryAttributes.length;
                        while (this.index < n && LongEdgeMarker.this.temporaryAttributes[this.index] == LongEdgeMarker.this.unmarkedValue) {
                            ++this.index;
                        }
                    }

                    @Override
                    public Edge next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException(NO_MORE_ELEMENTS_ERROR_MESSAGE);
                        }
                        if (this.version != LongEdgeMarker.this.version) {
                            throw new ConcurrentModificationException(MODIFIED_ERROR_MESSAGE);
                        }
                        Edge edge = LongEdgeMarker.this.graph.getEdge(this.index++);
                        this.moveIndex();
                        return edge;
                    }
                };
            }
        };
    }
}

