/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Vertex;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.pcollections.PSet;

public class GraphIndex {
    private int indexSize;
    private Graph graph;
    private int graphSize;
    private long graphVersion;
    private HashMap<String, VertexIndexEntry> vertexIndex;

    public GraphIndex(Graph graph) {
        this.graph = graph;
        this.graphVersion = graph.getGraphVersion();
        this.graphSize = graph.getECount() + graph.getVCount();
        this.vertexIndex = new HashMap();
    }

    public boolean isValid(Graph graph) {
        return graph == this.graph && !graph.isGraphModified(this.graphVersion);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void addVertexSet(String string, PSet<Vertex> pSet) {
        this.vertexIndex.put(string, new VertexIndexEntry(pSet));
        this.indexSize += pSet.size();
        this.reduceIndexSize(this.graphSize);
    }

    public PSet<Vertex> getVertexSet(String string) {
        VertexIndexEntry vertexIndexEntry = this.vertexIndex.get(string);
        if (vertexIndexEntry != null) {
            vertexIndexEntry.modified();
            return vertexIndexEntry.vertexSet;
        }
        return null;
    }

    public void reduceIndexSize(long l) {
        if ((long)this.indexSize <= l) {
            return;
        }
        TreeSet<Map.Entry<String, VertexIndexEntry>> treeSet = new TreeSet<Map.Entry<String, VertexIndexEntry>>(new Comparator<Map.Entry<String, VertexIndexEntry>>(){

            @Override
            public int compare(Map.Entry<String, VertexIndexEntry> entry, Map.Entry<String, VertexIndexEntry> entry2) {
                return (int)(entry.getValue().modificationTime - entry2.getValue().modificationTime);
            }
        });
        treeSet.addAll(this.vertexIndex.entrySet());
        Iterator<Map.Entry<String, VertexIndexEntry>> iterator = treeSet.iterator();
        while (iterator.hasNext() && (long)this.indexSize > l) {
            Map.Entry<String, VertexIndexEntry> entry = iterator.next();
            this.indexSize -= entry.getValue().vertexSet.size();
            this.vertexIndex.remove(entry.getKey());
        }
    }

    private static class VertexIndexEntry {
        public long modificationTime = 0L;
        public PSet<Vertex> vertexSet = null;

        public VertexIndexEntry(PSet<Vertex> pSet) {
            this.vertexSet = pSet;
            this.modificationTime = System.currentTimeMillis();
        }

        public void modified() {
            this.modificationTime = System.currentTimeMillis();
        }
    }
}

