/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator;

import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlSchema;
import java.io.File;
import java.util.logging.Logger;

public class SyntaxGraphEntry {
    private final GreqlGraph syntaxGraph;
    private static Logger logger = Logger.getLogger(SyntaxGraphEntry.class.getName());
    private Optimizer optimizer;
    private String queryText;

    public GreqlGraph getSyntaxGraph() {
        return this.syntaxGraph;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public SyntaxGraphEntry(String string, GreqlGraph greqlGraph, Optimizer optimizer) {
        this.queryText = string;
        this.syntaxGraph = greqlGraph;
        this.optimizer = optimizer;
    }

    public SyntaxGraphEntry(File file) throws GraphIOException {
        this.syntaxGraph = GreqlSchema.instance().loadGreqlGraph(file.getPath());
        GreqlExpression greqlExpression = this.syntaxGraph.getFirstGreqlExpression();
        try {
            this.queryText = (String)greqlExpression.getAttribute("_queryText");
            String string = (String)greqlExpression.getAttribute("_optimizer");
            if (!string.isEmpty()) {
                this.optimizer = (Optimizer)Class.forName(string).newInstance();
            }
            greqlExpression.setAttribute("_queryText", null);
            greqlExpression.setAttribute("_optimizer", null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GraphIOException(exception.getMessage());
        }
    }

    public void saveToDirectory(File file) throws GraphIOException {
        String string = "";
        String string2 = "";
        GreqlExpression greqlExpression = this.syntaxGraph.getFirstGreqlExpression();
        greqlExpression.set_queryText(this.queryText);
        if (this.optimizer != null) {
            string = this.optimizer.getClass().getName();
            string2 = this.optimizer.getClass().getSimpleName();
        }
        greqlExpression.set_optimizer(string);
        String string3 = file.getPath() + File.separator + this.queryText.hashCode() + "-" + string2 + ".tg";
        this.syntaxGraph.save(string3);
        logger.info("Saved SyntaxGraphEntry to \"" + string3 + "\".");
    }

    public boolean equals(Object object) {
        if (object instanceof SyntaxGraphEntry) {
            SyntaxGraphEntry syntaxGraphEntry = (SyntaxGraphEntry)object;
            return this.queryText.equals(syntaxGraphEntry.queryText) && this.optimizer.getClass().equals(syntaxGraphEntry.optimizer.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.queryText.hashCode() + this.optimizer.getClass().hashCode();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public String toString() {
        return "{SyntaxGraphEntry@" + this.syntaxGraph.hashCode() + ":" + this.optimizer.getClass().getSimpleName() + "}";
    }
}

