/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.fa;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.ThisEdgeEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import java.util.Set;

public class AggregationTransition
extends Transition {
    private final VertexEvaluator<? extends Expression> predicateEvaluator;
    private ThisEdgeEvaluator thisEdgeEvaluator;
    protected TypeCollection typeCollection;
    protected Set<String> validToEdgeRoles;
    protected Set<String> validFromEdgeRoles;
    protected boolean aggregateFrom;

    public VertexEvaluator<? extends Expression> getPredicateEvaluator() {
        return this.predicateEvaluator;
    }

    public TypeCollection getTypeCollection() {
        return this.typeCollection;
    }

    public Set<String> getValidToRoles() {
        return this.validToEdgeRoles;
    }

    public Set<String> getValidFromRoles() {
        return this.validFromEdgeRoles;
    }

    public boolean isAggregateFrom() {
        return this.aggregateFrom;
    }

    @Override
    public String edgeString() {
        String string = "AggregationTransition (aggregateFrom:" + this.aggregateFrom;
        if (this.typeCollection != null) {
            string = string + "\n " + this.typeCollection.toString() + "\n ";
        }
        string = string + ")";
        return string;
    }

    @Override
    public boolean equalSymbol(Transition transition) {
        if (!(transition instanceof AggregationTransition)) {
            return false;
        }
        AggregationTransition aggregationTransition = (AggregationTransition)transition;
        if (!this.typeCollection.equals(aggregationTransition.typeCollection)) {
            return false;
        }
        if (this.aggregateFrom != aggregationTransition.aggregateFrom) {
            return false;
        }
        if (this.validToEdgeRoles != null) {
            if (aggregationTransition.validToEdgeRoles == null) {
                return false;
            }
            if (!this.validToEdgeRoles.equals(aggregationTransition.validToEdgeRoles)) {
                return false;
            }
        } else if (aggregationTransition.validToEdgeRoles != null) {
            return false;
        }
        if (this.validFromEdgeRoles != null) {
            if (aggregationTransition.validFromEdgeRoles == null) {
                return false;
            }
            if (!this.validFromEdgeRoles.equals(aggregationTransition.validFromEdgeRoles)) {
                return false;
            }
        } else if (aggregationTransition.validFromEdgeRoles != null) {
            return false;
        }
        if (this.predicateEvaluator != null) {
            if (aggregationTransition.predicateEvaluator == null) {
                return false;
            }
            if (!this.predicateEvaluator.equals(aggregationTransition.predicateEvaluator)) {
                return false;
            }
        } else if (aggregationTransition.predicateEvaluator != null) {
            return false;
        }
        return true;
    }

    protected AggregationTransition(AggregationTransition aggregationTransition, boolean bl) {
        super(aggregationTransition, bl);
        this.aggregateFrom = aggregationTransition.aggregateFrom;
        this.typeCollection = aggregationTransition.typeCollection;
        this.validToEdgeRoles = aggregationTransition.validToEdgeRoles;
        this.predicateEvaluator = aggregationTransition.predicateEvaluator;
        this.thisEdgeEvaluator = aggregationTransition.thisEdgeEvaluator;
        this.validToEdgeRoles = aggregationTransition.validToEdgeRoles;
        this.validFromEdgeRoles = aggregationTransition.validFromEdgeRoles;
    }

    @Override
    public Transition copy(boolean bl) {
        return new AggregationTransition(this, bl);
    }

    public AggregationTransition(State state, State state2, boolean bl, TypeCollection typeCollection, Set<String> set, VertexEvaluator<? extends Expression> vertexEvaluator, GreqlQueryImpl greqlQueryImpl) {
        super(state, state2);
        this.aggregateFrom = bl;
        this.validToEdgeRoles = set;
        this.validFromEdgeRoles = null;
        this.typeCollection = typeCollection;
        this.predicateEvaluator = vertexEvaluator;
        ThisEdge thisEdge = (ThisEdge)greqlQueryImpl.getQueryGraph().getFirstVertex(ThisEdge.VC);
        if (thisEdge != null) {
            this.thisEdgeEvaluator = (ThisEdgeEvaluator)greqlQueryImpl.getVertexEvaluator(thisEdge);
        }
    }

    @Override
    public void reverse() {
        super.reverse();
        this.aggregateFrom = !this.aggregateFrom;
        Set<String> set = this.validFromEdgeRoles;
        this.validFromEdgeRoles = this.validToEdgeRoles;
        this.validToEdgeRoles = set;
    }

    @Override
    public boolean isEpsilon() {
        return false;
    }

    @Override
    public boolean accepts(Vertex vertex, Edge edge, InternalGreqlEvaluator internalGreqlEvaluator) {
        Object object;
        if (edge == null) {
            return false;
        }
        if (this.aggregateFrom ? edge.getThatAggregationKind() == AggregationKind.NONE : edge.getThisAggregationKind() == AggregationKind.NONE) {
            return false;
        }
        Set<String> set = this.validToEdgeRoles;
        boolean bl = true;
        if (set == null) {
            set = this.validFromEdgeRoles;
            bl = false;
        }
        boolean bl2 = set != null && this.typeCollection.isEmpty();
        boolean bl3 = false;
        if (set != null) {
            object = edge.getAttributedElementClass();
            Set<String> set2 = null;
            set2 = edge.isNormal() == bl ? object.getTo().getAllRoles() : object.getFrom().getAllRoles();
            for (String string : set2) {
                if (!set.contains(string)) continue;
                bl3 = true;
                break;
            }
        }
        if (bl2 ? !bl3 : !bl3 && !this.typeCollection.acceptsType((GraphElementClass<?, ?>)(object = edge.getAttributedElementClass()))) {
            return false;
        }
        if (this.predicateEvaluator != null) {
            this.thisEdgeEvaluator.setValue(edge, internalGreqlEvaluator);
            object = this.predicateEvaluator.getResult(internalGreqlEvaluator);
            return object instanceof Boolean && ((Boolean)object).equals(Boolean.TRUE);
        }
        return true;
    }

    @Override
    public Vertex getNextVertex(Vertex vertex, Edge edge) {
        return edge.getThat();
    }

    @Override
    public String prettyPrint() {
        String string = "--<>";
        if (this.aggregateFrom) {
            string = "<>--";
        }
        return string + this.typeCollection.toString();
    }

    @Override
    public boolean consumesEdge() {
        return true;
    }
}

