/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.executable;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.ProgressFunction;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.executable.ExecutableQuery;
import de.uni_koblenz.jgralab.greql.schema.Direction;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.Schema;
import java.util.BitSet;

public abstract class AbstractExecutableQuery
extends GreqlQuery
implements ExecutableQuery {
    protected static boolean checkDirection(Edge edge, Direction direction) {
        if (direction.get_dirValue().equals((Object)GReQLDirection.IN)) {
            return edge.isNormal();
        }
        return !edge.isNormal();
    }

    protected BitSet bindIncidenceClassesToSchema(Schema schema, String[] stringArray, boolean[] blArray) {
        assert (stringArray.length == blArray.length);
        BitSet bitSet = new BitSet();
        for (int i = 0; i < stringArray.length; ++i) {
            EdgeClass edgeClass = schema.getGraphClass().getEdgeClass(stringArray[i]);
            IncidenceClass incidenceClass = blArray[i] ? edgeClass.getFrom() : edgeClass.getTo();
            bitSet.set(incidenceClass.getIncidenceClassIdInSchema());
        }
        return bitSet;
    }

    @Override
    public Object execute(Graph graph) {
        return this.execute(graph, new GreqlEnvironmentAdapter());
    }

    @Override
    public GreqlGraph getQueryGraph() {
        throw new UnsupportedOperationException("This method is not available for generated queries.");
    }

    @Override
    public GreqlExpression getRootExpression() {
        throw new UnsupportedOperationException("This method is not available for generated queries.");
    }

    @Override
    public Object evaluate() {
        return this.execute(null);
    }

    @Override
    public Object evaluate(Graph graph) {
        return this.execute(graph);
    }

    @Override
    public Object evaluate(Graph graph, GreqlEnvironment greqlEnvironment) {
        return this.execute(graph, greqlEnvironment);
    }

    @Override
    public Object evaluate(Graph graph, ProgressFunction progressFunction) {
        if (progressFunction != null) {
            throw new UnsupportedOperationException("This method is not available for generated queries.");
        }
        return this.execute(graph);
    }

    @Override
    public Object evaluate(Graph graph, GreqlEnvironment greqlEnvironment, ProgressFunction progressFunction) {
        if (progressFunction != null) {
            throw new UnsupportedOperationException("This method is not available for generated queries.");
        }
        return this.execute(graph, greqlEnvironment);
    }
}

