/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.executable;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.greql.executable.PathSystemMarkerEntry;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class ExecutablePathSystemHelper {
    public static PathSystem createPathSystemFromMarkings(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, Set<PathSystemMarkerEntry> set) {
        PathSystem pathSystem = new PathSystem();
        HashMap<Vertex, PathSystem.PathSystemNode[]> hashMap = new HashMap<Vertex, PathSystem.PathSystemNode[]>();
        HashMap<Vertex, PathSystemMarkerEntry[]> hashMap2 = new HashMap<Vertex, PathSystemMarkerEntry[]>();
        LinkedList<PathSystem.PathSystemNode> linkedList = new LinkedList<PathSystem.PathSystemNode>();
        PathSystemMarkerEntry pathSystemMarkerEntry = (PathSystemMarkerEntry)graphMarkerArray[0].getMark(vertex);
        PathSystem.PathSystemNode pathSystemNode = pathSystem.setRootVertex(vertex, pathSystemMarkerEntry.stateNumber, pathSystemMarkerEntry.stateIsFinal);
        PathSystem.PathSystemNode[] pathSystemNodeArray = new PathSystem.PathSystemNode[graphMarkerArray.length];
        pathSystemNodeArray[pathSystemMarkerEntry.stateNumber] = pathSystemNode;
        hashMap.put(vertex, pathSystemNodeArray);
        for (PathSystemMarkerEntry pathSystemMarkerEntry2 : set) {
            Vertex vertex2 = pathSystemMarkerEntry2.vertex;
            while (vertex2 != null) {
                PathSystemMarkerEntry[] pathSystemMarkerEntryArray;
                PathSystem.PathSystemNode pathSystemNode2 = ExecutablePathSystemHelper.addVertexToPathSystem(pathSystem, hashMap, graphMarkerArray.length, vertex2, pathSystemMarkerEntry2.stateNumber, pathSystemMarkerEntry2.stateIsFinal);
                if (pathSystemMarkerEntry2.edgeToParentVertex != null) {
                    pathSystemMarkerEntryArray = ExecutablePathSystemHelper.addVertexToPathSystem(pathSystem, hashMap, graphMarkerArray.length, pathSystemMarkerEntry2.parentVertex, pathSystemMarkerEntry2.parentStateNumber, false);
                    pathSystem.addEdge(pathSystemNode2, (PathSystem.PathSystemNode)pathSystemMarkerEntryArray, pathSystemMarkerEntry2.edgeToParentVertex);
                } else if (!(vertex2 == pathSystem.getRootVertex() && pathSystemMarkerEntry2.distanceToRoot == 0 || linkedList.contains(pathSystemNode2))) {
                    linkedList.add(pathSystemNode2);
                    pathSystemMarkerEntryArray = (PathSystemMarkerEntry[])hashMap2.get(vertex2);
                    if (pathSystemMarkerEntryArray == null) {
                        pathSystemMarkerEntryArray = new PathSystemMarkerEntry[graphMarkerArray.length];
                        hashMap2.put(vertex2, pathSystemMarkerEntryArray);
                    }
                    assert (pathSystemMarkerEntryArray[pathSystemMarkerEntry2.stateNumber] == null) : "already exiting:" + pathSystemMarkerEntryArray[pathSystemMarkerEntry2.stateNumber] + " new: " + pathSystemMarkerEntry2;
                    pathSystemMarkerEntryArray[pathSystemMarkerEntry2.stateNumber] = pathSystemMarkerEntry2;
                }
                vertex2 = pathSystemMarkerEntry2.parentVertex;
                pathSystemMarkerEntry2 = ExecutablePathSystemHelper.getMarkerWithState(graphMarkerArray, vertex2, pathSystemMarkerEntry2.parentStateNumber);
            }
        }
        ExecutablePathSystemHelper.completePathSystem(pathSystem, linkedList, hashMap2, hashMap);
        pathSystem.finish();
        return pathSystem;
    }

    private static PathSystem.PathSystemNode addVertexToPathSystem(PathSystem pathSystem, Map<Vertex, PathSystem.PathSystemNode[]> map, int n, Vertex vertex, int n2, boolean bl) {
        PathSystem.PathSystemNode pathSystemNode;
        PathSystem.PathSystemNode[] pathSystemNodeArray = map.get(vertex);
        if (pathSystemNodeArray == null) {
            pathSystemNodeArray = new PathSystem.PathSystemNode[n];
            map.put(vertex, pathSystemNodeArray);
        } else {
            pathSystemNode = pathSystemNodeArray[n2];
            if (pathSystemNode != null) {
                if (bl) {
                    pathSystem.addLeaf(pathSystemNode);
                }
                return pathSystemNode;
            }
        }
        pathSystemNodeArray[n2] = pathSystemNode = pathSystem.addVertex(vertex, n2, bl);
        return pathSystemNode;
    }

    private static void completePathSystem(PathSystem pathSystem, Queue<PathSystem.PathSystemNode> queue, Map<Vertex, PathSystemMarkerEntry[]> map, Map<Vertex, PathSystem.PathSystemNode[]> map2) {
        while (!queue.isEmpty()) {
            PathSystem.PathSystemNode pathSystemNode = queue.poll();
            PathSystem.PathSystemNode pathSystemNode2 = null;
            PathSystemMarkerEntry[] pathSystemMarkerEntryArray = map.get(pathSystemNode.currentVertex);
            assert (pathSystemMarkerEntryArray != null);
            pathSystemNode2 = pathSystemMarkerEntryArray[pathSystemNode.state] != null ? map2.get(pathSystemMarkerEntryArray[pathSystemNode.state].parentVertex)[pathSystemMarkerEntryArray[pathSystemNode.state].parentStateNumber] : pathSystem.getRoot();
            if (pathSystemNode2 == null) continue;
            Set<PathSystem.PathSystemNode> set = pathSystem.getParents(pathSystemNode2);
            assert (set.size() <= 1);
            for (PathSystem.PathSystemNode pathSystemNode3 : set) {
                pathSystem.addEdge(pathSystemNode, pathSystemNode3, pathSystemNode2.edge2parent);
            }
        }
    }

    private static PathSystemMarkerEntry getMarkerWithState(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, int n) {
        if (vertex == null) {
            return null;
        }
        GraphMarker<PathSystemMarkerEntry> graphMarker = graphMarkerArray[n];
        PathSystemMarkerEntry pathSystemMarkerEntry = (PathSystemMarkerEntry)graphMarker.getMark(vertex);
        return pathSystemMarkerEntry;
    }

    public static PathSystemMarkerEntry markVertex(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, int n, boolean bl, Vertex vertex2, Edge edge, int n2, int n3) {
        PathSystemMarkerEntry pathSystemMarkerEntry = new PathSystemMarkerEntry(vertex, vertex2, edge, n, bl, n2, n3);
        GraphMarker<PathSystemMarkerEntry> graphMarker = graphMarkerArray[n];
        graphMarker.mark(vertex, pathSystemMarkerEntry);
        return pathSystemMarkerEntry;
    }

    public static boolean isMarked(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, int n) {
        GraphMarker<PathSystemMarkerEntry> graphMarker = graphMarkerArray[n];
        return graphMarker.isMarked(vertex);
    }
}

