/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.executable;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEvaluatorImpl;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.AggregationTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.BoolExpressionTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.EdgeTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.IntermediateVertexTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.SimpleTransition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.evaluator.fa.VertexTypeRestrictionTransition;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.executable.ExecutableQuery;
import de.uni_koblenz.jgralab.greql.executable.Scope;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.DefaultOptimizerInfo;
import de.uni_koblenz.jgralab.greql.schema.BackwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.DoubleLiteral;
import de.uni_koblenz.jgralab.greql.schema.EdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.EdgeSetExpression;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ExpressionDefinedSubgraph;
import de.uni_koblenz.jgralab.greql.schema.ForwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IntLiteral;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsIdOfStoreClause;
import de.uni_koblenz.jgralab.greql.schema.IsKeyExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.IsPartOf;
import de.uni_koblenz.jgralab.greql.schema.IsQueryExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordElementOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsTableHeaderOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfFunction;
import de.uni_koblenz.jgralab.greql.schema.IsTypeRestrOfExpression;
import de.uni_koblenz.jgralab.greql.schema.IsValueExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.ListComprehension;
import de.uni_koblenz.jgralab.greql.schema.ListConstruction;
import de.uni_koblenz.jgralab.greql.schema.ListRangeConstruction;
import de.uni_koblenz.jgralab.greql.schema.Literal;
import de.uni_koblenz.jgralab.greql.schema.LongLiteral;
import de.uni_koblenz.jgralab.greql.schema.MapComprehension;
import de.uni_koblenz.jgralab.greql.schema.MapConstruction;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.Quantifier;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.SetComprehension;
import de.uni_koblenz.jgralab.greql.schema.SetConstruction;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.StringLiteral;
import de.uni_koblenz.jgralab.greql.schema.SubgraphDefinition;
import de.uni_koblenz.jgralab.greql.schema.SubgraphRestrictedExpression;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.schema.ThisLiteral;
import de.uni_koblenz.jgralab.greql.schema.ThisVertex;
import de.uni_koblenz.jgralab.greql.schema.TupleConstruction;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.VertexSetExpression;
import de.uni_koblenz.jgralab.greql.serialising.GreqlSerializer;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.compilation.ClassFileManager;
import de.uni_koblenz.jgralab.schema.impl.compilation.InMemoryJavaSourceFile;
import de.uni_koblenz.jgralab.schema.impl.compilation.ManagableArtifact;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class GreqlCodeGenerator
extends CodeGenerator
implements ManagableArtifact {
    public static final String codeGeneratorFileManagerName = "GeneratedQueries";
    private final GreqlGraph graph;
    private final String classname;
    private final String packageName;
    private final CodeSnippet classFieldSnippet = new CodeSnippet();
    private final CodeSnippet staticFieldSnippet = new CodeSnippet();
    private final CodeSnippet staticInitializerSnippet = new CodeSnippet("static {");
    private final List<CodeBlock> createdMethods = new LinkedList<CodeBlock>();
    private final Scope scope;
    private final Schema schema;
    private boolean thisEdgeCreated = false;
    private boolean thisVertexCreated = false;
    private final GreqlQuery query;
    private final InternalGreqlEvaluator evaluator;
    private final HashSet<String> resultVariables = new HashSet();
    private int acceptedIncidenceClassesNumber = 0;
    private int acceptedTypesNumber = 0;
    private int uniqueMethodId = 0;
    private final HashSet<String> staticFieldNames = new HashSet();

    public GreqlCodeGenerator(GreqlQuery greqlQuery, Schema schema, String string, String string2) {
        super(string, "", CodeGeneratorConfiguration.MINIMAL);
        this.graph = greqlQuery.getQueryGraph();
        this.query = greqlQuery;
        this.classname = string2;
        this.packageName = string;
        this.schema = schema;
        this.scope = new Scope();
        this.evaluator = new GreqlEvaluatorImpl(greqlQuery, null, new GreqlEnvironmentAdapter());
        this.evaluator.setSchema(schema);
    }

    public static void generateCode(String string, Schema schema, String string2, String string3) {
        GreqlQuery greqlQuery = GreqlQuery.createQuery(string, new DefaultOptimizer(new DefaultOptimizerInfo(schema)));
        String string4 = string2;
        String string5 = "";
        if (string2.contains(".")) {
            string4 = string2.substring(string2.lastIndexOf(".") + 1);
            string5 = string2.substring(0, string2.lastIndexOf("."));
        }
        GreqlCodeGenerator greqlCodeGenerator = new GreqlCodeGenerator(greqlQuery, schema, string5, string4);
        try {
            greqlCodeGenerator.createFiles(string3);
        }
        catch (GraphIOException graphIOException) {
            graphIOException.printStackTrace();
        }
    }

    public static Class<ExecutableQuery> generateCode(String string, Schema schema, String string2) {
        GreqlQuery greqlQuery = GreqlQuery.createQuery(string, new DefaultOptimizer(new DefaultOptimizerInfo(schema)));
        String string3 = string2;
        String string4 = "";
        if (string2.contains(".")) {
            string3 = string2.substring(string2.lastIndexOf(".") + 1);
            string4 = string2.substring(0, string2.lastIndexOf("."));
        }
        GreqlCodeGenerator greqlCodeGenerator = new GreqlCodeGenerator(greqlQuery, schema, string4, string3);
        return greqlCodeGenerator.compile();
    }

    @Override
    public CodeBlock createBody() {
        int n;
        CodeList codeList = new CodeList();
        this.addImports("de.uni_koblenz.jgralab.greql.executable.*");
        this.addImports("de.uni_koblenz.jgralab.Graph");
        this.addImports("de.uni_koblenz.jgralab.greql.GreqlEnvironment");
        this.addImports("java.util.Set");
        codeList.add(this.staticFieldSnippet);
        codeList.add(this.staticInitializerSnippet);
        codeList.add(this.classFieldSnippet);
        GreqlExpression greqlExpression = this.graph.getFirstGreqlExpression();
        this.addClassField("Graph", "datagraph", "null");
        this.addClassField("GreqlEnvironment", "boundVariables", "null");
        CodeList codeList2 = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("public synchronized Object execute(de.uni_koblenz.jgralab.Graph graph, GreqlEnvironment boundVariables) {");
        codeSnippet.add("\tthis.datagraph = graph;");
        codeSnippet.add("\tthis.boundVariables = boundVariables;");
        codeList2.addNoIndent(codeSnippet);
        CodeSnippet codeSnippet2 = new CodeSnippet();
        codeList2.add(codeSnippet2);
        codeSnippet = new CodeSnippet();
        codeSnippet.add("\treturn " + this.createCodeForGreqlExpression(greqlExpression) + ";");
        for (String object2 : this.resultVariables) {
            codeSnippet2.add(object2 + " = null;");
        }
        for (n = 0; n < this.acceptedTypesNumber; ++n) {
            codeSnippet2.add("acceptedTypeCollection_" + n + " = " + "acceptedTypeCollection_" + n + ".bindToSchema(graph.getSchema());");
            codeSnippet2.add("acceptedType_" + n + " = acceptedTypeCollection_" + n + ".getTypeIdSet();");
        }
        for (n = 0; n < this.acceptedIncidenceClassesNumber; ++n) {
            codeSnippet2.add("acceptedIncidenceClasses_" + n + " = " + "bindIncidenceClassesToSchema(graph.getSchema(), acceptedIncideceClassesEC_" + n + ", acceptedIncideceClassesIncidenceClass_" + n + ");");
        }
        codeSnippet.add("}");
        codeList2.addNoIndent(codeSnippet);
        codeList.add(codeList2);
        CodeSnippet codeSnippet3 = new CodeSnippet();
        codeSnippet3.add("\n\tpublic String getQueryText() {");
        codeSnippet3.add("\treturn \"" + this.quote(this.query.getQueryText()) + "\";");
        codeSnippet3.add("}");
        codeList.add(codeSnippet3);
        CodeSnippet codeSnippet4 = new CodeSnippet();
        codeSnippet4.add("\n\tpublic Set<String> getUsedVariables() {");
        codeSnippet4.add("\tjava.util.Set<String> usedVariables = new java.util.HashSet<String>();");
        for (String string : this.query.getUsedVariables()) {
            codeSnippet4.add("\tusedVariables.add(\"" + string + "\");");
        }
        codeSnippet4.add("\treturn usedVariables;");
        codeSnippet4.add("}");
        codeList.add(codeSnippet4);
        CodeSnippet codeSnippet5 = new CodeSnippet();
        codeSnippet5.add("\n\tpublic Set<String> getStoredVariables() {");
        codeSnippet5.add("\tjava.util.Set<String> storedVariables = new java.util.HashSet<String>();");
        for (String string : this.query.getStoredVariables()) {
            codeSnippet5.add("\tstoredVariables.add(\"" + string + "\");");
        }
        codeSnippet5.add("\treturn storedVariables;");
        codeSnippet5.add("}");
        codeList.add(codeSnippet5);
        codeList.add(new CodeSnippet("", ""));
        for (CodeBlock codeBlock : this.createdMethods) {
            codeList.addNoIndent(codeBlock);
            codeList.add(new CodeSnippet("", ""));
        }
        this.staticInitializerSnippet.add("}");
        return codeList;
    }

    private String quote(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block7: for (char c : string.toCharArray()) {
            switch (c) {
                case '\n': {
                    stringBuilder.append("\\\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\\\t");
                    continue block7;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                default: {
                    if (String.valueOf(c).matches("^[\\p{Cntrl}]$")) {
                        stringBuilder.append("\\\\" + c);
                        continue block7;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String createCodeForGreqlExpression(GreqlExpression greqlExpression) {
        Object object;
        CodeList codeList = new CodeList();
        this.scope.blockBegin();
        for (IsBoundVarOf graphElement2 : greqlExpression.getIsBoundVarOfIncidences(EdgeDirection.IN)) {
            this.addImports("de.uni_koblenz.jgralab.greql.exception.UndefinedVariableException");
            object = (Variable)graphElement2.getThat();
            this.scope.addVariable(object.get_name());
            codeList.add(new CodeSnippet("Object " + object.get_name() + " = boundVariables.getVariable(\"" + object.get_name() + "\");"));
            codeList.add(new CodeSnippet("if (" + object.get_name() + " == null) {"));
            codeList.add(new CodeSnippet("\tthrow new UndefinedVariableException(\"" + object.get_name() + "\");"));
            codeList.add(new CodeSnippet("}"));
        }
        IsQueryExprOf isQueryExprOf = greqlExpression.getFirstIsQueryExprOfIncidence(EdgeDirection.IN);
        Expression expression = (Expression)isQueryExprOf.getThat();
        object = "result";
        codeList.add(new CodeSnippet("Object " + (String)object + " = " + this.createCodeForExpression(expression) + ";"));
        for (IsIdOfStoreClause isIdOfStoreClause : greqlExpression.getIsIdOfStoreClauseIncidences(EdgeDirection.IN)) {
            Identifier identifier = (Identifier)isIdOfStoreClause.getThat();
            codeList.add(new CodeSnippet("boundVariables.setVariable(\"" + identifier.get_name() + "\"," + (String)object + ");"));
        }
        codeList.add(new CodeSnippet("return result;"));
        this.scope.blockEnd();
        return this.createMethod(codeList, greqlExpression);
    }

    private String createCodeForExpression(Expression expression) {
        if (expression instanceof FunctionApplication) {
            return this.createCodeForFunctionApplication((FunctionApplication)expression);
        }
        if (expression instanceof Comprehension) {
            return this.createCodeForComprehension((Comprehension)expression);
        }
        if (expression instanceof QuantifiedExpression) {
            return this.createCodeForQuantifiedExpression((QuantifiedExpression)expression);
        }
        if (expression instanceof ConditionalExpression) {
            return this.createCodeForConditionalExpression((ConditionalExpression)expression);
        }
        if (expression instanceof EdgeSetExpression) {
            return this.createCodeForEdgeSetExpression((EdgeSetExpression)expression);
        }
        if (expression instanceof VertexSetExpression) {
            return this.createCodeForVertexSetExpression((VertexSetExpression)expression);
        }
        if (expression instanceof ListRangeConstruction) {
            return this.createCodeForListRangeConstruction((ListRangeConstruction)expression);
        }
        if (expression instanceof ListConstruction) {
            return this.createCodeForListConstruction((ListConstruction)expression);
        }
        if (expression instanceof SetConstruction) {
            return this.createCodeForSetConstruction((SetConstruction)expression);
        }
        if (expression instanceof TupleConstruction) {
            return this.createCodeForTupleConstruction((TupleConstruction)expression);
        }
        if (expression instanceof MapConstruction) {
            return this.createCodeForMapConstruction((MapConstruction)expression);
        }
        if (expression instanceof RecordConstruction) {
            return this.createCodeForRecordConstruction((RecordConstruction)expression);
        }
        if (expression instanceof Literal) {
            return this.createCodeForLiteral((Literal)expression);
        }
        if (expression instanceof Variable) {
            return this.createCodeForVariable((Variable)expression);
        }
        if (expression instanceof Identifier) {
            return this.createCodeForIdentifier((Identifier)expression);
        }
        if (expression instanceof ForwardVertexSet) {
            return this.createCodeForForwardVertexSet((ForwardVertexSet)expression);
        }
        if (expression instanceof BackwardVertexSet) {
            return this.createCodeForBackwardVertexSet((BackwardVertexSet)expression);
        }
        if (expression instanceof PathExistence) {
            return this.createCodeForPathExistence((PathExistence)expression);
        }
        if (expression instanceof SubgraphRestrictedExpression) {
            return this.createCodeForSubgraphRestrictedExpression((SubgraphRestrictedExpression)expression);
        }
        return "UnsupportedElement: " + expression.getClass().getSimpleName();
    }

    private String createCodeForSubgraphRestrictedExpression(SubgraphRestrictedExpression subgraphRestrictedExpression) {
        SubgraphDefinition subgraphDefinition = subgraphRestrictedExpression.get_subgraphDefinition();
        Expression expression = (Expression)subgraphRestrictedExpression.getFirstIsExpressionOnSubgraphIncidence(EdgeDirection.IN).getThat();
        CodeList codeList = null;
        if (subgraphDefinition.isInstanceOf(ExpressionDefinedSubgraph.VC)) {
            codeList = new CodeList();
            codeList.add(new CodeSnippet(this.createCodeForExpressionDefinedSubraph((ExpressionDefinedSubgraph)subgraphDefinition)));
        }
        if (codeList != null) {
            codeList.add(new CodeSnippet("Object result = " + this.createCodeForExpression(expression) + ";"));
            codeList.add(new CodeSnippet("datagraph.setTraversalContext(null);"));
            codeList.add(new CodeSnippet("return result;"));
            return this.createMethod(codeList, subgraphRestrictedExpression);
        }
        return "UnsupportedElement: " + subgraphRestrictedExpression.getClass().getSimpleName();
    }

    private String createCodeForExpressionDefinedSubraph(ExpressionDefinedSubgraph expressionDefinedSubgraph) {
        Expression expression = expressionDefinedSubgraph.get_definingExpression();
        this.addImports("de.uni_koblenz.jgralab.graphmarker.SubGraphMarker");
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("SubGraphMarker subGraphMarker = (SubGraphMarker) " + this.createCodeForExpression(expression) + ";");
        codeSnippet.add("\t\tdatagraph.setTraversalContext(subGraphMarker);");
        return codeSnippet.getCode();
    }

    private String createCodeForIdentifier(Identifier identifier) {
        return "\"" + identifier.get_name() + "\"";
    }

    private String createInitializerForTypeCollection(Iterable<IsTypeRestrOfExpression> iterable) {
        String string = "acceptedType_" + this.acceptedTypesNumber;
        this.addStaticField("java.util.BitSet", string, "null");
        String string2 = "acceptedTypeCollection_" + this.acceptedTypesNumber++;
        this.addStaticField("de.uni_koblenz.jgralab.greql.types.TypeCollection", string2, "de.uni_koblenz.jgralab.greql.types.TypeCollection.empty()");
        if (iterable.iterator().hasNext()) {
            StringBuilder stringBuilder = new StringBuilder(string2).append(" = ").append(string2);
            for (IsTypeRestrOfExpression isTypeRestrOfExpression : iterable) {
                TypeId typeId = isTypeRestrOfExpression.getAlpha();
                GraphElementClass<?, ?> graphElementClass = this.evaluator.getGraphElementClass(typeId.get_name());
                if (graphElementClass == null) {
                    ((GreqlQueryImpl)this.query).getVertexEvaluator(isTypeRestrOfExpression.getOmega()).evaluate(this.evaluator);
                    graphElementClass = this.evaluator.getGraphElementClass(typeId.get_name());
                }
                stringBuilder.append(".with(\"").append(graphElementClass.getQualifiedName()).append("\", ").append(typeId.is_type()).append(", ").append(typeId.is_excluded()).append(")");
            }
            stringBuilder.append(";");
            this.addStaticInitializer(stringBuilder.toString());
        }
        return string;
    }

    private String createInitializerForTypeCollection(TypeCollection typeCollection) {
        String string = "acceptedType_" + this.acceptedTypesNumber;
        this.addStaticField("java.util.BitSet", string, "null");
        String string2 = "acceptedTypeCollection_" + this.acceptedTypesNumber++;
        this.addStaticField("de.uni_koblenz.jgralab.greql.types.TypeCollection", string2, "de.uni_koblenz.jgralab.greql.types.TypeCollection.empty()");
        if (!typeCollection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(string2).append(" = ").append(string2);
            for (GraphElementClass<?, ?> graphElementClass : this.schema.getGraphClass().getGraphElementClasses()) {
                stringBuilder.append(".with(\"").append(graphElementClass.getQualifiedName()).append("\", true, ").append(!typeCollection.acceptsType(graphElementClass)).append(")");
            }
            stringBuilder.append(";");
            this.addStaticInitializer(stringBuilder.toString());
        }
        return string;
    }

    private String createInitializerForIncidenceTypeCollection(Set<IncidenceClass> set) {
        String string = "acceptedIncidenceClasses_" + this.acceptedIncidenceClassesNumber;
        this.addStaticField("java.util.BitSet", string, "null");
        String string2 = "acceptedIncideceClassesEC_" + this.acceptedIncidenceClassesNumber;
        this.addStaticField("String[]", string2, "new String[" + set.size() + "]");
        String string3 = "acceptedIncideceClassesIncidenceClass_" + this.acceptedIncidenceClassesNumber++;
        this.addStaticField("boolean[]", string3, "new boolean[" + set.size() + "]");
        if (!set.isEmpty()) {
            int n = 0;
            for (IncidenceClass incidenceClass : set) {
                this.addStaticInitializer(string2 + "[" + n + "] = \"" + incidenceClass.getEdgeClass().getQualifiedName() + "\";");
                this.addStaticInitializer(string3 + "[" + n + "] = " + (incidenceClass.getEdgeClass().getFrom() == incidenceClass ? "true" : "false") + ";");
            }
        }
        return string;
    }

    private String createCodeForEdgeSetExpression(EdgeSetExpression edgeSetExpression) {
        this.addImports("de.uni_koblenz.jgralab.JGraLab");
        this.addImports("de.uni_koblenz.jgralab.Edge");
        CodeList codeList = new CodeList();
        String string = this.createInitializerForTypeCollection(edgeSetExpression.getIsTypeRestrOfExpressionIncidences(EdgeDirection.IN));
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("org.pcollections.PCollection<Edge> edgeSet = JGraLab.set();");
        codeSnippet.add("for (Edge e : datagraph.edges()) {");
        codeSnippet.add("\tif (" + string + ".get(e.getAttributedElementClass().getGraphElementClassIdInSchema())) {");
        codeSnippet.add("\t\tedgeSet = edgeSet.plus(e);");
        codeSnippet.add("\t}");
        codeSnippet.add("}");
        codeSnippet.add("return edgeSet;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, edgeSetExpression);
    }

    private String createCodeForVertexSetExpression(VertexSetExpression vertexSetExpression) {
        CodeList codeList = new CodeList();
        String string = this.createInitializerForTypeCollection(vertexSetExpression.getIsTypeRestrOfExpressionIncidences(EdgeDirection.IN));
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("org.pcollections.PCollection<de.uni_koblenz.jgralab.Vertex> vertexSet = de.uni_koblenz.jgralab.JGraLab.set();");
        codeSnippet.add("for (de.uni_koblenz.jgralab.Vertex e : datagraph.vertices()) {");
        codeSnippet.add("\tif (" + string + ".get(e.getAttributedElementClass().getGraphElementClassIdInSchema())) {");
        codeSnippet.add("\t\tvertexSet = vertexSet.plus(e);");
        codeSnippet.add("\t}");
        codeSnippet.add("}");
        codeSnippet.add("return vertexSet;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, vertexSetExpression);
    }

    private String createCodeForListRangeConstruction(ListRangeConstruction listRangeConstruction) {
        this.addImports("de.uni_koblenz.jgralab.JGraLab");
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("org.pcollections.PCollection<Object> list = JGraLab.vector();");
        Expression expression = (Expression)listRangeConstruction.getFirstIsFirstValueOfIncidence(EdgeDirection.IN).getThat();
        int n = (Integer)((GreqlQueryImpl)this.query).getVertexEvaluator(expression).getResult(this.evaluator);
        Expression expression2 = (Expression)listRangeConstruction.getFirstIsLastValueOfIncidence(EdgeDirection.IN).getThat();
        int n2 = (Integer)((GreqlQueryImpl)this.query).getVertexEvaluator(expression2).getResult(this.evaluator);
        codeSnippet.add("int startRange = " + this.createCodeForExpression(expression) + ";");
        codeSnippet.add("int endRange = " + this.createCodeForExpression(expression2) + ";");
        codeSnippet.add("for (int i = startRange; i " + (n <= n2 ? "<=" : ">=") + " endRange; " + (n <= n2 ? "i++" : "i--") + ") {");
        codeSnippet.add("\tlist = list.plus(i);");
        codeSnippet.add("}");
        codeSnippet.add("return list;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, listRangeConstruction);
    }

    private String createCodeForListConstruction(ListConstruction listConstruction) {
        this.addImports("de.uni_koblenz.jgralab.JGraLab");
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("org.pcollections.PCollection<Object> list = JGraLab.vector();");
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder("list = list");
        for (IsPartOf isPartOf : listConstruction.getIsPartOfIncidences(EdgeDirection.IN)) {
            bl = false;
            Expression expression = (Expression)isPartOf.getThat();
            stringBuilder.append(".plus(" + this.createCodeForExpression(expression) + ")");
        }
        stringBuilder.append(";");
        if (!bl) {
            codeSnippet.add(stringBuilder.toString());
        }
        codeSnippet.add("return list;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, listConstruction);
    }

    private String createCodeForSetConstruction(SetConstruction setConstruction) {
        this.addImports("de.uni_koblenz.jgralab.JGraLab");
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("org.pcollections.PCollection<Object> list = JGraLab.set();");
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder("list = list");
        for (IsPartOf isPartOf : setConstruction.getIsPartOfIncidences(EdgeDirection.IN)) {
            bl = false;
            Expression expression = (Expression)isPartOf.getThat();
            stringBuilder.append(".plus(" + this.createCodeForExpression(expression) + ")");
        }
        stringBuilder.append(";");
        if (!bl) {
            codeSnippet.add(stringBuilder.toString());
        }
        codeSnippet.add("return list;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, setConstruction);
    }

    private String createCodeForMapConstruction(MapConstruction mapConstruction) {
        this.addImports("de.uni_koblenz.jgralab.JGraLab");
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("org.pcollections.PMap<Object, Object> list = JGraLab.map();");
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder("list = list");
        IsKeyExprOfConstruction isKeyExprOfConstruction = mapConstruction.getFirstIsKeyExprOfConstructionIncidence(EdgeDirection.IN);
        IsValueExprOfConstruction isValueExprOfConstruction = mapConstruction.getFirstIsValueExprOfConstructionIncidence(EdgeDirection.IN);
        while (isKeyExprOfConstruction != null) {
            assert (isValueExprOfConstruction != null);
            bl = false;
            Expression expression = (Expression)isKeyExprOfConstruction.getThat();
            Expression expression2 = (Expression)isValueExprOfConstruction.getThat();
            stringBuilder.append(".plus(" + this.createCodeForExpression(expression) + ", " + this.createCodeForExpression(expression2) + ")");
            isKeyExprOfConstruction = isKeyExprOfConstruction.getNextIsKeyExprOfConstructionIncidence(EdgeDirection.IN);
            isValueExprOfConstruction = isValueExprOfConstruction.getNextIsValueExprOfConstructionIncidence(EdgeDirection.IN);
        }
        assert (isValueExprOfConstruction == null);
        stringBuilder.append(";");
        if (!bl) {
            codeSnippet.add(stringBuilder.toString());
        }
        codeSnippet.add("return list;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, mapConstruction);
    }

    private String createCodeForTupleConstruction(TupleConstruction tupleConstruction) {
        this.addImports("de.uni_koblenz.jgralab.greql.types.Tuple");
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("org.pcollections.PCollection<Object> list = Tuple.empty();");
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder("list = list");
        for (IsPartOf isPartOf : tupleConstruction.getIsPartOfIncidences(EdgeDirection.IN)) {
            bl = false;
            Expression expression = (Expression)isPartOf.getThat();
            stringBuilder.append(".plus(" + this.createCodeForExpression(expression) + ")");
        }
        stringBuilder.append(";");
        if (!bl) {
            codeSnippet.add(stringBuilder.toString());
        }
        codeSnippet.add("return list;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, tupleConstruction);
    }

    private String createCodeForRecordConstruction(RecordConstruction recordConstruction) {
        this.addImports("de.uni_koblenz.jgralab.impl.RecordImpl");
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("RecordImpl resultRecord = RecordImpl.empty();");
        StringBuilder stringBuilder = new StringBuilder("resultRecord = resultRecord");
        for (IsRecordElementOf isRecordElementOf : recordConstruction.getIsRecordElementOfIncidences(EdgeDirection.IN)) {
            RecordElement recordElement = isRecordElementOf.getAlpha();
            Identifier identifier = (Identifier)recordElement.getFirstIsRecordIdOfIncidence(EdgeDirection.IN).getThat();
            Expression expression = (Expression)recordElement.getFirstIsRecordExprOfIncidence(EdgeDirection.IN).getThat();
            stringBuilder.append(".plus(\"" + identifier.get_name() + "\"," + this.createCodeForExpression(expression) + ")");
        }
        stringBuilder.append(";");
        codeSnippet.add(stringBuilder.toString());
        codeSnippet.add("return resultRecord;");
        codeList.add(codeSnippet);
        return this.createMethod(codeList, recordConstruction);
    }

    private String createCodeForConditionalExpression(ConditionalExpression conditionalExpression) {
        CodeList codeList = new CodeList();
        Expression expression = (Expression)conditionalExpression.getFirstIsConditionOfIncidence(EdgeDirection.IN).getThat();
        Expression expression2 = (Expression)conditionalExpression.getFirstIsTrueExprOfIncidence(EdgeDirection.IN).getThat();
        Expression expression3 = (Expression)conditionalExpression.getFirstIsFalseExprOfIncidence(EdgeDirection.IN).getThat();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeList.add(codeSnippet);
        codeSnippet.add("if ((Boolean) " + this.createCodeForExpression(expression) + ") {");
        codeSnippet.add("\treturn " + this.createCodeForExpression(expression2) + ";");
        codeSnippet.add("} else {");
        codeSnippet.add("\treturn " + this.createCodeForExpression(expression3) + ";");
        codeSnippet.add("}");
        String string = this.createMethod(codeList, conditionalExpression);
        return string;
    }

    private String createCodeForComprehension(Comprehension comprehension) {
        Object object;
        CodeSnippet codeSnippet;
        IsTableHeaderOf isTableHeaderOf;
        Expression expression;
        boolean bl;
        this.addImports("de.uni_koblenz.jgralab.JGraLab");
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet2 = new CodeSnippet();
        if (comprehension instanceof ListComprehension) {
            if (comprehension.getFirstIsTableHeaderOfIncidence(EdgeDirection.IN) == null) {
                codeSnippet2.add("org.pcollections.PCollection<Object> result = JGraLab.vector();");
            } else {
                codeSnippet2.add("de.uni_koblenz.jgralab.greql.types.Table<Object> result = de.uni_koblenz.jgralab.greql.types.Table.empty();");
            }
        }
        if (comprehension instanceof SetComprehension) {
            codeSnippet2.add("org.pcollections.PCollection<Object> result = JGraLab.set();");
        }
        if (comprehension instanceof MapComprehension) {
            codeSnippet2.add("org.pcollections.PMap<Object, Object> result = JGraLab.map();");
        }
        boolean bl2 = bl = (expression = comprehension.get_maxCount()) != null;
        if (bl) {
            codeSnippet2.add("int maxCount = (Integer) " + this.createCodeForExpression(expression) + ";");
        }
        if ((isTableHeaderOf = comprehension.getFirstIsTableHeaderOfIncidence(EdgeDirection.IN)) != null) {
            codeSnippet2.add("org.pcollections.PVector<String> header = JGraLab.vector();");
            while (isTableHeaderOf != null) {
                codeSnippet2.add("header = header.plus(" + this.createCodeForExpression(isTableHeaderOf.getAlpha()) + ");");
                isTableHeaderOf = isTableHeaderOf.getNextIsTableHeaderOfIncidence(EdgeDirection.IN);
            }
            codeSnippet2.add("result = result.withTitles(header);");
        }
        codeList.add(codeSnippet2);
        this.scope.blockBegin();
        CodeList object3 = this.createCodeForVariableIterationOfComprehension(codeList, bl, comprehension, null);
        Declaration declaration = (Declaration)comprehension.getFirstIsCompDeclOfIncidence(EdgeDirection.IN).getThat();
        if (declaration.getFirstIsConstraintOfIncidence(EdgeDirection.IN) != null) {
            codeSnippet = new CodeSnippet();
            codeSnippet.add("boolean constraint = true;");
            for (IsConstraintOf object22 : declaration.getIsConstraintOfIncidences(EdgeDirection.IN)) {
                Expression expression2 = (Expression)object22.getThat();
                codeSnippet.add("constraint = constraint && (Boolean) " + this.createCodeForExpression(expression2) + ";");
            }
            codeSnippet.add("if (constraint){");
            object = new CodeList();
            ((CodeList)object).add(codeSnippet);
            CodeList codeList2 = new CodeList();
            ((CodeList)object).add(codeList2);
            ((CodeList)object).add(new CodeSnippet("}"));
            object3.add((CodeBlock)object);
            object3 = codeList2;
        }
        codeSnippet = new CodeSnippet();
        if (comprehension instanceof MapComprehension) {
            object = (Expression)((MapComprehension)comprehension).getFirstIsKeyExprOfComprehensionIncidence(EdgeDirection.IN).getThat();
            Expression expression3 = (Expression)((MapComprehension)comprehension).getFirstIsValueExprOfComprehensionIncidence(EdgeDirection.IN).getThat();
            codeSnippet.add("result = result.plus(" + this.createCodeForExpression((Expression)object) + ", " + this.createCodeForExpression(expression3) + ");");
        } else {
            object = (Expression)comprehension.getFirstIsCompResultDefOfIncidence(EdgeDirection.IN).getThat();
            codeSnippet.add("result = result.plus(" + this.createCodeForExpression((Expression)object) + ");");
        }
        if (bl) {
            codeSnippet.add("maxCount--;");
        }
        object3.add(codeSnippet);
        codeList.add(new CodeSnippet("return result;"));
        this.scope.blockEnd();
        return this.createMethod(codeList, comprehension);
    }

    public CodeList createCodeForVariableIterationOfComprehension(CodeList codeList, boolean bl, Comprehension comprehension, Set<Variable> set) {
        Declaration declaration = (Declaration)comprehension.getFirstIsCompDeclOfIncidence(EdgeDirection.IN).getThat();
        Object object = new CodeList();
        codeList.add(new CodeSnippet("{"));
        codeList.add((CodeBlock)object);
        codeList.add(new CodeSnippet("}"));
        for (IsSimpleDeclOf isSimpleDeclOf : declaration.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)isSimpleDeclOf.getThat();
            Expression expression = (Expression)simpleDeclaration.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN).getThat();
            CodeSnippet codeSnippet = new CodeSnippet();
            boolean bl2 = false;
            ((CodeList)object).add(codeSnippet);
            for (IsDeclaredVarOf isDeclaredVarOf : simpleDeclaration.getIsDeclaredVarOfIncidences(EdgeDirection.IN)) {
                Variable variable = (Variable)isDeclaredVarOf.getThat();
                if (set != null && !set.contains(variable)) continue;
                if (!bl2) {
                    bl2 = true;
                    ((CodeBlock)object).setVariable("simpleDeclDomainName", "domainOfSimpleDecl_" + Integer.toString(simpleDeclaration.getId()));
                    codeSnippet.add("@SuppressWarnings(\"unchecked\")", "org.pcollections.PCollection<Object> #simpleDeclDomainName# = (org.pcollections.PCollection<Object>) " + this.createCodeForExpression(expression) + ";");
                }
                CodeSnippet codeSnippet2 = new CodeSnippet();
                codeSnippet2.setVariable("variableName", variable.get_name());
                codeSnippet2.add("for (Object #variableName# : #simpleDeclDomainName#) {");
                if (bl) {
                    codeSnippet2.add("\tif(maxCount==0) break;");
                }
                VariableEvaluator variableEvaluator = (VariableEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(variable);
                List<VertexEvaluator<Expression>> list = variableEvaluator.calculateDependingExpressions();
                for (VertexEvaluator<Expression> vertexEvaluator : list) {
                    Expression expression2 = vertexEvaluator.getVertex();
                    if (expression2 instanceof Variable) continue;
                    String string = this.getVariableName(Integer.toString(expression2.getId()));
                    codeSnippet2.add("\t" + string + " = null;");
                }
                this.scope.addVariable(variable.get_name());
                ((CodeList)object).add(codeSnippet2);
                CodeList codeList2 = new CodeList();
                ((CodeList)object).add(codeList2);
                ((CodeList)object).add(new CodeSnippet("}"));
                object = codeList2;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private String createCodeForQuantifiedExpression(QuantifiedExpression quantifiedExpression) {
        void var10_17;
        Object object;
        Comparable<AttributedElement<VertexClass, Vertex>> comparable;
        CodeList codeList = new CodeList();
        Declaration declaration = (Declaration)quantifiedExpression.getFirstIsQuantifiedDeclOfIncidence(EdgeDirection.IN).getThat();
        int n = 0;
        String string = "";
        int n2 = 0;
        Quantifier quantifier = (Quantifier)quantifiedExpression.getFirstIsQuantifierOfIncidence(EdgeDirection.IN).getThat();
        switch (quantifier.get_type()) {
            case FORALL: {
                break;
            }
            case EXISTS: {
                break;
            }
            case EXISTSONE: {
                codeList.add(new CodeSnippet("boolean result = false;"));
            }
        }
        this.scope.blockBegin();
        for (IsSimpleDeclOf iterator2 : declaration.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            SimpleDeclaration simpleDeclaration = (SimpleDeclaration)iterator2.getThat();
            comparable = (Expression)simpleDeclaration.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN).getThat();
            CodeSnippet codeSnippet = new CodeSnippet();
            codeSnippet.setVariable("simpleDeclNum", Integer.toString(n2));
            codeSnippet.add("@SuppressWarnings(\"unchecked\")", string + "org.pcollections.PCollection<Object> domain_#simpleDeclNum# = (org.pcollections.PCollection<Object>) " + this.createCodeForExpression((Expression)comparable) + ";");
            codeList.add(codeSnippet);
            for (IsDeclaredVarOf isDeclaredVarOf : simpleDeclaration.getIsDeclaredVarOfIncidences(EdgeDirection.IN)) {
                ++n;
                Variable variable = (Variable)isDeclaredVarOf.getThat();
                CodeSnippet codeSnippet2 = new CodeSnippet();
                codeSnippet2.setVariable("variableName", variable.get_name());
                codeSnippet2.setVariable("simpleDeclNum", Integer.toString(n2));
                codeSnippet2.add(string + "for (Object #variableName# : domain_#simpleDeclNum#) {");
                string = string + "\t";
                this.scope.addVariable(variable.get_name());
                codeList.add(codeSnippet2);
            }
            ++n2;
        }
        if (declaration.getFirstIsConstraintOfIncidence(EdgeDirection.IN) != null) {
            object = new CodeSnippet();
            ((CodeSnippet)object).add(string + "boolean constraint = true;");
            for (IsConstraintOf isConstraintOf : declaration.getIsConstraintOfIncidences(EdgeDirection.IN)) {
                comparable = (Expression)isConstraintOf.getThat();
                ((CodeSnippet)object).add(string + "constraint = constraint && (Boolean) " + this.createCodeForExpression((Expression)comparable) + ";");
            }
            ((CodeSnippet)object).add(string + "if (constraint)");
            codeList.add((CodeBlock)object);
        }
        object = (Expression)quantifiedExpression.getFirstIsBoundExprOfQuantifiedExpressionIncidence(EdgeDirection.IN).getThat();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add(string + this.getVariableName(Integer.toString(object.getId())) + " = null;");
        codeSnippet.add(string + "Object currentResult = " + this.createCodeForExpression((Expression)object) + ";");
        switch (quantifier.get_type()) {
            case FORALL: {
                codeSnippet.add(string + "if ((currentResult instanceof Boolean) && ! (Boolean) currentResult) return false;");
                break;
            }
            case EXISTS: {
                codeSnippet.add(string + "if (!(currentResult instanceof Boolean) || (Boolean) currentResult) return true;");
                break;
            }
            case EXISTSONE: {
                codeSnippet.add(string + "if (!(currentResult instanceof Boolean) || (Boolean) currentResult) {");
                codeSnippet.add(string + "\tif (result) {");
                codeSnippet.add(string + "\t\treturn false; //two elements exists");
                codeSnippet.add(string + "\t} else {");
                codeSnippet.add(string + "\t\tresult = true; //first element found");
                codeSnippet.add(string + "\t}");
                codeSnippet.add(string + "}");
            }
        }
        codeList.add(codeSnippet);
        boolean bl = false;
        while (var10_17 < n) {
            comparable = new StringBuilder();
            for (int i = 1; i < n - var10_17; ++i) {
                ((StringBuilder)comparable).append("\t");
            }
            string = ((StringBuilder)comparable).toString();
            codeList.add(new CodeSnippet(string + "}"));
            ++var10_17;
        }
        switch (quantifier.get_type()) {
            case FORALL: {
                codeList.add(new CodeSnippet("return true;"));
                break;
            }
            case EXISTSONE: {
                codeList.add(new CodeSnippet("return result;"));
                break;
            }
            case EXISTS: {
                codeList.add(new CodeSnippet("return false;"));
            }
        }
        this.scope.blockEnd();
        return this.createMethod(codeList, quantifiedExpression);
    }

    private String createCodeForLiteral(Literal literal) {
        if (literal instanceof StringLiteral) {
            return GraphIO.toUtfString(((StringLiteral)literal).get_stringValue());
        }
        if (literal instanceof IntLiteral) {
            return Integer.toString(((IntLiteral)literal).get_intValue());
        }
        if (literal instanceof LongLiteral) {
            return Long.toString(((LongLiteral)literal).get_longValue()) + "l";
        }
        if (literal instanceof DoubleLiteral) {
            return Double.toString(((DoubleLiteral)literal).get_doubleValue());
        }
        if (literal instanceof BoolLiteral) {
            return Boolean.toString(((BoolLiteral)literal).is_boolValue());
        }
        if (literal instanceof ThisEdge) {
            this.createThisEdge();
            return "thisEdge";
        }
        if (literal instanceof ThisVertex) {
            this.createThisVertex();
            return "thisVertex";
        }
        this.addImports("de.uni_koblenz.jgralab.greql.types.Undefined");
        return "Undefined.UNDEFINED";
    }

    private String createCodeForVariable(Variable variable) {
        return variable.get_name();
    }

    private String createCodeForFunctionApplication(FunctionApplication functionApplication) {
        FunctionId functionId = (FunctionId)functionApplication.getFirstIsFunctionIdOfIncidence(EdgeDirection.IN).getThat();
        if (functionId.get_name().equals("pathSystem")) {
            return this.createCodeForPathSystemFunction(functionApplication);
        }
        if (functionId.get_name().equals("forwardVertexSet")) {
            return this.createCodeForReachableVertices(functionApplication);
        }
        if (functionId.get_name().equals("backwardVertexSet")) {
            return this.createCodeForReachableVertices(functionApplication);
        }
        if (functionId.get_name().equals("reachableVertices")) {
            return this.createCodeForReachableVertices(functionApplication);
        }
        if (functionId.get_name().equals("isReachable")) {
            return this.createCodeForIsReachable(functionApplication);
        }
        if (functionId.get_name().equals("slice")) {
            return this.createCodeForSliceFunction(functionApplication);
        }
        this.addImports("de.uni_koblenz.jgralab.greql.funlib.FunLib");
        Function function = FunLib.getFunctionInfo(functionId.get_name()).getFunction();
        String string = function.getClass().getName();
        String string2 = function.getClass().getSimpleName();
        if (string2.contains(".")) {
            string2 = string2.substring(string2.lastIndexOf("."));
        }
        String string3 = string2 + "_" + functionApplication.getId();
        this.addStaticField(string, string3, "(" + string + ") FunLib.getFunctionInfo(\"" + functionId.get_name() + "\").getFunction()");
        CodeList codeList = new CodeList();
        int n = 0;
        Object object = functionApplication.getIsArgumentOfIncidences(EdgeDirection.IN).iterator();
        while (object.hasNext()) {
            Method[] methodArray = object.next();
            Expression graphElement = (Expression)methodArray.getThat();
            codeList.add(new CodeSnippet("Object arg_" + n++ + " = " + this.createCodeForExpression(graphElement) + ";"));
        }
        if (functionApplication.getFirstIsTypeExprOfFunctionIncidence(EdgeDirection.IN) != null) {
            this.addImports("de.uni_koblenz.jgralab.greql.types.TypeCollection");
            object = new StringBuilder();
            ((StringBuilder)object).append("TypeCollection arg_").append(n).append(" = TypeCollection.empty()");
            for (IsTypeExprOfFunction isTypeExprOfFunction : functionApplication.getIsTypeExprOfFunctionIncidences(EdgeDirection.IN)) {
                TypeId typeId = (TypeId)isTypeExprOfFunction.getAlpha();
                GraphElementClass<?, ?> graphElementClass = this.evaluator.getGraphElementClass(typeId.get_name());
                if (graphElementClass == null) {
                    ((GreqlQueryImpl)this.query).getVertexEvaluator(isTypeExprOfFunction.getOmega()).evaluate(this.evaluator);
                    graphElementClass = this.evaluator.getGraphElementClass(typeId.get_name());
                }
                ((StringBuilder)object).append(".with(\"").append(graphElementClass.getQualifiedName()).append("\", ").append(typeId.is_type()).append(", ").append(typeId.is_excluded()).append(")");
            }
            ((StringBuilder)object).append(";");
            codeList.add(new CodeSnippet(((StringBuilder)object).toString()));
            object = new StringBuilder();
            ((StringBuilder)object).append("arg_").append(n).append(" = arg_").append(n++).append(".bindToSchema(datagraph.getSchema());");
            codeList.add(new CodeSnippet(((StringBuilder)object).toString()));
        }
        codeList.add(new CodeSnippet("boolean matches;"));
        for (GraphElementClass<?, ?> graphElementClass : object = function.getClass().getMethods()) {
            Object object2;
            boolean bl;
            if (((Method)((Object)graphElementClass)).getName() != "evaluate") continue;
            Object object3 = ((Method)((Object)graphElementClass)).getParameterTypes();
            if (object3[0] == GreqlEvaluatorImpl.class) {
                throw new RuntimeException("Functions with an evaluator parameter are not supported yet");
            }
            boolean bl2 = bl = ((Class<?>[])object3).length > 1 && object3[0] == Graph.class;
            if (bl) {
                object2 = new Class[((Class<?>[])object3).length - 1];
                System.arraycopy(object3, 1, object2, 0, ((Class<?>[])object3).length - 1);
                object3 = object2;
            }
            if (((Class<?>[])object3).length != n) continue;
            object2 = new CodeSnippet();
            ((CodeSnippet)object2).add("matches = true;");
            for (int i = 0; i < ((Class<?>[])object3).length; ++i) {
                ((CodeSnippet)object2).add("matches &= arg_" + i + " instanceof " + object3[i].getCanonicalName() + ";");
            }
            ((CodeSnippet)object2).add("if (matches) {");
            String string4 = "";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\tObject result = " + string3 + ".evaluate(");
            if (bl) {
                stringBuilder.append("datagraph");
                string4 = ", ";
            }
            boolean bl3 = false;
            boolean bl4 = false;
            for (int i = 0; i < ((Class<?>[])object3).length; ++i) {
                String string5 = "(" + object3[i].getCanonicalName() + ") ";
                TypeVariable<Class<?>>[] typeVariableArray = object3[i].getTypeParameters();
                bl3 |= typeVariableArray.length > 0;
                bl4 |= typeVariableArray.length > 0 && object3[i] != Enum.class && object3[i] != AttributedElement.class;
                stringBuilder.append(string4 + string5 + "arg_" + i);
                string4 = ", ";
            }
            stringBuilder.append(");");
            if (bl3) {
                ((CodeSnippet)object2).add("\t@SuppressWarnings({ " + (bl4 ? "\"unchecked\", " : "") + "\"rawtypes\" })");
            }
            ((CodeSnippet)object2).add(stringBuilder.toString());
            ((CodeSnippet)object2).add("\treturn result;");
            ((CodeSnippet)object2).add("}");
            codeList.add((CodeBlock)object2);
        }
        codeList.add(new CodeSnippet("throw new RuntimeException(\"Given arguments don't match an available GReQL function. If you have added a function, you need to recompile the GReQL query for the function to be available.\");"));
        return this.createMethod(codeList, functionApplication);
    }

    private String createCodeForForwardVertexSet(ForwardVertexSet forwardVertexSet) {
        PathDescription pathDescription = (PathDescription)forwardVertexSet.getFirstIsPathOfIncidence(EdgeDirection.IN).getThat();
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(pathDescription);
        DFA dFA = ((NFA)pathDescriptionEvaluator.getResult(this.evaluator)).getDFA();
        Expression expression = (Expression)forwardVertexSet.getFirstIsStartExprOfIncidence(EdgeDirection.IN).getThat();
        return this.createCodeForForwarOrBackwardVertexSet(dFA, expression, forwardVertexSet);
    }

    private String createCodeForBackwardVertexSet(BackwardVertexSet backwardVertexSet) {
        PathDescription pathDescription = (PathDescription)backwardVertexSet.getFirstIsPathOfIncidence(EdgeDirection.IN).getThat();
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(pathDescription);
        DFA dFA = NFA.revertNFA((NFA)pathDescriptionEvaluator.getResult(this.evaluator)).getDFA();
        Expression expression = (Expression)backwardVertexSet.getFirstIsTargetExprOfIncidence(EdgeDirection.IN).getThat();
        return this.createCodeForForwarOrBackwardVertexSet(dFA, expression, backwardVertexSet);
    }

    private String createCodeForReachableVertices(FunctionApplication functionApplication) {
        PathDescription pathDescription = null;
        Expression expression = null;
        for (IsArgumentOf object2 : functionApplication.getIsArgumentOfIncidences(EdgeDirection.IN)) {
            if (expression == null) {
                expression = (Expression)object2.getThat();
                continue;
            }
            if (object2.getThat() instanceof PathDescription) {
                assert (pathDescription == null);
                pathDescription = (PathDescription)object2.getThat();
                continue;
            }
            assert (false);
        }
        assert (pathDescription != null);
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(pathDescription);
        DFA dFA = ((NFA)pathDescriptionEvaluator.getResult(this.evaluator)).getDFA();
        return this.createCodeForForwarOrBackwardVertexSet(dFA, expression, functionApplication);
    }

    private String createCodeForPathExistence(PathExistence pathExistence) {
        Expression expression = (Expression)pathExistence.getFirstIsStartExprOfIncidence(EdgeDirection.IN).getThat();
        Expression expression2 = (Expression)pathExistence.getFirstIsTargetExprOfIncidence(EdgeDirection.IN).getThat();
        PathDescription pathDescription = (PathDescription)pathExistence.getFirstIsPathOfIncidence(EdgeDirection.IN).getThat();
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(pathDescription);
        DFA dFA = ((NFA)pathDescriptionEvaluator.getResult(this.evaluator)).getDFA();
        return this.createCodeForForwarOrBackwardVertexSetOrPathExcistence(dFA, expression, expression2, pathExistence);
    }

    private String createCodeForIsReachable(FunctionApplication functionApplication) {
        Expression expression = null;
        Expression expression2 = null;
        PathDescription pathDescription = null;
        for (IsArgumentOf object2 : functionApplication.getIsArgumentOfIncidences(EdgeDirection.IN)) {
            if (expression == null) {
                expression = (Expression)object2.getThat();
                continue;
            }
            if (expression2 == null) {
                expression2 = (Expression)object2.getThat();
                continue;
            }
            assert (pathDescription == null);
            pathDescription = (PathDescription)object2.getThat();
        }
        assert (pathDescription != null);
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(pathDescription);
        DFA dFA = ((NFA)pathDescriptionEvaluator.getResult(this.evaluator)).getDFA();
        return this.createCodeForForwarOrBackwardVertexSetOrPathExcistence(dFA, expression, expression2, functionApplication);
    }

    private String createCodeForForwarOrBackwardVertexSet(DFA dFA, Expression expression, GreqlVertex greqlVertex) {
        return this.createCodeForForwarOrBackwardVertexSetOrPathExcistence(dFA, expression, null, greqlVertex);
    }

    private String createCodeForForwarOrBackwardVertexSetOrPathExcistence(DFA dFA, Expression expression, Expression expression2, GreqlVertex greqlVertex) {
        CodeList codeList = new CodeList();
        if (expression2 == null) {
            this.addImports("org.pcollections.PSet");
        }
        this.addImports("de.uni_koblenz.jgralab.*");
        this.addImports("de.uni_koblenz.jgralab.greql.executable.VertexStateNumberQueue");
        CodeSnippet codeSnippet = new CodeSnippet();
        codeList.add(codeSnippet);
        if (expression2 == null) {
            codeSnippet.add("PSet<Vertex> resultSet = JGraLab.set();");
        }
        codeSnippet.add("//one BitSet for each state");
        codeSnippet.add("@SuppressWarnings(\"unchecked\")", "java.util.HashSet<Vertex>[] markedElements = new java.util.HashSet[#stateCount#];");
        codeSnippet.setVariable("stateCount", Integer.toString(dFA.stateList.size()));
        codeSnippet.add("for (int i=0; i<#stateCount#;i++) {");
        codeSnippet.add("\tmarkedElements[i] = new java.util.HashSet<Vertex>(100);");
        codeSnippet.add("}");
        codeSnippet.add("java.util.BitSet finalStates = new java.util.BitSet();");
        for (State state : dFA.stateList) {
            if (!state.isFinal) continue;
            codeSnippet.add("finalStates.set(" + state.number + ");");
        }
        codeSnippet.add("int stateNumber;");
        codeSnippet.add("Vertex element = (Vertex)" + this.createCodeForExpression(expression) + ";");
        if (expression2 != null) {
            codeSnippet.add("Vertex target = (Vertex)" + this.createCodeForExpression(expression2) + ";");
        }
        codeSnippet.add("Vertex nextElement;");
        codeSnippet.add("VertexStateNumberQueue queue = new VertexStateNumberQueue();");
        codeSnippet.add("markedElements[" + dFA.initialState.number + "].add(element);");
        codeSnippet.add("queue.put((Vertex) element, " + dFA.initialState.number + ");");
        codeSnippet.add("while (queue.hasNext()) {");
        codeSnippet.add("\telement = queue.currentVertex;");
        codeSnippet.add("\tstateNumber = queue.currentState;");
        if (expression2 == null) {
            codeSnippet.add("\tif (finalStates.get(stateNumber)) {");
            codeSnippet.add("\t\tresultSet = resultSet.plus(element);");
        } else {
            codeSnippet.add("\tif (finalStates.get(stateNumber) && element == target){");
            codeSnippet.add("\t\treturn true;");
        }
        codeSnippet.add("\t}");
        codeSnippet.add("\tfor (Edge inc = element.getFirstIncidence();");
        codeSnippet.add("\t\tinc != null; inc = inc.getNextIncidence() ) { //iterating incident edges");
        codeSnippet.add("\t\tswitch (stateNumber) {");
        for (State state : dFA.stateList) {
            CodeList codeList2 = new CodeList();
            codeList.add(codeList2);
            codeList2.add(new CodeSnippet("\t\tcase " + state.number + ":"));
            for (Transition transition : state.outTransitions) {
                CodeList codeList3 = new CodeList();
                codeList2.add(codeList3);
                if (transition.consumesEdge()) {
                    codeList3.add(new CodeSnippet("\t\tnextElement = inc.getThat();"));
                } else {
                    codeList3.add(new CodeSnippet("\t\tnextElement = element;"));
                }
                codeList3.add(new CodeSnippet("\t\tif (!markedElements[" + transition.endState.number + "].contains(nextElement)) {//checking all transitions of state " + transition.endState.number));
                codeList3.add(this.createCodeForTransition(transition, FunctionType.OTHER), 2);
                codeList3.add(new CodeSnippet("\t\t} //finished checking transitions of state " + transition.endState.number));
            }
            codeList2.add(new CodeSnippet("\t\tbreak;//break case block"));
        }
        CodeSnippet codeSnippet2 = new CodeSnippet();
        codeSnippet2.add("\t\t} //end of switch");
        codeSnippet2.add("\t} //end of iterating incident edges ");
        codeSnippet2.add("} //end of processing queue");
        if (expression2 == null) {
            codeSnippet2.add("return resultSet;");
        } else {
            codeSnippet2.add("return false;");
        }
        codeList.add(codeSnippet2);
        return this.createMethod(codeList, greqlVertex);
    }

    private CodeSnippet createAddToPathSearchQueueSnippet(int n) {
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("markedElements[" + n + "].add(nextElement);");
        codeSnippet.add("queue.put(nextElement," + n + ");");
        return codeSnippet;
    }

    private CodeList createAddToPathSystemQueueSnippet(Transition transition) {
        CodeList codeList = new CodeList();
        if (transition.consumesEdge()) {
            codeList.setVariable("traversedEdge", "inc");
        } else {
            codeList.setVariable("traversedEdge", "null");
        }
        codeList.setVariable("endStateNumber", Integer.toString(transition.endState.number));
        codeList.setVariable("endStateFinal", Boolean.toString(transition.endState.isFinal));
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("PathSystemMarkerEntry newEntry = ExecutablePathSystemHelper.markVertex(marker,");
        codeSnippet.add("\tnextElement, #endStateNumber#, #endStateFinal#,");
        codeSnippet.add("    element, #traversedEdge#, currentEntry.stateNumber,");
        codeSnippet.add("    currentEntry.distanceToRoot + 1);");
        if (transition.endState.isFinal) {
            codeSnippet.add("finalEntries.add(newEntry);");
        }
        codeSnippet.add("queue.add(newEntry);");
        codeList.add(codeSnippet);
        return codeList;
    }

    private String createCodeForPathSystemFunction(FunctionApplication functionApplication) {
        IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
        Expression expression = (Expression)isArgumentOf.getThat();
        isArgumentOf = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN);
        PathDescription pathDescription = (PathDescription)isArgumentOf.getThat();
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(pathDescription);
        DFA dFA = ((NFA)pathDescriptionEvaluator.getResult(this.evaluator)).getDFA();
        return this.createCodeForPathSystem(dFA, expression, functionApplication);
    }

    private String createCodeForPathSystem(DFA dFA, Expression expression, GreqlVertex greqlVertex) {
        CodeList codeList = new CodeList();
        this.addImports("de.uni_koblenz.jgralab.*");
        this.addImports("de.uni_koblenz.jgralab.greql.executable.ExecutablePathSystemHelper");
        this.addImports("de.uni_koblenz.jgralab.greql.executable.PathSystemMarkerEntry");
        this.addImports("de.uni_koblenz.jgralab.graphmarker.GraphMarker");
        this.addImports("java.util.HashSet");
        codeList.setVariable("stateCount", Integer.toString(dFA.stateList.size()));
        codeList.setVariable("initialStateNumber", Integer.toString(dFA.initialState.number));
        codeList.setVariable("initialStateFinal", Boolean.toString(dFA.initialState.isFinal));
        CodeSnippet codeSnippet = new CodeSnippet();
        codeList.add(codeSnippet);
        codeSnippet.add("Vertex rootVertex = (Vertex)" + this.createCodeForExpression(expression) + ";");
        codeSnippet.add("Vertex element = rootVertex;");
        codeSnippet.add("Vertex nextElement;");
        codeSnippet.add("java.util.Queue<PathSystemMarkerEntry> queue = new java.util.LinkedList<PathSystemMarkerEntry>();");
        codeSnippet.add("@SuppressWarnings(\"unchecked\")");
        codeSnippet.add("GraphMarker<PathSystemMarkerEntry>[] marker = new GraphMarker[#stateCount#];");
        codeSnippet.add("for (int i = 0; i < #stateCount#; i++) {");
        codeSnippet.add("\tmarker[i] = new GraphMarker<PathSystemMarkerEntry>(element.getGraph());");
        codeSnippet.add("}");
        codeSnippet.add("HashSet<PathSystemMarkerEntry> finalEntries = new HashSet<PathSystemMarkerEntry>();");
        codeSnippet.add("PathSystemMarkerEntry currentEntry = ", "\tExecutablePathSystemHelper.markVertex(marker, element, #initialStateNumber#, #initialStateFinal#, null, null, 0, 0);");
        if (dFA.initialState.isFinal) {
            codeSnippet.add("finalEntries.add(currentEntry);");
        }
        codeSnippet.add("queue.add(currentEntry);");
        codeSnippet.add("while (!queue.isEmpty()) {");
        codeSnippet.add("\tcurrentEntry = queue.poll();");
        codeSnippet.add("\telement = currentEntry.vertex;");
        codeSnippet.add("\tfor (Edge inc = element.getFirstIncidence();");
        codeSnippet.add("\t\tinc != null; inc = inc.getNextIncidence() ) { //iterating incident edges");
        codeSnippet.add("\t\tswitch (currentEntry.stateNumber) {");
        for (State state : dFA.stateList) {
            CodeList codeList2 = new CodeList();
            codeList.add(codeList2);
            codeList2.add(new CodeSnippet("\t\tcase " + state.number + ":"));
            for (Transition transition : state.outTransitions) {
                CodeList codeList3 = new CodeList();
                codeList2.add(codeList3);
                if (transition.consumesEdge()) {
                    codeList3.add(new CodeSnippet("\t\tnextElement = inc.getThat();"));
                } else {
                    codeList3.add(new CodeSnippet("\t\tnextElement = element;"));
                }
                codeList3.add(new CodeSnippet("\t\tif (!ExecutablePathSystemHelper.isMarked(marker, nextElement, " + transition.endState.number + ")) {//checking all transitions of state " + transition.endState.number));
                codeList3.add(this.createCodeForTransition(transition, FunctionType.PATH_SYSTEM), 2);
                codeList3.add(new CodeSnippet("\t\t} //finished checking transitions of state " + transition.endState.number));
            }
            codeList2.add(new CodeSnippet("\t\tbreak;//break case block"));
        }
        CodeSnippet codeSnippet2 = new CodeSnippet();
        codeSnippet2.add("\t\t} //end of switch");
        codeSnippet2.add("\t} //end of iterating incident edges ");
        codeSnippet2.add("} //end of processing queue");
        codeSnippet2.add("return ExecutablePathSystemHelper.createPathSystemFromMarkings(marker, (Vertex)rootVertex, finalEntries);");
        codeList.add(codeSnippet2);
        return this.createMethod(codeList, greqlVertex);
    }

    private CodeBlock createAddToSliceQueueSnippet(Transition transition) {
        CodeList codeList = new CodeList();
        if (transition.consumesEdge()) {
            codeList.setVariable("traversedEdge", "inc");
        } else {
            codeList.setVariable("traversedEdge", "null");
        }
        codeList.setVariable("endStateNumber", Integer.toString(transition.endState.number));
        codeList.setVariable("endStateFinal", Boolean.toString(transition.endState.isFinal));
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("if (!ExecutableSliceHelper.isMarked(marker, nextElement, #endStateNumber#)) {");
        codeSnippet.add("\tqueue.add(new PathSystemMarkerEntry(nextElement, element, #traversedEdge#, #endStateNumber#, #endStateFinal#, currentEntry.stateNumber, 0));");
        codeSnippet.add("}");
        codeSnippet.add("ExecutableSliceHelper.markVertex(marker, nextElement, #endStateNumber#, #endStateFinal#, element, #traversedEdge#, currentEntry.stateNumber, 0);");
        codeList.add(codeSnippet);
        return codeList;
    }

    private String createCodeForSliceFunction(FunctionApplication functionApplication) {
        IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
        Expression expression = (Expression)isArgumentOf.getThat();
        isArgumentOf = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN);
        PathDescription pathDescription = (PathDescription)isArgumentOf.getThat();
        PathDescriptionEvaluator pathDescriptionEvaluator = (PathDescriptionEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(pathDescription);
        DFA dFA = ((NFA)pathDescriptionEvaluator.getResult(this.evaluator)).getDFA();
        return this.createCodeForSlice(dFA, expression, functionApplication);
    }

    private String createCodeForSlice(DFA dFA, Expression expression, FunctionApplication functionApplication) {
        CodeList codeList = new CodeList();
        this.addImports("de.uni_koblenz.jgralab.*");
        this.addImports("de.uni_koblenz.jgralab.greql.executable.ExecutableSliceHelper");
        this.addImports("de.uni_koblenz.jgralab.greql.executable.PathSystemMarkerEntry");
        this.addImports("de.uni_koblenz.jgralab.graphmarker.GraphMarker");
        this.addImports("java.util.HashSet");
        this.addImports("java.util.ArrayList");
        this.addImports("java.util.Map");
        codeList.setVariable("stateCount", Integer.toString(dFA.stateList.size()));
        codeList.setVariable("initialStateNumber", Integer.toString(dFA.initialState.number));
        codeList.setVariable("initialStateFinal", Boolean.toString(dFA.initialState.isFinal));
        CodeSnippet codeSnippet = new CodeSnippet();
        codeList.add(codeSnippet);
        codeSnippet.add("Object rootResult = " + this.createCodeForExpression(expression) + ";");
        codeSnippet.add("@SuppressWarnings(\"unchecked\")");
        codeSnippet.add("org.pcollections.PSet<Vertex> rootVertices = (org.pcollections.PSet<Vertex>) (rootResult instanceof Vertex ? JGraLab.set().plus(rootResult) : rootResult);");
        codeSnippet.add("Set<Vertex> sliCritVertices = new HashSet<Vertex>();");
        codeSnippet.add("sliCritVertices.addAll(rootVertices);");
        codeSnippet.add("java.util.List<GraphMarker<Map<Edge, PathSystemMarkerEntry>>> marker = new ArrayList<GraphMarker<Map<Edge, PathSystemMarkerEntry>>>(" + dFA.stateList.size() + ");");
        codeSnippet.add("for (int i = 0; i < " + dFA.stateList.size() + "; i++) {");
        codeSnippet.add("\tmarker.add(new GraphMarker<Map<Edge, PathSystemMarkerEntry>>(datagraph));");
        codeSnippet.add("}");
        codeSnippet.add("java.util.List<Vertex> finalVertices = new ArrayList<Vertex>();");
        codeSnippet.add("Vertex element;");
        codeSnippet.add("Vertex nextElement;");
        codeSnippet.add("java.util.Queue<PathSystemMarkerEntry> queue = new java.util.LinkedList<PathSystemMarkerEntry>();");
        codeSnippet.add("PathSystemMarkerEntry currentEntry;");
        codeSnippet.add("for (Vertex v: sliCritVertices) {");
        codeSnippet.add("\tcurrentEntry = new PathSystemMarkerEntry(v, null, null, " + dFA.initialState.number + ", " + dFA.initialState.isFinal + ", 0, 0);");
        codeSnippet.add("\tqueue.offer(currentEntry);");
        codeSnippet.add("\tExecutableSliceHelper.markVertex(marker, v, #initialStateNumber#, #initialStateFinal#, null, null, 0, 0);");
        codeSnippet.add("}");
        codeSnippet.add("while (!queue.isEmpty()) {");
        codeSnippet.add("\tcurrentEntry = queue.poll();");
        codeSnippet.add("\telement = currentEntry.vertex;");
        codeSnippet.add("\tif (currentEntry.stateIsFinal) {");
        codeSnippet.add("\t\tfinalVertices.add(element);");
        codeSnippet.add("\t}");
        codeSnippet.add("\tfor (Edge inc = element.getFirstIncidence();");
        codeSnippet.add("\t\tinc != null; inc = inc.getNextIncidence() ) { //iterating incident edges");
        codeSnippet.add("\t\tswitch (currentEntry.stateNumber) {");
        for (State state : dFA.stateList) {
            CodeList codeList2 = new CodeList();
            codeList.add(codeList2);
            codeList2.add(new CodeSnippet("\t\tcase " + state.number + ":"));
            for (Transition transition : state.outTransitions) {
                CodeList codeList3 = new CodeList();
                codeList2.add(codeList3);
                if (transition.consumesEdge()) {
                    codeList3.add(new CodeSnippet("\t\tnextElement = inc.getThat();"));
                } else {
                    codeList3.add(new CodeSnippet("\t\tnextElement = element;"));
                }
                codeList3.add(new CodeSnippet("\t\tif (!ExecutableSliceHelper.isMarked(marker, nextElement, " + transition.endState.number + ", inc)) {//checking all transitions of state " + transition.endState.number));
                codeList3.add(this.createCodeForTransition(transition, FunctionType.SLICE), 2);
                codeList3.add(new CodeSnippet("\t\t} //finished checking transitions of state " + transition.endState.number));
            }
            codeList2.add(new CodeSnippet("\t\tbreak;//break case block"));
        }
        CodeSnippet codeSnippet2 = new CodeSnippet();
        codeSnippet2.add("\t\t} //end of switch");
        codeSnippet2.add("\t} //end of iterating incident edges ");
        codeSnippet2.add("} //end of processing queue");
        codeSnippet2.add("return ExecutableSliceHelper.createSliceFromMarkings(datagraph, sliCritVertices, finalVertices, marker);");
        codeList.add(codeSnippet2);
        return this.createMethod(codeList, functionApplication);
    }

    private CodeBlock createCodeForTransition(Transition transition, FunctionType functionType) {
        if (transition instanceof EdgeTransition) {
            return this.createCodeForEdgeTransition((EdgeTransition)transition, functionType);
        }
        if (transition instanceof SimpleTransition) {
            return this.createCodeForSimpleTransition((SimpleTransition)transition, functionType);
        }
        if (transition instanceof AggregationTransition) {
            return this.createCodeForAggregationTransition((AggregationTransition)transition, functionType);
        }
        if (transition instanceof BoolExpressionTransition) {
            return this.createCodeForBooleanExpressionTransition((BoolExpressionTransition)transition, functionType);
        }
        if (transition instanceof IntermediateVertexTransition) {
            return this.createCodeForIntermediateVertexTransition((IntermediateVertexTransition)transition, functionType);
        }
        if (transition instanceof VertexTypeRestrictionTransition) {
            return this.createCodeForVertexTypeRestrictionTransition((VertexTypeRestrictionTransition)transition, functionType);
        }
        return new CodeSnippet("FAILURE: TRANSITION TYPE IS UNKNOWN TO GREQL CODE GENERATOR " + transition.getClass().getSimpleName());
    }

    private CodeBlock createCodeForSimpleTransition(SimpleTransition simpleTransition, FunctionType functionType) {
        return this.createCodeForSimpleOrEdgeTransition(simpleTransition, functionType, null);
    }

    private CodeBlock createCodeForEdgeTransition(EdgeTransition edgeTransition, FunctionType functionType) {
        CodeList codeList = new CodeList();
        VertexEvaluator<?> vertexEvaluator = edgeTransition.getAllowedEdgeEvaluator();
        CodeBlock codeBlock = this.createCodeForSimpleOrEdgeTransition(edgeTransition, functionType, codeList);
        if (vertexEvaluator != null) {
            codeList.add(new CodeSnippet("Edge allowedEdge = (Edge) " + this.createCodeForExpression((Expression)vertexEvaluator.getVertex()) + ";"));
            codeList.add(new CodeSnippet("if (inc.getNormalEdge() == allowedEdge.getNormalEdge()){"));
            codeList.add(codeBlock, 1);
            codeList.add(new CodeSnippet("}"));
        }
        return codeList;
    }

    private CodeBlock createCodeForSimpleOrEdgeTransition(SimpleTransition simpleTransition, FunctionType functionType, CodeBlock codeBlock) {
        CodeList codeList;
        CodeList codeList2 = codeList = new CodeList();
        if (simpleTransition.getAllowedDirection() != GReQLDirection.INOUT) {
            switch (simpleTransition.getAllowedDirection()) {
                case IN: {
                    codeList2.add(new CodeSnippet("if (!inc.isNormal()) { //begin of simple transition"));
                    break;
                }
                case OUT: {
                    codeList2.add(new CodeSnippet("if (inc.isNormal()) { //begin of simple transition"));
                    break;
                }
            }
            CodeList codeList3 = new CodeList();
            codeList2.add(codeList3);
            codeList2.add(new CodeSnippet("} //end of simple transition"));
            codeList2 = codeList3;
        }
        codeList2 = this.createTypeCollectionCheck(codeList2, simpleTransition.getTypeCollection());
        codeList2 = this.createRolenameCheck(codeList2, simpleTransition.getValidToRoles(), simpleTransition.getValidFromRoles());
        codeList2 = this.createPredicateCheck(codeList2, simpleTransition.getPredicateEvaluator());
        codeList2.add(codeBlock);
        if (functionType == FunctionType.PATH_SYSTEM) {
            codeList2.add(this.createAddToPathSystemQueueSnippet(simpleTransition));
        } else if (functionType == FunctionType.SLICE) {
            codeList2.add(this.createAddToSliceQueueSnippet(simpleTransition));
        } else {
            codeList2.add(this.createAddToPathSearchQueueSnippet(simpleTransition.endState.number));
        }
        return codeList;
    }

    private CodeBlock createCodeForAggregationTransition(AggregationTransition aggregationTransition, FunctionType functionType) {
        CodeList codeList;
        CodeList codeList2 = codeList = new CodeList();
        this.addImports("de.uni_koblenz.jgralab.schema.AggregationKind");
        if (aggregationTransition.isAggregateFrom()) {
            codeList2.add(new CodeSnippet("AggregationKind aggrKind = inc.getThatAggregationKind();"));
        } else {
            codeList2.add(new CodeSnippet("AggregationKind aggrKind = inc.getThisAggregationKind();"));
        }
        codeList2.add(new CodeSnippet("if ((aggrKind == AggregationKind.SHARED) || (aggrKind == AggregationKind.COMPOSITE)) {"));
        CodeList codeList3 = new CodeList();
        codeList2.add(codeList3);
        codeList2.add(new CodeSnippet("} //of of check aggregation kind"));
        codeList2 = codeList3;
        codeList2 = this.createTypeCollectionCheck(codeList2, aggregationTransition.getTypeCollection());
        codeList2 = this.createRolenameCheck(codeList2, aggregationTransition.getValidToRoles(), aggregationTransition.getValidFromRoles());
        codeList2 = this.createPredicateCheck(codeList2, aggregationTransition.getPredicateEvaluator());
        if (functionType == FunctionType.PATH_SYSTEM) {
            codeList2.add(this.createAddToPathSystemQueueSnippet(aggregationTransition));
        } else if (functionType == FunctionType.SLICE) {
            codeList2.add(this.createAddToSliceQueueSnippet(aggregationTransition));
        } else {
            codeList2.add(this.createAddToPathSearchQueueSnippet(aggregationTransition.endState.number));
        }
        return codeList;
    }

    private CodeList createTypeCollectionCheck(CodeList codeList, TypeCollection typeCollection) {
        if (typeCollection != null) {
            String string = this.createInitializerForTypeCollection(typeCollection);
            codeList.add(new CodeSnippet("if (" + string + ".get(((de.uni_koblenz.jgralab.schema.GraphElementClass<?,?>)inc.getAttributedElementClass()).getGraphElementClassIdInSchema())) { //check type collection"));
            CodeList codeList2 = new CodeList();
            codeList.add(codeList2);
            codeList.add(new CodeSnippet("} //end of check type collection"));
            codeList = codeList2;
        }
        return codeList;
    }

    private CodeList createRolenameCheck(CodeList object, Set<String> set, Set<String> set2) {
        Set<String> set3 = set;
        boolean bl = true;
        if (set3 == null) {
            set3 = set2;
            bl = false;
        }
        if (set3 != null) {
            this.addImports("de.uni_koblenz.jgralab.schema.IncidenceClass");
            HashSet<IncidenceClass> hashSet = new HashSet<IncidenceClass>();
            for (EdgeClass object22 : this.schema.getGraphClass().getEdgeClasses()) {
                Object object2;
                IncidenceClass incidenceClass = object22.getTo();
                if (set3.contains(incidenceClass.getRolename())) {
                    hashSet.add(incidenceClass);
                    object2 = object22.getAllSubClasses().iterator();
                    while (object2.hasNext()) {
                        EdgeClass edgeClass = (EdgeClass)object2.next();
                        hashSet.add(edgeClass.getTo());
                    }
                }
                if (!set3.contains((object2 = object22.getFrom()).getRolename())) continue;
                hashSet.add((IncidenceClass)object2);
                for (EdgeClass edgeClass : object22.getAllSubClasses()) {
                    hashSet.add(edgeClass.getFrom());
                }
            }
            String string = this.createInitializerForIncidenceTypeCollection(hashSet);
            if (bl) {
                ((CodeList)object).add(new CodeSnippet("IncidenceClass ic = inc.isNormal() ? inc.getAttributedElementClass().getTo() : inc.getAttributedElementClass().getFrom();"));
            } else {
                ((CodeList)object).add(new CodeSnippet("IncidenceClass ic = inc.isNormal() ? inc.getAttributedElementClass().getFrom() : inc.getAttributedElementClass().getTo();"));
            }
            ((CodeList)object).add(new CodeSnippet("if (" + (String)string + ".get(ic.getIncidenceClassIdInSchema())) { // begin of role test"));
            CodeList codeList = new CodeList();
            ((CodeList)object).add(codeList);
            ((CodeList)object).add(new CodeSnippet("} //end of role test"));
            object = codeList;
        }
        return object;
    }

    private CodeList createPredicateCheck(CodeList codeList, VertexEvaluator<? extends Expression> vertexEvaluator) {
        if (vertexEvaluator != null) {
            this.createThisLiterals();
            codeList.add(new CodeSnippet("setThisEdge(inc);"));
            codeList.add(new CodeSnippet("setThisVertex(element);"));
            codeList.add(new CodeSnippet("if ((Boolean) " + this.createCodeForExpression(vertexEvaluator.getVertex()) + ") { //begin check predicate"));
            CodeList codeList2 = new CodeList();
            codeList.add(codeList2);
            codeList.add(new CodeSnippet("} //end of predicate check"));
            codeList = codeList2;
        }
        return codeList;
    }

    private CodeBlock createCodeForVertexTypeRestrictionTransition(VertexTypeRestrictionTransition vertexTypeRestrictionTransition, FunctionType functionType) {
        CodeList codeList;
        CodeList codeList2 = codeList = new CodeList();
        TypeCollection typeCollection = vertexTypeRestrictionTransition.getAcceptedVertexTypes();
        if (typeCollection != null) {
            String string = this.createInitializerForTypeCollection(typeCollection);
            codeList2.add(new CodeSnippet("if (" + string + ".get(((de.uni_koblenz.jgralab.schema.GraphElementClass<?,?>)nextElement.getAttributedElementClass()).getGraphElementClassIdInSchema())) {//test for VertexTypeRestriction"));
            CodeList codeList3 = new CodeList();
            codeList2.add(codeList3);
            codeList2.add(new CodeSnippet("} //end of vertex type restriction"));
            codeList2 = codeList3;
        }
        if (functionType == FunctionType.PATH_SYSTEM) {
            codeList2.add(this.createAddToPathSystemQueueSnippet(vertexTypeRestrictionTransition));
        } else if (functionType == FunctionType.SLICE) {
            codeList2.add(this.createAddToSliceQueueSnippet(vertexTypeRestrictionTransition));
        } else {
            codeList2.add(this.createAddToPathSearchQueueSnippet(vertexTypeRestrictionTransition.endState.number));
        }
        return codeList;
    }

    private CodeBlock createCodeForIntermediateVertexTransition(IntermediateVertexTransition intermediateVertexTransition, FunctionType functionType) {
        CodeList codeList;
        CodeList codeList2 = codeList = new CodeList();
        VertexEvaluator<?> vertexEvaluator = intermediateVertexTransition.getIntermediateVertexEvaluator();
        if (vertexEvaluator != null) {
            this.createThisVertex();
            CodeSnippet codeSnippet = new CodeSnippet();
            codeSnippet.add("setThisVertex(element);");
            codeSnippet.add("Object tempRes = " + this.createCodeForExpression((Expression)vertexEvaluator.getVertex()) + ";");
            codeSnippet.add("boolean transitionWorks = tempRes == element;");
            codeSnippet.add("if(!transitionWorks) {");
            codeSnippet.add("\tif(tempRes instanceof org.pcollections.PCollection) {");
            codeSnippet.add("\t\t@SuppressWarnings(\"unchecked\")");
            codeSnippet.add("\t\torg.pcollections.PCollection<Object> tmpList = (org.pcollections.PCollection<Object>) tempRes;");
            codeSnippet.add("\t\ttransitionWorks = tmpList.contains(element);");
            codeSnippet.add("\t}");
            codeSnippet.add("}");
            codeSnippet.add("if(transitionWorks) { //test of intermediate vertex transition");
            codeList.add(codeSnippet);
            CodeList codeList3 = new CodeList();
            codeList.add(codeList3);
            codeList.add(new CodeSnippet("} //end of intermediate vertex transition"));
            codeList = codeList3;
        }
        if (functionType == FunctionType.PATH_SYSTEM) {
            codeList.add(this.createAddToPathSystemQueueSnippet(intermediateVertexTransition));
        } else if (functionType == FunctionType.SLICE) {
            codeList.add(this.createAddToSliceQueueSnippet(intermediateVertexTransition));
        } else {
            codeList.add(this.createAddToPathSearchQueueSnippet(intermediateVertexTransition.endState.number));
        }
        return codeList2;
    }

    private CodeBlock createCodeForBooleanExpressionTransition(BoolExpressionTransition boolExpressionTransition, FunctionType functionType) {
        CodeList codeList;
        CodeList codeList2 = codeList = new CodeList();
        VertexEvaluator<? extends Expression> vertexEvaluator = boolExpressionTransition.getBooleanExpressionEvaluator();
        if (vertexEvaluator != null) {
            this.createThisVertex();
            codeList.add(new CodeSnippet("setThisVertex(element);"));
            codeList.add(new CodeSnippet("if ((Boolean) " + this.createCodeForExpression(vertexEvaluator.getVertex()) + ") {"));
            CodeList codeList3 = new CodeList();
            codeList.add(codeList3);
            codeList.add(new CodeSnippet("}"));
            codeList = codeList3;
        }
        if (functionType == FunctionType.PATH_SYSTEM) {
            codeList.add(this.createAddToPathSystemQueueSnippet(boolExpressionTransition));
        } else if (functionType == FunctionType.SLICE) {
            codeList.add(this.createAddToSliceQueueSnippet(boolExpressionTransition));
        } else {
            codeList.add(this.createAddToPathSearchQueueSnippet(boolExpressionTransition.endState.number));
        }
        return codeList2;
    }

    private String getVariableName(String string) {
        return "result_" + string;
    }

    private String createMethod(CodeList codeList, GreqlVertex greqlVertex) {
        String string = "// " + GreqlSerializer.serializeVertex(greqlVertex).replace("\n", " ");
        String string2 = Integer.toString(greqlVertex.getId());
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string3 = "";
        for (String object2 : this.scope.getDefinedVariables()) {
            stringBuilder.append(string3 + "Object " + object2);
            stringBuilder2.append(string3 + object2);
            string3 = ",";
        }
        String string4 = "evaluationMethod_" + greqlVertex.getId() + "_" + this.uniqueMethodId++;
        CodeList codeList2 = new CodeList();
        codeList2.setVariable("actualParams", stringBuilder2.toString());
        codeList2.setVariable("formalParams", stringBuilder.toString());
        if (!this.resultVariables.contains(this.getVariableName(string2))) {
            codeList2.add(new CodeSnippet("private Object " + this.getVariableName(string2) + " = null;"));
            this.resultVariables.add(this.getVariableName(string2));
        }
        CodeSnippet codeSnippet = new CodeSnippet();
        codeSnippet.add("private Object " + (String)string4 + "(#formalParams#) {");
        codeSnippet.add("\tif (result_" + string2 + " == null) {");
        codeSnippet.add("\t\tresult_" + string2 + " = internal_" + (String)string4 + "(#actualParams#);");
        codeSnippet.add("\t}");
        codeSnippet.add("\treturn result_" + string2 + ";");
        codeSnippet.add("}\n");
        codeList2.add(codeSnippet);
        codeList2.add(new CodeSnippet(string));
        codeList2.add(new CodeSnippet("private Object internal_" + (String)string4 + "(#formalParams#) {"));
        codeList2.add(codeList);
        codeList2.add(new CodeSnippet("}\n"));
        this.createdMethods.add(codeList2);
        return (String)string4 + "(" + stringBuilder2.toString() + ")";
    }

    private void createThisLiterals() {
        this.createThisEdge();
        this.createThisVertex();
    }

    public void createThisEdge() {
        if (!this.thisEdgeCreated) {
            this.thisEdgeCreated = true;
            this.addClassField("Edge", "thisEdge", "null");
            this.createSetterForThisLiteral(this.graph.getFirstThisEdge(), "Edge");
        }
    }

    public void createThisVertex() {
        if (!this.thisVertexCreated) {
            this.thisVertexCreated = true;
            this.addClassField("Vertex", "thisVertex", "null");
            this.createSetterForThisLiteral(this.graph.getFirstThisVertex(), "Vertex");
        }
    }

    protected void createSetterForThisLiteral(ThisLiteral thisLiteral, String string) {
        CodeList codeList = new CodeList();
        CodeSnippet codeSnippet = new CodeSnippet();
        codeList.add(codeSnippet);
        codeSnippet.setVariable("edgeOrVertex", string);
        codeSnippet.add("private final void setThis#edgeOrVertex#(#edgeOrVertex# value) {");
        if (thisLiteral != null) {
            VariableEvaluator variableEvaluator = (VariableEvaluator)((GreqlQueryImpl)this.query).getVertexEvaluator(thisLiteral);
            List<VertexEvaluator<Expression>> list = variableEvaluator.calculateDependingExpressions();
            for (VertexEvaluator<Expression> vertexEvaluator : list) {
                Expression expression = vertexEvaluator.getVertex();
                if (expression instanceof Variable || expression instanceof PathDescription || expression instanceof EdgeRestriction) continue;
                String string2 = this.getVariableName(Integer.toString(expression.getId()));
                codeSnippet.add("\t" + string2 + " = null; //result of vertex " + expression.getAttributedElementClass().getSimpleName());
            }
        }
        codeSnippet.add("\tthis#edgeOrVertex# = value;");
        codeSnippet.add("}");
        this.createdMethods.add(codeList);
    }

    private void addStaticField(String string, String string2, String string3) {
        if (!this.staticFieldNames.contains(string2)) {
            this.staticFieldNames.add(string2);
            this.staticFieldSnippet.add("static " + string + " " + string2 + " = " + string3 + ";", "");
        }
    }

    private void addClassField(String string, String string2, String string3) {
        this.classFieldSnippet.add(string + " " + string2 + " = " + string3 + ";", "");
    }

    private void addStaticInitializer(String string) {
        this.staticInitializerSnippet.add("\t" + string);
    }

    @Override
    public void createFiles(String string) throws GraphIOException {
        String string2 = this.rootBlock.getVariable("schemaPackage");
        this.createCode();
        this.writeCodeToFile(string, this.classname + ".java", string2);
    }

    public InMemoryJavaSourceFile createInMemoryJavaSource() {
        this.createCode();
        return new InMemoryJavaSourceFile(this.classname, this.rootBlock.getCode());
    }

    public Class<ExecutableQuery> compile() {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            throw new SchemaException("Cannot compile greql query. Most probably, you use a JRE instead of a JDK. The JRE does not provide a compiler.");
        }
        Vector<InMemoryJavaSourceFile> vector = new Vector<InMemoryJavaSourceFile>();
        vector.add(this.createInMemoryJavaSource());
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
        ClassFileManager classFileManager = new ClassFileManager(this, standardJavaFileManager);
        javaCompiler.getTask(null, classFileManager, null, null, null, vector).call();
        try {
            SchemaClassManager schemaClassManager = SchemaClassManager.instance(codeGeneratorFileManagerName);
            return Class.forName(this.packageName + "." + this.classname, true, schemaClassManager);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    @Override
    protected CodeBlock createHeader() {
        return new CodeSnippet("public class " + this.classname + " extends AbstractExecutableQuery implements ExecutableQuery {");
    }

    @Override
    protected CodeBlock createPackageDeclaration() {
        return new CodeSnippet("package " + this.packageName + ";");
    }

    @Override
    public String getManagedName() {
        return codeGeneratorFileManagerName;
    }

    private static enum FunctionType {
        SLICE,
        PATH_SYSTEM,
        OTHER;

    }
}

