/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.GraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSystemMarkerEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

@NeedsEvaluatorArgument
public class PathSystem
extends Function {
    @Description(params={"internal", "startVertex", "fa"}, description="Returns a path system with the given root vertex, which is structured according to the given path description.", categories={Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public PathSystem() {
        super(1000L, 1L, 1.0);
    }

    public de.uni_koblenz.jgralab.greql.types.PathSystem evaluate(InternalGreqlEvaluator internalGreqlEvaluator, Vertex vertex, DFA dFA) {
        GraphMarker[] graphMarkerArray = new GraphMarker[dFA.stateList.size()];
        for (int i = 0; i < dFA.stateList.size(); ++i) {
            graphMarkerArray[i] = new GraphMarker(vertex.getGraph());
        }
        Set<PathSystemMarkerEntry> set = this.markVerticesOfPathSystem(internalGreqlEvaluator, graphMarkerArray, vertex, dFA);
        de.uni_koblenz.jgralab.greql.types.PathSystem pathSystem = this.createPathSystemFromMarkings(graphMarkerArray, vertex, set);
        return pathSystem;
    }

    protected PathSystemMarkerEntry markVertex(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, State state, Vertex vertex2, Edge edge, State state2, int n) {
        PathSystemMarkerEntry pathSystemMarkerEntry = new PathSystemMarkerEntry(vertex, vertex2, edge, state, state2, n);
        GraphMarker<PathSystemMarkerEntry> graphMarker = graphMarkerArray[state.number];
        graphMarker.mark(vertex, pathSystemMarkerEntry);
        return pathSystemMarkerEntry;
    }

    protected boolean isMarked(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, State state) {
        GraphMarker<PathSystemMarkerEntry> graphMarker = graphMarkerArray[state.number];
        return graphMarker.isMarked(vertex);
    }

    private Set<PathSystemMarkerEntry> markVerticesOfPathSystem(InternalGreqlEvaluator internalGreqlEvaluator, GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, DFA dFA) {
        HashSet<PathSystemMarkerEntry> hashSet = new HashSet<PathSystemMarkerEntry>();
        LinkedList<PathSystemMarkerEntry> linkedList = new LinkedList<PathSystemMarkerEntry>();
        PathSystemMarkerEntry pathSystemMarkerEntry = this.markVertex(graphMarkerArray, vertex, dFA.initialState, null, null, null, 0);
        if (dFA.initialState.isFinal) {
            hashSet.add(pathSystemMarkerEntry);
        }
        linkedList.add(pathSystemMarkerEntry);
        while (!linkedList.isEmpty()) {
            pathSystemMarkerEntry = (PathSystemMarkerEntry)linkedList.poll();
            Vertex vertex2 = pathSystemMarkerEntry.vertex;
            for (Edge edge : vertex2.incidences()) {
                for (Transition transition : pathSystemMarkerEntry.state.outTransitions) {
                    Vertex vertex3 = transition.getNextVertex(vertex2, edge);
                    if (this.isMarked(graphMarkerArray, vertex3, transition.endState) || !transition.accepts(vertex2, edge, internalGreqlEvaluator)) continue;
                    Edge edge2 = transition.consumesEdge() ? edge : null;
                    PathSystemMarkerEntry pathSystemMarkerEntry2 = this.markVertex(graphMarkerArray, vertex3, transition.endState, vertex2, edge2, pathSystemMarkerEntry.state, pathSystemMarkerEntry.distanceToRoot + 1);
                    if (transition.endState.isFinal) {
                        hashSet.add(pathSystemMarkerEntry2);
                    }
                    linkedList.add(pathSystemMarkerEntry2);
                }
            }
        }
        return hashSet;
    }

    private de.uni_koblenz.jgralab.greql.types.PathSystem createPathSystemFromMarkings(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, Set<PathSystemMarkerEntry> set) {
        de.uni_koblenz.jgralab.greql.types.PathSystem pathSystem = new de.uni_koblenz.jgralab.greql.types.PathSystem();
        HashMap<Vertex, PathSystem.PathSystemNode[]> hashMap = new HashMap<Vertex, PathSystem.PathSystemNode[]>();
        HashMap<Vertex, PathSystemMarkerEntry[]> hashMap2 = new HashMap<Vertex, PathSystemMarkerEntry[]>();
        LinkedList<PathSystem.PathSystemNode> linkedList = new LinkedList<PathSystem.PathSystemNode>();
        PathSystemMarkerEntry pathSystemMarkerEntry = (PathSystemMarkerEntry)graphMarkerArray[0].getMark(vertex);
        PathSystem.PathSystemNode pathSystemNode = pathSystem.setRootVertex(vertex, pathSystemMarkerEntry.state.number, pathSystemMarkerEntry.state.isFinal);
        PathSystem.PathSystemNode[] pathSystemNodeArray = new PathSystem.PathSystemNode[graphMarkerArray.length];
        pathSystemNodeArray[pathSystemMarkerEntry.state.number] = pathSystemNode;
        hashMap.put(vertex, pathSystemNodeArray);
        for (PathSystemMarkerEntry pathSystemMarkerEntry2 : set) {
            Vertex vertex2 = pathSystemMarkerEntry2.vertex;
            while (vertex2 != null) {
                PathSystemMarkerEntry[] pathSystemMarkerEntryArray;
                PathSystem.PathSystemNode pathSystemNode2 = this.addVertexToPathSystem(pathSystem, hashMap, graphMarkerArray.length, vertex2, pathSystemMarkerEntry2.state.number, pathSystemMarkerEntry2.state.isFinal);
                if (pathSystemMarkerEntry2.edgeToParentVertex != null) {
                    pathSystemMarkerEntryArray = this.addVertexToPathSystem(pathSystem, hashMap, graphMarkerArray.length, pathSystemMarkerEntry2.parentVertex, pathSystemMarkerEntry2.parentState != null ? pathSystemMarkerEntry2.parentState.number : 0, pathSystemMarkerEntry2.parentState != null ? pathSystemMarkerEntry2.parentState.isFinal : false);
                    pathSystem.addEdge(pathSystemNode2, (PathSystem.PathSystemNode)pathSystemMarkerEntryArray, pathSystemMarkerEntry2.edgeToParentVertex);
                } else if (!(vertex2 == pathSystem.getRootVertex() && pathSystemMarkerEntry2.distanceToRoot == 0 || linkedList.contains(pathSystemNode2))) {
                    linkedList.add(pathSystemNode2);
                    pathSystemMarkerEntryArray = (PathSystemMarkerEntry[])hashMap2.get(vertex2);
                    if (pathSystemMarkerEntryArray == null) {
                        pathSystemMarkerEntryArray = new PathSystemMarkerEntry[graphMarkerArray.length];
                        hashMap2.put(vertex2, pathSystemMarkerEntryArray);
                    }
                    assert (pathSystemMarkerEntryArray[pathSystemMarkerEntry2.state.number] == null) : "already exiting:" + pathSystemMarkerEntryArray[pathSystemMarkerEntry2.state.number] + " new: " + pathSystemMarkerEntry2;
                    pathSystemMarkerEntryArray[pathSystemMarkerEntry2.state.number] = pathSystemMarkerEntry2;
                }
                vertex2 = pathSystemMarkerEntry2.parentVertex;
                pathSystemMarkerEntry2 = this.getMarkerWithState(graphMarkerArray, vertex2, pathSystemMarkerEntry2.parentState);
            }
        }
        this.completePathSystem(pathSystem, linkedList, hashMap2, hashMap);
        pathSystem.finish();
        return pathSystem;
    }

    private PathSystem.PathSystemNode addVertexToPathSystem(de.uni_koblenz.jgralab.greql.types.PathSystem pathSystem, Map<Vertex, PathSystem.PathSystemNode[]> map, int n, Vertex vertex, int n2, boolean bl) {
        PathSystem.PathSystemNode pathSystemNode;
        assert (vertex != null);
        PathSystem.PathSystemNode[] pathSystemNodeArray = map.get(vertex);
        if (pathSystemNodeArray == null) {
            pathSystemNodeArray = new PathSystem.PathSystemNode[n];
            map.put(vertex, pathSystemNodeArray);
        } else {
            pathSystemNode = pathSystemNodeArray[n2];
            if (pathSystemNode != null) {
                if (bl) {
                    pathSystem.addLeaf(pathSystemNode);
                }
                return pathSystemNode;
            }
        }
        pathSystemNodeArray[n2] = pathSystemNode = pathSystem.addVertex(vertex, n2, bl);
        return pathSystemNode;
    }

    private void completePathSystem(de.uni_koblenz.jgralab.greql.types.PathSystem pathSystem, Queue<PathSystem.PathSystemNode> queue, Map<Vertex, PathSystemMarkerEntry[]> map, Map<Vertex, PathSystem.PathSystemNode[]> map2) {
        while (!queue.isEmpty()) {
            PathSystem.PathSystemNode pathSystemNode = queue.poll();
            PathSystem.PathSystemNode pathSystemNode2 = null;
            PathSystemMarkerEntry[] pathSystemMarkerEntryArray = map.get(pathSystemNode.currentVertex);
            assert (pathSystemMarkerEntryArray != null);
            pathSystemNode2 = pathSystemMarkerEntryArray[pathSystemNode.state] != null ? map2.get(pathSystemMarkerEntryArray[pathSystemNode.state].parentVertex)[pathSystemMarkerEntryArray[pathSystemNode.state].parentState.number] : pathSystem.getRoot();
            if (pathSystemNode2 == null) continue;
            Set<PathSystem.PathSystemNode> set = pathSystem.getParents(pathSystemNode2);
            assert (set.size() <= 1);
            for (PathSystem.PathSystemNode pathSystemNode3 : set) {
                pathSystem.addEdge(pathSystemNode, pathSystemNode3, pathSystemNode2.edge2parent);
            }
        }
    }

    private PathSystemMarkerEntry getMarkerWithState(GraphMarker<PathSystemMarkerEntry>[] graphMarkerArray, Vertex vertex, State state) {
        if (vertex == null) {
            return null;
        }
        GraphMarker<PathSystemMarkerEntry> graphMarker = graphMarkerArray[state.number];
        PathSystemMarkerEntry pathSystemMarkerEntry = (PathSystemMarkerEntry)graphMarker.getMark(vertex);
        return pathSystemMarkerEntry;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> arrayList) {
        return 1000L;
    }

    @Override
    public double getSelectivity() {
        return 0.001f;
    }

    @Override
    public long getEstimatedCardinality(int n) {
        return 1L;
    }
}

