/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.relations;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;

public class Equals
extends Function {
    @Description(params={"a", "b"}, description="Determines if $a$ and $b$ are equal. Alternative: a = b", categories={Function.Category.RELATIONS})
    public Equals() {
        super(2L, 1L, 0.05);
    }

    public Boolean evaluate(String string, Enum<?> enum_) {
        return string.equals(enum_.toString());
    }

    public Boolean evaluate(Enum<?> enum_, String string) {
        return string.equals(enum_.toString());
    }

    public Boolean evaluate(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return number.doubleValue() == number2.doubleValue();
        }
        if (number instanceof Long || number2 instanceof Long) {
            return number.longValue() == number2.longValue();
        }
        return number.intValue() == number2.intValue();
    }

    public Boolean evaluate(Object object, Object object2) {
        return object.equals(object2);
    }
}

