/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class DefaultOptimizerInfo
implements OptimizerInfo {
    public static final String PROPERTY_FILE_VERSION = "OptimizerInfo-1.0";
    private static final String OPTIMIZER_INFO_VERSION_KEY = "OptimizerInfoVersion";
    private static final String AVERAGE_VERTEX_COUNT_KEY = "AverageVertexCount";
    private static final String AVERAGE_EDGE_COUNT_KEY = "AverageEdgeCount";
    private static final String QUALIFIED_SCHEMA_NAME_KEY = "QualifiedSchemaName";
    private static final double DEFAULT_AVG_EC_SUBCLASSES = 2.0;
    private static final double DEFAULT_AVG_VC_SUBCLASSES = 2.0;
    private static final int DEFAULT_ABSTRACT_EC_COUNT = 10;
    private static final int DEFAULT_EC_COUNT = 50;
    private static final int DEFAULT_ABSTRACT_VC_COUNT = 10;
    private static final int DEFAULT_VC_COUNT = 50;
    private static final int DEFAULT_AVG_EDGE_COUNT = 15000;
    private static final long DEFAULT_AVG_VERTEX_COUNT = 10000L;
    private Schema schema;
    private long avgVertexCount;
    private long avgEdgeCount;
    private int abstractVertexClassCount;
    private int abstractEdgeClassCount;
    private int vertexClassCount;
    private int edgeClassCount;
    private double avgEdgeSubclasses;
    private double avgVertexSubclasses;
    private HashMap<GraphElementClass<?, ?>, Double> frequenciesWithoutSubclasses;
    private HashMap<GraphElementClass<?, ?>, Double> frequencies;

    public DefaultOptimizerInfo() {
        this(null);
    }

    public DefaultOptimizerInfo(Schema schema) {
        this(schema, null);
    }

    public DefaultOptimizerInfo(Schema schema, String string) {
        int n;
        this.schema = schema;
        this.avgVertexCount = 10000L;
        this.avgEdgeCount = 15000L;
        if (schema == null) {
            this.vertexClassCount = 50;
            this.abstractVertexClassCount = 10;
            this.edgeClassCount = 50;
            this.abstractEdgeClassCount = 10;
            this.avgVertexSubclasses = 2.0;
            this.avgEdgeSubclasses = 2.0;
            return;
        }
        GraphClass graphClass = schema.getGraphClass();
        this.vertexClassCount = graphClass.getVertexClassCount();
        this.edgeClassCount = graphClass.getEdgeClassCount();
        this.abstractVertexClassCount = 0;
        this.abstractEdgeClassCount = 0;
        this.avgVertexSubclasses = 0.0;
        this.avgEdgeSubclasses = 0.0;
        if (this.vertexClassCount > 0) {
            n = 0;
            for (VertexClass graphElementClass : graphClass.getVertexClasses()) {
                n += graphElementClass.getAllSubClasses().size();
                if (!graphElementClass.isAbstract()) continue;
                ++this.abstractVertexClassCount;
            }
            this.avgVertexSubclasses = (double)n / (double)this.vertexClassCount;
            if (this.abstractVertexClassCount == this.vertexClassCount) {
                this.abstractVertexClassCount = 0;
            }
        }
        if (this.edgeClassCount > 0) {
            n = 0;
            for (EdgeClass edgeClass : graphClass.getEdgeClasses()) {
                n += edgeClass.getAllSubClasses().size();
                if (!edgeClass.isAbstract()) continue;
                ++this.abstractEdgeClassCount;
            }
            this.avgEdgeSubclasses = (double)n / (double)this.edgeClassCount;
            if (this.abstractEdgeClassCount == this.edgeClassCount) {
                this.abstractEdgeClassCount = 0;
            }
        }
        this.frequenciesWithoutSubclasses = new HashMap(this.vertexClassCount + this.edgeClassCount);
        for (GraphElementClass<?, ?> graphElementClass : graphClass.getGraphElementClasses()) {
            if (graphElementClass instanceof VertexClass) {
                this.frequenciesWithoutSubclasses.put(graphElementClass, graphElementClass.isAbstract() ? 0.0 : 1.0 / (double)(this.vertexClassCount - this.abstractVertexClassCount));
                continue;
            }
            this.frequenciesWithoutSubclasses.put(graphElementClass, graphElementClass.isAbstract() ? 0.0 : 1.0 / (double)(this.edgeClassCount - this.abstractEdgeClassCount));
        }
        this.frequencies = new HashMap(this.vertexClassCount + this.edgeClassCount);
        for (GraphElementClass<?, ?> graphElementClass : schema.getGraphClass().getGraphElementClasses()) {
            double d = this.frequenciesWithoutSubclasses.get(graphElementClass);
            for (GraphElementClass graphElementClass2 : graphElementClass.getAllSubClasses()) {
                d += this.frequenciesWithoutSubclasses.get(graphElementClass2).doubleValue();
            }
            this.frequencies.put(graphElementClass, d);
        }
        if (string != null) {
            try {
                this.loadFromPropertyFile(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public void storePropertyFile(String string) throws IOException {
        Properties properties = new Properties();
        properties.put(OPTIMIZER_INFO_VERSION_KEY, PROPERTY_FILE_VERSION);
        properties.put(QUALIFIED_SCHEMA_NAME_KEY, this.schema.getQualifiedName());
        properties.put(AVERAGE_VERTEX_COUNT_KEY, Long.toString(this.avgVertexCount));
        properties.put(AVERAGE_EDGE_COUNT_KEY, Long.toString(this.avgEdgeCount));
        for (GraphElementClass<?, ?> graphElementClass : this.frequencies.keySet()) {
            properties.put((graphElementClass instanceof VertexClass ? "VC_" : "EC_") + graphElementClass.getQualifiedName(), this.frequenciesWithoutSubclasses.get(graphElementClass) + ";" + this.frequencies.get(graphElementClass));
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        properties.store(bufferedOutputStream, null);
        bufferedOutputStream.close();
    }

    private void loadFromPropertyFile(String string) throws IOException {
        if (this.schema == null) {
            throw new IllegalStateException("schema must not be null when loading a property file");
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        Properties properties = new Properties();
        properties.load(bufferedInputStream);
        String string2 = properties.getProperty(OPTIMIZER_INFO_VERSION_KEY);
        if (!PROPERTY_FILE_VERSION.equals(string2)) {
            throw new RuntimeException("Wrong property file format, expected: \"OptimizerInfo-1.0\", found: \"" + string2 + "\"");
        }
        String string3 = properties.getProperty(QUALIFIED_SCHEMA_NAME_KEY);
        if (!this.schema.getQualifiedName().equals(string3)) {
            throw new RuntimeException("Schema name mismatch, expected \"" + this.schema.getQualifiedName() + "\", found \"" + string3 + "\"");
        }
        for (String string4 : properties.stringPropertyNames()) {
            String string5 = properties.getProperty(string4);
            if (string4.startsWith("VC_") || string4.startsWith("EC_")) {
                String string6 = string4.substring(3);
                GraphElementClass<?, ?> graphElementClass = this.schema.getGraphClass().getGraphElementClass(string6);
                if (graphElementClass == null) {
                    throw new RuntimeException("GraphElementClass \"" + string6 + "\" does not exist in schema \"" + this.schema.getQualifiedName() + "\"");
                }
                String[] stringArray = string5.split(";");
                this.frequenciesWithoutSubclasses.put(graphElementClass, Double.parseDouble(stringArray[0]));
                this.frequencies.put(graphElementClass, Double.parseDouble(stringArray[1]));
                continue;
            }
            if (string4.equals(AVERAGE_VERTEX_COUNT_KEY)) {
                this.setAvgVertexCount(Long.parseLong(string5));
                continue;
            }
            if (string4.equals(AVERAGE_EDGE_COUNT_KEY)) {
                this.setAvgEdgeCount(Long.parseLong(string5));
                continue;
            }
            if (string4.equals(QUALIFIED_SCHEMA_NAME_KEY) || string4.equals(OPTIMIZER_INFO_VERSION_KEY)) continue;
            throw new RuntimeException("Unknown property key \"" + string4 + "\"");
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int getEdgeClassCount() {
        return this.edgeClassCount;
    }

    @Override
    public int getVertexClassCount() {
        return this.vertexClassCount;
    }

    public int getAbstractVertexClassCount() {
        return this.abstractVertexClassCount;
    }

    public int getAbstractEdgeClassCount() {
        return this.abstractEdgeClassCount;
    }

    @Override
    public long getAverageVertexCount() {
        return this.avgVertexCount;
    }

    @Override
    public long getAverageEdgeCount() {
        return this.avgEdgeCount;
    }

    public void setSchema(Schema schema) {
        if (this.schema != null) {
            throw new IllegalArgumentException("Schema can be set only once");
        }
        this.schema = schema;
    }

    public void setAvgVertexCount(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("avgVertexCount must be > 0");
        }
        this.avgVertexCount = l;
    }

    public void setAvgEdgeCount(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("avgEdgeCount must be > 0");
        }
        this.avgEdgeCount = l;
    }

    public void setFrequencies(GraphElementClass<?, ?> graphElementClass, double d, double d2) {
        if (this.schema == null) {
            throw new IllegalStateException("Schema must be set before defining frequencies");
        }
        if (graphElementClass.getSchema() != this.schema) {
            throw new IllegalArgumentException("GraphElementClass does not belong to schema");
        }
        this.frequenciesWithoutSubclasses.put(graphElementClass, d);
        this.frequencies.put(graphElementClass, d2);
    }

    @Override
    public double getAverageVertexSubclasses() {
        return this.avgVertexSubclasses;
    }

    @Override
    public double getAverageEdgeSubclasses() {
        return this.avgEdgeSubclasses;
    }

    @Override
    public double getFrequencyOfGraphElementClass(GraphElementClass<?, ?> graphElementClass) {
        if (this.schema == null) {
            if (graphElementClass instanceof VertexClass) {
                return (double)this.getAverageVertexCount() * this.getAverageVertexSubclasses() / (double)(this.getVertexClassCount() - this.getAbstractVertexClassCount());
            }
            return (double)this.getAverageEdgeCount() * this.getAverageEdgeSubclasses() / (double)(this.getEdgeClassCount() - this.getAbstractEdgeClassCount());
        }
        return this.frequencies.get(graphElementClass);
    }

    @Override
    public double getFrequencyOfGraphElementClassWithoutSubclasses(GraphElementClass<?, ?> graphElementClass) {
        if (this.schema == null) {
            if (graphElementClass.isAbstract()) {
                return 0.0;
            }
            if (graphElementClass instanceof VertexClass) {
                return (double)this.getAverageVertexCount() / (double)(this.getVertexClassCount() - this.getAbstractVertexClassCount());
            }
            return (double)this.getAverageEdgeCount() / (double)(this.getEdgeClassCount() - this.getAbstractEdgeClassCount());
        }
        return this.frequenciesWithoutSubclasses.get(graphElementClass);
    }

    @Override
    public double getFrequencyOfTypeCollection(TypeCollection typeCollection) {
        return typeCollection.getFrequency(this);
    }

    @Override
    public double getEdgesPerVertex() {
        return (double)this.getAverageEdgeCount() / (double)this.getAverageVertexCount();
    }

    @Override
    public long getEstimatedGraphElementCount(GraphElementClass<?, ?> graphElementClass) {
        if (graphElementClass instanceof VertexClass) {
            return (long)((double)this.getAverageVertexCount() * this.getFrequencyOfGraphElementClass(graphElementClass));
        }
        return (long)((double)this.getAverageEdgeCount() * this.getFrequencyOfGraphElementClass(graphElementClass));
    }

    @Override
    public long getEstimatedGraphElementCount(TypeCollection typeCollection) {
        return typeCollection.getEstimatedGraphElementCount(this);
    }
}

