/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsVarOf;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.RecordId;
import de.uni_koblenz.jgralab.greql.schema.SetComprehension;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class EarlySelectionOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(EarlySelectionOptimizer.class);
    private GreqlGraph syntaxgraph;

    public EarlySelectionOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof EarlySelectionOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        this.syntaxgraph = greqlQuery.getQueryGraph();
        int n = 1;
        while (this.runOptimization()) {
            logger.finer(this.optimizerHeaderString() + "Iteration " + n + " finished.  Restarting...");
            ++n;
        }
        if (n > 1) {
            logger.finer(this.optimizerHeaderString() + "finished after " + n + " runs.");
        }
        OptimizerUtility.createMissingSourcePositions(this.syntaxgraph);
        return n > 1;
    }

    private boolean runOptimization() throws OptimizerException {
        HashMap hashMap = new HashMap();
        for (Declaration object22 : this.syntaxgraph.getDeclarationVertices()) {
            for (Object object = object22.getFirstIsConstraintOfIncidence(EdgeDirection.IN); object != null; object = object.getNextIsConstraintOfIncidence(EdgeDirection.IN)) {
                GreqlVertex greqlVertex = object.getAlpha();
                for (Map.Entry<SimpleDeclaration, Set<Expression>> entry : this.collectMovableExpressions((Expression)greqlVertex).entrySet()) {
                    if (hashMap.containsKey(entry.getKey())) {
                        ((Set)hashMap.get(entry.getKey())).addAll((Collection)entry.getValue());
                        continue;
                    }
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList, new Comparator<SimpleDeclaration>(){

            @Override
            public int compare(SimpleDeclaration simpleDeclaration, SimpleDeclaration simpleDeclaration2) {
                Declaration declaration;
                Declaration declaration2 = simpleDeclaration.getFirstIsSimpleDeclOfIncidence().getOmega();
                if (OptimizerUtility.isAbove(declaration2, declaration = simpleDeclaration2.getFirstIsSimpleDeclOfIncidence().getOmega())) {
                    return 1;
                }
                if (OptimizerUtility.isAbove(declaration, declaration2)) {
                    return -1;
                }
                return 0;
            }
        });
        for (GreqlVertex greqlVertex : arrayList) {
            Map.Entry<SimpleDeclaration, Set<Expression>> entry;
            Declaration declaration = greqlVertex.getFirstIsSimpleDeclOfIncidence().getOmega();
            entry = OptimizerUtility.collectVariablesDeclaredBy((SimpleDeclaration)greqlVertex);
            boolean bl2 = false;
            boolean bl3 = false;
            Set<Variable> set = new HashSet<Variable>();
            for (Expression expression : (Set)hashMap.get(greqlVertex)) {
                Set<Variable> set2 = this.collectNeededLocalVariables(expression);
                if (set2.size() < entry.size()) {
                    bl3 = true;
                    if (set.size() >= set2.size()) continue;
                    set = set2;
                    continue;
                }
                bl2 = true;
            }
            List<SimpleDeclaration> list = this.collectSimpleDeclarationsOf(declaration);
            if (bl3 && (!bl2 || list.size() == 1)) {
                this.splitSimpleDeclaration((SimpleDeclaration)greqlVertex, set);
                bl = true;
                continue;
            }
            if (entry.size() == 1) {
                this.movePredicatesToOneVarSimpleDeclaration((SimpleDeclaration)greqlVertex, (Set)hashMap.get(greqlVertex), (Set<Variable>)((Object)entry));
                bl = true;
                continue;
            }
            if (list.size() <= 1) continue;
            this.movePredicatesToMultiVarSimpleDeclaration((SimpleDeclaration)greqlVertex, (Set)hashMap.get(greqlVertex), (Set<Variable>)((Object)entry));
            bl = true;
        }
        return bl;
    }

    private void movePredicatesToMultiVarSimpleDeclaration(SimpleDeclaration simpleDeclaration, Set<Expression> set, Set<Variable> set2) throws OptimizerException {
        GreqlVertex greqlVertex;
        GreqlVertex greqlVertex2;
        logger.finer(this.optimizerHeaderString() + "(Mn) Performing early selection transformation for " + simpleDeclaration + " declaring ");
        int n = set2.size();
        int n2 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (Variable object2 : set2) {
            stringBuilder.append(object2 + " (" + object2.get_name() + ")");
            if (n2 < n) {
                stringBuilder.append(", ");
            }
            ++n2;
        }
        logger.finer(stringBuilder.toString() + " with predicates " + set + ".");
        Declaration declaration = simpleDeclaration.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega();
        assert (declaration.getDegree(EdgeDirection.OUT) == 1);
        HashMap<Variable, Set<Edge>> hashMap = new HashMap<Variable, Set<Edge>>();
        for (Variable variable : set2) {
            hashMap.put(variable, this.collectVariableAccessEdges(variable));
        }
        RecordConstruction recordConstruction = this.syntaxgraph.createRecordConstruction();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Variable variable : set2) {
            stringBuilder2.append(variable.get_name());
            greqlVertex2 = this.syntaxgraph.createRecordElement();
            this.syntaxgraph.createIsRecordElementOf((RecordElement)greqlVertex2, recordConstruction);
            greqlVertex = this.syntaxgraph.createRecordId();
            greqlVertex.set_name("_" + variable.get_name());
            this.syntaxgraph.createIsRecordIdOf((RecordId)greqlVertex, (RecordElement)greqlVertex2);
            this.syntaxgraph.createIsRecordExprOf(variable, (RecordElement)greqlVertex2);
        }
        Variable variable = this.syntaxgraph.createVariable();
        variable.set_name(stringBuilder2.toString());
        SimpleDeclaration simpleDeclaration2 = this.syntaxgraph.createSimpleDeclaration();
        this.syntaxgraph.createIsSimpleDeclOf(simpleDeclaration2, declaration);
        this.syntaxgraph.createIsDeclaredVarOf(variable, simpleDeclaration2);
        greqlVertex2 = this.syntaxgraph.createSetComprehension();
        this.syntaxgraph.createIsTypeExprOfDeclaration((Expression)greqlVertex2, simpleDeclaration2);
        greqlVertex = this.syntaxgraph.createDeclaration();
        this.syntaxgraph.createIsCompDeclOf((Declaration)greqlVertex, (Comprehension)greqlVertex2);
        this.syntaxgraph.createIsCompResultDefOf(recordConstruction, (Comprehension)greqlVertex2);
        simpleDeclaration.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).setOmega(greqlVertex);
        Expression expression = this.createConjunction(new ArrayList<Expression>(set), new HashSet<Variable>());
        this.syntaxgraph.createIsConstraintOf(expression, (Declaration)greqlVertex);
        for (Expression expression2 : set) {
            this.removeExpressionFromOriginalConstraint(expression2, declaration);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            FunctionApplication functionApplication = this.syntaxgraph.createFunctionApplication();
            FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("getValue", this.syntaxgraph);
            this.syntaxgraph.createIsFunctionIdOf(functionId, functionApplication);
            Identifier identifier = this.syntaxgraph.createIdentifier();
            identifier.set_name("_" + ((Variable)entry.getKey()).get_name());
            this.syntaxgraph.createIsArgumentOf(variable, functionApplication);
            this.syntaxgraph.createIsArgumentOf(identifier, functionApplication);
            for (Edge edge : (Set)entry.getValue()) {
                if (!edge.isValid()) continue;
                edge.setAlpha(functionApplication);
                assert (edge.getAlpha() == functionApplication);
            }
        }
    }

    private void movePredicatesToOneVarSimpleDeclaration(SimpleDeclaration simpleDeclaration, Set<Expression> set, Set<Variable> set2) throws OptimizerException {
        Variable variable = set2.iterator().next();
        logger.finer(this.optimizerHeaderString() + "Performing early selection transformation for " + simpleDeclaration + " declaring variable " + variable + " (" + variable.get_name() + ") with predicates " + set);
        Expression expression = this.createConjunction(new ArrayList<Expression>(set), set2);
        SetComprehension setComprehension = this.syntaxgraph.createSetComprehension();
        Declaration declaration = this.syntaxgraph.createDeclaration();
        SimpleDeclaration simpleDeclaration2 = this.syntaxgraph.createSimpleDeclaration();
        Set<Variable> set3 = this.collectUndeclaredVariablesBelow(expression);
        if (set3.size() != 1) {
            OptimizerException optimizerException = new OptimizerException("undeclaredVars = " + set3 + " has size different form 1.");
            logger.throwing(this.getClass().getName(), "movePredicatesToOneVarSimpleDeclaration", optimizerException);
            throw optimizerException;
        }
        Variable variable2 = set3.iterator().next();
        simpleDeclaration.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).setOmega(simpleDeclaration2);
        this.syntaxgraph.createIsTypeExprOfDeclaration(setComprehension, simpleDeclaration);
        this.syntaxgraph.createIsCompDeclOf(declaration, setComprehension);
        this.syntaxgraph.createIsSimpleDeclOf(simpleDeclaration2, declaration);
        this.syntaxgraph.createIsDeclaredVarOf(variable2, simpleDeclaration2);
        this.syntaxgraph.createIsConstraintOf(expression, declaration);
        this.syntaxgraph.createIsCompResultDefOf(variable2, setComprehension);
        for (Expression expression2 : set) {
            this.removeExpressionFromOriginalConstraint(expression2, simpleDeclaration.getFirstIsSimpleDeclOfIncidence().getOmega());
        }
    }

    private void removeExpressionFromOriginalConstraint(Expression expression, Declaration declaration) throws OptimizerException {
        FunctionApplication functionApplication;
        if (expression.getFirstIsConstraintOfIncidence(EdgeDirection.OUT) != null) {
            expression.getFirstIsConstraintOfIncidence(EdgeDirection.OUT).delete();
            OptimizerUtility.deleteOrphanedVerticesBelow(expression, new HashSet<Vertex>());
            return;
        }
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        for (Edge edge : expression.incidences(EdgeDirection.OUT)) {
            if (!(edge.getOmega() instanceof FunctionApplication) || !this.existsForwardPathExcludingOtherTargetClassVertices(edge, declaration) || !OptimizerUtility.isAnd(functionApplication = (FunctionApplication)edge.getOmega())) continue;
            arrayList.add(edge);
        }
        for (Edge edge : arrayList) {
            if (!edge.isValid()) continue;
            functionApplication = (FunctionApplication)edge.getOmega();
            if (functionApplication == null) {
                throw new OptimizerException("Something's pretty wrong. upEdge.getOmega() returned null!! upEdge = " + edge + ".");
            }
            Expression expression2 = null;
            for (IsArgumentOf isArgumentOf : functionApplication.getIsArgumentOfIncidences(EdgeDirection.IN)) {
                if (isArgumentOf.getNormalEdge() == edge.getNormalEdge()) continue;
                expression2 = isArgumentOf.getAlpha();
            }
            ArrayList arrayList2 = new ArrayList();
            for (Edge edge2 : functionApplication.incidences(EdgeDirection.OUT)) {
                arrayList2.add(edge2);
            }
            Iterator object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                Edge edge2;
                edge2 = (Edge)object2.next();
                edge2.setAlpha(expression2);
            }
            OptimizerUtility.deleteOrphanedVerticesBelow(functionApplication, new HashSet<Vertex>());
        }
    }

    private Set<Edge> collectVariableAccessEdges(Variable variable) {
        HashSet<Edge> hashSet = new HashSet<Edge>();
        for (Edge edge : variable.incidences(EdgeDirection.OUT)) {
            if (edge instanceof IsDeclaredVarOf || edge instanceof IsBoundVarOf || edge instanceof IsVarOf) continue;
            hashSet.add(edge);
        }
        return hashSet;
    }

    private Expression createConjunction(List<Expression> list, Set<Variable> set, HashMap<Variable, Variable> hashMap) {
        if (list.size() == 1) {
            return (Expression)this.copySubgraph(list.get(0), this.syntaxgraph, set, hashMap);
        }
        FunctionApplication functionApplication = this.syntaxgraph.createFunctionApplication();
        FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("and", this.syntaxgraph);
        this.syntaxgraph.createIsFunctionIdOf(functionId, functionApplication);
        this.syntaxgraph.createIsArgumentOf((Expression)this.copySubgraph(list.get(0), this.syntaxgraph, set, hashMap), functionApplication);
        this.syntaxgraph.createIsArgumentOf(this.createConjunction(list.subList(1, list.size()), set, hashMap), functionApplication);
        return functionApplication;
    }

    private Expression createConjunction(List<Expression> list, Set<Variable> set) {
        return this.createConjunction(list, set, new HashMap<Variable, Variable>());
    }

    private HashMap<SimpleDeclaration, Set<Expression>> collectMovableExpressions(Expression expression) {
        Declaration declaration;
        HashMap<SimpleDeclaration, Set<Expression>> hashMap = new HashMap<SimpleDeclaration, Set<Expression>>();
        if (expression instanceof FunctionApplication && OptimizerUtility.isAnd((FunctionApplication)expression)) {
            FunctionApplication functionApplication = (FunctionApplication)expression;
            for (IsArgumentOf isArgumentOf = functionApplication.getFirstIsArgumentOfIncidence(EdgeDirection.IN); isArgumentOf != null; isArgumentOf = isArgumentOf.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
                for (Map.Entry<SimpleDeclaration, Set<Expression>> entry : this.collectMovableExpressions(isArgumentOf.getAlpha()).entrySet()) {
                    if (hashMap.containsKey(entry.getKey())) {
                        hashMap.get(entry.getKey()).addAll((Collection<Expression>)entry.getValue());
                        continue;
                    }
                    hashMap.put(entry.getKey(), entry.getValue());
                }
            }
            return hashMap;
        }
        SimpleDeclaration simpleDeclaration = this.findSimpleDeclarationThatDeclaresAllNeededLocalVariables(expression);
        if (simpleDeclaration != null && (this.collectSimpleDeclarationsOf(declaration = simpleDeclaration.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega()).size() > 1 || OptimizerUtility.collectVariablesDeclaredBy(simpleDeclaration).size() > 1)) {
            if (hashMap.containsKey(simpleDeclaration)) {
                hashMap.get(simpleDeclaration).add(expression);
            } else {
                HashSet<Expression> hashSet = new HashSet<Expression>();
                hashSet.add(expression);
                hashMap.put(simpleDeclaration, hashSet);
            }
        }
        return hashMap;
    }

    private SimpleDeclaration findSimpleDeclarationThatDeclaresAllNeededLocalVariables(Expression expression) {
        Set<Variable> set = this.collectNeededLocalVariables(expression);
        SimpleDeclaration simpleDeclaration = null;
        SimpleDeclaration simpleDeclaration2 = null;
        for (Variable variable : set) {
            simpleDeclaration = variable.getFirstIsDeclaredVarOfIncidence().getOmega();
            if (simpleDeclaration2 != null && simpleDeclaration != simpleDeclaration2) {
                return null;
            }
            simpleDeclaration2 = simpleDeclaration;
        }
        return simpleDeclaration;
    }

    private Set<Variable> collectNeededLocalVariables(Expression expression) {
        Set<Variable> set = OptimizerUtility.collectInternallyDeclaredVariablesBelow(expression);
        HashSet<Variable> hashSet = new HashSet<Variable>();
        Declaration declaration = this.findNearestDeclarationAbove(expression);
        for (SimpleDeclaration simpleDeclaration : this.collectSimpleDeclarationsOf(declaration)) {
            for (Variable variable : set) {
                for (IsDeclaredVarOf isDeclaredVarOf = simpleDeclaration.getFirstIsDeclaredVarOfIncidence(); isDeclaredVarOf != null; isDeclaredVarOf = isDeclaredVarOf.getNextIsDeclaredVarOfIncidence()) {
                    if (isDeclaredVarOf.getAlpha() != variable) continue;
                    hashSet.add(variable);
                }
            }
        }
        return hashSet;
    }

    private boolean existsForwardPathExcludingOtherTargetClassVertices(Edge edge, Vertex vertex) {
        Vertex vertex2 = edge.getOmega();
        if (vertex2 == vertex) {
            return true;
        }
        if (vertex2.getAttributedElementClass().getSchemaClass() == vertex.getAttributedElementClass().getSchemaClass()) {
            return false;
        }
        for (Edge edge2 : vertex2.incidences(EdgeDirection.OUT)) {
            if (!this.existsForwardPathExcludingOtherTargetClassVertices(edge2, vertex)) continue;
            return true;
        }
        return false;
    }

    private List<SimpleDeclaration> collectSimpleDeclarationsOf(Declaration declaration) {
        ArrayList<SimpleDeclaration> arrayList = new ArrayList<SimpleDeclaration>();
        for (IsSimpleDeclOf isSimpleDeclOf : declaration.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            arrayList.add(isSimpleDeclOf.getAlpha());
        }
        return arrayList;
    }

    private Set<Variable> collectUndeclaredVariablesBelow(Vertex vertex) {
        HashSet<Variable> hashSet = new HashSet<Variable>();
        for (Variable variable : OptimizerUtility.collectInternallyDeclaredVariablesBelow(vertex)) {
            if (variable.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT) != null) continue;
            hashSet.add(variable);
        }
        return hashSet;
    }

    private Vertex copySubgraph(Vertex vertex, GreqlGraph greqlGraph, Set<Variable> set, HashMap<Variable, Variable> hashMap) {
        GraphElement<VertexClass, Vertex> graphElement;
        if (vertex instanceof Identifier && !(vertex instanceof Variable)) {
            return vertex;
        }
        if (vertex instanceof Variable) {
            if (hashMap.containsKey(vertex)) {
                return hashMap.get(vertex);
            }
            if (!set.contains(vertex)) {
                return vertex;
            }
        }
        Object t = greqlGraph.createVertex(vertex.getAttributedElementClass());
        this.copyAttributes(vertex, (AttributedElement<?, ?>)t);
        if (t instanceof Variable) {
            graphElement = (Variable)t;
            graphElement.set_name("_" + graphElement.get_name());
            hashMap.put((Variable)vertex, (Variable)graphElement);
        }
        for (graphElement = vertex.getFirstIncidence(EdgeDirection.IN); graphElement != null; graphElement = graphElement.getNextIncidence(EdgeDirection.IN)) {
            Vertex vertex2 = this.copySubgraph(graphElement.getAlpha(), greqlGraph, set, hashMap);
            greqlGraph.createEdge(graphElement.getAttributedElementClass(), vertex2, (Vertex)t);
        }
        return t;
    }

    private void copyAttributes(AttributedElement<?, ?> attributedElement, AttributedElement<?, ?> attributedElement2) {
        for (Attribute attribute : attributedElement.getAttributedElementClass().getAttributeList()) {
            attributedElement2.setAttribute(attribute.getName(), attributedElement.getAttribute(attribute.getName()));
        }
    }
}

