/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MergeSimpleDeclarationsOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(MergeSimpleDeclarationsOptimizer.class);
    private boolean anOptimizationWasDone = false;

    public MergeSimpleDeclarationsOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof MergeSimpleDeclarationsOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) {
        this.anOptimizationWasDone = false;
        this.findAndMergeSimpleDeclarations(greqlQuery.getQueryGraph());
        return this.anOptimizationWasDone;
    }

    private void findAndMergeSimpleDeclarations(GreqlGraph greqlGraph) {
        HashMap<String, ArrayList<SimpleDeclaration>> hashMap = new HashMap<String, ArrayList<SimpleDeclaration>>();
        for (Declaration declaration = greqlGraph.getFirstDeclaration(); declaration != null; declaration = declaration.getNextDeclaration()) {
            for (IsSimpleDeclOf isSimpleDeclOf = declaration.getFirstIsSimpleDeclOfIncidence(EdgeDirection.IN); isSimpleDeclOf != null; isSimpleDeclOf = isSimpleDeclOf.getNextIsSimpleDeclOfIncidence()) {
                SimpleDeclaration simpleDeclaration = isSimpleDeclOf.getAlpha();
                String string = declaration.getId() + "-" + simpleDeclaration.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).getAlpha().getId();
                if (hashMap.containsKey(string)) {
                    hashMap.get(string).add(simpleDeclaration);
                    continue;
                }
                ArrayList<SimpleDeclaration> arrayList = new ArrayList<SimpleDeclaration>();
                arrayList.add(simpleDeclaration);
                hashMap.put(string, arrayList);
            }
        }
        this.mergeSimpleDeclarations(hashMap);
    }

    private void mergeSimpleDeclarations(HashMap<String, ArrayList<SimpleDeclaration>> hashMap) {
        for (Map.Entry<String, ArrayList<SimpleDeclaration>> entry : hashMap.entrySet()) {
            SimpleDeclaration simpleDeclaration = entry.getValue().get(0);
            Declaration declaration = simpleDeclaration.getFirstIsSimpleDeclOfIncidence().getOmega();
            IsSimpleDeclOf isSimpleDeclOf = simpleDeclaration.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT);
            IsTypeExprOfDeclaration isTypeExprOfDeclaration = simpleDeclaration.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN);
            for (SimpleDeclaration simpleDeclaration2 : entry.getValue()) {
                IsSimpleDeclOf isSimpleDeclOf2 = simpleDeclaration2.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT);
                if (this.isNextInIncidenceList(declaration, isSimpleDeclOf, isSimpleDeclOf2)) {
                    logger.finer(this.optimizerHeaderString() + "Merging all variables of " + simpleDeclaration2 + " into " + simpleDeclaration + ".");
                    while (simpleDeclaration2.getFirstIsDeclaredVarOfIncidence() != null) {
                        ((InternalEdge)((Object)simpleDeclaration2.getFirstIsDeclaredVarOfIncidence())).setOmega(simpleDeclaration);
                    }
                    OptimizerUtility.mergeSourcePositions(isSimpleDeclOf2, isSimpleDeclOf);
                    IsTypeExprOfDeclaration isTypeExprOfDeclaration2 = simpleDeclaration2.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN);
                    OptimizerUtility.mergeSourcePositions(isTypeExprOfDeclaration2, isTypeExprOfDeclaration);
                    simpleDeclaration2.delete();
                    this.anOptimizationWasDone = true;
                    continue;
                }
                simpleDeclaration = simpleDeclaration2;
            }
        }
    }

    private boolean isNextInIncidenceList(Declaration declaration, IsSimpleDeclOf isSimpleDeclOf, IsSimpleDeclOf isSimpleDeclOf2) {
        for (IsSimpleDeclOf isSimpleDeclOf3 = declaration.getFirstIsSimpleDeclOfIncidence(); isSimpleDeclOf3 != null; isSimpleDeclOf3 = isSimpleDeclOf3.getNextIsSimpleDeclOfIncidence()) {
            if (isSimpleDeclOf3.getNormalEdge() != isSimpleDeclOf) {
                continue;
            }
            IsSimpleDeclOf isSimpleDeclOf4 = isSimpleDeclOf3.getNextIsSimpleDeclOfIncidence();
            return isSimpleDeclOf4 != null && isSimpleDeclOf4.getNormalEdge() == isSimpleDeclOf2;
        }
        return false;
    }
}

