/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PathExpression;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class PathExistenceOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(PathExistenceOptimizer.class);
    private GreqlGraph syntaxgraph;
    private boolean anOptimizationWasDone = false;

    public PathExistenceOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof PathExistenceOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery greqlQuery) throws OptimizerException {
        GreqlGraph greqlGraph = greqlQuery.getQueryGraph();
        if (greqlGraph.getFirstVertex(PathExistence.VC) == null) {
            return false;
        }
        this.anOptimizationWasDone = false;
        this.syntaxgraph = greqlGraph;
        this.runOptimization();
        OptimizerUtility.createMissingSourcePositions(greqlGraph);
        return this.anOptimizationWasDone;
    }

    private void runOptimization() {
        Set<PathExistence> set = this.collectPathExistenceVertices();
        for (PathExistence pathExistence : set) {
            this.maybeTransformPathExistence(pathExistence);
        }
    }

    private void maybeTransformPathExistence(PathExistence pathExistence) {
        Object object;
        Object object2;
        Expression expression = pathExistence.getFirstIsStartExprOfIncidence(EdgeDirection.IN).getAlpha();
        Expression expression2 = pathExistence.getFirstIsTargetExprOfIncidence(EdgeDirection.IN).getAlpha();
        if (expression instanceof Variable && expression2 instanceof Variable) {
            object2 = (Variable)expression;
            object = (Variable)expression2;
            if (object2.getFirstIsBoundVarOfIncidence() != null && object.getFirstIsBoundVarOfIncidence() != null) {
                logger.finer(this.optimizerHeaderString() + "PathExistence has form var1 --> var2 where both vars are externally bound, skipping...");
            }
        }
        object2 = new Comparator<Variable>(){

            @Override
            public int compare(Variable variable, Variable variable2) {
                if (variable == variable2) {
                    return 0;
                }
                if (PathExistenceOptimizer.this.isDeclaredBefore(variable, variable2)) {
                    return -1;
                }
                return 1;
            }
        };
        object = new TreeSet(object2);
        ((TreeSet)object).addAll(OptimizerUtility.collectInternallyDeclaredVariablesBelow(expression));
        TreeSet<Variable> treeSet = new TreeSet<Variable>((Comparator<Variable>)object2);
        treeSet.addAll(OptimizerUtility.collectInternallyDeclaredVariablesBelow(expression2));
        if (((TreeSet)object).isEmpty() && treeSet.isEmpty()) {
            return;
        }
        if (((TreeSet)object).isEmpty() || !treeSet.isEmpty() && this.isDeclaredBefore((Variable)((TreeSet)object).last(), (Variable)treeSet.last())) {
            this.replacePathExistenceWithContainsFunApp(pathExistence, expression, expression2, true);
        } else if (treeSet.isEmpty() || !((TreeSet)object).isEmpty() && this.isDeclaredBefore((Variable)treeSet.last(), (Variable)((TreeSet)object).last())) {
            this.replacePathExistenceWithContainsFunApp(pathExistence, expression2, expression, false);
        }
    }

    private void replacePathExistenceWithContainsFunApp(PathExistence pathExistence, Expression expression, Expression expression2, boolean bl) {
        PathExpression pathExpression;
        logger.finer(this.optimizerHeaderString() + "Replacing " + pathExistence + " with a contains FunctionApplication using a " + (bl ? "Forward" : "Backward") + "VertexSet.");
        this.anOptimizationWasDone = true;
        HashSet<Edge> hashSet = new HashSet<Edge>();
        for (Edge edge = pathExistence.getFirstIncidence(EdgeDirection.OUT); edge != null; edge = edge.getNextIncidence(EdgeDirection.OUT)) {
            hashSet.add(edge);
        }
        FunctionApplication functionApplication = this.syntaxgraph.createFunctionApplication();
        FunctionId functionId = OptimizerUtility.findOrCreateFunctionId("contains", this.syntaxgraph);
        this.syntaxgraph.createIsFunctionIdOf(functionId, functionApplication);
        if (bl) {
            pathExpression = this.syntaxgraph.createForwardVertexSet();
            this.syntaxgraph.createIsStartExprOf(expression, pathExpression);
        } else {
            pathExpression = this.syntaxgraph.createBackwardVertexSet();
            this.syntaxgraph.createIsTargetExprOf(expression, pathExpression);
        }
        this.syntaxgraph.createIsPathOf(pathExistence.getFirstIsPathOfIncidence(EdgeDirection.IN).getAlpha(), pathExpression);
        this.syntaxgraph.createIsArgumentOf(pathExpression, functionApplication);
        this.syntaxgraph.createIsArgumentOf(expression2, functionApplication);
        for (Edge edge : hashSet) {
            edge.setAlpha(functionApplication);
        }
        pathExistence.delete();
    }

    private Set<PathExistence> collectPathExistenceVertices() {
        HashSet<PathExistence> hashSet = new HashSet<PathExistence>();
        for (PathExistence pathExistence : this.syntaxgraph.getPathExistenceVertices()) {
            hashSet.add(pathExistence);
        }
        return hashSet;
    }
}

