/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parser;

import de.uni_koblenz.jgralab.greql.exception.ParsingException;
import de.uni_koblenz.jgralab.greql.parser.ComplexToken;
import de.uni_koblenz.jgralab.greql.parser.DoubleToken;
import de.uni_koblenz.jgralab.greql.parser.LongToken;
import de.uni_koblenz.jgralab.greql.parser.SimpleToken;
import de.uni_koblenz.jgralab.greql.parser.Token;
import de.uni_koblenz.jgralab.greql.parser.TokenTypes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GreqlLexer {
    protected static final Map<TokenTypes, String> fixedTokens = Collections.unmodifiableMap(new EnumMap<TokenTypes, String>(TokenTypes.class){
        {
            this.put(TokenTypes.TRANSPOSED, "^T");
            this.put(TokenTypes.AND, "and");
            this.put(TokenTypes.FALSE, "false");
            this.put(TokenTypes.NOT, "not");
            this.put(TokenTypes.UNDEFINED, "undefined");
            this.put(TokenTypes.OR, "or");
            this.put(TokenTypes.TRUE, "true");
            this.put(TokenTypes.XOR, "xor");
            this.put(TokenTypes.AS, "as");
            this.put(TokenTypes.MAP, "map");
            this.put(TokenTypes.E, "E");
            this.put(TokenTypes.EXISTS_ONE, "exists!");
            this.put(TokenTypes.EXISTS, "exists");
            this.put(TokenTypes.END, "end");
            this.put(TokenTypes.FORALL, "forall");
            this.put(TokenTypes.FROM, "from");
            this.put(TokenTypes.IN, "in");
            this.put(TokenTypes.ON, "on");
            this.put(TokenTypes.LET, "let");
            this.put(TokenTypes.LIST, "list");
            this.put(TokenTypes.REC, "rec");
            this.put(TokenTypes.REPORT, "report");
            this.put(TokenTypes.REPORTSET, "reportSet");
            this.put(TokenTypes.REPORTSETN, "reportSetN");
            this.put(TokenTypes.REPORTLIST, "reportList");
            this.put(TokenTypes.REPORTLISTN, "reportListN");
            this.put(TokenTypes.REPORTMAP, "reportMap");
            this.put(TokenTypes.REPORTMAPN, "reportMapN");
            this.put(TokenTypes.STORE, "store");
            this.put(TokenTypes.SET, "set");
            this.put(TokenTypes.TUP, "tup");
            this.put(TokenTypes.USING, "using");
            this.put(TokenTypes.V, "V");
            this.put(TokenTypes.WHERE, "where");
            this.put(TokenTypes.WITH, "with");
            this.put(TokenTypes.QUESTION, "?");
            this.put(TokenTypes.EXCL, "!");
            this.put(TokenTypes.COLON, ":");
            this.put(TokenTypes.COMMA, ",");
            this.put(TokenTypes.DOT, ".");
            this.put(TokenTypes.DOTDOT, "..");
            this.put(TokenTypes.AT, "@");
            this.put(TokenTypes.LPAREN, "(");
            this.put(TokenTypes.RPAREN, ")");
            this.put(TokenTypes.LBRACK, "[");
            this.put(TokenTypes.RBRACK, "]");
            this.put(TokenTypes.LCURLY, "{");
            this.put(TokenTypes.RCURLY, "}");
            this.put(TokenTypes.EDGESTART, "<-");
            this.put(TokenTypes.EDGEEND, "->");
            this.put(TokenTypes.EDGE, "--");
            this.put(TokenTypes.RARROW, "-->");
            this.put(TokenTypes.LARROW, "<--");
            this.put(TokenTypes.ARROW, "<->");
            this.put(TokenTypes.ASSIGN, ":=");
            this.put(TokenTypes.EQUAL, "=");
            this.put(TokenTypes.MATCH, "=~");
            this.put(TokenTypes.NOT_EQUAL, "<>");
            this.put(TokenTypes.LE, "<=");
            this.put(TokenTypes.GE, ">=");
            this.put(TokenTypes.L_T, "<");
            this.put(TokenTypes.G_T, ">");
            this.put(TokenTypes.DIV, "/");
            this.put(TokenTypes.PLUS, "+");
            this.put(TokenTypes.MINUS, "-");
            this.put(TokenTypes.STAR, "*");
            this.put(TokenTypes.MOD, "%");
            this.put(TokenTypes.PLUSPLUS, "++");
            this.put(TokenTypes.SEMI, ";");
            this.put(TokenTypes.CARET, "^");
            this.put(TokenTypes.BOR, "|");
            this.put(TokenTypes.AMP, "&");
            this.put(TokenTypes.SMILEY, ":-)");
            this.put(TokenTypes.HASH, "#");
            this.put(TokenTypes.OUTAGGREGATION, "<>--");
            this.put(TokenTypes.INAGGREGATION, "--<>");
            this.put(TokenTypes.PATHSYSTEMSTART, "-<");
            this.put(TokenTypes.IMPORT, "import");
            this.put(TokenTypes.POS_INFINITY, "POSITIVE_INFINITY");
            this.put(TokenTypes.NEG_INFINITY, "NEGATIVE_INFINITY");
            this.put(TokenTypes.NOT_A_NUMBER, "NaN");
        }
    });
    protected static Map<String, TokenTypes> stringToTokenMap = new HashMap<String, TokenTypes>();
    protected static BitSet separators = new BitSet();
    protected String query;
    protected int position;

    public GreqlLexer(String string) {
        Character[] characterArray = fixedTokens.entrySet().iterator();
        while (characterArray.hasNext()) {
            Character[] characterArray2 = characterArray.next();
            stringToTokenMap.put(characterArray2.getValue(), characterArray2.getKey());
        }
        for (Character c : characterArray = new Character[]{Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(':'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('='), Character.valueOf('?'), Character.valueOf('^'), Character.valueOf('|'), Character.valueOf('!'), Character.valueOf('@')}) {
            separators.set(c.charValue());
        }
        this.query = null;
        this.position = 0;
        this.query = string;
        if (this.query == null) {
            throw new NullPointerException("Cannot parse nullpointer as GReQL query");
        }
    }

    public static String getTokenString(TokenTypes tokenTypes) {
        return fixedTokens.get((Object)tokenTypes);
    }

    private static final boolean isSeparator(int n) {
        return separators.get(n);
    }

    public Token getNextToken() {
        char c;
        TokenTypes tokenTypes = null;
        Token token = null;
        int n = 0;
        this.skipWs();
        int n2 = 1;
        for (c = '\u0000'; c < '\u0004'; ++c) {
            while (this.position + n2 < this.query.length() - 1 && !GreqlLexer.isSeparator(this.query.charAt(this.position + n2)) && !GreqlLexer.isSeparator(this.query.charAt(this.position + n2 - 1))) {
                ++n2;
            }
            String string = this.position + n2 < this.query.length() ? this.query.substring(this.position, this.position + n2) : this.query.substring(this.position);
            TokenTypes tokenTypes2 = stringToTokenMap.get(string);
            if (tokenTypes2 != null) {
                tokenTypes = tokenTypes2;
                n = string.length();
            }
            ++n2;
        }
        if (tokenTypes == null) {
            c = this.query.charAt(this.position);
            if (c == '\"' || c == '\'') {
                ++this.position;
                int n3 = this.position;
                StringBuilder stringBuilder = new StringBuilder();
                while (this.position < this.query.length() && this.query.charAt(this.position) != c) {
                    if (this.query.charAt(this.position) == '\\') {
                        if (this.position == this.query.length()) {
                            throw new ParsingException("String started at position " + n3 + " but is not closed in query", this.query.substring(n3, this.position), n3, this.position - n3, this.query);
                        }
                        if (this.query.charAt(this.position + 1) == c || this.query.charAt(this.position + 1) == '\\') {
                            ++this.position;
                        }
                    }
                    stringBuilder.append(this.query.charAt(this.position));
                    ++this.position;
                }
                if (this.position >= this.query.length() || this.query.charAt(this.position) != c) {
                    throw new ParsingException("String started at position " + n3 + " but is not closed in query", stringBuilder.toString(), n3, this.position - n3, this.query);
                }
                tokenTypes = TokenTypes.STRING;
                token = new ComplexToken(tokenTypes, n3, this.position, stringBuilder.toString());
                ++this.position;
            } else {
                char c2 = this.query.charAt(this.position);
                if (this.isNumber(c2)) {
                    Matcher matcher = Pattern.compile("(0[xX][0-9A-Fa-f]+)|([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)").matcher(this.query.substring(this.position));
                    matcher.lookingAt();
                    int n4 = matcher.end() + this.position;
                    this.position += matcher.end();
                    String string = matcher.group();
                    if (string.startsWith("0x") || string.startsWith("0X")) {
                        Long l = Long.parseLong(string.substring(2), 16);
                        return new LongToken(TokenTypes.LONGLITERAL, this.position, n4, string, l);
                    }
                    if (string.startsWith("0")) {
                        try {
                            Long l = Long.parseLong(string.substring(1), 8);
                            return new LongToken(TokenTypes.LONGLITERAL, this.position, n4, string, l);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        Long l = Long.parseLong(string);
                        return new LongToken(TokenTypes.LONGLITERAL, this.position, n4, string, l);
                    }
                    catch (Exception exception) {
                        Double d = Double.parseDouble(string);
                        return new DoubleToken(TokenTypes.DOUBLELITERAL, this.position, n4, string, d);
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                int n5 = this.position;
                while (this.query.length() > this.position && !GreqlLexer.isSeparator(this.query.charAt(this.position))) {
                    stringBuilder.append(this.query.charAt(this.position++));
                }
                if (this.query.length() < this.position) {
                    return new SimpleToken(TokenTypes.EOF, n5, 0);
                }
                String string = stringBuilder.toString();
                token = string.equals("thisVertex") ? new ComplexToken(TokenTypes.THISVERTEX, n5, this.position - n5, string) : (string.equals("thisEdge") ? new ComplexToken(TokenTypes.THISEDGE, n5, this.position - n5, string) : (string.equals(fixedTokens.get((Object)TokenTypes.POS_INFINITY)) || string.equals(fixedTokens.get((Object)TokenTypes.NEG_INFINITY)) || string.equals(fixedTokens.get((Object)TokenTypes.NOT_A_NUMBER)) ? this.matchDoubleConstantToken(n5, this.position - n5, string) : new ComplexToken(TokenTypes.IDENTIFIER, n5, this.position - n5, string)));
            }
        } else {
            token = new SimpleToken(tokenTypes, this.position, n);
            this.position += n;
        }
        if (token == null) {
            throw new ParsingException("Error while scanning query at position", null, this.position, this.position, this.query);
        }
        return token;
    }

    private final Token matchDoubleConstantToken(int n, int n2, String string) {
        Double d = Double.parseDouble(string);
        return new DoubleToken(TokenTypes.DOUBLELITERAL, n, n2, string, d);
    }

    private final boolean isNumber(char c) {
        return c >= Character.valueOf('0').charValue() && c <= Character.valueOf('9').charValue();
    }

    public boolean hasNextToken() {
        this.skipWs();
        return this.position < this.query.length();
    }

    private static final boolean isWs(int n) {
        return n == 32 || n == 10 || n == 9 || n == 13;
    }

    private final void skipWs() {
        while (true) {
            if (this.position < this.query.length() && GreqlLexer.isWs(this.query.charAt(this.position))) {
                ++this.position;
                continue;
            }
            if (this.position < this.query.length() - 2 && this.query.substring(this.position, this.position + 2).equals("//")) {
                ++this.position;
                while (this.position < this.query.length() && this.query.charAt(this.position) != '\n') {
                    ++this.position;
                }
                if (this.position < this.query.length() && this.query.charAt(this.position) == '\n') {
                    ++this.position;
                }
            }
            if (this.position < this.query.length() - 4 && this.query.substring(this.position, this.position + 2).equals("/*")) {
                ++this.position;
                while (this.position < this.query.length() - 1 && this.query.substring(this.position, this.position + 2).equals("*/")) {
                    ++this.position;
                }
                if (this.position < this.query.length() && this.query.substring(this.position, this.position + 2).equals("*/")) {
                    this.position += 2;
                }
            }
            if (!(this.position < this.query.length() && GreqlLexer.isWs(this.query.charAt(this.position)) || this.position < this.query.length() - 2 && this.query.substring(this.position, this.position + 2).equals("//") || this.position < this.query.length() - 4 && this.query.substring(this.position, this.position + 2).equals("/*"))) break;
        }
    }

    public static List<Token> scan(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        GreqlLexer greqlLexer = new GreqlLexer(string);
        while (greqlLexer.hasNextToken()) {
            Token token = greqlLexer.getNextToken();
            arrayList.add(token);
        }
        if (arrayList.isEmpty() || ((Token)arrayList.get((int)(arrayList.size() - 1))).type != TokenTypes.EOF) {
            arrayList.add(new SimpleToken(TokenTypes.EOF, greqlLexer.position, 0));
        }
        return arrayList;
    }
}

