/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parser;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.DuplicateVariableException;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SimpleSymbolTable {
    protected LinkedList<HashMap<String, Vertex>> list = new LinkedList();

    public void blockBegin() {
        HashMap hashMap = new HashMap();
        this.list.addFirst(hashMap);
    }

    public void blockEnd() {
        if (!this.list.isEmpty()) {
            this.list.removeFirst();
        }
    }

    public void insert(String string, Vertex vertex) throws DuplicateVariableException {
        Vertex vertex2 = this.lookup(string);
        if (vertex2 != null) {
            GreqlAggregation greqlAggregation = (GreqlAggregation)vertex2.getFirstIncidence(EdgeDirection.OUT);
            SourcePosition sourcePosition = null;
            if (greqlAggregation != null) {
                sourcePosition = (SourcePosition)greqlAggregation.get_sourcePositions().get(0);
            } else {
                List<RecordDomain> list = vertex2.getSchema().getRecordDomains();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("length", -1);
                hashMap.put("offset", -1);
                for (RecordDomain recordDomain : list) {
                    if (!recordDomain.getQualifiedName().equals("SourcePosition")) continue;
                    sourcePosition = (SourcePosition)vertex2.getGraph().createRecord(recordDomain, hashMap);
                }
            }
            throw new DuplicateVariableException(((Variable)vertex2).get_name(), (List<SourcePosition>)null, sourcePosition);
        }
        this.list.getFirst().put(string, vertex);
    }

    public Vertex lookup(String string) {
        for (HashMap hashMap : this.list) {
            if (!hashMap.containsKey(string)) continue;
            return (Vertex)hashMap.get(string);
        }
        return null;
    }

    public Set<String> getKnownIdentifierSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (HashMap hashMap : this.list) {
            hashSet.addAll(hashMap.keySet());
        }
        return hashSet;
    }
}

