/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateEnumDomain;
import de.uni_koblenz.jgralab.gretl.CreateListDomain;
import de.uni_koblenz.jgralab.gretl.CreateMapDomain;
import de.uni_koblenz.jgralab.gretl.CreateRecordDomain;
import de.uni_koblenz.jgralab.gretl.CreateSetDomain;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.SetDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import java.util.Collection;

public class CopyDomain
extends Transformation<Domain> {
    private Domain sourceDomain;

    public CopyDomain(Context context, Domain domain) {
        super(context);
        this.sourceDomain = domain;
    }

    public static CopyDomain parseAndCreate(ExecuteTransformation executeTransformation) {
        Domain domain = executeTransformation.matchDomain();
        return new CopyDomain(executeTransformation.context, domain);
    }

    @Override
    protected Domain transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                if (this.sourceDomain instanceof BooleanDomain) {
                    return this.getBooleanDomain();
                }
                if (this.sourceDomain instanceof DoubleDomain) {
                    return this.getDoubleDomain();
                }
                if (this.sourceDomain instanceof IntegerDomain) {
                    return this.getIntegerDomain();
                }
                if (this.sourceDomain instanceof LongDomain) {
                    return this.getLongDomain();
                }
                if (this.sourceDomain instanceof StringDomain) {
                    return this.getStringDomain();
                }
                if (this.sourceDomain instanceof ListDomain) {
                    return (Domain)new CreateListDomain(this.context, (Domain)new CopyDomain(this.context, ((ListDomain)this.sourceDomain).getBaseDomain()).execute()).execute();
                }
                if (this.sourceDomain instanceof SetDomain) {
                    return (Domain)new CreateSetDomain(this.context, (Domain)new CopyDomain(this.context, ((SetDomain)this.sourceDomain).getBaseDomain()).execute()).execute();
                }
                if (this.sourceDomain instanceof MapDomain) {
                    MapDomain mapDomain = (MapDomain)this.sourceDomain;
                    return (Domain)new CreateMapDomain(this.context, (Domain)new CopyDomain(this.context, mapDomain.getKeyDomain()).execute(), (Domain)new CopyDomain(this.context, mapDomain.getValueDomain()).execute()).execute();
                }
                if (this.sourceDomain instanceof RecordDomain) {
                    RecordDomain recordDomain = (RecordDomain)this.sourceDomain;
                    Collection<RecordDomain.RecordComponent> collection = recordDomain.getComponents();
                    RecordDomain.RecordComponent[] recordComponentArray = new RecordDomain.RecordComponent[collection.size()];
                    int n = 0;
                    for (RecordDomain.RecordComponent recordComponent : collection) {
                        recordComponentArray[n] = new RecordDomain.RecordComponent(recordComponent.getName(), (Domain)new CopyDomain(this.context, recordComponent.getDomain()).execute());
                        ++n;
                    }
                    return (Domain)new CreateRecordDomain(this.context, recordDomain.getQualifiedName(), recordComponentArray).execute();
                }
                if (this.sourceDomain instanceof EnumDomain) {
                    EnumDomain enumDomain = (EnumDomain)this.sourceDomain;
                    new CreateEnumDomain(this.context, enumDomain.getQualifiedName(), enumDomain.getConsts().toArray(new String[0])).execute();
                } else {
                    throw new GReTLException(this.context, "Unknown Domain '" + this.sourceDomain + "'.");
                }
            }
            case GRAPH: {
                return this.domain(this.sourceDomain.getQualifiedName());
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }
}

