/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.ProgressFunction;
import java.io.PrintStream;

public class ConsoleProgressFunction
implements ProgressFunction {
    private static final int DEFAULTLENGTH = 60;
    private static final String DEFAULTMESSAGE = "Processing";
    private long totalElements;
    private long length;
    private long startTime;
    private int currentChar;
    private PrintStream printStream;
    private String message;

    public ConsoleProgressFunction() {
        this(System.out, 60);
    }

    public ConsoleProgressFunction(int n) {
        this(System.out);
    }

    public ConsoleProgressFunction(String string) {
        this(System.out, string);
    }

    public ConsoleProgressFunction(PrintStream printStream) {
        this(printStream, 60);
    }

    public ConsoleProgressFunction(PrintStream printStream, int n) {
        this(printStream, DEFAULTMESSAGE, n);
    }

    public ConsoleProgressFunction(PrintStream printStream, String string) {
        this(printStream, string, 60);
    }

    public ConsoleProgressFunction(PrintStream printStream, String string, int n) {
        this.printStream = printStream;
        this.length = n;
        this.message = string;
    }

    @Override
    public long getUpdateInterval() {
        return this.length > this.totalElements ? 1L : this.totalElements / this.length;
    }

    @Override
    public void init(long l) {
        this.printStream.println(this.message + " " + l + " elements");
        this.currentChar = 0;
        this.totalElements = l;
        this.printStream.print("[");
        this.printStream.flush();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void progress(long l) {
        if ((long)this.currentChar < this.length) {
            this.printStream.print("#");
            this.printStream.flush();
            ++this.currentChar;
        }
    }

    @Override
    public void finished() {
        long l = System.currentTimeMillis();
        for (long i = (long)this.currentChar; i < this.length; ++i) {
            this.printStream.print("#");
        }
        this.printStream.println("] time: " + (double)(l - this.startTime) / 1000.0 + "s");
    }
}

