/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.impl;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.impl.InternalVertex;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IncidenceIterable<E extends Edge>
implements Iterable<E> {
    Vertex v;
    EdgeClass ec;
    EdgeDirection orientation;

    public IncidenceIterable(Vertex vertex) {
        this(vertex, null, EdgeDirection.INOUT);
    }

    public IncidenceIterable(Vertex vertex, EdgeDirection edgeDirection) {
        this(vertex, null, edgeDirection);
    }

    public IncidenceIterable(Vertex vertex, EdgeClass edgeClass) {
        this(vertex, edgeClass, EdgeDirection.INOUT);
    }

    public IncidenceIterable(Vertex vertex, EdgeClass edgeClass, EdgeDirection edgeDirection) {
        assert (vertex != null && vertex.isValid());
        this.v = vertex;
        this.ec = edgeClass;
        this.orientation = edgeDirection;
    }

    @Override
    public Iterator<E> iterator() {
        return new IncidenceIterator((InternalVertex)this.v, this.ec, this.orientation);
    }

    class IncidenceIterator
    implements Iterator<E> {
        protected E current = null;
        protected InternalVertex vertex = null;
        protected EdgeClass schemaEc;
        protected EdgeDirection dir;
        protected long incidenceListVersion;

        public IncidenceIterator(InternalVertex internalVertex, EdgeClass edgeClass, EdgeDirection edgeDirection) {
            this.vertex = internalVertex;
            this.schemaEc = edgeClass;
            this.dir = edgeDirection;
            this.incidenceListVersion = internalVertex.getIncidenceListVersion();
            this.current = edgeClass == null ? internalVertex.getFirstIncidence(edgeDirection) : internalVertex.getFirstIncidence(edgeClass, edgeDirection);
        }

        @Override
        public E next() {
            if (this.vertex.isIncidenceListModified(this.incidenceListVersion)) {
                throw new ConcurrentModificationException("The incidence list of the vertex has been modified - the iterator is not longer valid");
            }
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object e = this.current;
            this.current = this.schemaEc == null ? this.current.getNextIncidence(this.dir) : this.current.getNextIncidence(this.schemaEc, this.dir);
            return e;
        }

        @Override
        public boolean hasNext() {
            if (this.vertex.isIncidenceListModified(this.incidenceListVersion)) {
                throw new ConcurrentModificationException("The incidence list of the vertex has been modified - the iterator is not longer valid");
            }
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove Edges using Iterator");
        }
    }
}

