/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.codegenerator;

import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGenerator;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeGeneratorConfiguration;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeList;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;

public class RecordCodeGenerator
extends CodeGenerator {
    protected RecordDomain recordDomain;

    public RecordCodeGenerator(RecordDomain recordDomain, String string, CodeGeneratorConfiguration codeGeneratorConfiguration) {
        super(string, recordDomain.getPackageName(), codeGeneratorConfiguration);
        this.rootBlock.setVariable("simpleClassName", recordDomain.getSimpleName());
        this.rootBlock.setVariable("isClassOnly", "true");
        this.recordDomain = recordDomain;
    }

    @Override
    protected CodeBlock createBody() {
        CodeList codeList = new CodeList();
        if (this.currentCycle.isClassOnly()) {
            codeList.add(this.createRecordComponents());
            codeList.add(this.createFieldConstructor());
            codeList.add(this.createMapConstructor());
            codeList.add(this.createGraphIOConstructor());
            codeList.add(this.createGetterMethods());
            codeList.add(this.createGenericGetter());
            codeList.add(this.createToStringMethod());
            codeList.add(this.createWriteComponentsMethod());
            codeList.add(this.createToPMapMethod());
            codeList.add(this.createEqualsMethod());
            codeList.add(this.createHashCodeMethod());
        }
        return codeList;
    }

    private CodeBlock createGraphIOConstructor() {
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException");
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "public #simpleClassName#(GraphIO io) throws GraphIOException {"));
        codeList.add(new CodeSnippet("io.match(#token#.LBR);"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            codeList.add(recordComponent.getDomain().getReadMethod(this.schemaRootPackageName, "_" + recordComponent.getName(), "io", false));
        }
        codeList.add(new CodeSnippet("io.match(#token#.RBR);"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    private CodeBlock createFieldConstructor() {
        CodeList codeList = new CodeList();
        StringBuilder stringBuilder = new StringBuilder();
        codeList.addNoIndent(new CodeSnippet(true, "public #simpleClassName#(#fields#) {"));
        String string = "";
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            stringBuilder.append(string);
            string = ", ";
            stringBuilder.append(recordComponent.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            stringBuilder.append(" _");
            stringBuilder.append(recordComponent.getName());
            CodeSnippet codeSnippet = null;
            codeSnippet = new CodeSnippet("this._#name# = _#name#;");
            codeSnippet.setVariable("name", recordComponent.getName());
            codeList.add(codeSnippet);
        }
        codeList.setVariable("fields", stringBuilder.toString());
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    private CodeBlock createMapConstructor() {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        codeList.setVariable("rcname", this.recordDomain.getQualifiedName());
        CodeSnippet codeSnippet = new CodeSnippet("");
        codeList.addNoIndent(codeSnippet);
        codeList.addNoIndent(new CodeSnippet("public #simpleClassName#(java.util.Map<String, Object> componentValues) {"));
        codeList.add(new CodeSnippet("assert componentValues.size() == " + this.recordDomain.getComponents().size() + ";"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            if (recordComponent.getDomain().isComposite() && codeSnippet.size() <= 1) {
                codeSnippet.add("@SuppressWarnings(\"unchecked\")");
            }
            CodeSnippet codeSnippet2 = new CodeSnippet("assert componentValues.containsKey(\"#name#\");", "_#name# = (#cls#)componentValues.get(\"#name#\");");
            codeSnippet2.setVariable("name", recordComponent.getName());
            codeSnippet2.setVariable("cls", recordComponent.getDomain().getJavaClassName(this.schemaRootPackageName));
            codeList.add(codeSnippet2);
        }
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    private CodeBlock createToPMapMethod() {
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet("public org.pcollections.PMap<String, Object> toPMap() {"));
        codeList.add(new CodeSnippet("org.pcollections.PMap<String, Object> m = de.uni_koblenz.jgralab.JGraLab.map();"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            CodeSnippet codeSnippet = new CodeSnippet("m = m.plus(\"#name#\", _#name#);");
            codeSnippet.setVariable("name", recordComponent.getName());
            codeList.add(codeSnippet);
        }
        codeList.add(new CodeSnippet("return m;"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    private CodeBlock createHashCodeMethod() {
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "@Override", "public int hashCode() {", "\tint h = 0;"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            CodeSnippet codeSnippet = new CodeSnippet();
            codeList.add(codeSnippet);
            codeSnippet.setVariable("name", recordComponent.getName());
            codeSnippet.setVariable("cls", recordComponent.getDomain().getJavaClassName(this.schemaRootPackageName));
            if (recordComponent.getDomain().isPrimitive()) {
                codeSnippet.add("h += ((#cls#) _#name#).hashCode();");
                continue;
            }
            codeSnippet.add("h += _#name#.hashCode();");
        }
        codeList.addNoIndent(new CodeSnippet("\treturn h;", "}"));
        return codeList;
    }

    private CodeBlock createEqualsMethod() {
        CodeSnippet codeSnippet;
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "@Override", "public boolean equals(Object o) {"));
        codeList.add(new CodeSnippet("if (o == null) {", "\treturn false;", "}"));
        codeList.add(new CodeSnippet("if (o instanceof #simpleClassName#) {", "\t#simpleClassName# rec = (#simpleClassName#) o;"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            codeSnippet = new CodeSnippet();
            codeSnippet.setVariable("name", recordComponent.getName());
            if (recordComponent.getDomain().isPrimitive()) {
                codeSnippet.add("\tif (_#name# != rec._#name#) {");
                codeSnippet.add("\t\treturn false;", "\t}");
            } else {
                codeSnippet.add("\tif (!(_#name#.equals(rec._#name#))) {");
                codeSnippet.add("\t\treturn false;", "\t\t}");
            }
            codeList.add(codeSnippet);
        }
        codeList.add(new CodeSnippet("\treturn true;", "}"));
        codeList.add(new CodeSnippet("if (o instanceof #jgPackage#.Record) {", "\t#jgPackage#.Record rec = (#jgPackage#.Record) o;", "\tif (rec.size() != " + this.recordDomain.getComponents().size() + ") {", "\t\treturn false;", "\t}", "\ttry {"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            codeSnippet = new CodeSnippet("\t\tif (!rec.getComponent(\"#name#\").equals(_#name#)) {", "\t\t\treturn false;", "\t\t}");
            codeSnippet.setVariable("name", recordComponent.getName());
            codeList.add(codeSnippet);
        }
        codeList.add(new CodeSnippet("\t\treturn true;", "\t} catch (NoSuchAttributeException e) {", "\t\treturn false;", "\t}", "}", "return false;"));
        codeList.addNoIndent(new CodeSnippet("}"));
        return codeList;
    }

    @Override
    protected CodeBlock createHeader() {
        CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
        if (!this.currentCycle.isClassOnly()) {
            return codeSnippet;
        }
        this.addImports("java.util.Collections", "java.util.List", "java.util.ArrayList");
        codeSnippet.add("public class #simpleClassName# implements de.uni_koblenz.jgralab.Record {");
        codeSnippet.add("\tprivate static List<String> componentNames = new ArrayList<String>(" + this.recordDomain.getComponents().size() + ");", "", "\tstatic {");
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            codeSnippet.add("\t\tcomponentNames.add(\"" + recordComponent.getName() + "\");");
        }
        codeSnippet.add("\t\tcomponentNames = Collections.unmodifiableList(componentNames);", "\t}");
        codeSnippet.add("", "\t@Override", "\tpublic List<String> getComponentNames() {", "\t\treturn componentNames;", "\t}");
        codeSnippet.add("", "\t@Override", "\tpublic boolean hasComponent(String name) {", "\t\treturn componentNames.contains(name);", "\t}");
        codeSnippet.add("", "\t@Override", "public int size() {", "\treturn " + this.recordDomain.getComponents().size() + ";", "}");
        return codeSnippet;
    }

    protected CodeBlock createGetterMethods() {
        CodeList codeList = new CodeList();
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            CodeSnippet codeSnippet = new CodeSnippet(true, new String[0]);
            codeSnippet.setVariable("name", recordComponent.getName());
            codeSnippet.setVariable("isOrGet", recordComponent.getDomain().isBoolean() ? "is" : "get");
            codeSnippet.setVariable("type", recordComponent.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            codeSnippet.setVariable("ctype", recordComponent.getDomain().getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            codeSnippet.add("public #type# #isOrGet#_#name#() {");
            codeSnippet.add("\treturn _#name#;");
            codeSnippet.add("}");
            codeList.addNoIndent(codeSnippet);
        }
        return codeList;
    }

    private CodeBlock createGenericGetter() {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.exception.NoSuchAttributeException");
        codeList.addNoIndent(new CodeSnippet(true, "@Override", "public Object getComponent(String name) {"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            CodeSnippet codeSnippet = null;
            codeSnippet = new CodeSnippet("if (name.equals(\"#name#\")) {", "\treturn _#name#;", "}");
            codeSnippet.setVariable("name", recordComponent.getName());
            codeSnippet.setVariable("cname", recordComponent.getDomain().getJavaClassName(this.schemaRootPackageName));
            codeSnippet.setVariable("isOrGet", recordComponent.getDomain().isBoolean() ? "is" : "get");
            codeList.add(codeSnippet);
        }
        codeList.add(new CodeSnippet("throw new NoSuchAttributeException(\"#rcname# doesn't contain an attribute \" + name);"));
        codeList.addNoIndent(new CodeSnippet("}"));
        codeList.setVariable("rcname", this.recordDomain.getQualifiedName());
        return codeList;
    }

    private CodeBlock createWriteComponentsMethod() {
        CodeList codeList = new CodeList();
        this.addImports("#jgPackage#.GraphIO", "#jgPackage#.exception.GraphIOException", "java.io.IOException");
        codeList.addNoIndent(new CodeSnippet(true, "@Override", "public void writeComponentValues(GraphIO io) throws IOException, GraphIOException {", "\tio.write(\"(\");"));
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            codeList.add(recordComponent.getDomain().getWriteMethod(this.schemaRootPackageName, "_" + recordComponent.getName(), "io"));
        }
        codeList.addNoIndent(new CodeSnippet("\tio.write(\")\");", "}"));
        return codeList;
    }

    private CodeBlock createRecordComponents() {
        CodeList codeList = new CodeList();
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            Domain domain = recordComponent.getDomain();
            CodeSnippet codeSnippet = new CodeSnippet(true, "private final #type# _#field#;");
            codeSnippet.setVariable("field", recordComponent.getName());
            codeSnippet.setVariable("type", domain.getJavaAttributeImplementationTypeName(this.schemaRootPackageName));
            codeList.addNoIndent(codeSnippet);
        }
        return codeList;
    }

    private CodeBlock createToStringMethod() {
        CodeList codeList = new CodeList();
        codeList.addNoIndent(new CodeSnippet(true, "@Override", "public String toString() {", "\tStringBuilder sb = new StringBuilder();"));
        String string = "[";
        for (RecordDomain.RecordComponent recordComponent : this.recordDomain.getComponents()) {
            CodeSnippet codeSnippet = new CodeSnippet("String #key#String;");
            if (recordComponent.getDomain().isComposite() || recordComponent.getDomain() instanceof StringDomain) {
                codeSnippet.add("if (_#key# == null) #key#String = \"null\";", "else #key#String = #toString#;");
            } else {
                codeSnippet.add("#key#String = #toString#;");
            }
            codeSnippet.add("sb.append(\"#delim#\").append(\"#key#\").append(\"=\").append(#key#String);");
            codeSnippet.setVariable("delim", string);
            codeSnippet.setVariable("key", recordComponent.getName());
            if (recordComponent.getDomain().isComposite()) {
                codeSnippet.setVariable("toString", "_" + recordComponent.getName() + ".toString()");
            } else {
                codeSnippet.setVariable("toString", "String.valueOf(_#key#)");
            }
            codeList.add(codeSnippet);
            string = ", ";
        }
        codeList.addNoIndent(new CodeSnippet("\treturn sb.append(\"]\").toString();", "}"));
        return codeList;
    }
}

