/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;

public final class BooleanDomainImpl
extends BasicDomainImpl
implements BooleanDomain {
    BooleanDomainImpl(Schema schema) {
        super("Boolean", (PackageImpl)schema.getDefaultPackage());
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return "boolean";
    }

    @Override
    public String getJavaClassName(String string) {
        return "java.lang.Boolean";
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3, boolean bl) {
        return this.maybeWrapInUnsetCheck(string3, bl, string2 + " = " + string3 + ".matchBoolean();");
    }

    @Override
    public String getTGTypeName(Package package_) {
        return "Boolean";
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        return new CodeSnippet(string3 + ".writeBoolean(" + string2 + ");");
    }

    @Override
    public String getInitialValue() {
        return "false";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        if (graphIO.isNextToken(TgLexer.Token.UNSET)) {
            graphIO.match();
            return GraphIO.Unset.UNSET;
        }
        return graphIO.matchBoolean();
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        graphIO.writeBoolean((Boolean)object);
    }

    @Override
    public boolean isConformValue(Object object) {
        return Boolean.class.isInstance(object);
    }
}

