/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import java.util.HashMap;
import java.util.Map;
import org.pcollections.ArrayPSet;
import org.pcollections.PSet;

public class DirectedGraph<T> {
    protected PSet<Node<T>> nodes = ArrayPSet.empty();
    protected final Map<T, Node<T>> entries = new HashMap<T, Node<T>>();
    protected boolean finished;
    protected PSet<T> nodeValues = ArrayPSet.empty();

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void createEdge(T t, T t2) {
        if (this.finished) {
            throw new IllegalStateException("Graph is already finished.");
        }
        if (!this.nodeValues.contains(t)) {
            throw new IllegalArgumentException("alpha doesn't belong to this graph.");
        }
        if (!this.nodeValues.contains(t2)) {
            throw new IllegalArgumentException("omega doesn't belong to this graph.");
        }
        if (t.equals(t2)) {
            throw new SchemaException("Loops are not supported.");
        }
        Node<T> node = this.entries.get(t);
        assert (node != null);
        if (node.successors.contains(t2)) {
            return;
        }
        Node<T> node2 = this.entries.get(t2);
        assert (node2 != null);
        node.successors = node.successors.plus(t2);
        node2.predecessors = node2.predecessors.plus(t);
    }

    public T createNode(T t) {
        if (this.finished) {
            throw new IllegalStateException("Graph is already finished.");
        }
        assert (!this.nodeValues.contains(t));
        assert (this.entries.get(t) == null);
        this.nodeValues = this.nodeValues.plus(t);
        Node<T> node = new Node<T>(t);
        this.nodes = this.nodes.plus(node);
        this.entries.put(t, node);
        return t;
    }

    public int getNodeCount() {
        return this.nodeValues.size();
    }

    public PSet<T> getNodes() {
        return this.nodeValues;
    }

    public boolean isConnected(T t, T t2) {
        return this.entries.get(t).successors.contains(t2);
    }

    public PSet<T> getDirectPredecessors(T t) {
        assert (this.nodeValues.contains(t));
        return this.entries.get(t).predecessors;
    }

    public PSet<T> getDirectSuccessors(T t) {
        assert (this.nodeValues.contains(t));
        return this.entries.get(t).successors;
    }

    public void delete(T t) {
        Node<T> node;
        if (this.finished) {
            throw new IllegalStateException("Graph is already finished.");
        }
        Node<T> node2 = this.entries.get(t);
        this.entries.remove(t);
        this.nodes = this.nodes.minus(node2);
        this.nodeValues = this.nodeValues.minus(node2);
        for (Object e : node2.predecessors) {
            node = this.entries.get(e);
            node.successors = node.successors.minus(t);
        }
        for (Object e : node2.successors) {
            node = this.entries.get(e);
            node.predecessors = node.predecessors.minus(t);
        }
    }

    protected static class Node<T> {
        final T data;
        PSet<T> successors;
        PSet<T> predecessors;
        int mark;

        Node(T t) {
            assert (t != null);
            this.data = t;
            this.successors = ArrayPSet.empty();
            this.predecessors = ArrayPSet.empty();
        }
    }
}

