/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.schema.impl;

import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.impl.TgLexer;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.Package;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeBlock;
import de.uni_koblenz.jgralab.schema.codegenerator.CodeSnippet;
import de.uni_koblenz.jgralab.schema.impl.BasicDomainImpl;
import de.uni_koblenz.jgralab.schema.impl.PackageImpl;
import java.io.IOException;

public final class LongDomainImpl
extends BasicDomainImpl
implements LongDomain {
    LongDomainImpl(Schema schema) {
        super("Long", (PackageImpl)schema.getDefaultPackage());
    }

    @Override
    public String getJavaAttributeImplementationTypeName(String string) {
        return "long";
    }

    @Override
    public String getJavaClassName(String string) {
        return "java.lang.Long";
    }

    @Override
    public CodeBlock getReadMethod(String string, String string2, String string3, boolean bl) {
        return this.maybeWrapInUnsetCheck(string3, bl, string2 + " = " + string3 + ".matchLong();");
    }

    @Override
    public String getTGTypeName(Package package_) {
        return "Long";
    }

    @Override
    public CodeBlock getWriteMethod(String string, String string2, String string3) {
        return new CodeSnippet(string3 + ".writeLong(" + string2 + ");");
    }

    @Override
    public String getInitialValue() {
        return "0L";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object parseGenericAttribute(GraphIO graphIO) throws GraphIOException {
        if (graphIO.isNextToken(TgLexer.Token.UNSET)) {
            graphIO.match();
            return GraphIO.Unset.UNSET;
        }
        return graphIO.matchLong();
    }

    @Override
    public void serializeGenericAttribute(GraphIO graphIO, Object object) throws IOException {
        graphIO.writeLong((Long)object);
    }

    @Override
    public boolean isConformValue(Object object) {
        return Long.class.isInstance(object);
    }
}

