/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.utilities.argouml2tg;

import de.uni_koblenz.ist.utilities.option_handler.OptionHandler;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.exception.GraphIOException;
import de.uni_koblenz.jgralab.grumlschema.GrumlSchema;
import de.uni_koblenz.jgralab.grumlschema.SchemaGraph;
import de.uni_koblenz.jgralab.grumlschema.domains.BasicDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.BooleanDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.CollectionDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.Domain;
import de.uni_koblenz.jgralab.grumlschema.domains.DoubleDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.EnumDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.HasRecordDomainComponent;
import de.uni_koblenz.jgralab.grumlschema.domains.IntegerDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.LongDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.MapDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.RecordDomain;
import de.uni_koblenz.jgralab.grumlschema.domains.StringDomain;
import de.uni_koblenz.jgralab.grumlschema.structure.Annotates;
import de.uni_koblenz.jgralab.grumlschema.structure.Attribute;
import de.uni_koblenz.jgralab.grumlschema.structure.AttributedElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.Comment;
import de.uni_koblenz.jgralab.grumlschema.structure.Constraint;
import de.uni_koblenz.jgralab.grumlschema.structure.EdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphClass;
import de.uni_koblenz.jgralab.grumlschema.structure.GraphElementClass;
import de.uni_koblenz.jgralab.grumlschema.structure.HasAttribute;
import de.uni_koblenz.jgralab.grumlschema.structure.HasConstraint;
import de.uni_koblenz.jgralab.grumlschema.structure.IncidenceClass;
import de.uni_koblenz.jgralab.grumlschema.structure.NamedElement;
import de.uni_koblenz.jgralab.grumlschema.structure.Package;
import de.uni_koblenz.jgralab.grumlschema.structure.Schema;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesEdgeClass;
import de.uni_koblenz.jgralab.grumlschema.structure.SpecializesVertexClass;
import de.uni_koblenz.jgralab.grumlschema.structure.VertexClass;
import de.uni_koblenz.jgralab.utilities.rsa2tg.SchemaGraph2XMI;
import de.uni_koblenz.jgralab.utilities.tg2schemagraph.Schema2SchemaGraph;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;

public class Tg2ArgoUml {
    private static final String UML_PROFILE_PREFIX = "http://argouml.org/user-profiles/gruml-1.0.1.xmi#";
    private static final String UML_NAMESPACE_URI = "org.omg.xmi.namespace.UML";
    private boolean isBidirectional = false;
    private boolean addEdgeClassGeneralizationAsComment = false;
    private final Map<Domain, String> domain2id = new HashMap<Domain, String>();

    public static void main(String[] stringArray) throws GraphIOException {
        System.out.println("Tg to ArgoUML");
        System.out.println("==================");
        Tg2ArgoUml tg2ArgoUml = new Tg2ArgoUml();
        CommandLine commandLine = Tg2ArgoUml.processCommandLineOptions(stringArray);
        assert (commandLine != null) : "No CommandLine object has been generated!";
        tg2ArgoUml.isBidirectional = commandLine.hasOption("b");
        tg2ArgoUml.addEdgeClassGeneralizationAsComment = commandLine.hasOption("c");
        String string = commandLine.getOptionValue("o");
        try {
            if (commandLine.hasOption("ig")) {
                tg2ArgoUml.process(GrumlSchema.instance().loadSchemaGraph(commandLine.getOptionValue("ig")), string);
            } else {
                tg2ArgoUml.process(new Schema2SchemaGraph().convert2SchemaGraph(GraphIO.loadSchemaFromFile(commandLine.getOptionValue("i"))), string);
            }
        }
        catch (Exception exception) {
            System.err.println("An Exception occured while processing " + (commandLine.hasOption("i") ? commandLine.getOptionValue("i") : commandLine.getOptionValue("ig")) + ".");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            exception.printStackTrace();
        }
        System.out.println("Fini.");
    }

    public static CommandLine processCommandLineOptions(String[] stringArray) {
        String string = "java " + SchemaGraph2XMI.class.getName();
        String string2 = JGraLab.getInfo(false);
        OptionHandler optionHandler = new OptionHandler(string, string2);
        Option option = new Option("o", "output", true, "(required): the output xmi file name");
        option.setRequired(true);
        option.setArgName("file");
        optionHandler.addOption(option);
        Option option2 = new Option("ig", "inputSchemaGraph", true, "(required or -i):if set, the schemaGraph is converted into a xmi.");
        option2.setRequired(false);
        option2.setArgs(0);
        option.setArgName("file");
        optionHandler.addOption(option2);
        Option option3 = new Option("i", "inputSchema", true, "(required or -ig): TG-file of the schema which should be converted into a xmi.");
        option3.setRequired(false);
        option3.setArgName("file");
        optionHandler.addOption(option3);
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(option2);
        optionGroup.addOption(option3);
        optionGroup.setRequired(true);
        optionHandler.addOptionGroup(optionGroup);
        Option option4 = new Option("b", "bidirectional", false, "(optional): If set the EdgeClasses are created as bidirectional associations.");
        option4.setRequired(false);
        optionHandler.addOption(option4);
        Option option5 = new Option("c", "commentsForEdgeClassGeneralization", false, "(optional): Creates comments which show the generalization of EdgeClasses.");
        option5.setRequired(false);
        optionHandler.addOption(option5);
        return optionHandler.parse(stringArray);
    }

    public void process(SchemaGraph schemaGraph, String string) throws XMLStreamException, IOException {
        this.createXMI(string, schemaGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXMI(String string, SchemaGraph schemaGraph) throws XMLStreamException, IOException {
        Writer writer = null;
        XMLStreamWriter xMLStreamWriter = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new ReplacementOutputStream(new FileOutputStream(string)), "UTF-8"));
            XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
            xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(writer);
            xMLStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.createRootElement(xMLStreamWriter, schemaGraph);
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            writer.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (xMLStreamWriter != null) {
                xMLStreamWriter.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void createRootElement(XMLStreamWriter xMLStreamWriter, SchemaGraph schemaGraph) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("XMI");
        xMLStreamWriter.writeAttribute("xmi.version", "1.2");
        xMLStreamWriter.setPrefix("UML", UML_NAMESPACE_URI);
        xMLStreamWriter.writeAttribute("tiemstamp", this.getCurrentTime());
        xMLStreamWriter.writeStartElement("XMI.header");
        xMLStreamWriter.writeStartElement("XMI.documentation");
        String[] stringArray = JGraLab.getVersionInfo(false).split("\\n");
        xMLStreamWriter.writeStartElement("XMI.exporter");
        xMLStreamWriter.writeCharacters(Tg2ArgoUml.class.getName() + " (part of " + stringArray[0].trim() + ")");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("XMI.exporterVersion");
        xMLStreamWriter.writeCharacters(stringArray[1].split("\\s*\\:\\s*")[1] + " (" + stringArray[2].split("\\s*\\:\\s*")[1] + ")");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("XMI.metamodel");
        xMLStreamWriter.writeAttribute("xmi.name", "UML");
        xMLStreamWriter.writeAttribute("xmi.version", "1.4");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("XMI.content");
        this.createSchema(xMLStreamWriter, schemaGraph.getFirstSchema());
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private String getCurrentTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        return simpleDateFormat.format(new Date(System.currentTimeMillis()));
    }

    private void createSchema(XMLStreamWriter xMLStreamWriter, Schema schema) throws XMLStreamException {
        HashMap<Vertex, String> hashMap = new HashMap<Vertex, String>();
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Model");
        xMLStreamWriter.writeAttribute("xmi.id", schema.get_packagePrefix() + "." + schema.get_name());
        xMLStreamWriter.writeAttribute("name", schema.get_packagePrefix() + "." + schema.get_name());
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("isRoot", "false");
        xMLStreamWriter.writeAttribute("isLeaf", "false");
        xMLStreamWriter.writeAttribute("isAbstract", "false");
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Namespace.ownedElement");
        this.createGraphClass(xMLStreamWriter, schema.get_graphclass(), hashMap);
        this.createPackage(xMLStreamWriter, schema.get_defaultpackage(), hashMap);
        this.createCommentsAndConstraints(xMLStreamWriter, hashMap);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void createGraphClass(XMLStreamWriter xMLStreamWriter, GraphClass graphClass, Map<Vertex, String> map) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Class");
        xMLStreamWriter.writeAttribute("xmi.id", graphClass.get_qualifiedName());
        xMLStreamWriter.writeAttribute("name", this.getSimpleName(graphClass.get_qualifiedName()));
        xMLStreamWriter.writeAttribute("visibility", "public");
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("isRoot", "false");
        xMLStreamWriter.writeAttribute("isLeaf", "false");
        xMLStreamWriter.writeAttribute("isAbstract", "false");
        xMLStreamWriter.writeAttribute("isActive", "false");
        this.attachCommentsAndConstraints(xMLStreamWriter, graphClass, map);
        this.attachStereotype(xMLStreamWriter, "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6A");
        this.createAttributes(xMLStreamWriter, graphClass);
        xMLStreamWriter.writeEndElement();
    }

    private void createPackage(XMLStreamWriter xMLStreamWriter, Package package_, Map<Vertex, String> map) throws XMLStreamException {
        if (package_.get_qualifiedName() != null && !package_.get_qualifiedName().isEmpty()) {
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Package");
            xMLStreamWriter.writeAttribute("xmi.id", package_.get_qualifiedName());
            xMLStreamWriter.writeAttribute("name", this.getSimpleName(package_.get_qualifiedName()));
            xMLStreamWriter.writeAttribute("isSpecification", "false");
            xMLStreamWriter.writeAttribute("isRoot", "false");
            xMLStreamWriter.writeAttribute("isLeaf", "false");
            xMLStreamWriter.writeAttribute("isAbstract", "false");
            this.attachCommentsAndConstraints(xMLStreamWriter, package_, map);
            map = new HashMap<Vertex, String>();
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Namespace.ownedElement");
        }
        for (Iterator iterator : package_.get_domains()) {
            this.createDomain(xMLStreamWriter, (Domain)((Object)iterator), map);
        }
        HashSet hashSet = new HashSet();
        for (NamedElement namedElement : package_.get_graphelementclasses()) {
            if (namedElement.isInstanceOf(VertexClass.VC)) {
                this.createVertexClass(xMLStreamWriter, (VertexClass)namedElement, hashSet, map);
                continue;
            }
            this.createEdgeClass(xMLStreamWriter, (EdgeClass)namedElement, hashSet, map);
        }
        this.createGeneralization(xMLStreamWriter, hashSet);
        for (NamedElement namedElement : package_.get_subpackages()) {
            this.createPackage(xMLStreamWriter, (Package)namedElement, map);
        }
        if (package_.get_qualifiedName() != null && !package_.get_qualifiedName().isEmpty()) {
            this.createCommentsAndConstraints(xMLStreamWriter, map);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
    }

    private void createGeneralization(XMLStreamWriter xMLStreamWriter, Set<Edge> set) throws XMLStreamException {
        for (Edge edge : set) {
            GraphElementClass graphElementClass = (GraphElementClass)edge.getAlpha();
            GraphElementClass graphElementClass2 = (GraphElementClass)edge.getOmega();
            boolean bl = graphElementClass.isInstanceOf(VertexClass.VC);
            String string = bl ? "Class" : "Association";
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Generalization");
            xMLStreamWriter.writeAttribute("xmi.id", graphElementClass.get_qualifiedName() + "_specializes_" + graphElementClass2.get_qualifiedName());
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Generalization.child");
            xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, string + (bl && graphElementClass.getDegree(HasAttribute.EC) > 0 ? "Class" : ""));
            xMLStreamWriter.writeAttribute("xmi.idref", graphElementClass.get_qualifiedName());
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Generalization.parent");
            xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, string + (bl && graphElementClass2.getDegree(HasAttribute.EC) > 0 ? "Class" : ""));
            xMLStreamWriter.writeAttribute("xmi.idref", graphElementClass2.get_qualifiedName());
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
    }

    private void createDomain(XMLStreamWriter xMLStreamWriter, Domain domain, Map<Vertex, String> map) throws XMLStreamException {
        if (domain.isInstanceOf(BasicDomain.VC)) {
            return;
        }
        if (domain.isInstanceOf(RecordDomain.VC)) {
            this.createRecordDomain(xMLStreamWriter, (RecordDomain)domain, map);
        } else if (domain.isInstanceOf(EnumDomain.VC)) {
            this.createEnumDomain(xMLStreamWriter, (EnumDomain)domain, map);
        } else {
            String string = this.getDomainId(domain);
            if (domain.getDegree(Annotates.EC) > 0) {
                xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "DataType");
            } else {
                xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "DataType");
            }
            xMLStreamWriter.writeAttribute("xmi.id", string);
            xMLStreamWriter.writeAttribute("name", string);
            xMLStreamWriter.writeAttribute("isSpecification", "false");
            xMLStreamWriter.writeAttribute("isRoot", "false");
            xMLStreamWriter.writeAttribute("isLeaf", "false");
            xMLStreamWriter.writeAttribute("isAbstract", "false");
            if (domain.getDegree(Annotates.EC) > 0) {
                this.attachCommentsAndConstraints(xMLStreamWriter, domain, map);
                xMLStreamWriter.writeEndElement();
            }
        }
    }

    private void createRecordDomain(XMLStreamWriter xMLStreamWriter, RecordDomain recordDomain, Map<Vertex, String> map) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Class");
        xMLStreamWriter.writeAttribute("xmi.id", recordDomain.get_qualifiedName());
        xMLStreamWriter.writeAttribute("name", this.getSimpleName(recordDomain.get_qualifiedName()));
        xMLStreamWriter.writeAttribute("visibility", "public");
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("isRoot", "false");
        xMLStreamWriter.writeAttribute("isLeaf", "false");
        xMLStreamWriter.writeAttribute("isAbstract", "false");
        xMLStreamWriter.writeAttribute("isActive", "false");
        this.attachCommentsAndConstraints(xMLStreamWriter, recordDomain, map);
        this.attachStereotype(xMLStreamWriter, "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6B");
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Classifier.feature");
        for (HasRecordDomainComponent hasRecordDomainComponent : recordDomain.getHasRecordDomainComponentIncidences(EdgeDirection.OUT)) {
            Domain domain = (Domain)hasRecordDomainComponent.getThat();
            String string = hasRecordDomainComponent.get_name();
            String string2 = recordDomain.get_qualifiedName() + "_attribute_" + string + ":" + domain.get_qualifiedName();
            this.attacheAttribute(xMLStreamWriter, domain, string, string2, null);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void createEnumDomain(XMLStreamWriter xMLStreamWriter, EnumDomain enumDomain, Map<Vertex, String> map) throws XMLStreamException {
        String string = this.getDomainId(enumDomain);
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Enumeration");
        xMLStreamWriter.writeAttribute("xmi.id", string);
        xMLStreamWriter.writeAttribute("name", this.getSimpleName(string));
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("isRoot", "false");
        xMLStreamWriter.writeAttribute("isLeaf", "false");
        xMLStreamWriter.writeAttribute("isAbstract", "false");
        this.attachCommentsAndConstraints(xMLStreamWriter, enumDomain, map);
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Enumeration.literal");
        for (String string2 : enumDomain.get_enumConstants()) {
            xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "EnumerationLiteral");
            xMLStreamWriter.writeAttribute("xmi.id", string + "_constant_" + string2);
            xMLStreamWriter.writeAttribute("name", string2);
            xMLStreamWriter.writeAttribute("isSpecification", "false");
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void createVertexClass(XMLStreamWriter xMLStreamWriter, VertexClass vertexClass, Set<Edge> set, Map<Vertex, String> map) throws XMLStreamException {
        if (this.hasVertexClassRepresentationChildren(vertexClass)) {
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Class");
        } else {
            xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "Class");
        }
        xMLStreamWriter.writeAttribute("xmi.id", vertexClass.get_qualifiedName());
        xMLStreamWriter.writeAttribute("name", this.getSimpleName(vertexClass.get_qualifiedName()));
        xMLStreamWriter.writeAttribute("visibility", "public");
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("isRoot", "false");
        xMLStreamWriter.writeAttribute("isLeaf", "false");
        xMLStreamWriter.writeAttribute("isAbstract", vertexClass.is_abstract() ? "true" : "false");
        xMLStreamWriter.writeAttribute("isActive", "false");
        this.attachCommentsAndConstraints(xMLStreamWriter, vertexClass, map);
        if (vertexClass.is_abstract()) {
            this.attachStereotype(xMLStreamWriter, "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6C");
        }
        this.createAttributes(xMLStreamWriter, vertexClass);
        this.attachGeneralization(xMLStreamWriter, vertexClass, set);
        if (this.hasVertexClassRepresentationChildren(vertexClass)) {
            xMLStreamWriter.writeEndElement();
        }
    }

    private boolean hasVertexClassRepresentationChildren(VertexClass vertexClass) {
        return vertexClass.is_abstract() || vertexClass.getDegree(HasAttribute.EC) > 0 || vertexClass.getDegree(HasConstraint.EC) > 0 || vertexClass.getDegree(Annotates.EC) > 0 || vertexClass.getDegree(SpecializesVertexClass.EC, EdgeDirection.OUT) > 0;
    }

    private void createEdgeClass(XMLStreamWriter xMLStreamWriter, EdgeClass edgeClass, Set<Edge> set, Map<Vertex, String> map) throws XMLStreamException {
        boolean bl = edgeClass.getDegree(HasAttribute.EC) == 0;
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, bl ? "Association" : "AssociationClass");
        xMLStreamWriter.writeAttribute("xmi.id", edgeClass.get_qualifiedName());
        xMLStreamWriter.writeAttribute("name", this.getSimpleName(edgeClass.get_qualifiedName()));
        if (!bl) {
            xMLStreamWriter.writeAttribute("visibility", "public");
        }
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("isRoot", "false");
        xMLStreamWriter.writeAttribute("isLeaf", "false");
        xMLStreamWriter.writeAttribute("isAbstract", edgeClass.is_abstract() ? "true" : "false");
        if (!bl) {
            xMLStreamWriter.writeAttribute("isActive", "false");
        }
        this.attachCommentsAndConstraints(xMLStreamWriter, edgeClass, map);
        if (this.addEdgeClassGeneralizationAsComment && edgeClass.getDegree(SpecializesEdgeClass.EC, EdgeDirection.OUT) > 0) {
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "ModelElement.comment");
            this.attachCommentAndConstraints(xMLStreamWriter, edgeClass, "generalizationComment_" + edgeClass.get_qualifiedName(), "_comment_", 0, map);
            xMLStreamWriter.writeEndElement();
        }
        if (edgeClass.is_abstract()) {
            this.attachStereotype(xMLStreamWriter, "-64--88-111--125-2048530b:13717182953:-8000:0000000000000D6C");
        }
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Association.connection");
        this.attacheAssociationEnd(xMLStreamWriter, edgeClass, edgeClass.get_from());
        this.attacheAssociationEnd(xMLStreamWriter, edgeClass, edgeClass.get_to());
        xMLStreamWriter.writeEndElement();
        this.createAttributes(xMLStreamWriter, edgeClass);
        this.attachGeneralization(xMLStreamWriter, edgeClass, set);
        xMLStreamWriter.writeEndElement();
    }

    private void attacheAssociationEnd(XMLStreamWriter xMLStreamWriter, EdgeClass edgeClass, IncidenceClass incidenceClass) throws XMLStreamException {
        String string;
        boolean bl = edgeClass.get_from() == incidenceClass;
        switch ((bl ? edgeClass.get_to() : edgeClass.get_from()).get_aggregation()) {
            case COMPOSITE: {
                string = "composite";
                break;
            }
            case SHARED: {
                string = "aggregate";
                break;
            }
            default: {
                string = "none";
            }
        }
        String string2 = (bl ? "alpha" : "omega") + "_incidence_" + edgeClass.get_qualifiedName() + "_" + incidenceClass.get_targetclass().get_qualifiedName();
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "AssociationEnd");
        xMLStreamWriter.writeAttribute("xmi.id", string2);
        if (incidenceClass.get_roleName() != null && !incidenceClass.get_roleName().isEmpty()) {
            xMLStreamWriter.writeAttribute("name", incidenceClass.get_roleName());
        }
        xMLStreamWriter.writeAttribute("visibility", "public");
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("isNavigable", this.isBidirectional || !bl ? "true" : "false");
        xMLStreamWriter.writeAttribute("ordering", "unordered");
        xMLStreamWriter.writeAttribute("aggregation", string);
        xMLStreamWriter.writeAttribute("targetScope", "instance");
        xMLStreamWriter.writeAttribute("changeability", "changeable");
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "AssociationEnd.multiplicity");
        this.createMultiplicity(xMLStreamWriter, string2, incidenceClass.get_min(), incidenceClass.get_max());
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "AssociationEnd.participant");
        xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "Class");
        xMLStreamWriter.writeAttribute("xmi.idref", incidenceClass.get_targetclass().get_qualifiedName());
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void attachGeneralization(XMLStreamWriter xMLStreamWriter, GraphElementClass graphElementClass, Set<Edge> set) throws XMLStreamException {
        boolean bl = false;
        for (Edge edge : graphElementClass.incidences(graphElementClass.isInstanceOf(VertexClass.VC) ? SpecializesVertexClass.EC : SpecializesEdgeClass.EC, EdgeDirection.OUT)) {
            set.add(edge);
            if (!bl) {
                xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "GeneralizableElement.generalization");
                bl = true;
            }
            xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "Generalization");
            xMLStreamWriter.writeAttribute("xmi.idref", ((GraphElementClass)edge.getAlpha()).get_qualifiedName() + "_specializes_" + ((GraphElementClass)edge.getOmega()).get_qualifiedName());
        }
        if (bl) {
            xMLStreamWriter.writeEndElement();
        }
    }

    private void createAttributes(XMLStreamWriter xMLStreamWriter, AttributedElementClass attributedElementClass) throws XMLStreamException {
        boolean bl = false;
        for (Attribute attribute : attributedElementClass.get_attributes()) {
            if (!bl) {
                xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Classifier.feature");
                bl = true;
            }
            Domain domain = attribute.get_domain();
            String string = attribute.get_name();
            String string2 = attributedElementClass.get_qualifiedName() + "_attribute_" + string + ":" + domain.get_qualifiedName();
            this.attacheAttribute(xMLStreamWriter, domain, string, string2, attribute.get_defaultValue());
        }
        if (bl) {
            xMLStreamWriter.writeEndElement();
        }
    }

    private void attacheAttribute(XMLStreamWriter xMLStreamWriter, Domain domain, String string, String string2, String string3) throws XMLStreamException {
        String string4 = "";
        String string5 = "";
        String string6 = this.getDomainId(domain);
        if (domain.isInstanceOf(BasicDomain.VC)) {
            string4 = "DataType";
            string5 = "href";
        } else if (domain.isInstanceOf(EnumDomain.VC)) {
            string4 = "Enumeration";
            string5 = "xmi.idref";
        } else if (domain.isInstanceOf(RecordDomain.VC)) {
            string4 = "Class";
            string5 = "xmi.idref";
        } else {
            string4 = "DataType";
            string5 = "xmi.idref";
        }
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Attribute");
        xMLStreamWriter.writeAttribute("xmi.id", string2);
        xMLStreamWriter.writeAttribute("name", string);
        xMLStreamWriter.writeAttribute("visibility", "public");
        xMLStreamWriter.writeAttribute("isSpecification", "false");
        xMLStreamWriter.writeAttribute("ownerScope", "instance");
        xMLStreamWriter.writeAttribute("changeability", "changeable");
        xMLStreamWriter.writeAttribute("targetScope", "instance");
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "StructuralFeature.multiplicity");
        this.createMultiplicity(xMLStreamWriter, string2, 1, 1);
        xMLStreamWriter.writeEndElement();
        if (string3 != null) {
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Attribute.initialValue");
            xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "Expression");
            xMLStreamWriter.writeAttribute("xmi.id", string2 + "_defaultValue");
            xMLStreamWriter.writeAttribute("language", "");
            xMLStreamWriter.writeAttribute("body", string3);
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "StructuralFeature.type");
        xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, string4);
        xMLStreamWriter.writeAttribute(string5, string6);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private String getDomainId(Domain domain) {
        String string = this.domain2id.get(domain);
        if (string == null) {
            string = domain.isInstanceOf(BooleanDomain.VC) ? "http://argouml.org/user-profiles/gruml-1.0.1.xmi#-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DB" : (domain.isInstanceOf(IntegerDomain.VC) ? "http://argouml.org/user-profiles/gruml-1.0.1.xmi#-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DA" : (domain.isInstanceOf(LongDomain.VC) ? "http://argouml.org/user-profiles/gruml-1.0.1.xmi#-115-26-95--20--17a78cb8:13718617229:-8000:0000000000000D77" : (domain.isInstanceOf(DoubleDomain.VC) ? "http://argouml.org/user-profiles/gruml-1.0.1.xmi#-115-26-95--20--17a78cb8:13718617229:-8000:0000000000000D76" : (domain.isInstanceOf(StringDomain.VC) ? "http://argouml.org/user-profiles/gruml-1.0.1.xmi#-115-26-95--20--17a78cb8:13718617229:-8000:00000000000019DC" : domain.get_qualifiedName()))));
            this.domain2id.put(domain, string);
        }
        return string;
    }

    private void createMultiplicity(XMLStreamWriter xMLStreamWriter, String string, int n, int n2) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Multiplicity");
        xMLStreamWriter.writeAttribute("xmi.id", string + "_multiplicity");
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Multiplicity.range");
        xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "MultiplicityRange");
        xMLStreamWriter.writeAttribute("xmi.id", string + "_multiplicityRange");
        xMLStreamWriter.writeAttribute("lower", Integer.toString(n));
        xMLStreamWriter.writeAttribute("upper", Integer.toString(n2 == Integer.MAX_VALUE ? -1 : n2));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    private void attachCommentsAndConstraints(XMLStreamWriter xMLStreamWriter, NamedElement namedElement, Map<Vertex, String> map) throws XMLStreamException {
        if (namedElement.getDegree(Annotates.EC) == 0 && namedElement.getDegree(HasConstraint.EC) == 0) {
            return;
        }
        int n = 0;
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "ModelElement.comment");
        String string = "_comment_";
        for (Vertex vertex : namedElement.get_comments()) {
            n = this.attachCommentAndConstraints(xMLStreamWriter, vertex, namedElement.get_qualifiedName(), string, n, map);
        }
        string = "_constraint_";
        if (namedElement.isInstanceOf(AttributedElementClass.VC)) {
            for (Vertex vertex : ((AttributedElementClass)namedElement).get_constraints()) {
                n = this.attachCommentAndConstraints(xMLStreamWriter, vertex, namedElement.get_qualifiedName(), string, n, map);
            }
        }
        xMLStreamWriter.writeEndElement();
    }

    private int attachCommentAndConstraints(XMLStreamWriter xMLStreamWriter, Vertex vertex, String string, String string2, int n, Map<Vertex, String> map) throws XMLStreamException {
        String string3 = map.get(vertex);
        if (string3 == null) {
            string3 = string + string2 + n++;
            map.put(vertex, string3);
        }
        xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "Comment");
        xMLStreamWriter.writeAttribute("xmi.idref", string3);
        return n;
    }

    private void createCommentsAndConstraints(XMLStreamWriter xMLStreamWriter, Map<Vertex, String> map) throws XMLStreamException {
        for (Map.Entry<Vertex, String> entry : map.entrySet()) {
            Comparable<StringBuilder> comparable;
            Object object;
            boolean bl = entry.getKey().isInstanceOf(Comment.VC);
            String string = "";
            String string2 = "";
            String string3 = "";
            if (entry.getKey() instanceof EdgeClass) {
                string = entry.getKey().getDegree(HasAttribute.EC) == 0 ? "Association" : "AssociationClass";
                string2 = ((EdgeClass)entry.getKey()).get_qualifiedName();
                object = ": ";
                comparable = new StringBuilder(string2);
                for (EdgeClass edgeClass : ((EdgeClass)entry.getKey()).get_superclasses()) {
                    ((StringBuilder)comparable).append((String)object).append(edgeClass.get_qualifiedName());
                    object = ", ";
                }
                string3 = ((StringBuilder)comparable).toString();
            } else {
                object = bl ? ((Comment)entry.getKey()).get_annotatedelement() : ((Constraint)entry.getKey()).get_constrainedelement();
                string2 = object.get_qualifiedName();
                string = object.isInstanceOf(Package.VC) ? "Package" : (object.isInstanceOf(EdgeClass.VC) ? (object.getDegree(HasAttribute.EC) == 0 ? "Association" : "AssociationClass") : (object.isInstanceOf(EnumDomain.VC) ? "Enumeration" : (object.isInstanceOf(CollectionDomain.VC) || object.isInstanceOf(MapDomain.VC) ? "DataType" : "Class")));
                if (bl) {
                    string3 = ((Comment)entry.getKey()).get_text();
                } else {
                    comparable = (Constraint)entry.getKey();
                    string3 = "{\"" + comparable.get_message() + "\" \"" + comparable.get_predicateQuery() + "\" \"" + comparable.get_offendingElementsQuery() + "\"}";
                }
            }
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Comment");
            xMLStreamWriter.writeAttribute("xmi.id", entry.getValue());
            xMLStreamWriter.writeAttribute("isSpecification", "false");
            xMLStreamWriter.writeAttribute("body", string3);
            xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "Comment.annotatedElement");
            xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, string);
            xMLStreamWriter.writeAttribute("xmi.idref", string2);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
    }

    private void attachStereotype(XMLStreamWriter xMLStreamWriter, String string) throws XMLStreamException {
        xMLStreamWriter.writeStartElement(UML_NAMESPACE_URI, "ModelElement.stereotype");
        xMLStreamWriter.writeEmptyElement(UML_NAMESPACE_URI, "Stereotype");
        xMLStreamWriter.writeAttribute("href", UML_PROFILE_PREFIX + string);
        xMLStreamWriter.writeEndElement();
    }

    private String getSimpleName(String string) {
        String string2 = string;
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    private class ReplacementOutputStream
    extends OutputStream {
        private final OutputStream output;

        public ReplacementOutputStream(OutputStream outputStream) {
            this.output = outputStream;
        }

        @Override
        public void write(int n) throws IOException {
            if (n == 10) {
                this.output.write(38);
                this.output.write(35);
                this.output.write(120);
                this.output.write(48);
                this.output.write(97);
                this.output.write(59);
            } else if (n == 13) {
                this.output.write(38);
                this.output.write(35);
                this.output.write(120);
                this.output.write(48);
                this.output.write(100);
                this.output.write(59);
            } else {
                this.output.write(n);
            }
        }
    }
}

